/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.util;

import com.aspect.snoop.JavaSnoop;
import com.aspect.snoop.util.RandomUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class JadUtil {
    private static Map<String, String> codeCache;

    private static File getExecutableFromPath(String executableName) {
        String systemPath = System.getenv("PATH");
        String[] pathDirs = systemPath.split(File.pathSeparator);
        File fullyQualifiedExecutable = null;
        for (String pathDir : pathDirs) {
            File file = new File(pathDir, executableName);
            if (!file.isFile()) continue;
            fullyQualifiedExecutable = file;
            break;
        }
        return fullyQualifiedExecutable;
    }

    public static String getJadLocation() {
        try {
            boolean isWin = System.getProperty("os.name").contains("Windows");
            File f = JadUtil.getExecutableFromPath("jad" + (isWin ? ".exe" : ""));
            if (f != null) {
                return f.getAbsolutePath();
            }
            String jadPath = JavaSnoop.getProperty("jad_path");
            if (jadPath == null || jadPath.length() == 0) {
                return null;
            }
            if (new File(jadPath).exists()) {
                return jadPath;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getDecompiledJava(String className, byte[] clazz) throws IOException {
        String jadPath = JadUtil.getJadLocation();
        if (jadPath == null) {
            throw new IOException("Couldn't find jad");
        }
        if (codeCache == null) {
            codeCache = new HashMap<String, String>();
        } else {
            String code = codeCache.get(className);
            if (code != null) {
                return code;
            }
        }
        String prefix = RandomUtil.randomString(8);
        File classFile = File.createTempFile(prefix, ".class");
        FileOutputStream fos = new FileOutputStream(classFile);
        fos.write(clazz);
        fos.close();
        String tmpDir = System.getProperty("java.io.tmpdir");
        String[] cmd = new String[]{jadPath, "-o", "-d", tmpDir, "-s", ".java", classFile.getAbsolutePath()};
        Process p = Runtime.getRuntime().exec(cmd);
        int rc = JadUtil.doWaitFor(p);
        String simpleClassName = JadUtil.getSimpleClassName(className);
        String javaFile = tmpDir + File.separatorChar + simpleClassName + ".java";
        BufferedReader reader = new BufferedReader(new FileReader(javaFile));
        StringBuffer sb = new StringBuffer(5000);
        String buff = null;
        String nl = System.getProperty("line.separator");
        while ((buff = reader.readLine()) != null) {
            if (buff.startsWith("//")) continue;
            sb.append(buff + nl);
        }
        String finalCode = "/* Decompiled " + className + " */" + nl + sb.toString().trim();
        codeCache.put(className, finalCode);
        File decompiledFile = new File(javaFile);
        decompiledFile.delete();
        classFile.delete();
        return finalCode;
    }

    private static String getSimpleClassName(String className) {
        String fqClassName = new String(className);
        int firstChar = fqClassName.lastIndexOf(46) + 1;
        if (firstChar > 0) {
            className = fqClassName.substring(firstChar);
        }
        return className;
    }

    public static int doWaitFor(Process p) {
        int exitValue = -1;
        try {
            InputStream in = p.getInputStream();
            InputStream err = p.getErrorStream();
            boolean finished = false;
            while (!finished) {
                try {
                    Character c;
                    while (in.available() > 0) {
                        c = new Character((char)in.read());
                        System.out.print(c);
                    }
                    while (err.available() > 0) {
                        c = new Character((char)err.read());
                        System.out.print(c);
                    }
                    exitValue = p.exitValue();
                    finished = true;
                }
                catch (IllegalThreadStateException e) {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
            }
        }
        catch (Exception e) {
            System.err.println("doWaitFor(): unexpected exception - " + e.getMessage());
        }
        return exitValue;
    }
}

