/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.forceclass;

import com.aspect.org.jdesktop.application.Action;
import com.aspect.org.jdesktop.application.Application;
import com.aspect.org.jdesktop.application.ApplicationActionMap;
import com.aspect.org.jdesktop.application.ResourceMap;
import com.aspect.snoop.JavaSnoop;
import com.aspect.snoop.agent.AgentLogger;
import com.aspect.snoop.util.UIUtil;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class ForceLoadClassesView
extends JDialog {
    private JButton btnAddFromJar;
    private JButton btnClear;
    private JButton btnLoad;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JTextArea txtClasses;
    List<String> classes = null;
    String lastJarFile = "";

    public ForceLoadClassesView(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.txtClasses = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.btnAddFromJar = new JButton();
        this.btnClear = new JButton();
        this.btnLoad = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(JavaSnoop.class).getContext().getResourceMap(ForceLoadClassesView.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setModal(true);
        this.setName("Form");
        this.setResizable(false);
        this.jScrollPane1.setName("jScrollPane1");
        this.txtClasses.setColumns(20);
        this.txtClasses.setRows(5);
        this.txtClasses.setName("txtClasses");
        this.jScrollPane1.setViewportView(this.txtClasses);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        ApplicationActionMap actionMap = Application.getInstance(JavaSnoop.class).getContext().getActionMap(ForceLoadClassesView.class, this);
        this.btnAddFromJar.setAction(actionMap.get("addFromJar"));
        this.btnAddFromJar.setText(resourceMap.getString("btnAddFromJar.text", new Object[0]));
        this.btnAddFromJar.setToolTipText(resourceMap.getString("btnAddFromJar.toolTipText", new Object[0]));
        this.btnAddFromJar.setName("btnAddFromJar");
        this.btnClear.setAction(actionMap.get("clear"));
        this.btnClear.setText(resourceMap.getString("btnClear.text", new Object[0]));
        this.btnClear.setName("btnClear");
        this.btnLoad.setAction(actionMap.get("done"));
        this.btnLoad.setText(resourceMap.getString("btnLoad.text", new Object[0]));
        this.btnLoad.setToolTipText(resourceMap.getString("btnLoad.toolTipText", new Object[0]));
        this.btnLoad.setName("btnLoad");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, 592, Short.MAX_VALUE).addComponent(this.jLabel2, -1, 592, Short.MAX_VALUE).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnAddFromJar, GroupLayout.Alignment.TRAILING, -1, 134, Short.MAX_VALUE).addComponent(this.jLabel4, GroupLayout.Alignment.TRAILING).addComponent(this.btnClear, GroupLayout.Alignment.TRAILING, -1, 134, Short.MAX_VALUE).addComponent(this.btnLoad, -1, 134, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 452, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel3).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addGap(23, 23, 23).addComponent(this.btnAddFromJar).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClear).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnLoad)).addComponent(this.jScrollPane1, -2, 209, -2)).addContainerGap()));
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ForceLoadClassesView dialog = new ForceLoadClassesView((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public List<String> getClassesToLoad() {
        return this.classes;
    }

    @Action
    public void addFromJar() {
        File f;
        JFileChooser fc = null;
        fc = this.lastJarFile.length() > 0 ? ((f = new File(this.lastJarFile)).exists() ? new JFileChooser(f.getParentFile()) : new JFileChooser()) : new JFileChooser();
        fc.setMultiSelectionEnabled(true);
        int rc = fc.showOpenDialog(this);
        if (rc == 0) {
            File[] of = fc.getSelectedFiles();
            try {
                for (File f2 : of) {
                    this.lastJarFile = f2.getAbsolutePath();
                    this.addJarClasses(f2.getAbsolutePath());
                }
            }
            catch (IOException ioe) {
                UIUtil.showErrorMessage(this, "Couldn't load classes from jar: " + ioe.getMessage());
                AgentLogger.error(ioe);
            }
        }
    }

    @Action
    public void clear() {
        this.txtClasses.setText("");
    }

    @Action
    public void done() {
        String[] classArray;
        this.classes = new ArrayList<String>();
        String txt = this.txtClasses.getText();
        for (String cls : classArray = txt.split("\n")) {
            this.classes.add(cls.trim());
        }
        this.setVisible(false);
    }

    public boolean userCanceled() {
        return this.classes == null;
    }

    private void addJarClasses(String lastJarFile) throws IOException {
        JarFile jar = new JarFile(lastJarFile);
        StringBuilder sb = new StringBuilder(2000);
        String nl = System.getProperty("line.separator");
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            String name;
            JarEntry entry = e.nextElement();
            if (entry.isDirectory() || !(name = entry.getName()).endsWith(".class")) continue;
            name = name.substring(0, name.length() - 6);
            name = name.replace('/', '.');
            sb.append(name);
            sb.append(nl);
        }
        String currentText = this.txtClasses.getText();
        if (currentText.length() > 0 && !currentText.endsWith(nl)) {
            currentText = currentText + nl;
        }
        this.txtClasses.setText(currentText + sb.toString().trim());
    }
}

