/*
 * Decompiled with CFR 0.152.
 */
package entities;

import entities.HashEntry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class IOProcessor {
    private static final String HASHFILE_COMMENT = "#!comment:";
    private static final String RULEFILE_COMMENT = "#";
    private static final String DECRYPTION_BOX_FILE_NAME = ".pandoras.box";

    public static final List<String> getLinesFromFile(String fileName, String comment, boolean ignoreEmpyLines) {
        ArrayList<String> lineList = new ArrayList<String>();
        BufferedReader br = null;
        try {
            try {
                File FileToRead = new File(fileName);
                String completeFileName = IOProcessor.getCompleteFileName(fileName);
                if (FileToRead.isFile()) {
                    String sCurrentLine;
                    br = new BufferedReader(new FileReader(completeFileName));
                    while ((sCurrentLine = br.readLine()) != null) {
                        if ((sCurrentLine = sCurrentLine.replaceAll("(\\r|\\n)", "")).startsWith(comment) || !ignoreEmpyLines || sCurrentLine.equals("")) continue;
                        lineList.add(sCurrentLine);
                    }
                } else {
                    System.out.println("The file " + completeFileName + " does not exists!");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return lineList;
    }

    public static final List<HashEntry> getLinesFromHashFile(String fileName) {
        ArrayList<HashEntry> hashList = new ArrayList<HashEntry>();
        BufferedReader br = null;
        try {
            try {
                File FileToRead = new File(fileName);
                String completeFileName = IOProcessor.getCompleteFileName(fileName);
                if (FileToRead.isFile()) {
                    String sCurrentLine;
                    br = new BufferedReader(new FileReader(completeFileName));
                    while ((sCurrentLine = br.readLine()) != null) {
                        sCurrentLine = sCurrentLine.replaceAll("(\\r|\\n)", "");
                        HashEntry he = new HashEntry(sCurrentLine);
                        hashList.add(he);
                    }
                } else {
                    System.out.println("The file " + completeFileName + " does not exists!");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return hashList;
    }

    public static boolean fileExists(String fileName) {
        File FileToRead = new File(fileName);
        return FileToRead.exists();
    }

    public static final List<StringBuilder> getStringBuilderLinesFromFile(String fileName, String comment) {
        ArrayList<StringBuilder> lineList = new ArrayList<StringBuilder>();
        BufferedReader br = null;
        try {
            try {
                File FileToRead = new File(fileName);
                String completeFileName = IOProcessor.getCompleteFileName(fileName);
                if (FileToRead.isFile()) {
                    String sCurrentLine;
                    br = new BufferedReader(new FileReader(completeFileName));
                    while ((sCurrentLine = br.readLine()) != null) {
                        if ((sCurrentLine = sCurrentLine.replaceAll("(\\r|\\n)", "")).startsWith(comment)) continue;
                        lineList.add(new StringBuilder(sCurrentLine));
                    }
                } else {
                    System.out.println("The file " + completeFileName + " does not exists!");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return lineList;
    }

    public static final List<String> getHashesFromHashFile(String fileName) {
        return IOProcessor.getLinesFromFile(fileName, HASHFILE_COMMENT, false);
    }

    public static final List<StringBuilder> getStringBuilderLinesFromFile(String fileName) {
        return IOProcessor.getStringBuilderLinesFromFile(fileName, HASHFILE_COMMENT);
    }

    public static final List<String> getRulesFromRuleFile(String fileName) {
        return IOProcessor.getLinesFromFile(fileName, RULEFILE_COMMENT, true);
    }

    public static List<HashEntry> getHashEntrysFromTheBox() {
        ArrayList<HashEntry> hashEntryList = new ArrayList<HashEntry>();
        BufferedReader br = null;
        String fileName = DECRYPTION_BOX_FILE_NAME;
        try {
            try {
                File FileToRead = new File(fileName);
                String completeFileName = IOProcessor.getCompleteFileName(fileName);
                if (FileToRead.isFile()) {
                    String sCurrentLine;
                    br = new BufferedReader(new FileReader(completeFileName));
                    while ((sCurrentLine = br.readLine()) != null) {
                        sCurrentLine = sCurrentLine.replaceAll("(\\r|\\n)", "");
                        int firstSpace = sCurrentLine.indexOf(32);
                        String hashEntrStr = sCurrentLine.substring(0, firstSpace);
                        hashEntryList.add(new HashEntry(hashEntrStr));
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return hashEntryList;
    }

    public static List<String> getLinesFromTheBox() {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader br = null;
        String fileName = DECRYPTION_BOX_FILE_NAME;
        try {
            try {
                File FileToRead = new File(fileName);
                String completeFileName = IOProcessor.getCompleteFileName(fileName);
                if (FileToRead.isFile()) {
                    String sCurrentLine;
                    br = new BufferedReader(new FileReader(completeFileName));
                    while ((sCurrentLine = br.readLine()) != null) {
                        sCurrentLine = sCurrentLine.replaceAll("(\\r|\\n)", "");
                        list.add(sCurrentLine);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return list;
    }

    public static boolean isHashInTheBox(HashEntry newHash) {
        boolean isInBox = false;
        List<HashEntry> boxHashes = IOProcessor.getHashEntrysFromTheBox();
        for (HashEntry decryptedHash : boxHashes) {
            if (!decryptedHash.toString().equals(newHash.toString())) continue;
            isInBox = true;
            break;
        }
        return isInBox;
    }

    public static final synchronized void addHashEntryToTheBox(HashEntry hashEntry, String word) {
        String fileName = IOProcessor.getCompleteFileName(DECRYPTION_BOX_FILE_NAME);
        File FileToRead = new File(fileName);
        boolean mustCreatesBox = false;
        if (!FileToRead.isFile()) {
            try {
                File file = new File(fileName);
                if (file.createNewFile()) {
                    System.out.println("File " + fileName + " is created!");
                    mustCreatesBox = true;
                } else {
                    System.out.println("File " + fileName + " already exists.");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        boolean isInBox = false;
        if (!mustCreatesBox) {
            isInBox = IOProcessor.isHashInTheBox(hashEntry);
        }
        if (!isInBox) {
            try {
                String line = String.valueOf(hashEntry.toString()) + " --> " + word;
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName, true)));
                out.println(line);
                out.close();
            }
            catch (IOException e) {
                System.err.println("[DEBUG] ERROR! Can not write to decryption file.");
                e.printStackTrace();
            }
        } else {
            System.out.println("[INFO] entry " + hashEntry.toString() + " already in the box!");
        }
    }

    private static final String getCompleteFileName(String fileName) {
        String your_os = System.getProperty("os.name").toLowerCase();
        String workingDir = System.getProperty("user.dir");
        File FileToRead = new File(fileName);
        String completeFileName = "";
        if (FileToRead.getParent() == null) {
            if (your_os.contains("windows")) {
                completeFileName = String.valueOf(workingDir) + "\\" + fileName;
            } else if (your_os.contains("linux") || your_os.contains("nux") || your_os.contains("os x")) {
                completeFileName = String.valueOf(workingDir) + "/" + fileName;
            } else {
                System.out.println("Unknow OS: " + your_os);
                completeFileName = String.valueOf(workingDir) + "{unknowOS}" + fileName;
            }
        } else {
            completeFileName = fileName;
        }
        return completeFileName;
    }

    public static String getWordFromHashEntry(HashEntry hash) {
        String word = "";
        List<String> resolved = IOProcessor.getLinesFromTheBox();
        for (String line : resolved) {
            int firstSpace;
            String he = line.substring(0, firstSpace = line.indexOf(32));
            if (!he.equalsIgnoreCase(hash.toString())) continue;
            int lastSpace = line.lastIndexOf(32);
            word = line.substring(lastSpace + 1);
            break;
        }
        return word;
    }
}

