/*
 * Decompiled with CFR 0.152.
 */
package specialAlgorithm;

import entities.ByteArray;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import specialAlgorithm.SpecialAlgorithm;

public class LM
implements SpecialAlgorithm {
    private static byte[] MAGIC_STRING = new String("KGS!@#$%").getBytes();
    private static int PWD_FIXED_SIZE = 14;
    private static byte NULL_BYTE = 0;
    private Cipher myCipher1 = null;
    private Cipher myCipher2 = null;

    public LM() {
        try {
            this.myCipher1 = Cipher.getInstance("DES/ECB/NoPadding");
            this.myCipher2 = Cipher.getInstance("DES/ECB/NoPadding");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
    }

    private static final String bytes2Utf8(byte[] ba) {
        try {
            return new String(ba, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final byte[] prepare(byte[] password) {
        byte[] bpwd = null;
        if ((password = ByteArray.toUpperCase(password)).length < PWD_FIXED_SIZE) {
            int difference = PWD_FIXED_SIZE - password.length;
            byte[] aux = new byte[difference];
            int i = 0;
            while (i < aux.length) {
                aux[i] = NULL_BYTE;
                ++i;
            }
            bpwd = ByteArray.concat(password, aux);
        } else {
            bpwd = password.length > PWD_FIXED_SIZE ? ByteArray.getSubArray(password, 0, PWD_FIXED_SIZE - 1) : password;
        }
        return bpwd;
    }

    @Override
    public String toHash(byte[] hash) {
        return DatatypeConverter.printHexBinary((byte[])hash);
    }

    private static final byte[] toDESKey(byte[] password) {
        byte[] key = new byte[]{(byte)(password[0] >> 0), (byte)(password[0] << 7 | password[1] >> 1), (byte)(password[1] << 6 | password[2] >> 2), (byte)(password[2] << 5 | password[3] >> 3), (byte)(password[3] << 4 | password[4] >> 4), (byte)(password[4] << 3 | password[5] >> 5), (byte)(password[5] << 2 | password[6] >> 6), (byte)(password[6] << 1)};
        return key;
    }

    @Override
    public String crypt(String password, String salt) {
        return this.toHash(this.cryptPerf(password.getBytes(), null));
    }

    @Override
    public byte[] cryptPerf(byte[] password, byte[] salt) {
        byte[] returnValue = null;
        byte[] prepared = LM.prepare(password);
        byte[] part1 = ByteArray.getSubArray(prepared, 0, 6);
        byte[] part2 = ByteArray.getSubArray(prepared, 7, 13);
        SecretKeySpec keySpec1 = new SecretKeySpec(LM.toDESKey(part1), "DES");
        SecretKeySpec keySpec2 = new SecretKeySpec(LM.toDESKey(part2), "DES");
        try {
            this.myCipher1.init(1, keySpec1);
            byte[] result1 = this.myCipher1.doFinal(MAGIC_STRING);
            this.myCipher2.init(1, keySpec2);
            byte[] result2 = this.myCipher2.doFinal(MAGIC_STRING);
            returnValue = ByteArray.concat(result1, result2);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    @Override
    public byte[] appendSaltToWord(byte[] word, byte[] hash) {
        return word;
    }

    @Override
    public final byte[] toByteArray(String hash) {
        return DatatypeConverter.parseHexBinary((String)hash);
    }

    @Override
    public byte[] getSaltFromHash(byte[] hash) {
        return null;
    }
}

