/*
 * Decompiled with CFR 0.152.
 */
package specialAlgorithm;

import entities.ByteArray;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.xml.bind.DatatypeConverter;
import specialAlgorithm.SpecialAlgorithm;

public class SybaseASE1502
implements SpecialAlgorithm {
    private MessageDigest m = null;
    private static final int FIXED_SIZE = 510;

    public SybaseASE1502() {
        try {
            this.m = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    @Override
    public final String crypt(String password, String salt) {
        byte[] salt1 = null;
        if (salt == null) {
            salt1 = new byte[8];
            new Random().nextBytes(salt1);
        } else {
            salt1 = DatatypeConverter.parseHexBinary((String)salt);
        }
        return this.toHash(this.cryptPerf(password.getBytes(), salt1));
    }

    @Override
    public final String toHash(byte[] b) {
        return "0x" + DatatypeConverter.printHexBinary((byte[])b).toLowerCase();
    }

    private final byte[] prepare(byte[] password) {
        byte[] result = null;
        byte[] finalResult = new byte[518];
        result = ByteArray.toUTF16BE(password);
        if (result.length > 510) {
            finalResult = ByteArray.truncate(result, 510);
        } else {
            int i = 0;
            while (i < result.length) {
                finalResult[i] = result[i];
                ++i;
            }
        }
        return finalResult;
    }

    @Override
    public final byte[] cryptPerf(byte[] password, byte[] salt) {
        byte[] bpassword = this.prepare(password);
        bpassword = ByteArray.concat(bpassword, salt);
        this.m.update(bpassword);
        byte[] hashPrefix = new byte[]{-64, 7};
        byte[] output = ByteArray.concat(hashPrefix, salt);
        return ByteArray.concat(output, this.m.digest());
    }

    @Override
    public final byte[] toByteArray(String hash) {
        int separatorPos = hash.indexOf(120);
        String hexHash = hash.substring(separatorPos + 1, hash.length());
        return DatatypeConverter.parseHexBinary((String)hexHash);
    }

    @Override
    public byte[] getSaltFromHash(byte[] hash) {
        return ByteArray.getSubArray(hash, 2, 9);
    }

    @Override
    public byte[] appendSaltToWord(byte[] word, byte[] salt) {
        return ByteArray.concat(salt, word);
    }
}

