-- kismet2earth.sql

PRAGMA foreign_keys = ON;

CREATE TABLE IF NOT EXISTS networks (
  bssid         TEXT PRIMARY KEY,  -- unique identifier for an AP (e.g., 00:11:22:33:44:55)
  essid         TEXT,
  lat           REAL,
  lon           REAL,
  encryption    TEXT NOT NULL DEFAULT 'Open',
  manufacturer  TEXT,
  channel       INTEGER,
  date_insert   TEXT NOT NULL DEFAULT (strftime('%Y-%m-%dT%H:%M:%fZ','now')),
  date_update   TEXT NOT NULL DEFAULT (strftime('%Y-%m-%dT%H:%M:%fZ','now'))
);

-- Speeds up filtering/export by encryption type
CREATE INDEX IF NOT EXISTS idx_networks_encryption
  ON networks(encryption);

-- Auto-maintain date_update whenever a row changes
CREATE TRIGGER IF NOT EXISTS trg_networks_date_update
AFTER UPDATE ON networks
FOR EACH ROW
BEGIN
  UPDATE networks
  SET date_update = strftime('%Y-%m-%dT%H:%M:%fZ','now')
  WHERE bssid = OLD.bssid;
END;