# Leo colorizer control file for clojure mode.
# This file is in the public domain.
import re
number_pat = re.compile('\\b0x[0-9a-fA-F]+|\\b\\d*\\.\\d+|\\b\\d+\\.?')
def clojure_match_numbers(colorer, s, i):
    return colorer.match_compiled_regexp(s, i, kind='literal4', regexp=number_pat)

# Properties for clojure mode.
properties = {
    "lineComment": ";",
    "multipleBracketIndent": "true",
    "noWordSep": ".*+!-_?/",
    "unalignedCloseBrackets": ")",
    "unalignedOpenBrackets": "(",
}

# Attributes dict for clojure_main ruleset.
clojure_main_attributes_dict = {
    "default": "null",
    "digit_re": "([0-9]+)|(([0-9]*\\.[0-9]+)M?)|([0-9]+/[0-9]+)",
    "escape": "",
    "highlight_digits": "true",
    "ignore_case": "false",
    "no_word_sep": ".*+!-_?/",
}

# Attributes dict for clojure_strings ruleset.
clojure_strings_attributes_dict = {
    "default": "LITERAL1",
    "digit_re": "([0-9]+)|(([0-9]*\\.[0-9]+)M?)|([0-9]+/[0-9]+)",
    "escape": "",
    "highlight_digits": "false",
    "ignore_case": "true",
    "no_word_sep": ".*+!-_?/",
}

# Attributes dict for clojure_regexps ruleset.
clojure_regexps_attributes_dict = {
    "default": "LITERAL1",
    "digit_re": "([0-9]+)|(([0-9]*\\.[0-9]+)M?)|([0-9]+/[0-9]+)",
    "escape": "",
    "highlight_digits": "false",
    "ignore_case": "true",
    "no_word_sep": ".*+!-_?/",
}

# Dictionary of attributes dictionaries for clojure mode.
attributesDictDict = {
    "clojure_main": clojure_main_attributes_dict,
    "clojure_regexps": clojure_regexps_attributes_dict,
    "clojure_strings": clojure_strings_attributes_dict,
}

# Keywords dict for clojure_main ruleset.
clojure_main_keywords_dict = {
    "%": "operator",
    "&": "keyword4",
    "*": "operator",
    "*'": "operator",
    "*1": "keyword4",
    "*2": "keyword4",
    "*3": "keyword4",
    "*agent*": "keyword4",
    "*clojure-version*": "keyword4",
    "*command-line-args*": "keyword4",
    "*compile-files*": "keyword4",
    "*compile-path*": "keyword4",
    "*compiler-options*": "keyword4",
    "*current*": "keyword4",
    "*data-readers*": "keyword4",
    "*default-data-reader-fn*": "keyword4",
    "*e": "keyword4",
    "*err*": "keyword4",
    "*file*": "keyword4",
    "*flush-on-newline*": "keyword4",
    "*in*": "keyword4",
    "*ns*": "keyword4",
    "*open-url-script*": "keyword4",
    "*out*": "keyword4",
    "*print-base*": "keyword4",
    "*print-dup*": "keyword4",
    "*print-length*": "keyword4",
    "*print-level*": "keyword4",
    "*print-meta*": "keyword4",
    "*print-miser-width*": "keyword4",
    "*print-pprint-dispatch*": "keyword4",
    "*print-pretty*": "keyword4",
    "*print-radix*": "keyword4",
    "*print-readably*": "keyword4",
    "*print-right-margin*": "keyword4",
    "*print-suppress-namespaces*": "keyword4",
    "*read-eval*": "keyword4",
    "*sb*": "keyword4",
    "*stack*": "keyword4",
    "*state*": "keyword4",
    "*unchecked-math*": "keyword4",
    "*warn-on-reflection*": "keyword4",
    "+": "operator",
    "+'": "operator",
    "-": "operator",
    "-'": "operator",
    ".": "keyword3",
    "..": "keyword3",
    "/": "operator",
    "<": "operator",
    "=": "operator",
    "==": "operator",
    ">": "operator",
    "accessor": "keyword3",
    "aclone": "keyword3",
    "add-watch": "keyword3",
    "agent": "keyword3",
    "agent-error": "keyword3",
    "agent-errors": "keyword3",
    "aget": "keyword3",
    "alength": "keyword3",
    "alias": "keyword1",
    "all-ns": "keyword1",
    "alter": "keyword3",
    "alter-meta!": "keyword3",
    "alter-var-root": "keyword3",
    "amap": "keyword3",
    "ancestors": "keyword3",
    "and": "operator",
    "append-child": "function",
    "apply": "keyword3",
    "are": "function",
    "areduce": "keyword3",
    "array-map": "keyword3",
    "as-": "operator",
    "as-file": "function",
    "as-relative-path": "function",
    "as-url": "function",
    "aset": "keyword3",
    "aset-boolean": "keyword3",
    "aset-byte": "keyword3",
    "aset-char": "keyword3",
    "aset-double": "keyword3",
    "aset-float": "keyword3",
    "aset-int": "keyword3",
    "aset-long": "keyword3",
    "aset-short": "keyword3",
    "assert": "keyword1",
    "assert-any": "function",
    "assert-expr": "function",
    "assert-predicate": "function",
    "assoc": "keyword3",
    "assoc!": "keyword3",
    "assoc-in": "keyword3",
    "associative?": "literal3",
    "atom": "keyword3",
    "atom?": "literal3",
    "attrs": "function",
    "await": "keyword3",
    "await-for": "keyword3",
    "bases": "keyword3",
    "bean": "keyword3",
    "bigdec": "keyword3",
    "bigint": "keyword3",
    "biginteger": "keyword3",
    "binding": "keyword1",
    "bit-and": "operator",
    "bit-and-not": "operator",
    "bit-clear": "operator",
    "bit-flip": "operator",
    "bit-not": "operator",
    "bit-or": "operator",
    "bit-set": "operator",
    "bit-shift-left": "operator",
    "bit-shift-right": "operator",
    "bit-test": "operator",
    "bit-xor": "operator",
    "blank?": "literal3",
    "boolean": "keyword3",
    "boolean-array": "keyword3",
    "booleans": "keyword3",
    "bound-fn": "keyword1",
    "bound-fn*": "keyword1",
    "bound?": "literal3",
    "branch?": "literal3",
    "browse-url": "function",
    "butlast": "keyword3",
    "byte": "keyword3",
    "byte-array": "keyword3",
    "bytes": "keyword3",
    "capitalize": "function",
    "case": "keyword2",
    "cast": "keyword3",
    "catch": "keyword2",
    "char": "keyword3",
    "char-array": "keyword3",
    "char-escape-string": "keyword3",
    "char-name-string": "keyword3",
    "char?": "literal3",
    "chars": "keyword3",
    "children": "function",
    "cl-format": "function",
    "class": "keyword3",
    "class?": "literal3",
    "clear-agent-errors": "keyword3",
    "clojure-version": "keyword3",
    "code-dispatch": "function",
    "comment": "keyword1",
    "commute": "keyword3",
    "comp": "keyword3",
    "comparator": "keyword3",
    "compare": "keyword3",
    "compare-and-set!": "keyword3",
    "compile": "keyword1",
    "complement": "keyword3",
    "compose-fixtures": "function",
    "concat": "keyword3",
    "cond": "keyword2",
    "cond-": "keyword2",
    "condp": "keyword2",
    "conj": "keyword3",
    "conj!": "keyword3",
    "cons": "keyword3",
    "constantly": "keyword3",
    "construct-proxy": "keyword3",
    "contains?": "literal3",
    "content": "function",
    "content-handler": "function",
    "copy": "function",
    "count": "keyword3",
    "counted?": "literal3",
    "create-ns": "keyword1",
    "create-struct": "keyword3",
    "cycle": "keyword3",
    "dec": "operator",
    "dec'": "operator",
    "decimal?": "literal3",
    "declare": "keyword1",
    "def": "keyword1",
    "default-data-readers": "keyword3",
    "definline": "keyword1",
    "definterceptor": "keyword1",
    "definterceptorfn": "keyword1",
    "definterface": "keyword1",
    "defmacro": "keyword1",
    "defmethod": "keyword1",
    "defmulti": "keyword1",
    "defn": "keyword1",
    "defn-": "keyword1",
    "defon-request": "keyword1",
    "defonce": "keyword1",
    "defprotocol": "keyword1",
    "defrecord": "keyword1",
    "defstruct": "keyword1",
    "deftest": "keyword1",
    "deftest-": "keyword1",
    "deftype": "keyword1",
    "delay": "keyword3",
    "delay?": "literal3",
    "delete-file": "function",
    "deliver": "keyword3",
    "denominator": "keyword3",
    "deref": "keyword3",
    "derive": "keyword3",
    "descendants": "keyword3",
    "destructure": "keyword2",
    "diff": "function",
    "diff-similar": "function",
    "difference": "function",
    "disj": "keyword3",
    "disj!": "keyword3",
    "dissoc": "keyword3",
    "dissoc!": "keyword3",
    "distinct": "keyword3",
    "distinct?": "literal3",
    "do": "keyword2",
    "doall": "keyword2",
    "dorun": "keyword2",
    "doseq": "keyword2",
    "dosync": "keyword2",
    "dotimes": "keyword2",
    "doto": "keyword2",
    "double": "keyword3",
    "double-array": "keyword3",
    "doubles": "keyword3",
    "down": "function",
    "drop": "keyword3",
    "drop-last": "keyword3",
    "drop-while": "keyword3",
    "e": "function",
    "edit": "function",
    "element": "function",
    "emit": "function",
    "emit-element": "function",
    "empty": "keyword3",
    "empty?": "literal3",
    "end?": "literal3",
    "ensure": "keyword3",
    "enumeration-seq": "keyword3",
    "error-handler": "keyword3",
    "error-mode": "keyword3",
    "escape": "function",
    "eval": "keyword3",
    "even?": "literal3",
    "every-pred": "keyword3",
    "every?": "literal3",
    "ex-data": "keyword3",
    "ex-info": "keyword3",
    "extend": "keyword1",
    "extend-protocol": "keyword1",
    "extend-type": "keyword1",
    "extenders": "keyword1",
    "extends?": "literal3",
    "false": "literal4",
    "false?": "literal3",
    "ffirst": "keyword3",
    "file": "function",
    "file-seq": "keyword3",
    "filter": "keyword3",
    "filterv": "keyword3",
    "finally": "keyword2",
    "find": "keyword3",
    "find-keyword": "keyword1",
    "find-ns": "keyword1",
    "find-var": "keyword3",
    "first": "keyword3",
    "flatten": "keyword3",
    "float": "keyword3",
    "float-array": "keyword3",
    "float?": "literal3",
    "floats": "keyword3",
    "flush": "keyword3",
    "fn": "keyword1",
    "fn?": "literal3",
    "fnext": "keyword3",
    "fnil": "keyword3",
    "for": "keyword2",
    "force": "keyword3",
    "format": "keyword3",
    "formatter": "function",
    "formatter-out": "function",
    "frequencies": "keyword3",
    "fresh-line": "function",
    "frest": "keyword3",
    "function?": "literal3",
    "future": "keyword3",
    "future-call": "keyword3",
    "future-cancel": "keyword3",
    "future-cancelled?": "literal3",
    "future-done?": "literal3",
    "future?": "literal3",
    "gen-class": "keyword1",
    "gen-interface": "keyword1",
    "gensym": "keyword3",
    "get": "keyword3",
    "get-in": "keyword3",
    "get-method": "keyword1",
    "get-pretty-writer": "function",
    "get-proxy-class": "keyword3",
    "get-thread-bindings": "keyword3",
    "get-validator": "keyword3",
    "group-by": "keyword3",
    "hash": "keyword3",
    "hash-combine": "keyword3",
    "hash-map": "keyword3",
    "hash-ordered-coll": "keyword3",
    "hash-set": "keyword3",
    "hash-unordered-coll": "keyword3",
    "identical?": "literal3",
    "identity": "keyword3",
    "if": "keyword2",
    "if-let": "keyword2",
    "if-not": "keyword2",
    "if-some": "keyword2",
    "ifn?": "literal3",
    "import": "keyword1",
    "in-ns": "keyword1",
    "inc": "operator",
    "inc'": "operator",
    "index": "function",
    "init-proxy": "keyword3",
    "input-stream": "function",
    "insert-child": "function",
    "insert-left": "function",
    "insert-right": "function",
    "instance?": "literal3",
    "int": "keyword3",
    "int-array": "keyword3",
    "integer?": "literal3",
    "interleave": "keyword3",
    "intern": "keyword1",
    "interpose": "keyword3",
    "intersection": "function",
    "into": "keyword3",
    "into-array": "keyword3",
    "ints": "keyword3",
    "io!": "keyword3",
    "is": "function",
    "isa?": "literal3",
    "iterate": "keyword3",
    "iterator-seq": "keyword3",
    "join": "function",
    "join-fixtures": "function",
    "juxt": "keyword3",
    "keep": "keyword3",
    "keep-indexed": "keyword3",
    "key": "keyword3",
    "keys": "keyword3",
    "keyword": "keyword3",
    "keyword?": "literal3",
    "keywordize-keys": "function",
    "last": "keyword3",
    "lazy-cat": "keyword3",
    "lazy-cons": "keyword3",
    "lazy-seq": "keyword3",
    "left": "function",
    "leftmost": "function",
    "lefts": "function",
    "let": "keyword2",
    "letfn": "keyword2",
    "line-seq": "keyword3",
    "list": "keyword3",
    "list*": "keyword3",
    "list?": "literal3",
    "load": "keyword3",
    "load-file": "keyword3",
    "load-reader": "keyword3",
    "load-string": "keyword3",
    "loaded-libs": "keyword1",
    "locking": "keyword3",
    "long": "keyword3",
    "long-array": "keyword3",
    "longs": "keyword3",
    "loop": "keyword2",
    "lower-case": "function",
    "macroexpand": "keyword3",
    "macroexpand-1": "keyword3",
    "macroexpand-all": "function",
    "make-array": "keyword3",
    "make-hierarchy": "keyword3",
    "make-input-stream": "function",
    "make-node": "function",
    "make-output-stream": "function",
    "make-parents": "function",
    "make-reader": "function",
    "make-writer": "function",
    "map": "keyword3",
    "map-indexed": "keyword3",
    "map-invert": "function",
    "map?": "literal3",
    "mapcat": "keyword3",
    "mapv": "keyword3",
    "max": "keyword3",
    "max-key": "keyword3",
    "memfn": "keyword3",
    "memoize": "keyword3",
    "merge": "keyword3",
    "merge-with": "keyword3",
    "meta": "keyword3",
    "methods": "keyword1",
    "min": "keyword3",
    "min-key": "keyword3",
    "mix-collection-hash": "keyword3",
    "mod": "operator",
    "munge": "keyword3",
    "name": "keyword3",
    "namespace": "keyword3",
    "namespace-munge": "keyword3",
    "neg?": "literal3",
    "new": "keyword3",
    "newline": "keyword3",
    "next": "function",
    "nfirst": "keyword3",
    "nil": "literal4",
    "nil?": "literal3",
    "nnext": "keyword3",
    "node": "function",
    "not": "operator",
    "not-any?": "literal3",
    "not-empty": "literal3",
    "not-every?": "literal3",
    "not=": "operator",
    "ns": "keyword1",
    "ns-aliases": "keyword1",
    "ns-imports": "keyword1",
    "ns-interns": "keyword1",
    "ns-map": "keyword1",
    "ns-name": "keyword1",
    "ns-publics": "keyword1",
    "ns-refers": "keyword1",
    "ns-resolve": "keyword1",
    "ns-unalias": "keyword1",
    "ns-unmap": "keyword1",
    "nth": "keyword3",
    "nthnext": "keyword3",
    "nthrest": "keyword3",
    "num": "keyword3",
    "number?": "literal3",
    "numerator": "keyword3",
    "object-array": "keyword3",
    "odd?": "literal3",
    "or": "operator",
    "output-stream": "function",
    "parents": "keyword3",
    "parse": "function",
    "parse-timestamp": "function",
    "partial": "keyword1",
    "partition": "keyword3",
    "partition-all": "keyword3",
    "partition-by": "keyword3",
    "path": "function",
    "pcalls": "keyword3",
    "peek": "keyword3",
    "persistent!": "keyword3",
    "pmap": "keyword3",
    "pop": "keyword3",
    "pop!": "keyword3",
    "pos?": "literal3",
    "postwalk": "function",
    "postwalk-demo": "function",
    "postwalk-replace": "function",
    "pp": "function",
    "pprint": "function",
    "pprint-indent": "function",
    "pprint-logical-block": "function",
    "pprint-newline": "function",
    "pprint-tab": "function",
    "pr": "keyword3",
    "pr-str": "keyword3",
    "prefer-method": "keyword1",
    "prefers": "keyword1",
    "prev": "function",
    "prewalk": "function",
    "prewalk-demo": "function",
    "prewalk-replace": "function",
    "primitives-classnames": "keyword3",
    "print": "keyword3",
    "print-cause-trace": "function",
    "print-dup": "keyword3",
    "print-length-loop": "function",
    "print-stack-trace": "function",
    "print-str": "keyword3",
    "print-table": "function",
    "print-throwable": "function",
    "print-trace-element": "function",
    "printf": "keyword3",
    "println": "keyword3",
    "println-str": "keyword3",
    "prn": "keyword3",
    "prn-str": "keyword3",
    "project": "function",
    "promise": "keyword3",
    "proxy": "keyword3",
    "proxy-call-with-super": "keyword3",
    "proxy-mappings": "keyword3",
    "proxy-name": "keyword3",
    "proxy-super": "keyword3",
    "put": "keyword3",
    "pvalues": "keyword3",
    "quot": "literal3",
    "quote": "keyword3",
    "rand": "keyword3",
    "rand-int": "keyword3",
    "rand-nth": "keyword3",
    "range": "keyword3",
    "ratio?": "literal3",
    "rational?": "literal3",
    "rationalize": "keyword3",
    "re-find": "keyword3",
    "re-groups": "keyword3",
    "re-matcher": "keyword3",
    "re-matches": "keyword3",
    "re-pattern": "keyword3",
    "re-quote-replacement": "function",
    "re-seq": "keyword3",
    "read": "keyword3",
    "read-instant-calendar": "function",
    "read-instant-date": "function",
    "read-instant-timestamp": "function",
    "read-line": "keyword3",
    "read-string": "keyword3",
    "reader": "function",
    "realized?": "literal3",
    "record?": "literal3",
    "recur": "keyword2",
    "reduce": "keyword3",
    "reduce-kv": "keyword3",
    "reduced": "keyword3",
    "reduced?": "literal3",
    "reductions": "keyword3",
    "ref": "keyword3",
    "ref-history-count": "keyword3",
    "ref-max-history": "keyword3",
    "ref-min-history": "keyword3",
    "ref-set": "keyword3",
    "refer": "keyword1",
    "refer-clojure": "keyword1",
    "reify": "keyword1",
    "release-pending-sends": "keyword3",
    "rem": "operator",
    "remove": "function",
    "remove-all-methods": "keyword1",
    "remove-method": "keyword1",
    "remove-ns": "keyword1",
    "remove-watch": "keyword3",
    "rename": "function",
    "rename-keys": "function",
    "repeat": "keyword3",
    "repeatedly": "keyword3",
    "replace": "function",
    "replace-first": "function",
    "replicate": "keyword3",
    "require": "keyword1",
    "reset!": "keyword3",
    "reset-meta!": "keyword3",
    "resolve": "keyword3",
    "resource": "function",
    "rest": "keyword3",
    "restart-agent": "keyword3",
    "resultset-seq": "keyword3",
    "reverse": "keyword3",
    "reversible?": "literal3",
    "rfirst": "keyword3",
    "right": "function",
    "rightmost": "function",
    "rights": "function",
    "root": "function",
    "root-cause": "function",
    "rrest": "keyword3",
    "rseq": "keyword3",
    "rsubseq": "keyword3",
    "satisfies?": "literal3",
    "second": "keyword3",
    "select": "function",
    "select-keys": "keyword3",
    "send": "keyword3",
    "send-off": "keyword3",
    "send-via": "keyword3",
    "seq": "keyword3",
    "seq-zip": "function",
    "seq?": "literal3",
    "seque": "keyword3",
    "sequence": "keyword3",
    "sequential?": "literal3",
    "set": "keyword3",
    "set!": "keyword3",
    "set-agent-send-executor!": "keyword3",
    "set-agent-send-off-executor!": "keyword3",
    "set-error-handler!": "keyword3",
    "set-error-mode!": "keyword3",
    "set-pprint-dispatch": "function",
    "set-validator!": "keyword3",
    "set?": "literal3",
    "short": "keyword3",
    "short-array": "keyword3",
    "shorts": "keyword3",
    "shuffle": "keyword3",
    "shutdown-agents": "keyword3",
    "simple-dispatch": "function",
    "slurp": "keyword3",
    "some": "keyword3",
    "some-": "keyword3",
    "some-fn": "keyword3",
    "some?": "literal3",
    "sort": "keyword3",
    "sort-by": "keyword3",
    "sorted-map": "keyword3",
    "sorted-map-by": "keyword3",
    "sorted-set": "keyword3",
    "sorted-set-by": "keyword3",
    "sorted?": "literal3",
    "spit": "keyword3",
    "split": "function",
    "split-at": "keyword3",
    "split-lines": "function",
    "split-with": "keyword3",
    "startparse-sax": "function",
    "str": "keyword3",
    "string?": "literal3",
    "stringify-keys": "function",
    "struct": "keyword3",
    "struct-map": "keyword3",
    "subs": "keyword3",
    "subseq": "keyword3",
    "subset?": "literal3",
    "subvec": "keyword3",
    "successful?": "literal3",
    "supers": "keyword3",
    "superset?": "literal3",
    "swap!": "keyword3",
    "symbol": "keyword3",
    "symbol?": "literal3",
    "sync": "keyword2",
    "tag": "function",
    "take": "keyword3",
    "take-last": "keyword3",
    "take-nth": "keyword3",
    "take-while": "keyword3",
    "test": "keyword3",
    "testing": "function",
    "the-ns": "keyword1",
    "throw": "keyword2",
    "time": "keyword3",
    "to-array": "keyword3",
    "to-array-2d": "keyword3",
    "trampoline": "keyword2",
    "transient": "keyword3",
    "tree-seq": "keyword3",
    "trim": "function",
    "trim-newline": "function",
    "triml": "function",
    "trimr": "function",
    "true": "literal4",
    "true?": "literal3",
    "try": "keyword2",
    "try-expr": "function",
    "type": "keyword3",
    "unchecked-add": "function",
    "unchecked-add-int": "function",
    "unchecked-byte": "function",
    "unchecked-char": "function",
    "unchecked-dec": "function",
    "unchecked-dec-int": "function",
    "unchecked-divide-int": "function",
    "unchecked-double": "function",
    "unchecked-float": "function",
    "unchecked-inc": "function",
    "unchecked-inc-int": "function",
    "unchecked-int": "function",
    "unchecked-long": "function",
    "unchecked-multiply": "function",
    "unchecked-negate": "function",
    "unchecked-negate-int": "function",
    "unchecked-remainder-int": "function",
    "unchecked-short": "function",
    "unchecked-subtract": "function",
    "unchecked-subtract-int": "function",
    "underive": "keyword3",
    "union": "function",
    "unquote": "keyword3",
    "unquote-splicing": "keyword3",
    "unsigned-bit-shift-right": "function",
    "up": "function",
    "update-in": "keyword3",
    "update-proxy": "keyword3",
    "upper-case": "function",
    "use": "keyword1",
    "use-fixtures": "function",
    "val": "keyword3",
    "validated": "function",
    "vals": "keyword3",
    "var": "keyword3",
    "var-get": "keyword3",
    "var-set": "keyword3",
    "var?": "literal3",
    "vary-meta": "keyword3",
    "vec": "keyword3",
    "vector": "keyword3",
    "vector-of": "keyword3",
    "vector-zip": "function",
    "vector?": "literal3",
    "walk": "function",
    "when": "keyword2",
    "when-first": "keyword2",
    "when-let": "keyword2",
    "when-not": "keyword2",
    "when-some": "keyword2",
    "while": "keyword2",
    "with-bindings": "keyword3",
    "with-bindings*": "keyword3",
    "with-in-str": "keyword3",
    "with-loading-context": "keyword3",
    "with-local-vars": "keyword3",
    "with-meta": "keyword3",
    "with-open": "keyword3",
    "with-out-str": "keyword3",
    "with-pprint-dispatch": "function",
    "with-precision": "keyword3",
    "with-redefs": "keyword3",
    "with-redefs-fn": "keyword3",
    "with-test": "keyword3",
    "with-test-out": "keyword3",
    "write": "function",
    "write-out": "function",
    "writer": "function",
    "xml-seq": "keyword3",
    "xml-zip": "function",
    "zero?": "literal3",
    "zipmap": "keyword3",
    "zipper": "function",
}

# Keywords dict for clojure_strings ruleset.
clojure_strings_keywords_dict = {
    "\"": "invalid",
}

# Keywords dict for clojure_regexps ruleset.
clojure_regexps_keywords_dict = {
    "\"": "invalid",
}

# Dictionary of keywords dictionaries for clojure mode.
keywordsDictDict = {
    "clojure_main": clojure_main_keywords_dict,
    "clojure_regexps": clojure_regexps_keywords_dict,
    "clojure_strings": clojure_strings_keywords_dict,
}

# Rules for clojure_main ruleset.

def clojure_rule0(colorer, s, i):
    return colorer.match_span(s, i, kind="keyword4", begin="*", end="*",
          delegate="clojure::main")

def clojure_rule1(colorer, s, i):
    return colorer.match_span(s, i, kind="markup", begin="#^(", end=")",
          delegate="clojure::main")

def clojure_rule2(colorer, s, i):
    return colorer.match_span(s, i, kind="literal3", begin="@(", end=")",
          delegate="clojure::main")

def clojure_rule3(colorer, s, i):
    return colorer.match_span(s, i, kind="literal3", begin="^(", end=")",
          delegate="clojure::main")

def clojure_rule4(colorer, s, i):
    return colorer.match_span(s, i, kind="literal3", begin="`(", end=")",
          delegate="clojure::main")

def clojure_rule5(colorer, s, i):
    return colorer.match_span(s, i, kind="literal3", begin="'(", end=")",
          delegate="clojure::main")

def clojure_rule6(colorer, s, i):
    return colorer.match_span(s, i, kind="comment3", begin="#_(", end=")",
          delegate="clojure::main")

def clojure_rule7(colorer, s, i):
    return colorer.match_span(s, i, kind="keyword1", begin="#(", end=")",
          delegate="clojure::main")

def clojure_rule8(colorer, s, i):
    return colorer.match_span(s, i, kind="markup", begin="(", end=")",
          delegate="clojure::main")

def clojure_rule9(colorer, s, i):
    return colorer.match_span(s, i, kind="markup", begin="#^[", end="]",
          delegate="clojure::main")

def clojure_rule10(colorer, s, i):
    return colorer.match_span(s, i, kind="literal3", begin="@[", end="]",
          delegate="clojure::main")

def clojure_rule11(colorer, s, i):
    return colorer.match_span(s, i, kind="literal3", begin="^[", end="]",
          delegate="clojure::main")

def clojure_rule12(colorer, s, i):
    return colorer.match_span(s, i, kind="literal3", begin="'[", end="]",
          delegate="clojure::main")

def clojure_rule13(colorer, s, i):
    return colorer.match_span(s, i, kind="keyword1", begin="[", end="]",
          delegate="clojure::main")

def clojure_rule14(colorer, s, i):
    return colorer.match_span(s, i, kind="markup", begin="#^{", end="}",
          delegate="clojure::main")

def clojure_rule15(colorer, s, i):
    return colorer.match_span(s, i, kind="literal3", begin="@{", end="}",
          delegate="clojure::main")

def clojure_rule16(colorer, s, i):
    return colorer.match_span(s, i, kind="literal3", begin="^{", end="}",
          delegate="clojure::main")

def clojure_rule17(colorer, s, i):
    return colorer.match_span(s, i, kind="literal3", begin="'{", end="}",
          delegate="clojure::main")

def clojure_rule18(colorer, s, i):
    return colorer.match_span(s, i, kind="label", begin="{", end="}",
          delegate="clojure::main")

def clojure_rule19(colorer, s, i):
    return colorer.match_span(s, i, kind="markup", begin="#^#{", end="}",
          delegate="clojure::main")

def clojure_rule20(colorer, s, i):
    return colorer.match_span(s, i, kind="literal3", begin="@#{", end="}",
          delegate="clojure::main")

def clojure_rule21(colorer, s, i):
    return colorer.match_span(s, i, kind="literal3", begin="^#{", end="}",
          delegate="clojure::main")

def clojure_rule22(colorer, s, i):
    return colorer.match_span(s, i, kind="literal3", begin="'#{", end="}",
          delegate="clojure::main")

def clojure_rule23(colorer, s, i):
    return colorer.match_span(s, i, kind="label", begin="#{", end="}",
          delegate="clojure::main")

def clojure_rule24(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="keyword2", seq="#'")

def clojure_rule25(colorer, s, i):
    return colorer.match_mark_following(s, i, kind="literal3", pattern="'")

def clojure_rule26(colorer, s, i):
    return colorer.match_mark_following(s, i, kind="label", pattern="^")

def clojure_rule27(colorer, s, i):
    return colorer.match_mark_following(s, i, kind="label", pattern="@")

def clojure_rule28(colorer, s, i):
    return colorer.match_mark_following(s, i, kind="literal3", pattern=".")

def clojure_rule29(colorer, s, i):
    return colorer.match_mark_following(s, i, kind="markup", pattern="#^")

def clojure_rule30(colorer, s, i):
    return colorer.match_eol_span(s, i, kind="comment4", seq=";;;;")

def clojure_rule31(colorer, s, i):
    return colorer.match_eol_span(s, i, kind="comment3", seq=";;;")

def clojure_rule32(colorer, s, i):
    return colorer.match_eol_span(s, i, kind="comment2", seq=";;")

def clojure_rule33(colorer, s, i):
    return colorer.match_eol_span(s, i, kind="comment1", seq=";")

def clojure_rule34(colorer, s, i):
    return colorer.match_span(s, i, kind="literal2", begin="#\"", end="\"",
          delegate="clojure::regexps")

def clojure_rule35(colorer, s, i):
    return colorer.match_span(s, i, kind="literal1", begin="\"", end="\"",
          delegate="clojure::strings")

def clojure_rule36(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="literal2", regexp="\\\\(.|newline|space|tab)")

def clojure_rule37(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="literal4", seq=".")

def clojure_rule38(colorer, s, i):
    return colorer.match_mark_following(s, i, kind="keyword4", pattern=":")

def clojure_rule39(colorer, s, i):
    return colorer.match_keywords(s, i)

# Rules dict for clojure_main ruleset.
rulesDict1 = {
    "!": [clojure_rule39,],
    "\"": [clojure_rule35, clojure_rule39,],
    "#": [clojure_rule1, clojure_rule6, clojure_rule7, clojure_rule9, clojure_rule14, clojure_rule19, clojure_rule23, clojure_rule24, clojure_rule29, clojure_rule34,],
    "%": [clojure_rule39,],
    "&": [clojure_rule39,],
    "'": [clojure_rule5, clojure_rule12, clojure_rule17, clojure_rule22, clojure_rule25, clojure_rule39,],
    "(": [clojure_rule8,],
    "*": [clojure_rule0, clojure_rule39,],
    "+": [clojure_rule39,],
    "-": [clojure_rule39,],
    ".": [clojure_match_numbers, clojure_rule28, clojure_rule37, clojure_rule39,],
    "/": [clojure_rule39,],
    "0": [clojure_match_numbers, clojure_rule39,],
    "1": [clojure_match_numbers, clojure_rule39,],
    "2": [clojure_match_numbers, clojure_rule39,],
    "3": [clojure_match_numbers, clojure_rule39,],
    "4": [clojure_match_numbers, clojure_rule39,],
    "5": [clojure_match_numbers, clojure_rule39,],
    "6": [clojure_match_numbers, clojure_rule39,],
    "7": [clojure_match_numbers, clojure_rule39,],
    "8": [clojure_match_numbers, clojure_rule39,],
    "9": [clojure_match_numbers, clojure_rule39,],
    ":": [clojure_rule38,],
    ";": [clojure_rule30, clojure_rule31, clojure_rule32, clojure_rule33,],
    "<": [clojure_rule39,],
    "=": [clojure_rule39,],
    ">": [clojure_rule39,],
    "?": [clojure_rule39,],
    "@": [clojure_rule2, clojure_rule10, clojure_rule15, clojure_rule20, clojure_rule27, clojure_rule39,],
    "A": [clojure_rule39,],
    "B": [clojure_rule39,],
    "C": [clojure_rule39,],
    "D": [clojure_rule39,],
    "E": [clojure_rule39,],
    "F": [clojure_rule39,],
    "G": [clojure_rule39,],
    "H": [clojure_rule39,],
    "I": [clojure_rule39,],
    "J": [clojure_rule39,],
    "K": [clojure_rule39,],
    "L": [clojure_rule39,],
    "M": [clojure_rule39,],
    "N": [clojure_rule39,],
    "O": [clojure_rule39,],
    "P": [clojure_rule39,],
    "Q": [clojure_rule39,],
    "R": [clojure_rule39,],
    "S": [clojure_rule39,],
    "T": [clojure_rule39,],
    "U": [clojure_rule39,],
    "V": [clojure_rule39,],
    "W": [clojure_rule39,],
    "X": [clojure_rule39,],
    "Y": [clojure_rule39,],
    "Z": [clojure_rule39,],
    "[": [clojure_rule13,],
    "\\": [clojure_rule36,],
    "^": [clojure_rule3, clojure_rule11, clojure_rule16, clojure_rule21, clojure_rule26,],
    "`": [clojure_rule4,],
    "a": [clojure_rule39,],
    "b": [clojure_rule39,],
    "c": [clojure_rule39,],
    "d": [clojure_rule39,],
    "e": [clojure_rule39,],
    "f": [clojure_rule39,],
    "g": [clojure_rule39,],
    "h": [clojure_rule39,],
    "i": [clojure_rule39,],
    "j": [clojure_rule39,],
    "k": [clojure_rule39,],
    "l": [clojure_rule39,],
    "m": [clojure_rule39,],
    "n": [clojure_rule39,],
    "o": [clojure_rule39,],
    "p": [clojure_rule39,],
    "q": [clojure_rule39,],
    "r": [clojure_rule39,],
    "s": [clojure_rule39,],
    "t": [clojure_rule39,],
    "u": [clojure_rule39,],
    "v": [clojure_rule39,],
    "w": [clojure_rule39,],
    "x": [clojure_rule39,],
    "y": [clojure_rule39,],
    "z": [clojure_rule39,],
    "{": [clojure_rule18,],
}

# Rules for clojure_strings ruleset.

def clojure_rule40(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="label", regexp="\\\\.")

def clojure_rule41(colorer, s, i):
    j = s.find('"', i)
    while j > 0 and s[j] == '\\':
        j = s.find('"', j + 1)
    if j < 0: j = len(s)
    colorer.colorRangeWithTag(s, i, j, "literal1")
    return j - i

# Rules dict for clojure_strings ruleset.
rulesDict2 = {
    "!": [clojure_rule41,],
    "\"": [clojure_rule41,],
    "%": [clojure_rule41,],
    "&": [clojure_rule41,],
    "'": [clojure_rule41,],
    "*": [clojure_rule41,],
    "+": [clojure_rule41,],
    "-": [clojure_rule41,],
    ".": [clojure_rule41,],
    "/": [clojure_rule41,],
    "0": [clojure_rule41,],
    "1": [clojure_rule41,],
    "2": [clojure_rule41,],
    "3": [clojure_rule41,],
    "4": [clojure_rule41,],
    "5": [clojure_rule41,],
    "6": [clojure_rule41,],
    "7": [clojure_rule41,],
    "8": [clojure_rule41,],
    "9": [clojure_rule41,],
    "<": [clojure_rule41,],
    "=": [clojure_rule41,],
    ">": [clojure_rule41,],
    "?": [clojure_rule41,],
    "@": [clojure_rule41,],
    "A": [clojure_rule41,],
    "B": [clojure_rule41,],
    "C": [clojure_rule41,],
    "D": [clojure_rule41,],
    "E": [clojure_rule41,],
    "F": [clojure_rule41,],
    "G": [clojure_rule41,],
    "H": [clojure_rule41,],
    "I": [clojure_rule41,],
    "J": [clojure_rule41,],
    "K": [clojure_rule41,],
    "L": [clojure_rule41,],
    "M": [clojure_rule41,],
    "N": [clojure_rule41,],
    "O": [clojure_rule41,],
    "P": [clojure_rule41,],
    "Q": [clojure_rule41,],
    "R": [clojure_rule41,],
    "S": [clojure_rule41,],
    "T": [clojure_rule41,],
    "U": [clojure_rule41,],
    "V": [clojure_rule41,],
    "W": [clojure_rule41,],
    "X": [clojure_rule41,],
    "Y": [clojure_rule41,],
    "Z": [clojure_rule41,],
    "\\": [clojure_rule40,],
    "a": [clojure_rule41,],
    "b": [clojure_rule41,],
    "c": [clojure_rule41,],
    "d": [clojure_rule41,],
    "e": [clojure_rule41,],
    "f": [clojure_rule41,],
    "g": [clojure_rule41,],
    "h": [clojure_rule41,],
    "i": [clojure_rule41,],
    "j": [clojure_rule41,],
    "k": [clojure_rule41,],
    "l": [clojure_rule41,],
    "m": [clojure_rule41,],
    "n": [clojure_rule41,],
    "o": [clojure_rule41,],
    "p": [clojure_rule41,],
    "q": [clojure_rule41,],
    "r": [clojure_rule41,],
    "s": [clojure_rule41,],
    "t": [clojure_rule41,],
    "u": [clojure_rule41,],
    "v": [clojure_rule41,],
    "w": [clojure_rule41,],
    "x": [clojure_rule41,],
    "y": [clojure_rule41,],
    "z": [clojure_rule41,],
}

# Rules for clojure_regexps ruleset.

def clojure_rule42(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="label", regexp="\\\\.")

def clojure_rule43(colorer, s, i):
    return colorer.match_keywords(s, i)

# Rules dict for clojure_regexps ruleset.
rulesDict3 = {
    "!": [clojure_rule43,],
    "\"": [clojure_rule43,],
    "%": [clojure_rule43,],
    "&": [clojure_rule43,],
    "'": [clojure_rule43,],
    "*": [clojure_rule43,],
    "+": [clojure_rule43,],
    "-": [clojure_rule43,],
    ".": [clojure_rule43,],
    "/": [clojure_rule43,],
    "0": [clojure_rule43,],
    "1": [clojure_rule43,],
    "2": [clojure_rule43,],
    "3": [clojure_rule43,],
    "4": [clojure_rule43,],
    "5": [clojure_rule43,],
    "6": [clojure_rule43,],
    "7": [clojure_rule43,],
    "8": [clojure_rule43,],
    "9": [clojure_rule43,],
    "<": [clojure_rule43,],
    "=": [clojure_rule43,],
    ">": [clojure_rule43,],
    "?": [clojure_rule43,],
    "@": [clojure_rule43,],
    "A": [clojure_rule43,],
    "B": [clojure_rule43,],
    "C": [clojure_rule43,],
    "D": [clojure_rule43,],
    "E": [clojure_rule43,],
    "F": [clojure_rule43,],
    "G": [clojure_rule43,],
    "H": [clojure_rule43,],
    "I": [clojure_rule43,],
    "J": [clojure_rule43,],
    "K": [clojure_rule43,],
    "L": [clojure_rule43,],
    "M": [clojure_rule43,],
    "N": [clojure_rule43,],
    "O": [clojure_rule43,],
    "P": [clojure_rule43,],
    "Q": [clojure_rule43,],
    "R": [clojure_rule43,],
    "S": [clojure_rule43,],
    "T": [clojure_rule43,],
    "U": [clojure_rule43,],
    "V": [clojure_rule43,],
    "W": [clojure_rule43,],
    "X": [clojure_rule43,],
    "Y": [clojure_rule43,],
    "Z": [clojure_rule43,],
    "\\": [clojure_rule42,],
    "a": [clojure_rule43,],
    "b": [clojure_rule43,],
    "c": [clojure_rule43,],
    "d": [clojure_rule43,],
    "e": [clojure_rule43,],
    "f": [clojure_rule43,],
    "g": [clojure_rule43,],
    "h": [clojure_rule43,],
    "i": [clojure_rule43,],
    "j": [clojure_rule43,],
    "k": [clojure_rule43,],
    "l": [clojure_rule43,],
    "m": [clojure_rule43,],
    "n": [clojure_rule43,],
    "o": [clojure_rule43,],
    "p": [clojure_rule43,],
    "q": [clojure_rule43,],
    "r": [clojure_rule43,],
    "s": [clojure_rule43,],
    "t": [clojure_rule43,],
    "u": [clojure_rule43,],
    "v": [clojure_rule43,],
    "w": [clojure_rule43,],
    "x": [clojure_rule43,],
    "y": [clojure_rule43,],
    "z": [clojure_rule43,],
}

# x.rulesDictDict for clojure mode.
rulesDictDict = {
    "clojure_main": rulesDict1,
    "clojure_regexps": rulesDict3,
    "clojure_strings": rulesDict2,
}

# Import dict for clojure mode.
importDict = {}
