
/* LMS7002 definitions for HOST/MCU operations */
#ifndef LMS7002M_DEFS_H
#define LMS7002M_DEFS_H

/* Auto generated file, DO NOT MODIFY */


/*************************************
 * AFE configuration registers
 *************************************/
enum lms7002m_reg_0x0082 {
    LMS7002_AFE_ISEL_DAC_AFE_OFF = 13,
    LMS7002_AFE_ISEL_DAC_AFE_MSK = 0x7,
    LMS7002_AFE_MODE_INTERLEAVE_AFE_OFF = 12,
    LMS7002_AFE_MUX_AFE_1_OFF = 10,
    LMS7002_AFE_MUX_AFE_1_MSK = 0x3,
    LMS7002_AFE_MUX_AFE_2_OFF = 8,
    LMS7002_AFE_MUX_AFE_2_MSK = 0x3,
    LMS7002_AFE_PD_AFE_OFF = 5,
    LMS7002_AFE_PD_RX_AFE1_OFF = 4,
    LMS7002_AFE_PD_RX_AFE2_OFF = 3,
    LMS7002_AFE_PD_TX_AFE1_OFF = 2,
    LMS7002_AFE_PD_TX_AFE2_OFF = 1,
    LMS7002_AFE_EN_G_AFE_OFF = 0,
};
#define MAKE_LMS7002_0x0082( ISEL_DAC_AFE, MODE_INTERLEAVE_AFE, MUX_AFE_1, MUX_AFE_2, PD_AFE, PD_RX_AFE1, PD_RX_AFE2, PD_TX_AFE1, PD_TX_AFE2, EN_G_AFE ) ( \
    (((ISEL_DAC_AFE) & 0x7) << 13) | \
    (((MODE_INTERLEAVE_AFE) & 0x1) << 12) | \
    (((MUX_AFE_1) & 0x3) << 10) | \
    (((MUX_AFE_2) & 0x3) << 8) | \
    (((PD_AFE) & 0x1) << 5) | \
    (((PD_RX_AFE1) & 0x1) << 4) | \
    (((PD_RX_AFE2) & 0x1) << 3) | \
    (((PD_TX_AFE1) & 0x1) << 2) | \
    (((PD_TX_AFE2) & 0x1) << 1) | \
    (((EN_G_AFE) & 0x1) << 0) | \
    (0x00820000 | 0x80000000))
#define GET_LMS7002_AFE_ISEL_DAC_AFE(r) (((r) >> 13 ) & 0x7)
#define GET_LMS7002_AFE_MODE_INTERLEAVE_AFE(r) (((r) >> 12 ) & 0x1)
#define GET_LMS7002_AFE_MUX_AFE_1(r) (((r) >> 10 ) & 0x3)
#define GET_LMS7002_AFE_MUX_AFE_2(r) (((r) >> 8 ) & 0x3)
#define GET_LMS7002_AFE_PD_AFE(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_AFE_PD_RX_AFE1(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_AFE_PD_RX_AFE2(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_AFE_PD_TX_AFE1(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_AFE_PD_TX_AFE2(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_AFE_EN_G_AFE(r) (((r) >> 0 ) & 0x1)



/*************************************
 * BIAS configuration registers
 *************************************/
enum lms7002m_reg_0x0084 {
    LMS7002_BIAS_MUX_BIAS_OUT_OFF = 11,
    LMS7002_BIAS_MUX_BIAS_OUT_MSK = 0x3,
    LMS7002_BIAS_RP_CALIB_BIAS_OFF = 6,
    LMS7002_BIAS_RP_CALIB_BIAS_MSK = 0x1f,
    LMS7002_BIAS_PD_FRP_BIAS_OFF = 4,
    LMS7002_BIAS_PD_F_BIAS_OFF = 3,
    LMS7002_BIAS_PD_PTRP_BIAS_OFF = 2,
    LMS7002_BIAS_PD_PT_BIAS_OFF = 1,
    LMS7002_BIAS_PD_BIAS_MASTER_OFF = 0,
};
#define MAKE_LMS7002_0x0084( MUX_BIAS_OUT, RP_CALIB_BIAS, PD_FRP_BIAS, PD_F_BIAS, PD_PTRP_BIAS, PD_PT_BIAS, PD_BIAS_MASTER ) ( \
    (((MUX_BIAS_OUT) & 0x3) << 11) | \
    (((RP_CALIB_BIAS) & 0x1f) << 6) | \
    (((PD_FRP_BIAS) & 0x1) << 4) | \
    (((PD_F_BIAS) & 0x1) << 3) | \
    (((PD_PTRP_BIAS) & 0x1) << 2) | \
    (((PD_PT_BIAS) & 0x1) << 1) | \
    (((PD_BIAS_MASTER) & 0x1) << 0) | \
    (0x00840000 | 0x80000000))
#define GET_LMS7002_BIAS_MUX_BIAS_OUT(r) (((r) >> 11 ) & 0x3)
#define GET_LMS7002_BIAS_RP_CALIB_BIAS(r) (((r) >> 6 ) & 0x1f)
#define GET_LMS7002_BIAS_PD_FRP_BIAS(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_BIAS_PD_F_BIAS(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_BIAS_PD_PTRP_BIAS(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_BIAS_PD_PT_BIAS(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_BIAS_PD_BIAS_MASTER(r) (((r) >> 0 ) & 0x1)



/*************************************
 * CGEN configuration registers
 *************************************/
enum lms7002m_reg_0x0086 {
    LMS7002_CGEN_SPDUP_VCO_CGEN_OFF = 15,
    LMS7002_CGEN_RESET_N_CGEN_OFF = 14,
    LMS7002_CGEN_EN_ADCCLKH_CLKGN_OFF = 11,
    LMS7002_CGEN_EN_COARSE_CKLGEN_OFF = 10,
    LMS7002_CGEN_EN_INTONLY_SDM_CGEN_OFF = 9,
    LMS7002_CGEN_EN_SDM_CLK_CGEN_OFF = 8,
    LMS7002_CGEN_PD_CP_CGEN_OFF = 6,
    LMS7002_CGEN_PD_FDIV_FB_CGEN_OFF = 5,
    LMS7002_CGEN_PD_FDIV_O_CGEN_OFF = 4,
    LMS7002_CGEN_PD_SDM_CGEN_OFF = 3,
    LMS7002_CGEN_PD_VCO_CGEN_OFF = 2,
    LMS7002_CGEN_PD_VCO_COMP_CGEN_OFF = 1,
    LMS7002_CGEN_EN_G_CGEN_OFF = 0,
};
#define MAKE_LMS7002_0x0086( SPDUP_VCO_CGEN, RESET_N_CGEN, EN_ADCCLKH_CLKGN, EN_COARSE_CKLGEN, EN_INTONLY_SDM_CGEN, EN_SDM_CLK_CGEN, PD_CP_CGEN, PD_FDIV_FB_CGEN, PD_FDIV_O_CGEN, PD_SDM_CGEN, PD_VCO_CGEN, PD_VCO_COMP_CGEN, EN_G_CGEN ) ( \
    (((SPDUP_VCO_CGEN) & 0x1) << 15) | \
    (((RESET_N_CGEN) & 0x1) << 14) | \
    (((EN_ADCCLKH_CLKGN) & 0x1) << 11) | \
    (((EN_COARSE_CKLGEN) & 0x1) << 10) | \
    (((EN_INTONLY_SDM_CGEN) & 0x1) << 9) | \
    (((EN_SDM_CLK_CGEN) & 0x1) << 8) | \
    (((PD_CP_CGEN) & 0x1) << 6) | \
    (((PD_FDIV_FB_CGEN) & 0x1) << 5) | \
    (((PD_FDIV_O_CGEN) & 0x1) << 4) | \
    (((PD_SDM_CGEN) & 0x1) << 3) | \
    (((PD_VCO_CGEN) & 0x1) << 2) | \
    (((PD_VCO_COMP_CGEN) & 0x1) << 1) | \
    (((EN_G_CGEN) & 0x1) << 0) | \
    (0x00860000 | 0x80000000))
#define GET_LMS7002_CGEN_SPDUP_VCO_CGEN(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_CGEN_RESET_N_CGEN(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_CGEN_EN_ADCCLKH_CLKGN(r) (((r) >> 11 ) & 0x1)
#define GET_LMS7002_CGEN_EN_COARSE_CKLGEN(r) (((r) >> 10 ) & 0x1)
#define GET_LMS7002_CGEN_EN_INTONLY_SDM_CGEN(r) (((r) >> 9 ) & 0x1)
#define GET_LMS7002_CGEN_EN_SDM_CLK_CGEN(r) (((r) >> 8 ) & 0x1)
#define GET_LMS7002_CGEN_PD_CP_CGEN(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_CGEN_PD_FDIV_FB_CGEN(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_CGEN_PD_FDIV_O_CGEN(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_CGEN_PD_SDM_CGEN(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_CGEN_PD_VCO_CGEN(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_CGEN_PD_VCO_COMP_CGEN(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_CGEN_EN_G_CGEN(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x0087 {
    LMS7002_CGEN_FRAC_SDM_CGEN_LSB_OFF = 0,
    LMS7002_CGEN_FRAC_SDM_CGEN_LSB_MSK = 0xffff,
};
#define MAKE_LMS7002_0x0087( FRAC_SDM_CGEN_LSB ) ( \
    (((FRAC_SDM_CGEN_LSB) & 0xffff) << 0) | \
    (0x00870000 | 0x80000000))
#define GET_LMS7002_CGEN_FRAC_SDM_CGEN_LSB(r) (((r) >> 0 ) & 0xffff)

enum lms7002m_reg_0x0088 {
    LMS7002_CGEN_INT_SDM_CGEN_OFF = 4,
    LMS7002_CGEN_INT_SDM_CGEN_MSK = 0x3ff,
    LMS7002_CGEN_FRAC_SDM_CGEN_MSB_OFF = 0,
    LMS7002_CGEN_FRAC_SDM_CGEN_MSB_MSK = 0xf,
};
#define MAKE_LMS7002_0x0088( INT_SDM_CGEN, FRAC_SDM_CGEN_MSB ) ( \
    (((INT_SDM_CGEN) & 0x3ff) << 4) | \
    (((FRAC_SDM_CGEN_MSB) & 0xf) << 0) | \
    (0x00880000 | 0x80000000))
#define GET_LMS7002_CGEN_INT_SDM_CGEN(r) (((r) >> 4 ) & 0x3ff)
#define GET_LMS7002_CGEN_FRAC_SDM_CGEN_MSB(r) (((r) >> 0 ) & 0xf)

enum lms7002m_reg_0x0089 {
    LMS7002_CGEN_REV_SDMCLK_CGEN_OFF = 15,
    LMS7002_CGEN_SEL_SDMCLK_CGEN_OFF = 14,
    LMS7002_CGEN_SX_DITHER_EN_CGEN_OFF = 13,
    LMS7002_CGEN_CLKH_OV_CLKL_CGEN_OFF = 11,
    LMS7002_CGEN_CLKH_OV_CLKL_CGEN_MSK = 0x3,
    LMS7002_CGEN_DIV_OUTCH_CGEN_OFF = 3,
    LMS7002_CGEN_DIV_OUTCH_CGEN_MSK = 0xff,
    LMS7002_CGEN_TST_CGEN_OFF = 0,
    LMS7002_CGEN_TST_CGEN_MSK = 0x7,
};
#define MAKE_LMS7002_0x0089( REV_SDMCLK_CGEN, SEL_SDMCLK_CGEN, SX_DITHER_EN_CGEN, CLKH_OV_CLKL_CGEN, DIV_OUTCH_CGEN, TST_CGEN ) ( \
    (((REV_SDMCLK_CGEN) & 0x1) << 15) | \
    (((SEL_SDMCLK_CGEN) & 0x1) << 14) | \
    (((SX_DITHER_EN_CGEN) & 0x1) << 13) | \
    (((CLKH_OV_CLKL_CGEN) & 0x3) << 11) | \
    (((DIV_OUTCH_CGEN) & 0xff) << 3) | \
    (((TST_CGEN) & 0x7) << 0) | \
    (0x00890000 | 0x80000000))
#define GET_LMS7002_CGEN_REV_SDMCLK_CGEN(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_CGEN_SEL_SDMCLK_CGEN(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_CGEN_SX_DITHER_EN_CGEN(r) (((r) >> 13 ) & 0x1)
#define GET_LMS7002_CGEN_CLKH_OV_CLKL_CGEN(r) (((r) >> 11 ) & 0x3)
#define GET_LMS7002_CGEN_DIV_OUTCH_CGEN(r) (((r) >> 3 ) & 0xff)
#define GET_LMS7002_CGEN_TST_CGEN(r) (((r) >> 0 ) & 0x7)

enum lms7002m_reg_0x008A {
    LMS7002_CGEN_REV_CLKDAC_CGEN_OFF = 14,
    LMS7002_CGEN_REV_CLKADC_CGEN_OFF = 13,
    LMS7002_CGEN_REVPH_PFD_CGEN_OFF = 12,
    LMS7002_CGEN_IOFFSET_CP_CGEN_OFF = 6,
    LMS7002_CGEN_IOFFSET_CP_CGEN_MSK = 0x3f,
    LMS7002_CGEN_IPULSE_CP_CGEN_OFF = 0,
    LMS7002_CGEN_IPULSE_CP_CGEN_MSK = 0x3f,
};
#define MAKE_LMS7002_0x008A( REV_CLKDAC_CGEN, REV_CLKADC_CGEN, REVPH_PFD_CGEN, IOFFSET_CP_CGEN, IPULSE_CP_CGEN ) ( \
    (((REV_CLKDAC_CGEN) & 0x1) << 14) | \
    (((REV_CLKADC_CGEN) & 0x1) << 13) | \
    (((REVPH_PFD_CGEN) & 0x1) << 12) | \
    (((IOFFSET_CP_CGEN) & 0x3f) << 6) | \
    (((IPULSE_CP_CGEN) & 0x3f) << 0) | \
    (0x008A0000 | 0x80000000))
#define GET_LMS7002_CGEN_REV_CLKDAC_CGEN(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_CGEN_REV_CLKADC_CGEN(r) (((r) >> 13 ) & 0x1)
#define GET_LMS7002_CGEN_REVPH_PFD_CGEN(r) (((r) >> 12 ) & 0x1)
#define GET_LMS7002_CGEN_IOFFSET_CP_CGEN(r) (((r) >> 6 ) & 0x3f)
#define GET_LMS7002_CGEN_IPULSE_CP_CGEN(r) (((r) >> 0 ) & 0x3f)

enum lms7002m_reg_0x008B {
    LMS7002_CGEN_ICT_VCO_CGEN_OFF = 9,
    LMS7002_CGEN_ICT_VCO_CGEN_MSK = 0x1f,
    LMS7002_CGEN_CSW_VCO_CGEN_OFF = 1,
    LMS7002_CGEN_CSW_VCO_CGEN_MSK = 0xff,
    LMS7002_CGEN_COARSE_START_CGEN_OFF = 0,
};
#define MAKE_LMS7002_0x008B( ICT_VCO_CGEN, CSW_VCO_CGEN, COARSE_START_CGEN ) ( \
    (((ICT_VCO_CGEN) & 0x1f) << 9) | \
    (((CSW_VCO_CGEN) & 0xff) << 1) | \
    (((COARSE_START_CGEN) & 0x1) << 0) | \
    (0x008B0000 | 0x80000000))
#define GET_LMS7002_CGEN_ICT_VCO_CGEN(r) (((r) >> 9 ) & 0x1f)
#define GET_LMS7002_CGEN_CSW_VCO_CGEN(r) (((r) >> 1 ) & 0xff)
#define GET_LMS7002_CGEN_COARSE_START_CGEN(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x008C {
    LMS7002_CGEN_COARSE_STEPDONE_CGEN_OFF = 15,
    LMS7002_CGEN_COARSEPLL_COMPO_CGEN_OFF = 14,
    LMS7002_CGEN_VCO_CMPHO_CGEN_OFF = 13,
    LMS7002_CGEN_VCO_CMPLO_CGEN_OFF = 12,
    LMS7002_CGEN_CP2_CGEN_OFF = 8,
    LMS7002_CGEN_CP2_CGEN_MSK = 0xf,
    LMS7002_CGEN_CP3_CGEN_OFF = 4,
    LMS7002_CGEN_CP3_CGEN_MSK = 0xf,
    LMS7002_CGEN_CZ_CGEN_OFF = 0,
    LMS7002_CGEN_CZ_CGEN_MSK = 0xf,
};
#define MAKE_LMS7002_0x008C( COARSE_STEPDONE_CGEN, COARSEPLL_COMPO_CGEN, VCO_CMPHO_CGEN, VCO_CMPLO_CGEN, CP2_CGEN, CP3_CGEN, CZ_CGEN ) ( \
    (((COARSE_STEPDONE_CGEN) & 0x1) << 15) | \
    (((COARSEPLL_COMPO_CGEN) & 0x1) << 14) | \
    (((VCO_CMPHO_CGEN) & 0x1) << 13) | \
    (((VCO_CMPLO_CGEN) & 0x1) << 12) | \
    (((CP2_CGEN) & 0xf) << 8) | \
    (((CP3_CGEN) & 0xf) << 4) | \
    (((CZ_CGEN) & 0xf) << 0) | \
    (0x008C0000 | 0x80000000))
#define GET_LMS7002_CGEN_COARSE_STEPDONE_CGEN(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_CGEN_COARSEPLL_COMPO_CGEN(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_CGEN_VCO_CMPHO_CGEN(r) (((r) >> 13 ) & 0x1)
#define GET_LMS7002_CGEN_VCO_CMPLO_CGEN(r) (((r) >> 12 ) & 0x1)
#define GET_LMS7002_CGEN_CP2_CGEN(r) (((r) >> 8 ) & 0xf)
#define GET_LMS7002_CGEN_CP3_CGEN(r) (((r) >> 4 ) & 0xf)
#define GET_LMS7002_CGEN_CZ_CGEN(r) (((r) >> 0 ) & 0xf)

enum lms7002m_reg_0x008D {
    LMS7002_CGEN_RESRV_CGN_OFF = 0,
    LMS7002_CGEN_RESRV_CGN_MSK = 0x7,
};
#define MAKE_LMS7002_0x008D( RESRV_CGN ) ( \
    (((RESRV_CGN) & 0x7) << 0) | \
    (0x008D0000 | 0x80000000))
#define GET_LMS7002_CGEN_RESRV_CGN(r) (((r) >> 0 ) & 0x7)



/*************************************
 * DC configuration registers
 *************************************/
enum lms7002m_reg_0x05C0 {
    LMS7002_DC_DCMODE_OFF = 15,
    LMS7002_DC_PD_DCDAC_RXB_OFF = 7,
    LMS7002_DC_PD_DCDAC_RXA_OFF = 6,
    LMS7002_DC_PD_DCDAC_TXB_OFF = 5,
    LMS7002_DC_PD_DCDAC_TXA_OFF = 4,
    LMS7002_DC_PD_DCCMP_RXB_OFF = 3,
    LMS7002_DC_PD_DCCMP_RXA_OFF = 2,
    LMS7002_DC_PD_DCCMP_TXB_OFF = 1,
    LMS7002_DC_PD_DCCMP_TXA_OFF = 0,
};
#define MAKE_LMS7002_0x05C0( DCMODE, PD_DCDAC_RXB, PD_DCDAC_RXA, PD_DCDAC_TXB, PD_DCDAC_TXA, PD_DCCMP_RXB, PD_DCCMP_RXA, PD_DCCMP_TXB, PD_DCCMP_TXA ) ( \
    (((DCMODE) & 0x1) << 15) | \
    (((PD_DCDAC_RXB) & 0x1) << 7) | \
    (((PD_DCDAC_RXA) & 0x1) << 6) | \
    (((PD_DCDAC_TXB) & 0x1) << 5) | \
    (((PD_DCDAC_TXA) & 0x1) << 4) | \
    (((PD_DCCMP_RXB) & 0x1) << 3) | \
    (((PD_DCCMP_RXA) & 0x1) << 2) | \
    (((PD_DCCMP_TXB) & 0x1) << 1) | \
    (((PD_DCCMP_TXA) & 0x1) << 0) | \
    (0x05C00000 | 0x80000000))
#define GET_LMS7002_DC_DCMODE(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_DC_PD_DCDAC_RXB(r) (((r) >> 7 ) & 0x1)
#define GET_LMS7002_DC_PD_DCDAC_RXA(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_DC_PD_DCDAC_TXB(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_DC_PD_DCDAC_TXA(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_DC_PD_DCCMP_RXB(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_DC_PD_DCCMP_RXA(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_DC_PD_DCCMP_TXB(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_DC_PD_DCCMP_TXA(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x05C1 {
    LMS7002_DC_DCCAL_CALSTATUS_RXBQ_OFF = 15,
    LMS7002_DC_DCCAL_CALSTATUS_RXBI_OFF = 14,
    LMS7002_DC_DCCAL_CALSTATUS_RXAQ_OFF = 13,
    LMS7002_DC_DCCAL_CALSTATUS_RXAI_OFF = 12,
    LMS7002_DC_DCCAL_CALSTATUS_TXBQ_OFF = 11,
    LMS7002_DC_DCCAL_CALSTATUS_TXBI_OFF = 10,
    LMS7002_DC_DCCAL_CALSTATUS_TXAQ_OFF = 9,
    LMS7002_DC_DCCAL_CALSTATUS_TXAI_OFF = 8,
    LMS7002_DC_DCCAL_CMPSTATUS_RXBQ_OFF = 7,
    LMS7002_DC_DCCAL_CMPSTATUS_RXBI_OFF = 6,
    LMS7002_DC_DCCAL_CMPSTATUS_RXAQ_OFF = 5,
    LMS7002_DC_DCCAL_CMPSTATUS_RXAI_OFF = 4,
    LMS7002_DC_DCCAL_CMPSTATUS_TXBQ_OFF = 3,
    LMS7002_DC_DCCAL_CMPSTATUS_TXBI_OFF = 2,
    LMS7002_DC_DCCAL_CMPSTATUS_TXAQ_OFF = 1,
    LMS7002_DC_DCCAL_CMPSTATUS_TXAI_OFF = 0,
};
#define MAKE_LMS7002_0x05C1( DCCAL_CALSTATUS_RXBQ, DCCAL_CALSTATUS_RXBI, DCCAL_CALSTATUS_RXAQ, DCCAL_CALSTATUS_RXAI, DCCAL_CALSTATUS_TXBQ, DCCAL_CALSTATUS_TXBI, DCCAL_CALSTATUS_TXAQ, DCCAL_CALSTATUS_TXAI, DCCAL_CMPSTATUS_RXBQ, DCCAL_CMPSTATUS_RXBI, DCCAL_CMPSTATUS_RXAQ, DCCAL_CMPSTATUS_RXAI, DCCAL_CMPSTATUS_TXBQ, DCCAL_CMPSTATUS_TXBI, DCCAL_CMPSTATUS_TXAQ, DCCAL_CMPSTATUS_TXAI ) ( \
    (((DCCAL_CALSTATUS_RXBQ) & 0x1) << 15) | \
    (((DCCAL_CALSTATUS_RXBI) & 0x1) << 14) | \
    (((DCCAL_CALSTATUS_RXAQ) & 0x1) << 13) | \
    (((DCCAL_CALSTATUS_RXAI) & 0x1) << 12) | \
    (((DCCAL_CALSTATUS_TXBQ) & 0x1) << 11) | \
    (((DCCAL_CALSTATUS_TXBI) & 0x1) << 10) | \
    (((DCCAL_CALSTATUS_TXAQ) & 0x1) << 9) | \
    (((DCCAL_CALSTATUS_TXAI) & 0x1) << 8) | \
    (((DCCAL_CMPSTATUS_RXBQ) & 0x1) << 7) | \
    (((DCCAL_CMPSTATUS_RXBI) & 0x1) << 6) | \
    (((DCCAL_CMPSTATUS_RXAQ) & 0x1) << 5) | \
    (((DCCAL_CMPSTATUS_RXAI) & 0x1) << 4) | \
    (((DCCAL_CMPSTATUS_TXBQ) & 0x1) << 3) | \
    (((DCCAL_CMPSTATUS_TXBI) & 0x1) << 2) | \
    (((DCCAL_CMPSTATUS_TXAQ) & 0x1) << 1) | \
    (((DCCAL_CMPSTATUS_TXAI) & 0x1) << 0) | \
    (0x05C10000 | 0x80000000))
#define GET_LMS7002_DC_DCCAL_CALSTATUS_RXBQ(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_CALSTATUS_RXBI(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_CALSTATUS_RXAQ(r) (((r) >> 13 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_CALSTATUS_RXAI(r) (((r) >> 12 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_CALSTATUS_TXBQ(r) (((r) >> 11 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_CALSTATUS_TXBI(r) (((r) >> 10 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_CALSTATUS_TXAQ(r) (((r) >> 9 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_CALSTATUS_TXAI(r) (((r) >> 8 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_CMPSTATUS_RXBQ(r) (((r) >> 7 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_CMPSTATUS_RXBI(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_CMPSTATUS_RXAQ(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_CMPSTATUS_RXAI(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_CMPSTATUS_TXBQ(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_CMPSTATUS_TXBI(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_CMPSTATUS_TXAQ(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_CMPSTATUS_TXAI(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x05C2 {
    LMS7002_DC_DCCAL_CMPCFG_RXBQ_OFF = 15,
    LMS7002_DC_DCCAL_CMPCFG_RXBI_OFF = 14,
    LMS7002_DC_DCCAL_CMPCFG_RXAQ_OFF = 13,
    LMS7002_DC_DCCAL_CMPCFG_RXAI_OFF = 12,
    LMS7002_DC_DCCAL_CMPCFG_TXBQ_OFF = 11,
    LMS7002_DC_DCCAL_CMPCFG_TXBI_OFF = 10,
    LMS7002_DC_DCCAL_CMPCFG_TXAQ_OFF = 9,
    LMS7002_DC_DCCAL_CMPCFG_TXAI_OFF = 8,
    LMS7002_DC_DCCAL_START_RXBQ_OFF = 7,
    LMS7002_DC_DCCAL_START_RXBI_OFF = 6,
    LMS7002_DC_DCCAL_START_RXAQ_OFF = 5,
    LMS7002_DC_DCCAL_START_RXAI_OFF = 4,
    LMS7002_DC_DCCAL_START_TXBQ_OFF = 3,
    LMS7002_DC_DCCAL_START_TXBI_OFF = 2,
    LMS7002_DC_DCCAL_START_TXAQ_OFF = 1,
    LMS7002_DC_DCCAL_START_TXAI_OFF = 0,
};
#define MAKE_LMS7002_0x05C2( DCCAL_CMPCFG_RXBQ, DCCAL_CMPCFG_RXBI, DCCAL_CMPCFG_RXAQ, DCCAL_CMPCFG_RXAI, DCCAL_CMPCFG_TXBQ, DCCAL_CMPCFG_TXBI, DCCAL_CMPCFG_TXAQ, DCCAL_CMPCFG_TXAI, DCCAL_START_RXBQ, DCCAL_START_RXBI, DCCAL_START_RXAQ, DCCAL_START_RXAI, DCCAL_START_TXBQ, DCCAL_START_TXBI, DCCAL_START_TXAQ, DCCAL_START_TXAI ) ( \
    (((DCCAL_CMPCFG_RXBQ) & 0x1) << 15) | \
    (((DCCAL_CMPCFG_RXBI) & 0x1) << 14) | \
    (((DCCAL_CMPCFG_RXAQ) & 0x1) << 13) | \
    (((DCCAL_CMPCFG_RXAI) & 0x1) << 12) | \
    (((DCCAL_CMPCFG_TXBQ) & 0x1) << 11) | \
    (((DCCAL_CMPCFG_TXBI) & 0x1) << 10) | \
    (((DCCAL_CMPCFG_TXAQ) & 0x1) << 9) | \
    (((DCCAL_CMPCFG_TXAI) & 0x1) << 8) | \
    (((DCCAL_START_RXBQ) & 0x1) << 7) | \
    (((DCCAL_START_RXBI) & 0x1) << 6) | \
    (((DCCAL_START_RXAQ) & 0x1) << 5) | \
    (((DCCAL_START_RXAI) & 0x1) << 4) | \
    (((DCCAL_START_TXBQ) & 0x1) << 3) | \
    (((DCCAL_START_TXBI) & 0x1) << 2) | \
    (((DCCAL_START_TXAQ) & 0x1) << 1) | \
    (((DCCAL_START_TXAI) & 0x1) << 0) | \
    (0x05C20000 | 0x80000000))
#define GET_LMS7002_DC_DCCAL_CMPCFG_RXBQ(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_CMPCFG_RXBI(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_CMPCFG_RXAQ(r) (((r) >> 13 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_CMPCFG_RXAI(r) (((r) >> 12 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_CMPCFG_TXBQ(r) (((r) >> 11 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_CMPCFG_TXBI(r) (((r) >> 10 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_CMPCFG_TXAQ(r) (((r) >> 9 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_CMPCFG_TXAI(r) (((r) >> 8 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_START_RXBQ(r) (((r) >> 7 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_START_RXBI(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_START_RXAQ(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_START_RXAI(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_START_TXBQ(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_START_TXBI(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_START_TXAQ(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_DC_DCCAL_START_TXAI(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x05C3 {
    LMS7002_DC_DCWR_TXAI_OFF = 15,
    LMS7002_DC_DCRD_TXAI_OFF = 14,
    LMS7002_DC_DC_TXAI_OFF = 0,
    LMS7002_DC_DC_TXAI_MSK = 0x7ff,
};
#define MAKE_LMS7002_0x05C3( DCWR_TXAI, DCRD_TXAI, DC_TXAI ) ( \
    (((DCWR_TXAI) & 0x1) << 15) | \
    (((DCRD_TXAI) & 0x1) << 14) | \
    (((DC_TXAI) & 0x7ff) << 0) | \
    (0x05C30000 | 0x80000000))
#define GET_LMS7002_DC_DCWR_TXAI(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_DC_DCRD_TXAI(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_DC_DC_TXAI(r) (((r) >> 0 ) & 0x7ff)

enum lms7002m_reg_0x05C4 {
    LMS7002_DC_DCWR_TXAQ_OFF = 15,
    LMS7002_DC_DCRD_TXAQ_OFF = 14,
    LMS7002_DC_DC_TXAQ_OFF = 0,
    LMS7002_DC_DC_TXAQ_MSK = 0x7ff,
};
#define MAKE_LMS7002_0x05C4( DCWR_TXAQ, DCRD_TXAQ, DC_TXAQ ) ( \
    (((DCWR_TXAQ) & 0x1) << 15) | \
    (((DCRD_TXAQ) & 0x1) << 14) | \
    (((DC_TXAQ) & 0x7ff) << 0) | \
    (0x05C40000 | 0x80000000))
#define GET_LMS7002_DC_DCWR_TXAQ(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_DC_DCRD_TXAQ(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_DC_DC_TXAQ(r) (((r) >> 0 ) & 0x7ff)

enum lms7002m_reg_0x05C5 {
    LMS7002_DC_DCWR_TXBI_OFF = 15,
    LMS7002_DC_DCRD_TXBI_OFF = 14,
    LMS7002_DC_DC_TXBI_OFF = 0,
    LMS7002_DC_DC_TXBI_MSK = 0x7ff,
};
#define MAKE_LMS7002_0x05C5( DCWR_TXBI, DCRD_TXBI, DC_TXBI ) ( \
    (((DCWR_TXBI) & 0x1) << 15) | \
    (((DCRD_TXBI) & 0x1) << 14) | \
    (((DC_TXBI) & 0x7ff) << 0) | \
    (0x05C50000 | 0x80000000))
#define GET_LMS7002_DC_DCWR_TXBI(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_DC_DCRD_TXBI(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_DC_DC_TXBI(r) (((r) >> 0 ) & 0x7ff)

enum lms7002m_reg_0x05C6 {
    LMS7002_DC_DCWR_TXBQ_OFF = 15,
    LMS7002_DC_DCRD_TXBQ_OFF = 14,
    LMS7002_DC_DC_TXBQ_OFF = 0,
    LMS7002_DC_DC_TXBQ_MSK = 0x7ff,
};
#define MAKE_LMS7002_0x05C6( DCWR_TXBQ, DCRD_TXBQ, DC_TXBQ ) ( \
    (((DCWR_TXBQ) & 0x1) << 15) | \
    (((DCRD_TXBQ) & 0x1) << 14) | \
    (((DC_TXBQ) & 0x7ff) << 0) | \
    (0x05C60000 | 0x80000000))
#define GET_LMS7002_DC_DCWR_TXBQ(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_DC_DCRD_TXBQ(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_DC_DC_TXBQ(r) (((r) >> 0 ) & 0x7ff)

enum lms7002m_reg_0x05C7 {
    LMS7002_DC_DCWR_RXAI_OFF = 15,
    LMS7002_DC_DCRD_RXAI_OFF = 14,
    LMS7002_DC_DC_RXAI_OFF = 0,
    LMS7002_DC_DC_RXAI_MSK = 0x7ff,
};
#define MAKE_LMS7002_0x05C7( DCWR_RXAI, DCRD_RXAI, DC_RXAI ) ( \
    (((DCWR_RXAI) & 0x1) << 15) | \
    (((DCRD_RXAI) & 0x1) << 14) | \
    (((DC_RXAI) & 0x7ff) << 0) | \
    (0x05C70000 | 0x80000000))
#define GET_LMS7002_DC_DCWR_RXAI(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_DC_DCRD_RXAI(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_DC_DC_RXAI(r) (((r) >> 0 ) & 0x7ff)

enum lms7002m_reg_0x05C8 {
    LMS7002_DC_DCWR_RXAQ_OFF = 15,
    LMS7002_DC_DCRD_RXAQ_OFF = 14,
    LMS7002_DC_DC_RXAQ_OFF = 0,
    LMS7002_DC_DC_RXAQ_MSK = 0x7ff,
};
#define MAKE_LMS7002_0x05C8( DCWR_RXAQ, DCRD_RXAQ, DC_RXAQ ) ( \
    (((DCWR_RXAQ) & 0x1) << 15) | \
    (((DCRD_RXAQ) & 0x1) << 14) | \
    (((DC_RXAQ) & 0x7ff) << 0) | \
    (0x05C80000 | 0x80000000))
#define GET_LMS7002_DC_DCWR_RXAQ(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_DC_DCRD_RXAQ(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_DC_DC_RXAQ(r) (((r) >> 0 ) & 0x7ff)

enum lms7002m_reg_0x05C9 {
    LMS7002_DC_DCWR_RXBI_OFF = 15,
    LMS7002_DC_DCRD_RXBI_OFF = 14,
    LMS7002_DC_DC_RXBI_OFF = 0,
    LMS7002_DC_DC_RXBI_MSK = 0x7ff,
};
#define MAKE_LMS7002_0x05C9( DCWR_RXBI, DCRD_RXBI, DC_RXBI ) ( \
    (((DCWR_RXBI) & 0x1) << 15) | \
    (((DCRD_RXBI) & 0x1) << 14) | \
    (((DC_RXBI) & 0x7ff) << 0) | \
    (0x05C90000 | 0x80000000))
#define GET_LMS7002_DC_DCWR_RXBI(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_DC_DCRD_RXBI(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_DC_DC_RXBI(r) (((r) >> 0 ) & 0x7ff)

enum lms7002m_reg_0x05CA {
    LMS7002_DC_DCWR_RXBQ_OFF = 15,
    LMS7002_DC_DCRD_RXBQ_OFF = 14,
    LMS7002_DC_DC_RXBQ_OFF = 0,
    LMS7002_DC_DC_RXBQ_MSK = 0x7ff,
};
#define MAKE_LMS7002_0x05CA( DCWR_RXBQ, DCRD_RXBQ, DC_RXBQ ) ( \
    (((DCWR_RXBQ) & 0x1) << 15) | \
    (((DCRD_RXBQ) & 0x1) << 14) | \
    (((DC_RXBQ) & 0x7ff) << 0) | \
    (0x05CA0000 | 0x80000000))
#define GET_LMS7002_DC_DCWR_RXBQ(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_DC_DCRD_RXBQ(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_DC_DC_RXBQ(r) (((r) >> 0 ) & 0x7ff)

enum lms7002m_reg_0x05CB {
    LMS7002_DC_DC_RXCDIV_OFF = 8,
    LMS7002_DC_DC_RXCDIV_MSK = 0xff,
    LMS7002_DC_DC_TXCDIV_OFF = 0,
    LMS7002_DC_DC_TXCDIV_MSK = 0xff,
};
#define MAKE_LMS7002_0x05CB( DC_RXCDIV, DC_TXCDIV ) ( \
    (((DC_RXCDIV) & 0xff) << 8) | \
    (((DC_TXCDIV) & 0xff) << 0) | \
    (0x05CB0000 | 0x80000000))
#define GET_LMS7002_DC_DC_RXCDIV(r) (((r) >> 8 ) & 0xff)
#define GET_LMS7002_DC_DC_TXCDIV(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x05CC {
    LMS7002_DC_DC_HYSCMP_RXB_OFF = 9,
    LMS7002_DC_DC_HYSCMP_RXB_MSK = 0x7,
    LMS7002_DC_DC_HYSCMP_RXA_OFF = 6,
    LMS7002_DC_DC_HYSCMP_RXA_MSK = 0x7,
    LMS7002_DC_DC_HYSCMP_TXB_OFF = 3,
    LMS7002_DC_DC_HYSCMP_TXB_MSK = 0x7,
    LMS7002_DC_DC_HYSCMP_TXA_OFF = 0,
    LMS7002_DC_DC_HYSCMP_TXA_MSK = 0x7,
};
#define MAKE_LMS7002_0x05CC( DC_HYSCMP_RXB, DC_HYSCMP_RXA, DC_HYSCMP_TXB, DC_HYSCMP_TXA ) ( \
    (((DC_HYSCMP_RXB) & 0x7) << 9) | \
    (((DC_HYSCMP_RXA) & 0x7) << 6) | \
    (((DC_HYSCMP_TXB) & 0x7) << 3) | \
    (((DC_HYSCMP_TXA) & 0x7) << 0) | \
    (0x05CC0000 | 0x80000000))
#define GET_LMS7002_DC_DC_HYSCMP_RXB(r) (((r) >> 9 ) & 0x7)
#define GET_LMS7002_DC_DC_HYSCMP_RXA(r) (((r) >> 6 ) & 0x7)
#define GET_LMS7002_DC_DC_HYSCMP_TXB(r) (((r) >> 3 ) & 0x7)
#define GET_LMS7002_DC_DC_HYSCMP_TXA(r) (((r) >> 0 ) & 0x7)



/*************************************
 * ENDIR configuration registers
 *************************************/
enum lms7002m_reg_0x0081 {
    LMS7002_ENDIR_EN_DIR_LDO_OFF = 3,
    LMS7002_ENDIR_EN_DIR_CGEN_OFF = 2,
    LMS7002_ENDIR_EN_DIR_XBUF_OFF = 1,
    LMS7002_ENDIR_EN_DIR_AFE_OFF = 0,
};
#define MAKE_LMS7002_0x0081( EN_DIR_LDO, EN_DIR_CGEN, EN_DIR_XBUF, EN_DIR_AFE ) ( \
    (((EN_DIR_LDO) & 0x1) << 3) | \
    (((EN_DIR_CGEN) & 0x1) << 2) | \
    (((EN_DIR_XBUF) & 0x1) << 1) | \
    (((EN_DIR_AFE) & 0x1) << 0) | \
    (0x00810000 | 0x80000000))
#define GET_LMS7002_ENDIR_EN_DIR_LDO(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_ENDIR_EN_DIR_CGEN(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_ENDIR_EN_DIR_XBUF(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_ENDIR_EN_DIR_AFE(r) (((r) >> 0 ) & 0x1)



/*************************************
 * LDO configuration registers
 *************************************/
enum lms7002m_reg_0x0092 {
    LMS7002_LDO_EN_LDO_DIG_OFF = 15,
    LMS7002_LDO_EN_LDO_DIGGN_OFF = 14,
    LMS7002_LDO_EN_LDO_DIGSXR_OFF = 13,
    LMS7002_LDO_EN_LDO_DIGSXT_OFF = 12,
    LMS7002_LDO_EN_LDO_DIVGN_OFF = 11,
    LMS7002_LDO_EN_LDO_DIVSXR_OFF = 10,
    LMS7002_LDO_EN_LDO_DIVSXT_OFF = 9,
    LMS7002_LDO_EN_LDO_LNA12_OFF = 8,
    LMS7002_LDO_EN_LDO_LNA14_OFF = 7,
    LMS7002_LDO_EN_LDO_MXRFE_OFF = 6,
    LMS7002_LDO_EN_LDO_RBB_OFF = 5,
    LMS7002_LDO_EN_LDO_RXBUF_OFF = 4,
    LMS7002_LDO_EN_LDO_TBB_OFF = 3,
    LMS7002_LDO_EN_LDO_TIA12_OFF = 2,
    LMS7002_LDO_EN_LDO_TIA14_OFF = 1,
    LMS7002_LDO_EN_G_LDO_OFF = 0,
};
#define MAKE_LMS7002_0x0092( EN_LDO_DIG, EN_LDO_DIGGN, EN_LDO_DIGSXR, EN_LDO_DIGSXT, EN_LDO_DIVGN, EN_LDO_DIVSXR, EN_LDO_DIVSXT, EN_LDO_LNA12, EN_LDO_LNA14, EN_LDO_MXRFE, EN_LDO_RBB, EN_LDO_RXBUF, EN_LDO_TBB, EN_LDO_TIA12, EN_LDO_TIA14, EN_G_LDO ) ( \
    (((EN_LDO_DIG) & 0x1) << 15) | \
    (((EN_LDO_DIGGN) & 0x1) << 14) | \
    (((EN_LDO_DIGSXR) & 0x1) << 13) | \
    (((EN_LDO_DIGSXT) & 0x1) << 12) | \
    (((EN_LDO_DIVGN) & 0x1) << 11) | \
    (((EN_LDO_DIVSXR) & 0x1) << 10) | \
    (((EN_LDO_DIVSXT) & 0x1) << 9) | \
    (((EN_LDO_LNA12) & 0x1) << 8) | \
    (((EN_LDO_LNA14) & 0x1) << 7) | \
    (((EN_LDO_MXRFE) & 0x1) << 6) | \
    (((EN_LDO_RBB) & 0x1) << 5) | \
    (((EN_LDO_RXBUF) & 0x1) << 4) | \
    (((EN_LDO_TBB) & 0x1) << 3) | \
    (((EN_LDO_TIA12) & 0x1) << 2) | \
    (((EN_LDO_TIA14) & 0x1) << 1) | \
    (((EN_G_LDO) & 0x1) << 0) | \
    (0x00920000 | 0x80000000))
#define GET_LMS7002_LDO_EN_LDO_DIG(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_DIGGN(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_DIGSXR(r) (((r) >> 13 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_DIGSXT(r) (((r) >> 12 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_DIVGN(r) (((r) >> 11 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_DIVSXR(r) (((r) >> 10 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_DIVSXT(r) (((r) >> 9 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_LNA12(r) (((r) >> 8 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_LNA14(r) (((r) >> 7 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_MXRFE(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_RBB(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_RXBUF(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_TBB(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_TIA12(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_TIA14(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_LDO_EN_G_LDO(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x0093 {
    LMS7002_LDO_EN_LOADIMP_LDO_TLOB_OFF = 15,
    LMS7002_LDO_EN_LOADIMP_LDO_TPAD_OFF = 14,
    LMS7002_LDO_EN_LOADIMP_LDO_TXBUF_OFF = 13,
    LMS7002_LDO_EN_LOADIMP_LDO_VCOGN_OFF = 12,
    LMS7002_LDO_EN_LOADIMP_LDO_VCOSXR_OFF = 11,
    LMS7002_LDO_EN_LOADIMP_LDO_VCOSXT_OFF = 10,
    LMS7002_LDO_EN_LDO_AFE_OFF = 9,
    LMS7002_LDO_EN_LDO_CPGN_OFF = 8,
    LMS7002_LDO_EN_LDO_CPSXR_OFF = 7,
    LMS7002_LDO_EN_LDO_TLOB_OFF = 6,
    LMS7002_LDO_EN_LDO_TPAD_OFF = 5,
    LMS7002_LDO_EN_LDO_TXBUF_OFF = 4,
    LMS7002_LDO_EN_LDO_VCOGN_OFF = 3,
    LMS7002_LDO_EN_LDO_VCOSXR_OFF = 2,
    LMS7002_LDO_EN_LDO_VCOSXT_OFF = 1,
    LMS7002_LDO_EN_LDO_CPSXT_OFF = 0,
};
#define MAKE_LMS7002_0x0093( EN_LOADIMP_LDO_TLOB, EN_LOADIMP_LDO_TPAD, EN_LOADIMP_LDO_TXBUF, EN_LOADIMP_LDO_VCOGN, EN_LOADIMP_LDO_VCOSXR, EN_LOADIMP_LDO_VCOSXT, EN_LDO_AFE, EN_LDO_CPGN, EN_LDO_CPSXR, EN_LDO_TLOB, EN_LDO_TPAD, EN_LDO_TXBUF, EN_LDO_VCOGN, EN_LDO_VCOSXR, EN_LDO_VCOSXT, EN_LDO_CPSXT ) ( \
    (((EN_LOADIMP_LDO_TLOB) & 0x1) << 15) | \
    (((EN_LOADIMP_LDO_TPAD) & 0x1) << 14) | \
    (((EN_LOADIMP_LDO_TXBUF) & 0x1) << 13) | \
    (((EN_LOADIMP_LDO_VCOGN) & 0x1) << 12) | \
    (((EN_LOADIMP_LDO_VCOSXR) & 0x1) << 11) | \
    (((EN_LOADIMP_LDO_VCOSXT) & 0x1) << 10) | \
    (((EN_LDO_AFE) & 0x1) << 9) | \
    (((EN_LDO_CPGN) & 0x1) << 8) | \
    (((EN_LDO_CPSXR) & 0x1) << 7) | \
    (((EN_LDO_TLOB) & 0x1) << 6) | \
    (((EN_LDO_TPAD) & 0x1) << 5) | \
    (((EN_LDO_TXBUF) & 0x1) << 4) | \
    (((EN_LDO_VCOGN) & 0x1) << 3) | \
    (((EN_LDO_VCOSXR) & 0x1) << 2) | \
    (((EN_LDO_VCOSXT) & 0x1) << 1) | \
    (((EN_LDO_CPSXT) & 0x1) << 0) | \
    (0x00930000 | 0x80000000))
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_TLOB(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_TPAD(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_TXBUF(r) (((r) >> 13 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_VCOGN(r) (((r) >> 12 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_VCOSXR(r) (((r) >> 11 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_VCOSXT(r) (((r) >> 10 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_AFE(r) (((r) >> 9 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_CPGN(r) (((r) >> 8 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_CPSXR(r) (((r) >> 7 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_TLOB(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_TPAD(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_TXBUF(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_VCOGN(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_VCOSXR(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_VCOSXT(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_LDO_EN_LDO_CPSXT(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x0094 {
    LMS7002_LDO_EN_LOADIMP_LDO_CPSXT_OFF = 15,
    LMS7002_LDO_EN_LOADIMP_LDO_DIG_OFF = 14,
    LMS7002_LDO_EN_LOADIMP_LDO_DIGGN_OFF = 13,
    LMS7002_LDO_EN_LOADIMP_LDO_DIGSXR_OFF = 12,
    LMS7002_LDO_EN_LOADIMP_LDO_DIGSXT_OFF = 11,
    LMS7002_LDO_EN_LOADIMP_LDO_DIVGN_OFF = 10,
    LMS7002_LDO_EN_LOADIMP_LDO_DIVSXR_OFF = 9,
    LMS7002_LDO_EN_LOADIMP_LDO_DIVSXT_OFF = 8,
    LMS7002_LDO_EN_LOADIMP_LDO_LNA12_OFF = 7,
    LMS7002_LDO_EN_LOADIMP_LDO_LNA14_OFF = 6,
    LMS7002_LDO_EN_LOADIMP_LDO_MXRFE_OFF = 5,
    LMS7002_LDO_EN_LOADIMP_LDO_RBB_OFF = 4,
    LMS7002_LDO_EN_LOADIMP_LDO_RXBUF_OFF = 3,
    LMS7002_LDO_EN_LOADIMP_LDO_TBB_OFF = 2,
    LMS7002_LDO_EN_LOADIMP_LDO_TIA12_OFF = 1,
    LMS7002_LDO_EN_LOADIMP_LDO_TIA14_OFF = 0,
};
#define MAKE_LMS7002_0x0094( EN_LOADIMP_LDO_CPSXT, EN_LOADIMP_LDO_DIG, EN_LOADIMP_LDO_DIGGN, EN_LOADIMP_LDO_DIGSXR, EN_LOADIMP_LDO_DIGSXT, EN_LOADIMP_LDO_DIVGN, EN_LOADIMP_LDO_DIVSXR, EN_LOADIMP_LDO_DIVSXT, EN_LOADIMP_LDO_LNA12, EN_LOADIMP_LDO_LNA14, EN_LOADIMP_LDO_MXRFE, EN_LOADIMP_LDO_RBB, EN_LOADIMP_LDO_RXBUF, EN_LOADIMP_LDO_TBB, EN_LOADIMP_LDO_TIA12, EN_LOADIMP_LDO_TIA14 ) ( \
    (((EN_LOADIMP_LDO_CPSXT) & 0x1) << 15) | \
    (((EN_LOADIMP_LDO_DIG) & 0x1) << 14) | \
    (((EN_LOADIMP_LDO_DIGGN) & 0x1) << 13) | \
    (((EN_LOADIMP_LDO_DIGSXR) & 0x1) << 12) | \
    (((EN_LOADIMP_LDO_DIGSXT) & 0x1) << 11) | \
    (((EN_LOADIMP_LDO_DIVGN) & 0x1) << 10) | \
    (((EN_LOADIMP_LDO_DIVSXR) & 0x1) << 9) | \
    (((EN_LOADIMP_LDO_DIVSXT) & 0x1) << 8) | \
    (((EN_LOADIMP_LDO_LNA12) & 0x1) << 7) | \
    (((EN_LOADIMP_LDO_LNA14) & 0x1) << 6) | \
    (((EN_LOADIMP_LDO_MXRFE) & 0x1) << 5) | \
    (((EN_LOADIMP_LDO_RBB) & 0x1) << 4) | \
    (((EN_LOADIMP_LDO_RXBUF) & 0x1) << 3) | \
    (((EN_LOADIMP_LDO_TBB) & 0x1) << 2) | \
    (((EN_LOADIMP_LDO_TIA12) & 0x1) << 1) | \
    (((EN_LOADIMP_LDO_TIA14) & 0x1) << 0) | \
    (0x00940000 | 0x80000000))
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_CPSXT(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_DIG(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_DIGGN(r) (((r) >> 13 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_DIGSXR(r) (((r) >> 12 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_DIGSXT(r) (((r) >> 11 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_DIVGN(r) (((r) >> 10 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_DIVSXR(r) (((r) >> 9 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_DIVSXT(r) (((r) >> 8 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_LNA12(r) (((r) >> 7 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_LNA14(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_MXRFE(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_RBB(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_RXBUF(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_TBB(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_TIA12(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_TIA14(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x0095 {
    LMS7002_LDO_BYP_LDO_TBB_OFF = 15,
    LMS7002_LDO_BYP_LDO_TIA12_OFF = 14,
    LMS7002_LDO_BYP_LDO_TIA14_OFF = 13,
    LMS7002_LDO_BYP_LDO_TLOB_OFF = 12,
    LMS7002_LDO_BYP_LDO_TPAD_OFF = 11,
    LMS7002_LDO_BYP_LDO_TXBUF_OFF = 10,
    LMS7002_LDO_BYP_LDO_VCOGN_OFF = 9,
    LMS7002_LDO_BYP_LDO_VCOSXR_OFF = 8,
    LMS7002_LDO_BYP_LDO_VCOSXT_OFF = 7,
    LMS7002_LDO_EN_LOADIMP_LDO_AFE_OFF = 2,
    LMS7002_LDO_EN_LOADIMP_LDO_CPGN_OFF = 1,
    LMS7002_LDO_EN_LOADIMP_LDO_CPSXR_OFF = 0,
};
#define MAKE_LMS7002_0x0095( BYP_LDO_TBB, BYP_LDO_TIA12, BYP_LDO_TIA14, BYP_LDO_TLOB, BYP_LDO_TPAD, BYP_LDO_TXBUF, BYP_LDO_VCOGN, BYP_LDO_VCOSXR, BYP_LDO_VCOSXT, EN_LOADIMP_LDO_AFE, EN_LOADIMP_LDO_CPGN, EN_LOADIMP_LDO_CPSXR ) ( \
    (((BYP_LDO_TBB) & 0x1) << 15) | \
    (((BYP_LDO_TIA12) & 0x1) << 14) | \
    (((BYP_LDO_TIA14) & 0x1) << 13) | \
    (((BYP_LDO_TLOB) & 0x1) << 12) | \
    (((BYP_LDO_TPAD) & 0x1) << 11) | \
    (((BYP_LDO_TXBUF) & 0x1) << 10) | \
    (((BYP_LDO_VCOGN) & 0x1) << 9) | \
    (((BYP_LDO_VCOSXR) & 0x1) << 8) | \
    (((BYP_LDO_VCOSXT) & 0x1) << 7) | \
    (((EN_LOADIMP_LDO_AFE) & 0x1) << 2) | \
    (((EN_LOADIMP_LDO_CPGN) & 0x1) << 1) | \
    (((EN_LOADIMP_LDO_CPSXR) & 0x1) << 0) | \
    (0x00950000 | 0x80000000))
#define GET_LMS7002_LDO_BYP_LDO_TBB(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_TIA12(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_TIA14(r) (((r) >> 13 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_TLOB(r) (((r) >> 12 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_TPAD(r) (((r) >> 11 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_TXBUF(r) (((r) >> 10 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_VCOGN(r) (((r) >> 9 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_VCOSXR(r) (((r) >> 8 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_VCOSXT(r) (((r) >> 7 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_AFE(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_CPGN(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_CPSXR(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x0096 {
    LMS7002_LDO_BYP_LDO_AFE_OFF = 15,
    LMS7002_LDO_BYP_LDO_CPGN_OFF = 14,
    LMS7002_LDO_BYP_LDO_CPSXR_OFF = 13,
    LMS7002_LDO_BYP_LDO_CPSXT_OFF = 12,
    LMS7002_LDO_BYP_LDO_DIG_OFF = 11,
    LMS7002_LDO_BYP_LDO_DIGGN_OFF = 10,
    LMS7002_LDO_BYP_LDO_DIGSXR_OFF = 9,
    LMS7002_LDO_BYP_LDO_DIGSXT_OFF = 8,
    LMS7002_LDO_BYP_LDO_DIVGN_OFF = 7,
    LMS7002_LDO_BYP_LDO_DIVSXR_OFF = 6,
    LMS7002_LDO_BYP_LDO_DIVSXT_OFF = 5,
    LMS7002_LDO_BYP_LDO_LNA12_OFF = 4,
    LMS7002_LDO_BYP_LDO_LNA14_OFF = 3,
    LMS7002_LDO_BYP_LDO_MXRFE_OFF = 2,
    LMS7002_LDO_BYP_LDO_RBB_OFF = 1,
    LMS7002_LDO_BYP_LDO_RXBUF_OFF = 0,
};
#define MAKE_LMS7002_0x0096( BYP_LDO_AFE, BYP_LDO_CPGN, BYP_LDO_CPSXR, BYP_LDO_CPSXT, BYP_LDO_DIG, BYP_LDO_DIGGN, BYP_LDO_DIGSXR, BYP_LDO_DIGSXT, BYP_LDO_DIVGN, BYP_LDO_DIVSXR, BYP_LDO_DIVSXT, BYP_LDO_LNA12, BYP_LDO_LNA14, BYP_LDO_MXRFE, BYP_LDO_RBB, BYP_LDO_RXBUF ) ( \
    (((BYP_LDO_AFE) & 0x1) << 15) | \
    (((BYP_LDO_CPGN) & 0x1) << 14) | \
    (((BYP_LDO_CPSXR) & 0x1) << 13) | \
    (((BYP_LDO_CPSXT) & 0x1) << 12) | \
    (((BYP_LDO_DIG) & 0x1) << 11) | \
    (((BYP_LDO_DIGGN) & 0x1) << 10) | \
    (((BYP_LDO_DIGSXR) & 0x1) << 9) | \
    (((BYP_LDO_DIGSXT) & 0x1) << 8) | \
    (((BYP_LDO_DIVGN) & 0x1) << 7) | \
    (((BYP_LDO_DIVSXR) & 0x1) << 6) | \
    (((BYP_LDO_DIVSXT) & 0x1) << 5) | \
    (((BYP_LDO_LNA12) & 0x1) << 4) | \
    (((BYP_LDO_LNA14) & 0x1) << 3) | \
    (((BYP_LDO_MXRFE) & 0x1) << 2) | \
    (((BYP_LDO_RBB) & 0x1) << 1) | \
    (((BYP_LDO_RXBUF) & 0x1) << 0) | \
    (0x00960000 | 0x80000000))
#define GET_LMS7002_LDO_BYP_LDO_AFE(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_CPGN(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_CPSXR(r) (((r) >> 13 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_CPSXT(r) (((r) >> 12 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_DIG(r) (((r) >> 11 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_DIGGN(r) (((r) >> 10 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_DIGSXR(r) (((r) >> 9 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_DIGSXT(r) (((r) >> 8 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_DIVGN(r) (((r) >> 7 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_DIVSXR(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_DIVSXT(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_LNA12(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_LNA14(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_MXRFE(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_RBB(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_RXBUF(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x0097 {
    LMS7002_LDO_SPDUP_LDO_DIVSXR_OFF = 15,
    LMS7002_LDO_SPDUP_LDO_DIVSXT_OFF = 14,
    LMS7002_LDO_SPDUP_LDO_LNA12_OFF = 13,
    LMS7002_LDO_SPDUP_LDO_LNA14_OFF = 12,
    LMS7002_LDO_SPDUP_LDO_MXRFE_OFF = 11,
    LMS7002_LDO_SPDUP_LDO_RBB_OFF = 10,
    LMS7002_LDO_SPDUP_LDO_RXBUF_OFF = 9,
    LMS7002_LDO_SPDUP_LDO_TBB_OFF = 8,
    LMS7002_LDO_SPDUP_LDO_TIA12_OFF = 7,
    LMS7002_LDO_SPDUP_LDO_TIA14_OFF = 6,
    LMS7002_LDO_SPDUP_LDO_TLOB_OFF = 5,
    LMS7002_LDO_SPDUP_LDO_TPAD_OFF = 4,
    LMS7002_LDO_SPDUP_LDO_TXBUF_OFF = 3,
    LMS7002_LDO_SPDUP_LDO_VCOGN_OFF = 2,
    LMS7002_LDO_SPDUP_LDO_VCOSXR_OFF = 1,
    LMS7002_LDO_SPDUP_LDO_VCOSXT_OFF = 0,
};
#define MAKE_LMS7002_0x0097( SPDUP_LDO_DIVSXR, SPDUP_LDO_DIVSXT, SPDUP_LDO_LNA12, SPDUP_LDO_LNA14, SPDUP_LDO_MXRFE, SPDUP_LDO_RBB, SPDUP_LDO_RXBUF, SPDUP_LDO_TBB, SPDUP_LDO_TIA12, SPDUP_LDO_TIA14, SPDUP_LDO_TLOB, SPDUP_LDO_TPAD, SPDUP_LDO_TXBUF, SPDUP_LDO_VCOGN, SPDUP_LDO_VCOSXR, SPDUP_LDO_VCOSXT ) ( \
    (((SPDUP_LDO_DIVSXR) & 0x1) << 15) | \
    (((SPDUP_LDO_DIVSXT) & 0x1) << 14) | \
    (((SPDUP_LDO_LNA12) & 0x1) << 13) | \
    (((SPDUP_LDO_LNA14) & 0x1) << 12) | \
    (((SPDUP_LDO_MXRFE) & 0x1) << 11) | \
    (((SPDUP_LDO_RBB) & 0x1) << 10) | \
    (((SPDUP_LDO_RXBUF) & 0x1) << 9) | \
    (((SPDUP_LDO_TBB) & 0x1) << 8) | \
    (((SPDUP_LDO_TIA12) & 0x1) << 7) | \
    (((SPDUP_LDO_TIA14) & 0x1) << 6) | \
    (((SPDUP_LDO_TLOB) & 0x1) << 5) | \
    (((SPDUP_LDO_TPAD) & 0x1) << 4) | \
    (((SPDUP_LDO_TXBUF) & 0x1) << 3) | \
    (((SPDUP_LDO_VCOGN) & 0x1) << 2) | \
    (((SPDUP_LDO_VCOSXR) & 0x1) << 1) | \
    (((SPDUP_LDO_VCOSXT) & 0x1) << 0) | \
    (0x00970000 | 0x80000000))
#define GET_LMS7002_LDO_SPDUP_LDO_DIVSXR(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_DIVSXT(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_LNA12(r) (((r) >> 13 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_LNA14(r) (((r) >> 12 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_MXRFE(r) (((r) >> 11 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_RBB(r) (((r) >> 10 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_RXBUF(r) (((r) >> 9 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_TBB(r) (((r) >> 8 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_TIA12(r) (((r) >> 7 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_TIA14(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_TLOB(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_TPAD(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_TXBUF(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_VCOGN(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_VCOSXR(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_VCOSXT(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x0098 {
    LMS7002_LDO_SPDUP_LDO_AFE_OFF = 8,
    LMS7002_LDO_SPDUP_LDO_CPGN_OFF = 7,
    LMS7002_LDO_SPDUP_LDO_CPSXR_OFF = 6,
    LMS7002_LDO_SPDUP_LDO_CPSXT_OFF = 5,
    LMS7002_LDO_SPDUP_LDO_DIG_OFF = 4,
    LMS7002_LDO_SPDUP_LDO_DIGGN_OFF = 3,
    LMS7002_LDO_SPDUP_LDO_DIGSXR_OFF = 2,
    LMS7002_LDO_SPDUP_LDO_DIGSXT_OFF = 1,
    LMS7002_LDO_SPDUP_LDO_DIVGN_OFF = 0,
};
#define MAKE_LMS7002_0x0098( SPDUP_LDO_AFE, SPDUP_LDO_CPGN, SPDUP_LDO_CPSXR, SPDUP_LDO_CPSXT, SPDUP_LDO_DIG, SPDUP_LDO_DIGGN, SPDUP_LDO_DIGSXR, SPDUP_LDO_DIGSXT, SPDUP_LDO_DIVGN ) ( \
    (((SPDUP_LDO_AFE) & 0x1) << 8) | \
    (((SPDUP_LDO_CPGN) & 0x1) << 7) | \
    (((SPDUP_LDO_CPSXR) & 0x1) << 6) | \
    (((SPDUP_LDO_CPSXT) & 0x1) << 5) | \
    (((SPDUP_LDO_DIG) & 0x1) << 4) | \
    (((SPDUP_LDO_DIGGN) & 0x1) << 3) | \
    (((SPDUP_LDO_DIGSXR) & 0x1) << 2) | \
    (((SPDUP_LDO_DIGSXT) & 0x1) << 1) | \
    (((SPDUP_LDO_DIVGN) & 0x1) << 0) | \
    (0x00980000 | 0x80000000))
#define GET_LMS7002_LDO_SPDUP_LDO_AFE(r) (((r) >> 8 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_CPGN(r) (((r) >> 7 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_CPSXR(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_CPSXT(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_DIG(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_DIGGN(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_DIGSXR(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_DIGSXT(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_DIVGN(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x0099 {
    LMS7002_LDO_RDIV_VCOSXR_OFF = 8,
    LMS7002_LDO_RDIV_VCOSXR_MSK = 0xff,
    LMS7002_LDO_RDIV_VCOSXT_OFF = 0,
    LMS7002_LDO_RDIV_VCOSXT_MSK = 0xff,
};
#define MAKE_LMS7002_0x0099( RDIV_VCOSXR, RDIV_VCOSXT ) ( \
    (((RDIV_VCOSXR) & 0xff) << 8) | \
    (((RDIV_VCOSXT) & 0xff) << 0) | \
    (0x00990000 | 0x80000000))
#define GET_LMS7002_LDO_RDIV_VCOSXR(r) (((r) >> 8 ) & 0xff)
#define GET_LMS7002_LDO_RDIV_VCOSXT(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x009A {
    LMS7002_LDO_RDIV_TXBUF_OFF = 8,
    LMS7002_LDO_RDIV_TXBUF_MSK = 0xff,
    LMS7002_LDO_RDIV_VCOGN_OFF = 0,
    LMS7002_LDO_RDIV_VCOGN_MSK = 0xff,
};
#define MAKE_LMS7002_0x009A( RDIV_TXBUF, RDIV_VCOGN ) ( \
    (((RDIV_TXBUF) & 0xff) << 8) | \
    (((RDIV_VCOGN) & 0xff) << 0) | \
    (0x009A0000 | 0x80000000))
#define GET_LMS7002_LDO_RDIV_TXBUF(r) (((r) >> 8 ) & 0xff)
#define GET_LMS7002_LDO_RDIV_VCOGN(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x009B {
    LMS7002_LDO_RDIV_TLOB_OFF = 8,
    LMS7002_LDO_RDIV_TLOB_MSK = 0xff,
    LMS7002_LDO_RDIV_TPAD_OFF = 0,
    LMS7002_LDO_RDIV_TPAD_MSK = 0xff,
};
#define MAKE_LMS7002_0x009B( RDIV_TLOB, RDIV_TPAD ) ( \
    (((RDIV_TLOB) & 0xff) << 8) | \
    (((RDIV_TPAD) & 0xff) << 0) | \
    (0x009B0000 | 0x80000000))
#define GET_LMS7002_LDO_RDIV_TLOB(r) (((r) >> 8 ) & 0xff)
#define GET_LMS7002_LDO_RDIV_TPAD(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x009C {
    LMS7002_LDO_RDIV_TIA12_OFF = 8,
    LMS7002_LDO_RDIV_TIA12_MSK = 0xff,
    LMS7002_LDO_RDIV_TIA14_OFF = 0,
    LMS7002_LDO_RDIV_TIA14_MSK = 0xff,
};
#define MAKE_LMS7002_0x009C( RDIV_TIA12, RDIV_TIA14 ) ( \
    (((RDIV_TIA12) & 0xff) << 8) | \
    (((RDIV_TIA14) & 0xff) << 0) | \
    (0x009C0000 | 0x80000000))
#define GET_LMS7002_LDO_RDIV_TIA12(r) (((r) >> 8 ) & 0xff)
#define GET_LMS7002_LDO_RDIV_TIA14(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x009D {
    LMS7002_LDO_RDIV_RXBUF_OFF = 8,
    LMS7002_LDO_RDIV_RXBUF_MSK = 0xff,
    LMS7002_LDO_RDIV_TBB_OFF = 0,
    LMS7002_LDO_RDIV_TBB_MSK = 0xff,
};
#define MAKE_LMS7002_0x009D( RDIV_RXBUF, RDIV_TBB ) ( \
    (((RDIV_RXBUF) & 0xff) << 8) | \
    (((RDIV_TBB) & 0xff) << 0) | \
    (0x009D0000 | 0x80000000))
#define GET_LMS7002_LDO_RDIV_RXBUF(r) (((r) >> 8 ) & 0xff)
#define GET_LMS7002_LDO_RDIV_TBB(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x009E {
    LMS7002_LDO_RDIV_MXRFE_OFF = 8,
    LMS7002_LDO_RDIV_MXRFE_MSK = 0xff,
    LMS7002_LDO_RDIV_RBB_OFF = 0,
    LMS7002_LDO_RDIV_RBB_MSK = 0xff,
};
#define MAKE_LMS7002_0x009E( RDIV_MXRFE, RDIV_RBB ) ( \
    (((RDIV_MXRFE) & 0xff) << 8) | \
    (((RDIV_RBB) & 0xff) << 0) | \
    (0x009E0000 | 0x80000000))
#define GET_LMS7002_LDO_RDIV_MXRFE(r) (((r) >> 8 ) & 0xff)
#define GET_LMS7002_LDO_RDIV_RBB(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x009F {
    LMS7002_LDO_RDIV_LNA12_OFF = 8,
    LMS7002_LDO_RDIV_LNA12_MSK = 0xff,
    LMS7002_LDO_RDIV_LNA14_OFF = 0,
    LMS7002_LDO_RDIV_LNA14_MSK = 0xff,
};
#define MAKE_LMS7002_0x009F( RDIV_LNA12, RDIV_LNA14 ) ( \
    (((RDIV_LNA12) & 0xff) << 8) | \
    (((RDIV_LNA14) & 0xff) << 0) | \
    (0x009F0000 | 0x80000000))
#define GET_LMS7002_LDO_RDIV_LNA12(r) (((r) >> 8 ) & 0xff)
#define GET_LMS7002_LDO_RDIV_LNA14(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x00A0 {
    LMS7002_LDO_RDIV_DIVSXR_OFF = 8,
    LMS7002_LDO_RDIV_DIVSXR_MSK = 0xff,
    LMS7002_LDO_RDIV_DIVSXT_OFF = 0,
    LMS7002_LDO_RDIV_DIVSXT_MSK = 0xff,
};
#define MAKE_LMS7002_0x00A0( RDIV_DIVSXR, RDIV_DIVSXT ) ( \
    (((RDIV_DIVSXR) & 0xff) << 8) | \
    (((RDIV_DIVSXT) & 0xff) << 0) | \
    (0x00A00000 | 0x80000000))
#define GET_LMS7002_LDO_RDIV_DIVSXR(r) (((r) >> 8 ) & 0xff)
#define GET_LMS7002_LDO_RDIV_DIVSXT(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x00A1 {
    LMS7002_LDO_RDIV_DIGSXT_OFF = 8,
    LMS7002_LDO_RDIV_DIGSXT_MSK = 0xff,
    LMS7002_LDO_RDIV_DIVGN_OFF = 0,
    LMS7002_LDO_RDIV_DIVGN_MSK = 0xff,
};
#define MAKE_LMS7002_0x00A1( RDIV_DIGSXT, RDIV_DIVGN ) ( \
    (((RDIV_DIGSXT) & 0xff) << 8) | \
    (((RDIV_DIVGN) & 0xff) << 0) | \
    (0x00A10000 | 0x80000000))
#define GET_LMS7002_LDO_RDIV_DIGSXT(r) (((r) >> 8 ) & 0xff)
#define GET_LMS7002_LDO_RDIV_DIVGN(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x00A2 {
    LMS7002_LDO_RDIV_DIGGN_OFF = 8,
    LMS7002_LDO_RDIV_DIGGN_MSK = 0xff,
    LMS7002_LDO_RDIV_DIGSXR_OFF = 0,
    LMS7002_LDO_RDIV_DIGSXR_MSK = 0xff,
};
#define MAKE_LMS7002_0x00A2( RDIV_DIGGN, RDIV_DIGSXR ) ( \
    (((RDIV_DIGGN) & 0xff) << 8) | \
    (((RDIV_DIGSXR) & 0xff) << 0) | \
    (0x00A20000 | 0x80000000))
#define GET_LMS7002_LDO_RDIV_DIGGN(r) (((r) >> 8 ) & 0xff)
#define GET_LMS7002_LDO_RDIV_DIGSXR(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x00A3 {
    LMS7002_LDO_RDIV_CPSXT_OFF = 8,
    LMS7002_LDO_RDIV_CPSXT_MSK = 0xff,
    LMS7002_LDO_RDIV_DIG_OFF = 0,
    LMS7002_LDO_RDIV_DIG_MSK = 0xff,
};
#define MAKE_LMS7002_0x00A3( RDIV_CPSXT, RDIV_DIG ) ( \
    (((RDIV_CPSXT) & 0xff) << 8) | \
    (((RDIV_DIG) & 0xff) << 0) | \
    (0x00A30000 | 0x80000000))
#define GET_LMS7002_LDO_RDIV_CPSXT(r) (((r) >> 8 ) & 0xff)
#define GET_LMS7002_LDO_RDIV_DIG(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x00A4 {
    LMS7002_LDO_RDIV_CPGN_OFF = 8,
    LMS7002_LDO_RDIV_CPGN_MSK = 0xff,
    LMS7002_LDO_RDIV_CPSXR_OFF = 0,
    LMS7002_LDO_RDIV_CPSXR_MSK = 0xff,
};
#define MAKE_LMS7002_0x00A4( RDIV_CPGN, RDIV_CPSXR ) ( \
    (((RDIV_CPGN) & 0xff) << 8) | \
    (((RDIV_CPSXR) & 0xff) << 0) | \
    (0x00A40000 | 0x80000000))
#define GET_LMS7002_LDO_RDIV_CPGN(r) (((r) >> 8 ) & 0xff)
#define GET_LMS7002_LDO_RDIV_CPSXR(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x00A5 {
    LMS7002_LDO_RDIV_SPIBUF_OFF = 8,
    LMS7002_LDO_RDIV_SPIBUF_MSK = 0xff,
    LMS7002_LDO_RDIV_AFE_OFF = 0,
    LMS7002_LDO_RDIV_AFE_MSK = 0xff,
};
#define MAKE_LMS7002_0x00A5( RDIV_SPIBUF, RDIV_AFE ) ( \
    (((RDIV_SPIBUF) & 0xff) << 8) | \
    (((RDIV_AFE) & 0xff) << 0) | \
    (0x00A50000 | 0x80000000))
#define GET_LMS7002_LDO_RDIV_SPIBUF(r) (((r) >> 8 ) & 0xff)
#define GET_LMS7002_LDO_RDIV_AFE(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x00A6 {
    LMS7002_LDO_SPDUP_LDO_SPIBUF_OFF = 12,
    LMS7002_LDO_SPDUP_LDO_DIGIP2_OFF = 11,
    LMS7002_LDO_SPDUP_LDO_DIGIP1_OFF = 10,
    LMS7002_LDO_BYP_LDO_SPIBUF_OFF = 9,
    LMS7002_LDO_BYP_LDO_DIGIP2_OFF = 8,
    LMS7002_LDO_BYP_LDO_DIGIP1_OFF = 7,
    LMS7002_LDO_EN_LOADIMP_LDO_SPIBUF_OFF = 6,
    LMS7002_LDO_EN_LOADIMP_LDO_DIGIP2_OFF = 5,
    LMS7002_LDO_EN_LOADIMP_LDO_DIGIP1_OFF = 4,
    LMS7002_LDO_PD_LDO_SPIBUF_OFF = 3,
    LMS7002_LDO_PD_LDO_DIGIP2_OFF = 2,
    LMS7002_LDO_PD_LDO_DIGIP1_OFF = 1,
    LMS7002_LDO_EN_G_LDOP_OFF = 0,
};
#define MAKE_LMS7002_0x00A6( SPDUP_LDO_SPIBUF, SPDUP_LDO_DIGIp2, SPDUP_LDO_DIGIp1, BYP_LDO_SPIBUF, BYP_LDO_DIGIp2, BYP_LDO_DIGIp1, EN_LOADIMP_LDO_SPIBUF, EN_LOADIMP_LDO_DIGIp2, EN_LOADIMP_LDO_DIGIp1, PD_LDO_SPIBUF, PD_LDO_DIGIp2, PD_LDO_DIGIp1, EN_G_LDOP ) ( \
    (((SPDUP_LDO_SPIBUF) & 0x1) << 12) | \
    (((SPDUP_LDO_DIGIp2) & 0x1) << 11) | \
    (((SPDUP_LDO_DIGIp1) & 0x1) << 10) | \
    (((BYP_LDO_SPIBUF) & 0x1) << 9) | \
    (((BYP_LDO_DIGIp2) & 0x1) << 8) | \
    (((BYP_LDO_DIGIp1) & 0x1) << 7) | \
    (((EN_LOADIMP_LDO_SPIBUF) & 0x1) << 6) | \
    (((EN_LOADIMP_LDO_DIGIp2) & 0x1) << 5) | \
    (((EN_LOADIMP_LDO_DIGIp1) & 0x1) << 4) | \
    (((PD_LDO_SPIBUF) & 0x1) << 3) | \
    (((PD_LDO_DIGIp2) & 0x1) << 2) | \
    (((PD_LDO_DIGIp1) & 0x1) << 1) | \
    (((EN_G_LDOP) & 0x1) << 0) | \
    (0x00A60000 | 0x80000000))
#define GET_LMS7002_LDO_SPDUP_LDO_SPIBUF(r) (((r) >> 12 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_DIGIp2(r) (((r) >> 11 ) & 0x1)
#define GET_LMS7002_LDO_SPDUP_LDO_DIGIp1(r) (((r) >> 10 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_SPIBUF(r) (((r) >> 9 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_DIGIp2(r) (((r) >> 8 ) & 0x1)
#define GET_LMS7002_LDO_BYP_LDO_DIGIp1(r) (((r) >> 7 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_SPIBUF(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_DIGIp2(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_LDO_EN_LOADIMP_LDO_DIGIp1(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_LDO_PD_LDO_SPIBUF(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_LDO_PD_LDO_DIGIp2(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_LDO_PD_LDO_DIGIp1(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_LDO_EN_G_LDOP(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x00A7 {
    LMS7002_LDO_RDIV_DIGIP2_OFF = 8,
    LMS7002_LDO_RDIV_DIGIP2_MSK = 0xff,
    LMS7002_LDO_RDIV_DIGIP1_OFF = 0,
    LMS7002_LDO_RDIV_DIGIP1_MSK = 0xff,
};
#define MAKE_LMS7002_0x00A7( RDIV_DIGIp2, RDIV_DIGIp1 ) ( \
    (((RDIV_DIGIp2) & 0xff) << 8) | \
    (((RDIV_DIGIp1) & 0xff) << 0) | \
    (0x00A70000 | 0x80000000))
#define GET_LMS7002_LDO_RDIV_DIGIp2(r) (((r) >> 8 ) & 0xff)
#define GET_LMS7002_LDO_RDIV_DIGIp1(r) (((r) >> 0 ) & 0xff)



/*************************************
 * LML configuration registers
 *************************************/
enum lms7002m_reg_0x0020 {
    LMS7002_LML_LRST_TX_B_OFF = 15,
    LMS7002_LML_MRST_TX_B_OFF = 14,
    LMS7002_LML_LRST_TX_A_OFF = 13,
    LMS7002_LML_MRST_TX_A_OFF = 12,
    LMS7002_LML_LRST_RX_B_OFF = 11,
    LMS7002_LML_MRST_RX_B_OFF = 10,
    LMS7002_LML_LRST_RX_A_OFF = 9,
    LMS7002_LML_MRST_RX_A_OFF = 8,
    LMS7002_LML_SRST_RXFIFO_OFF = 7,
    LMS7002_LML_SRST_TXFIFO_OFF = 6,
    LMS7002_LML_RXEN_B_OFF = 5,
    LMS7002_LML_RXEN_A_OFF = 4,
    LMS7002_LML_TXEN_B_OFF = 3,
    LMS7002_LML_TXEN_A_OFF = 2,
    LMS7002_LML_MAC_OFF = 0,
    LMS7002_LML_MAC_MSK = 0x3,
};
#define MAKE_LMS7002_0x0020( LRST_TX_B, MRST_TX_B, LRST_TX_A, MRST_TX_A, LRST_RX_B, MRST_RX_B, LRST_RX_A, MRST_RX_A, SRST_RXFIFO, SRST_TXFIFO, RXEN_B, RXEN_A, TXEN_B, TXEN_A, MAC ) ( \
    (((LRST_TX_B) & 0x1) << 15) | \
    (((MRST_TX_B) & 0x1) << 14) | \
    (((LRST_TX_A) & 0x1) << 13) | \
    (((MRST_TX_A) & 0x1) << 12) | \
    (((LRST_RX_B) & 0x1) << 11) | \
    (((MRST_RX_B) & 0x1) << 10) | \
    (((LRST_RX_A) & 0x1) << 9) | \
    (((MRST_RX_A) & 0x1) << 8) | \
    (((SRST_RXFIFO) & 0x1) << 7) | \
    (((SRST_TXFIFO) & 0x1) << 6) | \
    (((RXEN_B) & 0x1) << 5) | \
    (((RXEN_A) & 0x1) << 4) | \
    (((TXEN_B) & 0x1) << 3) | \
    (((TXEN_A) & 0x1) << 2) | \
    (((MAC) & 0x3) << 0) | \
    (0x00200000 | 0x80000000))
#define GET_LMS7002_LML_LRST_TX_B(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_LML_MRST_TX_B(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_LML_LRST_TX_A(r) (((r) >> 13 ) & 0x1)
#define GET_LMS7002_LML_MRST_TX_A(r) (((r) >> 12 ) & 0x1)
#define GET_LMS7002_LML_LRST_RX_B(r) (((r) >> 11 ) & 0x1)
#define GET_LMS7002_LML_MRST_RX_B(r) (((r) >> 10 ) & 0x1)
#define GET_LMS7002_LML_LRST_RX_A(r) (((r) >> 9 ) & 0x1)
#define GET_LMS7002_LML_MRST_RX_A(r) (((r) >> 8 ) & 0x1)
#define GET_LMS7002_LML_SRST_RXFIFO(r) (((r) >> 7 ) & 0x1)
#define GET_LMS7002_LML_SRST_TXFIFO(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_LML_RXEN_B(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_LML_RXEN_A(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_LML_TXEN_B(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_LML_TXEN_A(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_LML_MAC(r) (((r) >> 0 ) & 0x3)

enum lms7002m_reg_0x0021 {
    LMS7002_LML_TX_CLK_PE_OFF = 11,
    LMS7002_LML_RX_CLK_PE_OFF = 10,
    LMS7002_LML_SDA_PE_OFF = 9,
    LMS7002_LML_SDA_DS_OFF = 8,
    LMS7002_LML_SCL_PE_OFF = 7,
    LMS7002_LML_SCL_DS_OFF = 6,
    LMS7002_LML_SDIO_DS_OFF = 5,
    LMS7002_LML_SDIO_PE_OFF = 4,
    LMS7002_LML_SDO_PE_OFF = 3,
    LMS7002_LML_SCLK_PE_OFF = 2,
    LMS7002_LML_SEN_PE_OFF = 1,
    LMS7002_LML_SPIMODE_OFF = 0,
};
#define MAKE_LMS7002_0x0021( TX_CLK_PE, RX_CLK_PE, SDA_PE, SDA_DS, SCL_PE, SCL_DS, SDIO_DS, SDIO_PE, SDO_PE, SCLK_PE, SEN_PE, SPIMODE ) ( \
    (((TX_CLK_PE) & 0x1) << 11) | \
    (((RX_CLK_PE) & 0x1) << 10) | \
    (((SDA_PE) & 0x1) << 9) | \
    (((SDA_DS) & 0x1) << 8) | \
    (((SCL_PE) & 0x1) << 7) | \
    (((SCL_DS) & 0x1) << 6) | \
    (((SDIO_DS) & 0x1) << 5) | \
    (((SDIO_PE) & 0x1) << 4) | \
    (((SDO_PE) & 0x1) << 3) | \
    (((SCLK_PE) & 0x1) << 2) | \
    (((SEN_PE) & 0x1) << 1) | \
    (((SPIMODE) & 0x1) << 0) | \
    (0x00210000 | 0x80000000))
#define GET_LMS7002_LML_TX_CLK_PE(r) (((r) >> 11 ) & 0x1)
#define GET_LMS7002_LML_RX_CLK_PE(r) (((r) >> 10 ) & 0x1)
#define GET_LMS7002_LML_SDA_PE(r) (((r) >> 9 ) & 0x1)
#define GET_LMS7002_LML_SDA_DS(r) (((r) >> 8 ) & 0x1)
#define GET_LMS7002_LML_SCL_PE(r) (((r) >> 7 ) & 0x1)
#define GET_LMS7002_LML_SCL_DS(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_LML_SDIO_DS(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_LML_SDIO_PE(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_LML_SDO_PE(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_LML_SCLK_PE(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_LML_SEN_PE(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_LML_SPIMODE(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x0022 {
    LMS7002_LML_DIQ2_DS_OFF = 11,
    LMS7002_LML_DIQ2_PE_OFF = 10,
    LMS7002_LML_IQ_SET_EN_2_PE_OFF = 9,
    LMS7002_LML_TXNRX2_PE_OFF = 8,
    LMS7002_LML_FCLK2_PE_OFF = 7,
    LMS7002_LML_MCLK2_PE_OFF = 6,
    LMS7002_LML_DIQ1_DS_OFF = 5,
    LMS7002_LML_DIQ1_PE_OFF = 4,
    LMS7002_LML_IQ_SET_EN_1_PE_OFF = 3,
    LMS7002_LML_TXNRX1_PE_OFF = 2,
    LMS7002_LML_FCLK1_PE_OFF = 1,
    LMS7002_LML_MCLK1_PE_OFF = 0,
};
#define MAKE_LMS7002_0x0022( DIQ2_DS, DIQ2_PE, IQ_SET_EN_2_PE, TXNRX2_PE, FCLK2_PE, MCLK2_PE, DIQ1_DS, DIQ1_PE, IQ_SET_EN_1_PE, TXNRX1_PE, FCLK1_PE, MCLK1_PE ) ( \
    (((DIQ2_DS) & 0x1) << 11) | \
    (((DIQ2_PE) & 0x1) << 10) | \
    (((IQ_SET_EN_2_PE) & 0x1) << 9) | \
    (((TXNRX2_PE) & 0x1) << 8) | \
    (((FCLK2_PE) & 0x1) << 7) | \
    (((MCLK2_PE) & 0x1) << 6) | \
    (((DIQ1_DS) & 0x1) << 5) | \
    (((DIQ1_PE) & 0x1) << 4) | \
    (((IQ_SET_EN_1_PE) & 0x1) << 3) | \
    (((TXNRX1_PE) & 0x1) << 2) | \
    (((FCLK1_PE) & 0x1) << 1) | \
    (((MCLK1_PE) & 0x1) << 0) | \
    (0x00220000 | 0x80000000))
#define GET_LMS7002_LML_DIQ2_DS(r) (((r) >> 11 ) & 0x1)
#define GET_LMS7002_LML_DIQ2_PE(r) (((r) >> 10 ) & 0x1)
#define GET_LMS7002_LML_IQ_SET_EN_2_PE(r) (((r) >> 9 ) & 0x1)
#define GET_LMS7002_LML_TXNRX2_PE(r) (((r) >> 8 ) & 0x1)
#define GET_LMS7002_LML_FCLK2_PE(r) (((r) >> 7 ) & 0x1)
#define GET_LMS7002_LML_MCLK2_PE(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_LML_DIQ1_DS(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_LML_DIQ1_PE(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_LML_IQ_SET_EN_1_PE(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_LML_TXNRX1_PE(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_LML_FCLK1_PE(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_LML_MCLK1_PE(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x0023 {
    LMS7002_LML_DIQDIRCTR2_OFF = 15,
    LMS7002_LML_DIQDIR2_OFF = 14,
    LMS7002_LML_DIQDIRCTR1_OFF = 13,
    LMS7002_LML_DIQDIR1_OFF = 12,
    LMS7002_LML_ENABLEDIRCTR2_OFF = 11,
    LMS7002_LML_ENABLEDIR2_OFF = 10,
    LMS7002_LML_ENABLEDIRCTR1_OFF = 9,
    LMS7002_LML_ENABLEDIR1_OFF = 8,
    LMS7002_LML_MOD_EN_OFF = 6,
    LMS7002_LML_LML2_FIDM_OFF = 5,
    LMS7002_LML_LML2_RXNTXIQ_OFF = 4,
    LMS7002_LML_LML2_MODE_OFF = 3,
    LMS7002_LML_LML1_FIDM_OFF = 2,
    LMS7002_LML_LML1_RXNTXIQ_OFF = 1,
    LMS7002_LML_LML1_MODE_OFF = 0,
};
#define MAKE_LMS7002_0x0023( DIQDIRCTR2, DIQDIR2, DIQDIRCTR1, DIQDIR1, ENABLEDIRCTR2, ENABLEDIR2, ENABLEDIRCTR1, ENABLEDIR1, MOD_EN, LML2_FIDM, LML2_RXNTXIQ, LML2_MODE, LML1_FIDM, LML1_RXNTXIQ, LML1_MODE ) ( \
    (((DIQDIRCTR2) & 0x1) << 15) | \
    (((DIQDIR2) & 0x1) << 14) | \
    (((DIQDIRCTR1) & 0x1) << 13) | \
    (((DIQDIR1) & 0x1) << 12) | \
    (((ENABLEDIRCTR2) & 0x1) << 11) | \
    (((ENABLEDIR2) & 0x1) << 10) | \
    (((ENABLEDIRCTR1) & 0x1) << 9) | \
    (((ENABLEDIR1) & 0x1) << 8) | \
    (((MOD_EN) & 0x1) << 6) | \
    (((LML2_FIDM) & 0x1) << 5) | \
    (((LML2_RXNTXIQ) & 0x1) << 4) | \
    (((LML2_MODE) & 0x1) << 3) | \
    (((LML1_FIDM) & 0x1) << 2) | \
    (((LML1_RXNTXIQ) & 0x1) << 1) | \
    (((LML1_MODE) & 0x1) << 0) | \
    (0x00230000 | 0x80000000))
#define GET_LMS7002_LML_DIQDIRCTR2(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_LML_DIQDIR2(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_LML_DIQDIRCTR1(r) (((r) >> 13 ) & 0x1)
#define GET_LMS7002_LML_DIQDIR1(r) (((r) >> 12 ) & 0x1)
#define GET_LMS7002_LML_ENABLEDIRCTR2(r) (((r) >> 11 ) & 0x1)
#define GET_LMS7002_LML_ENABLEDIR2(r) (((r) >> 10 ) & 0x1)
#define GET_LMS7002_LML_ENABLEDIRCTR1(r) (((r) >> 9 ) & 0x1)
#define GET_LMS7002_LML_ENABLEDIR1(r) (((r) >> 8 ) & 0x1)
#define GET_LMS7002_LML_MOD_EN(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_LML_LML2_FIDM(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_LML_LML2_RXNTXIQ(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_LML_LML2_MODE(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_LML_LML1_FIDM(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_LML_LML1_RXNTXIQ(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_LML_LML1_MODE(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x0024 {
    LMS7002_LML_LML1_S3S_OFF = 14,
    LMS7002_LML_LML1_S3S_MSK = 0x3,
    LMS7002_LML_LML1_S2S_OFF = 12,
    LMS7002_LML_LML1_S2S_MSK = 0x3,
    LMS7002_LML_LML1_S1S_OFF = 10,
    LMS7002_LML_LML1_S1S_MSK = 0x3,
    LMS7002_LML_LML1_S0S_OFF = 8,
    LMS7002_LML_LML1_S0S_MSK = 0x3,
    LMS7002_LML_LML1_BQP_OFF = 6,
    LMS7002_LML_LML1_BQP_MSK = 0x3,
    LMS7002_LML_LML1_BIP_OFF = 4,
    LMS7002_LML_LML1_BIP_MSK = 0x3,
    LMS7002_LML_LML1_AQP_OFF = 2,
    LMS7002_LML_LML1_AQP_MSK = 0x3,
    LMS7002_LML_LML1_AIP_OFF = 0,
    LMS7002_LML_LML1_AIP_MSK = 0x3,
};
#define MAKE_LMS7002_0x0024( LML1_S3S, LML1_S2S, LML1_S1S, LML1_S0S, LML1_BQP, LML1_BIP, LML1_AQP, LML1_AIP ) ( \
    (((LML1_S3S) & 0x3) << 14) | \
    (((LML1_S2S) & 0x3) << 12) | \
    (((LML1_S1S) & 0x3) << 10) | \
    (((LML1_S0S) & 0x3) << 8) | \
    (((LML1_BQP) & 0x3) << 6) | \
    (((LML1_BIP) & 0x3) << 4) | \
    (((LML1_AQP) & 0x3) << 2) | \
    (((LML1_AIP) & 0x3) << 0) | \
    (0x00240000 | 0x80000000))
#define GET_LMS7002_LML_LML1_S3S(r) (((r) >> 14 ) & 0x3)
#define GET_LMS7002_LML_LML1_S2S(r) (((r) >> 12 ) & 0x3)
#define GET_LMS7002_LML_LML1_S1S(r) (((r) >> 10 ) & 0x3)
#define GET_LMS7002_LML_LML1_S0S(r) (((r) >> 8 ) & 0x3)
#define GET_LMS7002_LML_LML1_BQP(r) (((r) >> 6 ) & 0x3)
#define GET_LMS7002_LML_LML1_BIP(r) (((r) >> 4 ) & 0x3)
#define GET_LMS7002_LML_LML1_AQP(r) (((r) >> 2 ) & 0x3)
#define GET_LMS7002_LML_LML1_AIP(r) (((r) >> 0 ) & 0x3)

enum lms7002m_reg_0x0025 {
    LMS7002_LML_LML1_BB2RF_PST_OFF = 8,
    LMS7002_LML_LML1_BB2RF_PST_MSK = 0xf,
    LMS7002_LML_LML1_BB2RF_PRE_OFF = 0,
    LMS7002_LML_LML1_BB2RF_PRE_MSK = 0x1f,
};
#define MAKE_LMS7002_0x0025( LML1_BB2RF_PST, LML1_BB2RF_PRE ) ( \
    (((LML1_BB2RF_PST) & 0xf) << 8) | \
    (((LML1_BB2RF_PRE) & 0x1f) << 0) | \
    (0x00250000 | 0x80000000))
#define GET_LMS7002_LML_LML1_BB2RF_PST(r) (((r) >> 8 ) & 0xf)
#define GET_LMS7002_LML_LML1_BB2RF_PRE(r) (((r) >> 0 ) & 0x1f)

enum lms7002m_reg_0x0026 {
    LMS7002_LML_LML1_RF2BB_PST_OFF = 8,
    LMS7002_LML_LML1_RF2BB_PST_MSK = 0xf,
    LMS7002_LML_LML1_RF2BB_PRE_OFF = 0,
    LMS7002_LML_LML1_RF2BB_PRE_MSK = 0x1f,
};
#define MAKE_LMS7002_0x0026( LML1_RF2BB_PST, LML1_RF2BB_PRE ) ( \
    (((LML1_RF2BB_PST) & 0xf) << 8) | \
    (((LML1_RF2BB_PRE) & 0x1f) << 0) | \
    (0x00260000 | 0x80000000))
#define GET_LMS7002_LML_LML1_RF2BB_PST(r) (((r) >> 8 ) & 0xf)
#define GET_LMS7002_LML_LML1_RF2BB_PRE(r) (((r) >> 0 ) & 0x1f)

enum lms7002m_reg_0x0027 {
    LMS7002_LML_LML2_S3S_OFF = 14,
    LMS7002_LML_LML2_S3S_MSK = 0x3,
    LMS7002_LML_LML2_S2S_OFF = 12,
    LMS7002_LML_LML2_S2S_MSK = 0x3,
    LMS7002_LML_LML2_S1S_OFF = 10,
    LMS7002_LML_LML2_S1S_MSK = 0x3,
    LMS7002_LML_LML2_S0S_OFF = 8,
    LMS7002_LML_LML2_S0S_MSK = 0x3,
    LMS7002_LML_LML2_BQP_OFF = 6,
    LMS7002_LML_LML2_BQP_MSK = 0x3,
    LMS7002_LML_LML2_BIP_OFF = 4,
    LMS7002_LML_LML2_BIP_MSK = 0x3,
    LMS7002_LML_LML2_AQP_OFF = 2,
    LMS7002_LML_LML2_AQP_MSK = 0x3,
    LMS7002_LML_LML2_AIP_OFF = 0,
    LMS7002_LML_LML2_AIP_MSK = 0x3,
};
#define MAKE_LMS7002_0x0027( LML2_S3S, LML2_S2S, LML2_S1S, LML2_S0S, LML2_BQP, LML2_BIP, LML2_AQP, LML2_AIP ) ( \
    (((LML2_S3S) & 0x3) << 14) | \
    (((LML2_S2S) & 0x3) << 12) | \
    (((LML2_S1S) & 0x3) << 10) | \
    (((LML2_S0S) & 0x3) << 8) | \
    (((LML2_BQP) & 0x3) << 6) | \
    (((LML2_BIP) & 0x3) << 4) | \
    (((LML2_AQP) & 0x3) << 2) | \
    (((LML2_AIP) & 0x3) << 0) | \
    (0x00270000 | 0x80000000))
#define GET_LMS7002_LML_LML2_S3S(r) (((r) >> 14 ) & 0x3)
#define GET_LMS7002_LML_LML2_S2S(r) (((r) >> 12 ) & 0x3)
#define GET_LMS7002_LML_LML2_S1S(r) (((r) >> 10 ) & 0x3)
#define GET_LMS7002_LML_LML2_S0S(r) (((r) >> 8 ) & 0x3)
#define GET_LMS7002_LML_LML2_BQP(r) (((r) >> 6 ) & 0x3)
#define GET_LMS7002_LML_LML2_BIP(r) (((r) >> 4 ) & 0x3)
#define GET_LMS7002_LML_LML2_AQP(r) (((r) >> 2 ) & 0x3)
#define GET_LMS7002_LML_LML2_AIP(r) (((r) >> 0 ) & 0x3)

enum lms7002m_reg_0x0028 {
    LMS7002_LML_LML2_BB2RF_PST_OFF = 8,
    LMS7002_LML_LML2_BB2RF_PST_MSK = 0xf,
    LMS7002_LML_LML2_BB2RF_PRE_OFF = 0,
    LMS7002_LML_LML2_BB2RF_PRE_MSK = 0x1f,
};
#define MAKE_LMS7002_0x0028( LML2_BB2RF_PST, LML2_BB2RF_PRE ) ( \
    (((LML2_BB2RF_PST) & 0xf) << 8) | \
    (((LML2_BB2RF_PRE) & 0x1f) << 0) | \
    (0x00280000 | 0x80000000))
#define GET_LMS7002_LML_LML2_BB2RF_PST(r) (((r) >> 8 ) & 0xf)
#define GET_LMS7002_LML_LML2_BB2RF_PRE(r) (((r) >> 0 ) & 0x1f)

enum lms7002m_reg_0x0029 {
    LMS7002_LML_LML2_RF2BB_PST_OFF = 8,
    LMS7002_LML_LML2_RF2BB_PST_MSK = 0xf,
    LMS7002_LML_LML2_RF2BB_PRE_OFF = 0,
    LMS7002_LML_LML2_RF2BB_PRE_MSK = 0x1f,
};
#define MAKE_LMS7002_0x0029( LML2_RF2BB_PST, LML2_RF2BB_PRE ) ( \
    (((LML2_RF2BB_PST) & 0xf) << 8) | \
    (((LML2_RF2BB_PRE) & 0x1f) << 0) | \
    (0x00290000 | 0x80000000))
#define GET_LMS7002_LML_LML2_RF2BB_PST(r) (((r) >> 8 ) & 0xf)
#define GET_LMS7002_LML_LML2_RF2BB_PRE(r) (((r) >> 0 ) & 0x1f)

enum lms7002m_reg_0x002A {
    LMS7002_LML_RX_MUX_OFF = 10,
    LMS7002_LML_RX_MUX_MSK = 0x3,
    LMS7002_LML_TX_MUX_OFF = 8,
    LMS7002_LML_TX_MUX_MSK = 0x3,
    LMS7002_LML_TXRDCLK_MUX_OFF = 6,
    LMS7002_LML_TXRDCLK_MUX_MSK = 0x3,
    LMS7002_LML_TXWRCLK_MUX_OFF = 4,
    LMS7002_LML_TXWRCLK_MUX_MSK = 0x3,
    LMS7002_LML_RXRDCLK_MUX_OFF = 2,
    LMS7002_LML_RXRDCLK_MUX_MSK = 0x3,
    LMS7002_LML_RXWRCLK_MUX_OFF = 0,
    LMS7002_LML_RXWRCLK_MUX_MSK = 0x3,
};
#define MAKE_LMS7002_0x002A( RX_MUX, TX_MUX, TXRDCLK_MUX, TXWRCLK_MUX, RXRDCLK_MUX, RXWRCLK_MUX ) ( \
    (((RX_MUX) & 0x3) << 10) | \
    (((TX_MUX) & 0x3) << 8) | \
    (((TXRDCLK_MUX) & 0x3) << 6) | \
    (((TXWRCLK_MUX) & 0x3) << 4) | \
    (((RXRDCLK_MUX) & 0x3) << 2) | \
    (((RXWRCLK_MUX) & 0x3) << 0) | \
    (0x002A0000 | 0x80000000))
#define GET_LMS7002_LML_RX_MUX(r) (((r) >> 10 ) & 0x3)
#define GET_LMS7002_LML_TX_MUX(r) (((r) >> 8 ) & 0x3)
#define GET_LMS7002_LML_TXRDCLK_MUX(r) (((r) >> 6 ) & 0x3)
#define GET_LMS7002_LML_TXWRCLK_MUX(r) (((r) >> 4 ) & 0x3)
#define GET_LMS7002_LML_RXRDCLK_MUX(r) (((r) >> 2 ) & 0x3)
#define GET_LMS7002_LML_RXWRCLK_MUX(r) (((r) >> 0 ) & 0x3)

enum lms7002m_reg_0x002B {
    LMS7002_LML_FCLK2_INV_OFF = 15,
    LMS7002_LML_FCLK1_INV_OFF = 14,
    LMS7002_LML_MCLK2_INV_OFF = 9,
    LMS7002_LML_MCLK1_INV_OFF = 8,
    LMS7002_LML_MCLK2SRC_OFF = 4,
    LMS7002_LML_MCLK2SRC_MSK = 0x3,
    LMS7002_LML_MCLK1SRC_OFF = 2,
    LMS7002_LML_MCLK1SRC_MSK = 0x3,
    LMS7002_LML_TXDIVEN_OFF = 1,
    LMS7002_LML_RXDIVEN_OFF = 0,
};
#define MAKE_LMS7002_0x002B( FCLK2_INV, FCLK1_INV, MCLK2_INV, MCLK1_INV, MCLK2SRC, MCLK1SRC, TXDIVEN, RXDIVEN ) ( \
    (((FCLK2_INV) & 0x1) << 15) | \
    (((FCLK1_INV) & 0x1) << 14) | \
    (((MCLK2_INV) & 0x1) << 9) | \
    (((MCLK1_INV) & 0x1) << 8) | \
    (((MCLK2SRC) & 0x3) << 4) | \
    (((MCLK1SRC) & 0x3) << 2) | \
    (((TXDIVEN) & 0x1) << 1) | \
    (((RXDIVEN) & 0x1) << 0) | \
    (0x002B0000 | 0x80000000))
#define GET_LMS7002_LML_FCLK2_INV(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_LML_FCLK1_INV(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_LML_MCLK2_INV(r) (((r) >> 9 ) & 0x1)
#define GET_LMS7002_LML_MCLK1_INV(r) (((r) >> 8 ) & 0x1)
#define GET_LMS7002_LML_MCLK2SRC(r) (((r) >> 4 ) & 0x3)
#define GET_LMS7002_LML_MCLK1SRC(r) (((r) >> 2 ) & 0x3)
#define GET_LMS7002_LML_TXDIVEN(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_LML_RXDIVEN(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x002C {
    LMS7002_LML_TXTSPCLK_DIV_OFF = 8,
    LMS7002_LML_TXTSPCLK_DIV_MSK = 0xff,
    LMS7002_LML_RXTSPCLK_DIV_OFF = 0,
    LMS7002_LML_RXTSPCLK_DIV_MSK = 0xff,
};
#define MAKE_LMS7002_0x002C( TXTSPCLK_DIV, RXTSPCLK_DIV ) ( \
    (((TXTSPCLK_DIV) & 0xff) << 8) | \
    (((RXTSPCLK_DIV) & 0xff) << 0) | \
    (0x002C0000 | 0x80000000))
#define GET_LMS7002_LML_TXTSPCLK_DIV(r) (((r) >> 8 ) & 0xff)
#define GET_LMS7002_LML_RXTSPCLK_DIV(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x002E {
    LMS7002_LML_MIMO_SISO_OFF = 15,
};
#define MAKE_LMS7002_0x002E( MIMO_SISO ) ( \
    (((MIMO_SISO) & 0x1) << 15) | \
    (0x002E0000 | 0x80000000))
#define GET_LMS7002_LML_MIMO_SISO(r) (((r) >> 15 ) & 0x1)

enum lms7002m_reg_0x002F {
    LMS7002_LML_VER_OFF = 11,
    LMS7002_LML_VER_MSK = 0x1f,
    LMS7002_LML_REV_OFF = 6,
    LMS7002_LML_REV_MSK = 0x1f,
    LMS7002_LML_MASK_OFF = 0,
    LMS7002_LML_MASK_MSK = 0x3f,
};
#define MAKE_LMS7002_0x002F( VER, REV, MASK ) ( \
    (((VER) & 0x1f) << 11) | \
    (((REV) & 0x1f) << 6) | \
    (((MASK) & 0x3f) << 0) | \
    (0x002F0000 | 0x80000000))
#define GET_LMS7002_LML_VER(r) (((r) >> 11 ) & 0x1f)
#define GET_LMS7002_LML_REV(r) (((r) >> 6 ) & 0x1f)
#define GET_LMS7002_LML_MASK(r) (((r) >> 0 ) & 0x3f)



/*************************************
 * RBB configuration registers
 *************************************/
enum lms7002m_reg_0x0115 {
    LMS7002_RBB_EN_LB_LPFH_RBB_OFF = 15,
    LMS7002_RBB_EN_LB_LPFL_RBB_OFF = 14,
    LMS7002_RBB_PD_LPFH_RBB_OFF = 3,
    LMS7002_RBB_PD_LPFL_RBB_OFF = 2,
    LMS7002_RBB_PD_PGA_RBB_OFF = 1,
    LMS7002_RBB_EN_G_RBB_OFF = 0,
};
#define MAKE_LMS7002_0x0115( EN_LB_LPFH_RBB, EN_LB_LPFL_RBB, PD_LPFH_RBB, PD_LPFL_RBB, PD_PGA_RBB, EN_G_RBB ) ( \
    (((EN_LB_LPFH_RBB) & 0x1) << 15) | \
    (((EN_LB_LPFL_RBB) & 0x1) << 14) | \
    (((PD_LPFH_RBB) & 0x1) << 3) | \
    (((PD_LPFL_RBB) & 0x1) << 2) | \
    (((PD_PGA_RBB) & 0x1) << 1) | \
    (((EN_G_RBB) & 0x1) << 0) | \
    (0x01150000 | 0x80000000))
#define GET_LMS7002_RBB_EN_LB_LPFH_RBB(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_RBB_EN_LB_LPFL_RBB(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_RBB_PD_LPFH_RBB(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_RBB_PD_LPFL_RBB(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_RBB_PD_PGA_RBB(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_RBB_EN_G_RBB(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x0116 {
    LMS7002_RBB_R_CTL_LPF_RBB_OFF = 11,
    LMS7002_RBB_R_CTL_LPF_RBB_MSK = 0x1f,
    LMS7002_RBB_RCC_CTL_LPFH_RBB_OFF = 8,
    LMS7002_RBB_RCC_CTL_LPFH_RBB_MSK = 0x7,
    LMS7002_RBB_C_CTL_LPFH_RBB_OFF = 0,
    LMS7002_RBB_C_CTL_LPFH_RBB_MSK = 0xff,
};
#define MAKE_LMS7002_0x0116( R_CTL_LPF_RBB, RCC_CTL_LPFH_RBB, C_CTL_LPFH_RBB ) ( \
    (((R_CTL_LPF_RBB) & 0x1f) << 11) | \
    (((RCC_CTL_LPFH_RBB) & 0x7) << 8) | \
    (((C_CTL_LPFH_RBB) & 0xff) << 0) | \
    (0x01160000 | 0x80000000))
#define GET_LMS7002_RBB_R_CTL_LPF_RBB(r) (((r) >> 11 ) & 0x1f)
#define GET_LMS7002_RBB_RCC_CTL_LPFH_RBB(r) (((r) >> 8 ) & 0x7)
#define GET_LMS7002_RBB_C_CTL_LPFH_RBB(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x0117 {
    LMS7002_RBB_RCC_CTL_LPFL_RBB_OFF = 11,
    LMS7002_RBB_RCC_CTL_LPFL_RBB_MSK = 0x7,
    LMS7002_RBB_C_CTL_LPFL_RBB_OFF = 0,
    LMS7002_RBB_C_CTL_LPFL_RBB_MSK = 0x7ff,
};
#define MAKE_LMS7002_0x0117( RCC_CTL_LPFL_RBB, C_CTL_LPFL_RBB ) ( \
    (((RCC_CTL_LPFL_RBB) & 0x7) << 11) | \
    (((C_CTL_LPFL_RBB) & 0x7ff) << 0) | \
    (0x01170000 | 0x80000000))
#define GET_LMS7002_RBB_RCC_CTL_LPFL_RBB(r) (((r) >> 11 ) & 0x7)
#define GET_LMS7002_RBB_C_CTL_LPFL_RBB(r) (((r) >> 0 ) & 0x7ff)

enum lms7002m_reg_0x0118 {
    LMS7002_RBB_INPUT_CTL_PGA_RBB_OFF = 13,
    LMS7002_RBB_INPUT_CTL_PGA_RBB_MSK = 0x7,
    LMS7002_RBB_ICT_LPF_IN_RBB_OFF = 5,
    LMS7002_RBB_ICT_LPF_IN_RBB_MSK = 0x1f,
    LMS7002_RBB_ICT_LPF_OUT_RBB_OFF = 0,
    LMS7002_RBB_ICT_LPF_OUT_RBB_MSK = 0x1f,
};
#define MAKE_LMS7002_0x0118( INPUT_CTL_PGA_RBB, ICT_LPF_IN_RBB, ICT_LPF_OUT_RBB ) ( \
    (((INPUT_CTL_PGA_RBB) & 0x7) << 13) | \
    (((ICT_LPF_IN_RBB) & 0x1f) << 5) | \
    (((ICT_LPF_OUT_RBB) & 0x1f) << 0) | \
    (0x01180000 | 0x80000000))
#define GET_LMS7002_RBB_INPUT_CTL_PGA_RBB(r) (((r) >> 13 ) & 0x7)
#define GET_LMS7002_RBB_ICT_LPF_IN_RBB(r) (((r) >> 5 ) & 0x1f)
#define GET_LMS7002_RBB_ICT_LPF_OUT_RBB(r) (((r) >> 0 ) & 0x1f)

enum lms7002m_reg_0x0119 {
    LMS7002_RBB_OSW_PGA_RBB_OFF = 15,
    LMS7002_RBB_ICT_PGA_OUT_RBB_OFF = 10,
    LMS7002_RBB_ICT_PGA_OUT_RBB_MSK = 0x1f,
    LMS7002_RBB_ICT_PGA_IN_RBB_OFF = 5,
    LMS7002_RBB_ICT_PGA_IN_RBB_MSK = 0x1f,
    LMS7002_RBB_G_PGA_RBB_OFF = 0,
    LMS7002_RBB_G_PGA_RBB_MSK = 0x1f,
};
#define MAKE_LMS7002_0x0119( OSW_PGA_RBB, ICT_PGA_OUT_RBB, ICT_PGA_IN_RBB, G_PGA_RBB ) ( \
    (((OSW_PGA_RBB) & 0x1) << 15) | \
    (((ICT_PGA_OUT_RBB) & 0x1f) << 10) | \
    (((ICT_PGA_IN_RBB) & 0x1f) << 5) | \
    (((G_PGA_RBB) & 0x1f) << 0) | \
    (0x01190000 | 0x80000000))
#define GET_LMS7002_RBB_OSW_PGA_RBB(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_RBB_ICT_PGA_OUT_RBB(r) (((r) >> 10 ) & 0x1f)
#define GET_LMS7002_RBB_ICT_PGA_IN_RBB(r) (((r) >> 5 ) & 0x1f)
#define GET_LMS7002_RBB_G_PGA_RBB(r) (((r) >> 0 ) & 0x1f)

enum lms7002m_reg_0x011A {
    LMS7002_RBB_RCC_CTL_PGA_RBB_OFF = 9,
    LMS7002_RBB_RCC_CTL_PGA_RBB_MSK = 0x1f,
    LMS7002_RBB_C_CTL_PGA_RBB_OFF = 0,
    LMS7002_RBB_C_CTL_PGA_RBB_MSK = 0xff,
};
#define MAKE_LMS7002_0x011A( RCC_CTL_PGA_RBB, C_CTL_PGA_RBB ) ( \
    (((RCC_CTL_PGA_RBB) & 0x1f) << 9) | \
    (((C_CTL_PGA_RBB) & 0xff) << 0) | \
    (0x011A0000 | 0x80000000))
#define GET_LMS7002_RBB_RCC_CTL_PGA_RBB(r) (((r) >> 9 ) & 0x1f)
#define GET_LMS7002_RBB_C_CTL_PGA_RBB(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x011B {
    LMS7002_RBB_RESRV_RBB_OFF = 0,
    LMS7002_RBB_RESRV_RBB_MSK = 0x7f,
};
#define MAKE_LMS7002_0x011B( RESRV_RBB ) ( \
    (((RESRV_RBB) & 0x7f) << 0) | \
    (0x011B0000 | 0x80000000))
#define GET_LMS7002_RBB_RESRV_RBB(r) (((r) >> 0 ) & 0x7f)



/*************************************
 * RFE configuration registers
 *************************************/
enum lms7002m_reg_0x010C {
    LMS7002_RFE_CDC_I_RFE_OFF = 12,
    LMS7002_RFE_CDC_I_RFE_MSK = 0xf,
    LMS7002_RFE_CDC_Q_RFE_OFF = 8,
    LMS7002_RFE_CDC_Q_RFE_MSK = 0xf,
    LMS7002_RFE_PD_LNA_RFE_OFF = 7,
    LMS7002_RFE_PD_RLOOPB_1_RFE_OFF = 6,
    LMS7002_RFE_PD_RLOOPB_2_RFE_OFF = 5,
    LMS7002_RFE_PD_MXLOBUF_RFE_OFF = 4,
    LMS7002_RFE_PD_QGEN_RFE_OFF = 3,
    LMS7002_RFE_PD_RSSI_RFE_OFF = 2,
    LMS7002_RFE_PD_TIA_RFE_OFF = 1,
    LMS7002_RFE_EN_G_RFE_OFF = 0,
};
#define MAKE_LMS7002_0x010C( CDC_I_RFE, CDC_Q_RFE, PD_LNA_RFE, PD_RLOOPB_1_RFE, PD_RLOOPB_2_RFE, PD_MXLOBUF_RFE, PD_QGEN_RFE, PD_RSSI_RFE, PD_TIA_RFE, EN_G_RFE ) ( \
    (((CDC_I_RFE) & 0xf) << 12) | \
    (((CDC_Q_RFE) & 0xf) << 8) | \
    (((PD_LNA_RFE) & 0x1) << 7) | \
    (((PD_RLOOPB_1_RFE) & 0x1) << 6) | \
    (((PD_RLOOPB_2_RFE) & 0x1) << 5) | \
    (((PD_MXLOBUF_RFE) & 0x1) << 4) | \
    (((PD_QGEN_RFE) & 0x1) << 3) | \
    (((PD_RSSI_RFE) & 0x1) << 2) | \
    (((PD_TIA_RFE) & 0x1) << 1) | \
    (((EN_G_RFE) & 0x1) << 0) | \
    (0x010C0000 | 0x80000000))
#define GET_LMS7002_RFE_CDC_I_RFE(r) (((r) >> 12 ) & 0xf)
#define GET_LMS7002_RFE_CDC_Q_RFE(r) (((r) >> 8 ) & 0xf)
#define GET_LMS7002_RFE_PD_LNA_RFE(r) (((r) >> 7 ) & 0x1)
#define GET_LMS7002_RFE_PD_RLOOPB_1_RFE(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_RFE_PD_RLOOPB_2_RFE(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_RFE_PD_MXLOBUF_RFE(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_RFE_PD_QGEN_RFE(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_RFE_PD_RSSI_RFE(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_RFE_PD_TIA_RFE(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_RFE_EN_G_RFE(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x010D {
    LMS7002_RFE_SEL_PATH_RFE_OFF = 7,
    LMS7002_RFE_SEL_PATH_RFE_MSK = 0x3,
    LMS7002_RFE_EN_DCOFF_RXFE_RFE_OFF = 6,
    LMS7002_RFE_EN_INSHSW_LB1_RFE_OFF = 4,
    LMS7002_RFE_EN_INSHSW_LB2_RFE_OFF = 3,
    LMS7002_RFE_EN_INSHSW_L_RFE_OFF = 2,
    LMS7002_RFE_EN_INSHSW_W_RFE_OFF = 1,
    LMS7002_RFE_EN_NEXTRX_RFE_OFF = 0,
};
#define MAKE_LMS7002_0x010D( SEL_PATH_RFE, EN_DCOFF_RXFE_RFE, EN_INSHSW_LB1_RFE, EN_INSHSW_LB2_RFE, EN_INSHSW_L_RFE, EN_INSHSW_W_RFE, EN_NEXTRX_RFE ) ( \
    (((SEL_PATH_RFE) & 0x3) << 7) | \
    (((EN_DCOFF_RXFE_RFE) & 0x1) << 6) | \
    (((EN_INSHSW_LB1_RFE) & 0x1) << 4) | \
    (((EN_INSHSW_LB2_RFE) & 0x1) << 3) | \
    (((EN_INSHSW_L_RFE) & 0x1) << 2) | \
    (((EN_INSHSW_W_RFE) & 0x1) << 1) | \
    (((EN_NEXTRX_RFE) & 0x1) << 0) | \
    (0x010D0000 | 0x80000000))
#define GET_LMS7002_RFE_SEL_PATH_RFE(r) (((r) >> 7 ) & 0x3)
#define GET_LMS7002_RFE_EN_DCOFF_RXFE_RFE(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_RFE_EN_INSHSW_LB1_RFE(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_RFE_EN_INSHSW_LB2_RFE(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_RFE_EN_INSHSW_L_RFE(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_RFE_EN_INSHSW_W_RFE(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_RFE_EN_NEXTRX_RFE(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x010E {
    LMS7002_RFE_DCOFFI_RFE_OFF = 7,
    LMS7002_RFE_DCOFFI_RFE_MSK = 0x7f,
    LMS7002_RFE_DCOFFQ_RFE_OFF = 0,
    LMS7002_RFE_DCOFFQ_RFE_MSK = 0x7f,
};
#define MAKE_LMS7002_0x010E( DCOFFI_RFE, DCOFFQ_RFE ) ( \
    (((DCOFFI_RFE) & 0x7f) << 7) | \
    (((DCOFFQ_RFE) & 0x7f) << 0) | \
    (0x010E0000 | 0x80000000))
#define GET_LMS7002_RFE_DCOFFI_RFE(r) (((r) >> 7 ) & 0x7f)
#define GET_LMS7002_RFE_DCOFFQ_RFE(r) (((r) >> 0 ) & 0x7f)

enum lms7002m_reg_0x010F {
    LMS7002_RFE_ICT_LOOPB_RFE_OFF = 10,
    LMS7002_RFE_ICT_LOOPB_RFE_MSK = 0x1f,
    LMS7002_RFE_ICT_TIAMAIN_RFE_OFF = 5,
    LMS7002_RFE_ICT_TIAMAIN_RFE_MSK = 0x1f,
    LMS7002_RFE_ICT_TIAOUT_RFE_OFF = 0,
    LMS7002_RFE_ICT_TIAOUT_RFE_MSK = 0x1f,
};
#define MAKE_LMS7002_0x010F( ICT_LOOPB_RFE, ICT_TIAMAIN_RFE, ICT_TIAOUT_RFE ) ( \
    (((ICT_LOOPB_RFE) & 0x1f) << 10) | \
    (((ICT_TIAMAIN_RFE) & 0x1f) << 5) | \
    (((ICT_TIAOUT_RFE) & 0x1f) << 0) | \
    (0x010F0000 | 0x80000000))
#define GET_LMS7002_RFE_ICT_LOOPB_RFE(r) (((r) >> 10 ) & 0x1f)
#define GET_LMS7002_RFE_ICT_TIAMAIN_RFE(r) (((r) >> 5 ) & 0x1f)
#define GET_LMS7002_RFE_ICT_TIAOUT_RFE(r) (((r) >> 0 ) & 0x1f)

enum lms7002m_reg_0x0110 {
    LMS7002_RFE_ICT_LNACMO_RFE_OFF = 10,
    LMS7002_RFE_ICT_LNACMO_RFE_MSK = 0x1f,
    LMS7002_RFE_ICT_LNA_RFE_OFF = 5,
    LMS7002_RFE_ICT_LNA_RFE_MSK = 0x1f,
    LMS7002_RFE_ICT_LODC_RFE_OFF = 0,
    LMS7002_RFE_ICT_LODC_RFE_MSK = 0x1f,
};
#define MAKE_LMS7002_0x0110( ICT_LNACMO_RFE, ICT_LNA_RFE, ICT_LODC_RFE ) ( \
    (((ICT_LNACMO_RFE) & 0x1f) << 10) | \
    (((ICT_LNA_RFE) & 0x1f) << 5) | \
    (((ICT_LODC_RFE) & 0x1f) << 0) | \
    (0x01100000 | 0x80000000))
#define GET_LMS7002_RFE_ICT_LNACMO_RFE(r) (((r) >> 10 ) & 0x1f)
#define GET_LMS7002_RFE_ICT_LNA_RFE(r) (((r) >> 5 ) & 0x1f)
#define GET_LMS7002_RFE_ICT_LODC_RFE(r) (((r) >> 0 ) & 0x1f)

enum lms7002m_reg_0x0111 {
    LMS7002_RFE_CAP_RXMXO_RFE_OFF = 5,
    LMS7002_RFE_CAP_RXMXO_RFE_MSK = 0x1f,
    LMS7002_RFE_CGSIN_LNA_RFE_OFF = 0,
    LMS7002_RFE_CGSIN_LNA_RFE_MSK = 0x1f,
};
#define MAKE_LMS7002_0x0111( CAP_RXMXO_RFE, CGSIN_LNA_RFE ) ( \
    (((CAP_RXMXO_RFE) & 0x1f) << 5) | \
    (((CGSIN_LNA_RFE) & 0x1f) << 0) | \
    (0x01110000 | 0x80000000))
#define GET_LMS7002_RFE_CAP_RXMXO_RFE(r) (((r) >> 5 ) & 0x1f)
#define GET_LMS7002_RFE_CGSIN_LNA_RFE(r) (((r) >> 0 ) & 0x1f)

enum lms7002m_reg_0x0112 {
    LMS7002_RFE_CCOMP_TIA_RFE_OFF = 12,
    LMS7002_RFE_CCOMP_TIA_RFE_MSK = 0xf,
    LMS7002_RFE_CFB_TIA_RFE_OFF = 0,
    LMS7002_RFE_CFB_TIA_RFE_MSK = 0xfff,
};
#define MAKE_LMS7002_0x0112( CCOMP_TIA_RFE, CFB_TIA_RFE ) ( \
    (((CCOMP_TIA_RFE) & 0xf) << 12) | \
    (((CFB_TIA_RFE) & 0xfff) << 0) | \
    (0x01120000 | 0x80000000))
#define GET_LMS7002_RFE_CCOMP_TIA_RFE(r) (((r) >> 12 ) & 0xf)
#define GET_LMS7002_RFE_CFB_TIA_RFE(r) (((r) >> 0 ) & 0xfff)

enum lms7002m_reg_0x0113 {
    LMS7002_RFE_G_LNA_RFE_OFF = 6,
    LMS7002_RFE_G_LNA_RFE_MSK = 0xf,
    LMS7002_RFE_G_RXLOOPB_RFE_OFF = 2,
    LMS7002_RFE_G_RXLOOPB_RFE_MSK = 0xf,
    LMS7002_RFE_G_TIA_RFE_OFF = 0,
    LMS7002_RFE_G_TIA_RFE_MSK = 0x3,
};
#define MAKE_LMS7002_0x0113( G_LNA_RFE, G_RXLOOPB_RFE, G_TIA_RFE ) ( \
    (((G_LNA_RFE) & 0xf) << 6) | \
    (((G_RXLOOPB_RFE) & 0xf) << 2) | \
    (((G_TIA_RFE) & 0x3) << 0) | \
    (0x01130000 | 0x80000000))
#define GET_LMS7002_RFE_G_LNA_RFE(r) (((r) >> 6 ) & 0xf)
#define GET_LMS7002_RFE_G_RXLOOPB_RFE(r) (((r) >> 2 ) & 0xf)
#define GET_LMS7002_RFE_G_TIA_RFE(r) (((r) >> 0 ) & 0x3)

enum lms7002m_reg_0x0114 {
    LMS7002_RFE_RCOMP_TIA_RFE_OFF = 5,
    LMS7002_RFE_RCOMP_TIA_RFE_MSK = 0xf,
    LMS7002_RFE_RFB_TIA_RFE_OFF = 0,
    LMS7002_RFE_RFB_TIA_RFE_MSK = 0x1f,
};
#define MAKE_LMS7002_0x0114( RCOMP_TIA_RFE, RFB_TIA_RFE ) ( \
    (((RCOMP_TIA_RFE) & 0xf) << 5) | \
    (((RFB_TIA_RFE) & 0x1f) << 0) | \
    (0x01140000 | 0x80000000))
#define GET_LMS7002_RFE_RCOMP_TIA_RFE(r) (((r) >> 5 ) & 0xf)
#define GET_LMS7002_RFE_RFB_TIA_RFE(r) (((r) >> 0 ) & 0x1f)



/*************************************
 * RXNCO configuration registers
 *************************************/
enum lms7002m_reg_0x0440 {
    LMS7002_RXNCO_DTHBIT_OFF = 5,
    LMS7002_RXNCO_DTHBIT_MSK = 0xf,
    LMS7002_RXNCO_SEL_OFF = 1,
    LMS7002_RXNCO_SEL_MSK = 0xf,
    LMS7002_RXNCO_MODE_OFF = 0,
};
#define MAKE_LMS7002_0x0440( DTHBIT, SEL, MODE ) ( \
    (((DTHBIT) & 0xf) << 5) | \
    (((SEL) & 0xf) << 1) | \
    (((MODE) & 0x1) << 0) | \
    (0x04400000 | 0x80000000))
#define GET_LMS7002_RXNCO_DTHBIT(r) (((r) >> 5 ) & 0xf)
#define GET_LMS7002_RXNCO_SEL(r) (((r) >> 1 ) & 0xf)
#define GET_LMS7002_RXNCO_MODE(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x0441 {
    LMS7002_RXNCO_PHO_OFF = 0,
    LMS7002_RXNCO_PHO_MSK = 0xffff,
};
#define MAKE_LMS7002_0x0441( PHO ) ( \
    (((PHO) & 0xffff) << 0) | \
    (0x04410000 | 0x80000000))
#define GET_LMS7002_RXNCO_PHO(r) (((r) >> 0 ) & 0xffff)

enum lms7002m_reg_0x0442 {
    LMS7002_RXNCO_FCW0_HI_OFF = 0,
    LMS7002_RXNCO_FCW0_HI_MSK = 0xffff,
};
#define MAKE_LMS7002_0x0442( FCW0_HI ) ( \
    (((FCW0_HI) & 0xffff) << 0) | \
    (0x04420000 | 0x80000000))
#define GET_LMS7002_RXNCO_FCW0_HI(r) (((r) >> 0 ) & 0xffff)

enum lms7002m_reg_0x0443 {
    LMS7002_RXNCO_FCW0_LO_OFF = 0,
    LMS7002_RXNCO_FCW0_LO_MSK = 0xffff,
};
#define MAKE_LMS7002_0x0443( FCW0_LO ) ( \
    (((FCW0_LO) & 0xffff) << 0) | \
    (0x04430000 | 0x80000000))
#define GET_LMS7002_RXNCO_FCW0_LO(r) (((r) >> 0 ) & 0xffff)



/*************************************
 * RXTSP configuration registers
 *************************************/
enum lms7002m_reg_0x0400 {
    LMS7002_RXTSP_CAPTURE_OFF = 15,
    LMS7002_RXTSP_CAPSEL_OFF = 13,
    LMS7002_RXTSP_CAPSEL_MSK = 0x3,
    LMS7002_RXTSP_CAPSEL_ADC_OFF = 12,
    LMS7002_RXTSP_TSGFC_OFF = 9,
    LMS7002_RXTSP_TSGFCW_OFF = 7,
    LMS7002_RXTSP_TSGFCW_MSK = 0x3,
    LMS7002_RXTSP_TSGDCLDQ_OFF = 6,
    LMS7002_RXTSP_TSGDCLDI_OFF = 5,
    LMS7002_RXTSP_TSGSWAPIQ_OFF = 4,
    LMS7002_RXTSP_TSGMODE_OFF = 3,
    LMS7002_RXTSP_INSEL_OFF = 2,
    LMS7002_RXTSP_BSTART_OFF = 1,
    LMS7002_RXTSP_EN_OFF = 0,
};
#define MAKE_LMS7002_0x0400( CAPTURE, CAPSEL, CAPSEL_ADC, TSGFC, TSGFCW, TSGDCLDQ, TSGDCLDI, TSGSWAPIQ, TSGMODE, INSEL, BSTART, EN ) ( \
    (((CAPTURE) & 0x1) << 15) | \
    (((CAPSEL) & 0x3) << 13) | \
    (((CAPSEL_ADC) & 0x1) << 12) | \
    (((TSGFC) & 0x1) << 9) | \
    (((TSGFCW) & 0x3) << 7) | \
    (((TSGDCLDQ) & 0x1) << 6) | \
    (((TSGDCLDI) & 0x1) << 5) | \
    (((TSGSWAPIQ) & 0x1) << 4) | \
    (((TSGMODE) & 0x1) << 3) | \
    (((INSEL) & 0x1) << 2) | \
    (((BSTART) & 0x1) << 1) | \
    (((EN) & 0x1) << 0) | \
    (0x04000000 | 0x80000000))
#define GET_LMS7002_RXTSP_CAPTURE(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_RXTSP_CAPSEL(r) (((r) >> 13 ) & 0x3)
#define GET_LMS7002_RXTSP_CAPSEL_ADC(r) (((r) >> 12 ) & 0x1)
#define GET_LMS7002_RXTSP_TSGFC(r) (((r) >> 9 ) & 0x1)
#define GET_LMS7002_RXTSP_TSGFCW(r) (((r) >> 7 ) & 0x3)
#define GET_LMS7002_RXTSP_TSGDCLDQ(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_RXTSP_TSGDCLDI(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_RXTSP_TSGSWAPIQ(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_RXTSP_TSGMODE(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_RXTSP_INSEL(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_RXTSP_BSTART(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_RXTSP_EN(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x0401 {
    LMS7002_RXTSP_GCORRQ_OFF = 0,
    LMS7002_RXTSP_GCORRQ_MSK = 0x7ff,
};
#define MAKE_LMS7002_0x0401( GCORRQ ) ( \
    (((GCORRQ) & 0x7ff) << 0) | \
    (0x04010000 | 0x80000000))
#define GET_LMS7002_RXTSP_GCORRQ(r) (((r) >> 0 ) & 0x7ff)

enum lms7002m_reg_0x0402 {
    LMS7002_RXTSP_GCORRI_OFF = 0,
    LMS7002_RXTSP_GCORRI_MSK = 0x7ff,
};
#define MAKE_LMS7002_0x0402( GCORRI ) ( \
    (((GCORRI) & 0x7ff) << 0) | \
    (0x04020000 | 0x80000000))
#define GET_LMS7002_RXTSP_GCORRI(r) (((r) >> 0 ) & 0x7ff)

enum lms7002m_reg_0x0403 {
    LMS7002_RXTSP_HBD_OVR_OFF = 12,
    LMS7002_RXTSP_HBD_OVR_MSK = 0x7,
    LMS7002_RXTSP_IQCORR_OFF = 0,
    LMS7002_RXTSP_IQCORR_MSK = 0xfff,
};
#define MAKE_LMS7002_0x0403( HBD_OVR, IQCORR ) ( \
    (((HBD_OVR) & 0x7) << 12) | \
    (((IQCORR) & 0xfff) << 0) | \
    (0x04030000 | 0x80000000))
#define GET_LMS7002_RXTSP_HBD_OVR(r) (((r) >> 12 ) & 0x7)
#define GET_LMS7002_RXTSP_IQCORR(r) (((r) >> 0 ) & 0xfff)

enum lms7002m_reg_0x0404 {
    LMS7002_RXTSP_HBD_DLY_OFF = 13,
    LMS7002_RXTSP_HBD_DLY_MSK = 0x7,
    LMS7002_RXTSP_DCCORR_AVG_OFF = 0,
    LMS7002_RXTSP_DCCORR_AVG_MSK = 0x7,
};
#define MAKE_LMS7002_0x0404( HBD_DLY, DCCORR_AVG ) ( \
    (((HBD_DLY) & 0x7) << 13) | \
    (((DCCORR_AVG) & 0x7) << 0) | \
    (0x04040000 | 0x80000000))
#define GET_LMS7002_RXTSP_HBD_DLY(r) (((r) >> 13 ) & 0x7)
#define GET_LMS7002_RXTSP_DCCORR_AVG(r) (((r) >> 0 ) & 0x7)

enum lms7002m_reg_0x0405 {
    LMS7002_RXTSP_GFIR1_L_OFF = 8,
    LMS7002_RXTSP_GFIR1_L_MSK = 0x7,
    LMS7002_RXTSP_GFIR1_N_OFF = 0,
    LMS7002_RXTSP_GFIR1_N_MSK = 0xff,
};
#define MAKE_LMS7002_0x0405( GFIR1_L, GFIR1_N ) ( \
    (((GFIR1_L) & 0x7) << 8) | \
    (((GFIR1_N) & 0xff) << 0) | \
    (0x04050000 | 0x80000000))
#define GET_LMS7002_RXTSP_GFIR1_L(r) (((r) >> 8 ) & 0x7)
#define GET_LMS7002_RXTSP_GFIR1_N(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x0406 {
    LMS7002_RXTSP_GFIR2_L_OFF = 8,
    LMS7002_RXTSP_GFIR2_L_MSK = 0x7,
    LMS7002_RXTSP_GFIR2_N_OFF = 0,
    LMS7002_RXTSP_GFIR2_N_MSK = 0xff,
};
#define MAKE_LMS7002_0x0406( GFIR2_L, GFIR2_N ) ( \
    (((GFIR2_L) & 0x7) << 8) | \
    (((GFIR2_N) & 0xff) << 0) | \
    (0x04060000 | 0x80000000))
#define GET_LMS7002_RXTSP_GFIR2_L(r) (((r) >> 8 ) & 0x7)
#define GET_LMS7002_RXTSP_GFIR2_N(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x0407 {
    LMS7002_RXTSP_GFIR3_L_OFF = 8,
    LMS7002_RXTSP_GFIR3_L_MSK = 0x7,
    LMS7002_RXTSP_GFIR3_N_OFF = 0,
    LMS7002_RXTSP_GFIR3_N_MSK = 0xff,
};
#define MAKE_LMS7002_0x0407( GFIR3_L, GFIR3_N ) ( \
    (((GFIR3_L) & 0x7) << 8) | \
    (((GFIR3_N) & 0xff) << 0) | \
    (0x04070000 | 0x80000000))
#define GET_LMS7002_RXTSP_GFIR3_L(r) (((r) >> 8 ) & 0x7)
#define GET_LMS7002_RXTSP_GFIR3_N(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x0408 {
    LMS7002_RXTSP_AGC_K_LSB_OFF = 0,
    LMS7002_RXTSP_AGC_K_LSB_MSK = 0xffff,
};
#define MAKE_LMS7002_0x0408( AGC_K_LSB ) ( \
    (((AGC_K_LSB) & 0xffff) << 0) | \
    (0x04080000 | 0x80000000))
#define GET_LMS7002_RXTSP_AGC_K_LSB(r) (((r) >> 0 ) & 0xffff)

enum lms7002m_reg_0x0409 {
    LMS7002_RXTSP_AGC_ADESIRED_OFF = 4,
    LMS7002_RXTSP_AGC_ADESIRED_MSK = 0xfff,
    LMS7002_RXTSP_AGC_K_MSB_OFF = 0,
    LMS7002_RXTSP_AGC_K_MSB_MSK = 0x3,
};
#define MAKE_LMS7002_0x0409( AGC_ADESIRED, AGC_K_MSB ) ( \
    (((AGC_ADESIRED) & 0xfff) << 4) | \
    (((AGC_K_MSB) & 0x3) << 0) | \
    (0x04090000 | 0x80000000))
#define GET_LMS7002_RXTSP_AGC_ADESIRED(r) (((r) >> 4 ) & 0xfff)
#define GET_LMS7002_RXTSP_AGC_K_MSB(r) (((r) >> 0 ) & 0x3)

enum lms7002m_reg_0x040A {
    LMS7002_RXTSP_RSSI_MODE_OFF = 14,
    LMS7002_RXTSP_RSSI_MODE_MSK = 0x3,
    LMS7002_RXTSP_AGC_MODE_OFF = 12,
    LMS7002_RXTSP_AGC_MODE_MSK = 0x3,
    LMS7002_RXTSP_AGC_AVG_OFF = 0,
    LMS7002_RXTSP_AGC_AVG_MSK = 0x7,
};
#define MAKE_LMS7002_0x040A( RSSI_MODE, AGC_MODE, AGC_AVG ) ( \
    (((RSSI_MODE) & 0x3) << 14) | \
    (((AGC_MODE) & 0x3) << 12) | \
    (((AGC_AVG) & 0x7) << 0) | \
    (0x040A0000 | 0x80000000))
#define GET_LMS7002_RXTSP_RSSI_MODE(r) (((r) >> 14 ) & 0x3)
#define GET_LMS7002_RXTSP_AGC_MODE(r) (((r) >> 12 ) & 0x3)
#define GET_LMS7002_RXTSP_AGC_AVG(r) (((r) >> 0 ) & 0x7)

enum lms7002m_reg_0x040B {
    LMS7002_RXTSP_DC_REG_OFF = 0,
    LMS7002_RXTSP_DC_REG_MSK = 0xffff,
};
#define MAKE_LMS7002_0x040B( DC_REG ) ( \
    (((DC_REG) & 0xffff) << 0) | \
    (0x040B0000 | 0x80000000))
#define GET_LMS7002_RXTSP_DC_REG(r) (((r) >> 0 ) & 0xffff)

enum lms7002m_reg_0x040C {
    LMS7002_RXTSP_CMIX_GAIN_OFF = 14,
    LMS7002_RXTSP_CMIX_GAIN_MSK = 0x3,
    LMS7002_RXTSP_CMIX_SC_OFF = 13,
    LMS7002_RXTSP_CMIX_GAINM_OFF = 12,
    LMS7002_RXTSP_DCLOOP_STOP_OFF = 8,
    LMS7002_RXTSP_CMIX_BYP_OFF = 7,
    LMS7002_RXTSP_AGC_BYP_OFF = 6,
    LMS7002_RXTSP_GFIR3_BYP_OFF = 5,
    LMS7002_RXTSP_GFIR2_BYP_OFF = 4,
    LMS7002_RXTSP_GFIR1_BYP_OFF = 3,
    LMS7002_RXTSP_DC_BYP_OFF = 2,
    LMS7002_RXTSP_GC_BYP_OFF = 1,
    LMS7002_RXTSP_PH_BYP_OFF = 0,
};
#define MAKE_LMS7002_0x040C( CMIX_GAIN, CMIX_SC, CMIX_GAINM, DCLOOP_STOP, CMIX_BYP, AGC_BYP, GFIR3_BYP, GFIR2_BYP, GFIR1_BYP, DC_BYP, GC_BYP, PH_BYP ) ( \
    (((CMIX_GAIN) & 0x3) << 14) | \
    (((CMIX_SC) & 0x1) << 13) | \
    (((CMIX_GAINM) & 0x1) << 12) | \
    (((DCLOOP_STOP) & 0x1) << 8) | \
    (((CMIX_BYP) & 0x1) << 7) | \
    (((AGC_BYP) & 0x1) << 6) | \
    (((GFIR3_BYP) & 0x1) << 5) | \
    (((GFIR2_BYP) & 0x1) << 4) | \
    (((GFIR1_BYP) & 0x1) << 3) | \
    (((DC_BYP) & 0x1) << 2) | \
    (((GC_BYP) & 0x1) << 1) | \
    (((PH_BYP) & 0x1) << 0) | \
    (0x040C0000 | 0x80000000))
#define GET_LMS7002_RXTSP_CMIX_GAIN(r) (((r) >> 14 ) & 0x3)
#define GET_LMS7002_RXTSP_CMIX_SC(r) (((r) >> 13 ) & 0x1)
#define GET_LMS7002_RXTSP_CMIX_GAINM(r) (((r) >> 12 ) & 0x1)
#define GET_LMS7002_RXTSP_DCLOOP_STOP(r) (((r) >> 8 ) & 0x1)
#define GET_LMS7002_RXTSP_CMIX_BYP(r) (((r) >> 7 ) & 0x1)
#define GET_LMS7002_RXTSP_AGC_BYP(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_RXTSP_GFIR3_BYP(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_RXTSP_GFIR2_BYP(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_RXTSP_GFIR1_BYP(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_RXTSP_DC_BYP(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_RXTSP_GC_BYP(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_RXTSP_PH_BYP(r) (((r) >> 0 ) & 0x1)



/*************************************
 * SXX configuration registers
 *************************************/
enum lms7002m_reg_0x011C {
    LMS7002_SXX_RESET_N_OFF = 15,
    LMS7002_SXX_SPDUP_VCO_OFF = 14,
    LMS7002_SXX_BYPLDO_VCO_OFF = 13,
    LMS7002_SXX_EN_COARSEPLL_OFF = 12,
    LMS7002_SXX_CURLIM_VCO_OFF = 11,
    LMS7002_SXX_EN_DIV2_DIVPROG_OFF = 10,
    LMS7002_SXX_EN_INTONLY_SDM_OFF = 9,
    LMS7002_SXX_EN_SDM_CLK_OFF = 8,
    LMS7002_SXX_PD_FBDIV_OFF = 7,
    LMS7002_SXX_PD_LOCH_T2RBUF_OFF = 6,
    LMS7002_SXX_PD_CP_OFF = 5,
    LMS7002_SXX_PD_FDIV_OFF = 4,
    LMS7002_SXX_PD_SDM_OFF = 3,
    LMS7002_SXX_PD_VCO_COMP_OFF = 2,
    LMS7002_SXX_PD_VCO_OFF = 1,
    LMS7002_SXX_EN_G_OFF = 0,
};
#define MAKE_LMS7002_0x011C( RESET_N, SPDUP_VCO, BYPLDO_VCO, EN_COARSEPLL, CURLIM_VCO, EN_DIV2_DIVPROG, EN_INTONLY_SDM, EN_SDM_CLK, PD_FBDIV, PD_LOCH_T2RBUF, PD_CP, PD_FDIV, PD_SDM, PD_VCO_COMP, PD_VCO, EN_G ) ( \
    (((RESET_N) & 0x1) << 15) | \
    (((SPDUP_VCO) & 0x1) << 14) | \
    (((BYPLDO_VCO) & 0x1) << 13) | \
    (((EN_COARSEPLL) & 0x1) << 12) | \
    (((CURLIM_VCO) & 0x1) << 11) | \
    (((EN_DIV2_DIVPROG) & 0x1) << 10) | \
    (((EN_INTONLY_SDM) & 0x1) << 9) | \
    (((EN_SDM_CLK) & 0x1) << 8) | \
    (((PD_FBDIV) & 0x1) << 7) | \
    (((PD_LOCH_T2RBUF) & 0x1) << 6) | \
    (((PD_CP) & 0x1) << 5) | \
    (((PD_FDIV) & 0x1) << 4) | \
    (((PD_SDM) & 0x1) << 3) | \
    (((PD_VCO_COMP) & 0x1) << 2) | \
    (((PD_VCO) & 0x1) << 1) | \
    (((EN_G) & 0x1) << 0) | \
    (0x011C0000 | 0x80000000))
#define GET_LMS7002_SXX_RESET_N(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_SXX_SPDUP_VCO(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_SXX_BYPLDO_VCO(r) (((r) >> 13 ) & 0x1)
#define GET_LMS7002_SXX_EN_COARSEPLL(r) (((r) >> 12 ) & 0x1)
#define GET_LMS7002_SXX_CURLIM_VCO(r) (((r) >> 11 ) & 0x1)
#define GET_LMS7002_SXX_EN_DIV2_DIVPROG(r) (((r) >> 10 ) & 0x1)
#define GET_LMS7002_SXX_EN_INTONLY_SDM(r) (((r) >> 9 ) & 0x1)
#define GET_LMS7002_SXX_EN_SDM_CLK(r) (((r) >> 8 ) & 0x1)
#define GET_LMS7002_SXX_PD_FBDIV(r) (((r) >> 7 ) & 0x1)
#define GET_LMS7002_SXX_PD_LOCH_T2RBUF(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_SXX_PD_CP(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_SXX_PD_FDIV(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_SXX_PD_SDM(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_SXX_PD_VCO_COMP(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_SXX_PD_VCO(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_SXX_EN_G(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x011D {
    LMS7002_SXX_FRAC_SDM_LSB_OFF = 0,
    LMS7002_SXX_FRAC_SDM_LSB_MSK = 0xffff,
};
#define MAKE_LMS7002_0x011D( FRAC_SDM_LSB ) ( \
    (((FRAC_SDM_LSB) & 0xffff) << 0) | \
    (0x011D0000 | 0x80000000))
#define GET_LMS7002_SXX_FRAC_SDM_LSB(r) (((r) >> 0 ) & 0xffff)

enum lms7002m_reg_0x011E {
    LMS7002_SXX_INT_SDM_OFF = 4,
    LMS7002_SXX_INT_SDM_MSK = 0x3ff,
    LMS7002_SXX_FRAC_SDM_MSB_OFF = 0,
    LMS7002_SXX_FRAC_SDM_MSB_MSK = 0xf,
};
#define MAKE_LMS7002_0x011E( INT_SDM, FRAC_SDM_MSB ) ( \
    (((INT_SDM) & 0x3ff) << 4) | \
    (((FRAC_SDM_MSB) & 0xf) << 0) | \
    (0x011E0000 | 0x80000000))
#define GET_LMS7002_SXX_INT_SDM(r) (((r) >> 4 ) & 0x3ff)
#define GET_LMS7002_SXX_FRAC_SDM_MSB(r) (((r) >> 0 ) & 0xf)

enum lms7002m_reg_0x011F {
    LMS7002_SXX_PW_DIV2_LOCH_OFF = 12,
    LMS7002_SXX_PW_DIV2_LOCH_MSK = 0x7,
    LMS7002_SXX_PW_DIV4_LOCH_OFF = 9,
    LMS7002_SXX_PW_DIV4_LOCH_MSK = 0x7,
    LMS7002_SXX_DIV_LOCH_OFF = 6,
    LMS7002_SXX_DIV_LOCH_MSK = 0x7,
    LMS7002_SXX_TST_SX_OFF = 3,
    LMS7002_SXX_TST_SX_MSK = 0x7,
    LMS7002_SXX_SEL_SDMCLK_OFF = 2,
    LMS7002_SXX_SX_DITHER_EN_OFF = 1,
    LMS7002_SXX_REV_SDMCLK_OFF = 0,
};
#define MAKE_LMS7002_0x011F( PW_DIV2_LOCH, PW_DIV4_LOCH, DIV_LOCH, TST_SX, SEL_SDMCLK, SX_DITHER_EN, REV_SDMCLK ) ( \
    (((PW_DIV2_LOCH) & 0x7) << 12) | \
    (((PW_DIV4_LOCH) & 0x7) << 9) | \
    (((DIV_LOCH) & 0x7) << 6) | \
    (((TST_SX) & 0x7) << 3) | \
    (((SEL_SDMCLK) & 0x1) << 2) | \
    (((SX_DITHER_EN) & 0x1) << 1) | \
    (((REV_SDMCLK) & 0x1) << 0) | \
    (0x011F0000 | 0x80000000))
#define GET_LMS7002_SXX_PW_DIV2_LOCH(r) (((r) >> 12 ) & 0x7)
#define GET_LMS7002_SXX_PW_DIV4_LOCH(r) (((r) >> 9 ) & 0x7)
#define GET_LMS7002_SXX_DIV_LOCH(r) (((r) >> 6 ) & 0x7)
#define GET_LMS7002_SXX_TST_SX(r) (((r) >> 3 ) & 0x7)
#define GET_LMS7002_SXX_SEL_SDMCLK(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_SXX_SX_DITHER_EN(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_SXX_REV_SDMCLK(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x0120 {
    LMS7002_SXX_VDIV_VCO_OFF = 8,
    LMS7002_SXX_VDIV_VCO_MSK = 0xff,
    LMS7002_SXX_ICT_VCO_OFF = 0,
    LMS7002_SXX_ICT_VCO_MSK = 0xff,
};
#define MAKE_LMS7002_0x0120( VDIV_VCO, ICT_VCO ) ( \
    (((VDIV_VCO) & 0xff) << 8) | \
    (((ICT_VCO) & 0xff) << 0) | \
    (0x01200000 | 0x80000000))
#define GET_LMS7002_SXX_VDIV_VCO(r) (((r) >> 8 ) & 0xff)
#define GET_LMS7002_SXX_ICT_VCO(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x0121 {
    LMS7002_SXX_RSEL_LDO_VCO_OFF = 11,
    LMS7002_SXX_RSEL_LDO_VCO_MSK = 0x1f,
    LMS7002_SXX_CSW_VCO_OFF = 3,
    LMS7002_SXX_CSW_VCO_MSK = 0xff,
    LMS7002_SXX_SEL_VCO_OFF = 1,
    LMS7002_SXX_SEL_VCO_MSK = 0x3,
    LMS7002_SXX_COARSE_START_OFF = 0,
};
#define MAKE_LMS7002_0x0121( RSEL_LDO_VCO, CSW_VCO, SEL_VCO, COARSE_START ) ( \
    (((RSEL_LDO_VCO) & 0x1f) << 11) | \
    (((CSW_VCO) & 0xff) << 3) | \
    (((SEL_VCO) & 0x3) << 1) | \
    (((COARSE_START) & 0x1) << 0) | \
    (0x01210000 | 0x80000000))
#define GET_LMS7002_SXX_RSEL_LDO_VCO(r) (((r) >> 11 ) & 0x1f)
#define GET_LMS7002_SXX_CSW_VCO(r) (((r) >> 3 ) & 0xff)
#define GET_LMS7002_SXX_SEL_VCO(r) (((r) >> 1 ) & 0x3)
#define GET_LMS7002_SXX_COARSE_START(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x0122 {
    LMS7002_SXX_REVPH_PFD_OFF = 12,
    LMS7002_SXX_IOFFSET_CP_OFF = 6,
    LMS7002_SXX_IOFFSET_CP_MSK = 0x3f,
    LMS7002_SXX_IPULSE_CP_OFF = 0,
    LMS7002_SXX_IPULSE_CP_MSK = 0x3f,
};
#define MAKE_LMS7002_0x0122( REVPH_PFD, IOFFSET_CP, IPULSE_CP ) ( \
    (((REVPH_PFD) & 0x1) << 12) | \
    (((IOFFSET_CP) & 0x3f) << 6) | \
    (((IPULSE_CP) & 0x3f) << 0) | \
    (0x01220000 | 0x80000000))
#define GET_LMS7002_SXX_REVPH_PFD(r) (((r) >> 12 ) & 0x1)
#define GET_LMS7002_SXX_IOFFSET_CP(r) (((r) >> 6 ) & 0x3f)
#define GET_LMS7002_SXX_IPULSE_CP(r) (((r) >> 0 ) & 0x3f)

enum lms7002m_reg_0x0123 {
    LMS7002_SXX_COARSE_STEPDONE_OFF = 15,
    LMS7002_SXX_COARSEPLL_COMPO_OFF = 14,
    LMS7002_SXX_VCO_CMPHO_OFF = 13,
    LMS7002_SXX_VCO_CMPLO_OFF = 12,
    LMS7002_SXX_CP2_PLL_OFF = 8,
    LMS7002_SXX_CP2_PLL_MSK = 0xf,
    LMS7002_SXX_CP3_PLL_OFF = 4,
    LMS7002_SXX_CP3_PLL_MSK = 0xf,
    LMS7002_SXX_CZ_OFF = 0,
    LMS7002_SXX_CZ_MSK = 0xf,
};
#define MAKE_LMS7002_0x0123( COARSE_STEPDONE, COARSEPLL_COMPO, VCO_CMPHO, VCO_CMPLO, CP2_PLL, CP3_PLL, CZ ) ( \
    (((COARSE_STEPDONE) & 0x1) << 15) | \
    (((COARSEPLL_COMPO) & 0x1) << 14) | \
    (((VCO_CMPHO) & 0x1) << 13) | \
    (((VCO_CMPLO) & 0x1) << 12) | \
    (((CP2_PLL) & 0xf) << 8) | \
    (((CP3_PLL) & 0xf) << 4) | \
    (((CZ) & 0xf) << 0) | \
    (0x01230000 | 0x80000000))
#define GET_LMS7002_SXX_COARSE_STEPDONE(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_SXX_COARSEPLL_COMPO(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_SXX_VCO_CMPHO(r) (((r) >> 13 ) & 0x1)
#define GET_LMS7002_SXX_VCO_CMPLO(r) (((r) >> 12 ) & 0x1)
#define GET_LMS7002_SXX_CP2_PLL(r) (((r) >> 8 ) & 0xf)
#define GET_LMS7002_SXX_CP3_PLL(r) (((r) >> 4 ) & 0xf)
#define GET_LMS7002_SXX_CZ(r) (((r) >> 0 ) & 0xf)

enum lms7002m_reg_0x0124 {
    LMS7002_SXX_EN_DIR_SXX_OFF = 4,
    LMS7002_SXX_EN_DIR_RBB_OFF = 3,
    LMS7002_SXX_EN_DIR_RFE_OFF = 2,
    LMS7002_SXX_EN_DIR_TBB_OFF = 1,
    LMS7002_SXX_EN_DIR_TRF_OFF = 0,
};
#define MAKE_LMS7002_0x0124( EN_DIR_SXX, EN_DIR_RBB, EN_DIR_RFE, EN_DIR_TBB, EN_DIR_TRF ) ( \
    (((EN_DIR_SXX) & 0x1) << 4) | \
    (((EN_DIR_RBB) & 0x1) << 3) | \
    (((EN_DIR_RFE) & 0x1) << 2) | \
    (((EN_DIR_TBB) & 0x1) << 1) | \
    (((EN_DIR_TRF) & 0x1) << 0) | \
    (0x01240000 | 0x80000000))
#define GET_LMS7002_SXX_EN_DIR_SXX(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_SXX_EN_DIR_RBB(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_SXX_EN_DIR_RFE(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_SXX_EN_DIR_TBB(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_SXX_EN_DIR_TRF(r) (((r) >> 0 ) & 0x1)



/*************************************
 * TBB configuration registers
 *************************************/
enum lms7002m_reg_0x0105 {
    LMS7002_TBB_STATPULSE_TBB_OFF = 15,
    LMS7002_TBB_LOOPB_TBB_OFF = 12,
    LMS7002_TBB_LOOPB_TBB_MSK = 0x7,
    LMS7002_TBB_PD_LPFH_TBB_OFF = 4,
    LMS7002_TBB_PD_LPFIAMP_TBB_OFF = 3,
    LMS7002_TBB_PD_LPFLAD_TBB_OFF = 2,
    LMS7002_TBB_PD_LPFS5_TBB_OFF = 1,
    LMS7002_TBB_EN_G_TBB_OFF = 0,
};
#define MAKE_LMS7002_0x0105( STATPULSE_TBB, LOOPB_TBB, PD_LPFH_TBB, PD_LPFIAMP_TBB, PD_LPFLAD_TBB, PD_LPFS5_TBB, EN_G_TBB ) ( \
    (((STATPULSE_TBB) & 0x1) << 15) | \
    (((LOOPB_TBB) & 0x7) << 12) | \
    (((PD_LPFH_TBB) & 0x1) << 4) | \
    (((PD_LPFIAMP_TBB) & 0x1) << 3) | \
    (((PD_LPFLAD_TBB) & 0x1) << 2) | \
    (((PD_LPFS5_TBB) & 0x1) << 1) | \
    (((EN_G_TBB) & 0x1) << 0) | \
    (0x01050000 | 0x80000000))
#define GET_LMS7002_TBB_STATPULSE_TBB(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_TBB_LOOPB_TBB(r) (((r) >> 12 ) & 0x7)
#define GET_LMS7002_TBB_PD_LPFH_TBB(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_TBB_PD_LPFIAMP_TBB(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_TBB_PD_LPFLAD_TBB(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_TBB_PD_LPFS5_TBB(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_TBB_EN_G_TBB(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x0106 {
    LMS7002_TBB_ICT_LPFS5_F_TBB_OFF = 10,
    LMS7002_TBB_ICT_LPFS5_F_TBB_MSK = 0x1f,
    LMS7002_TBB_ICT_LPFS5_PT_TBB_OFF = 5,
    LMS7002_TBB_ICT_LPFS5_PT_TBB_MSK = 0x1f,
    LMS7002_TBB_ICT_LPF_H_PT_TBB_OFF = 0,
    LMS7002_TBB_ICT_LPF_H_PT_TBB_MSK = 0x1f,
};
#define MAKE_LMS7002_0x0106( ICT_LPFS5_F_TBB, ICT_LPFS5_PT_TBB, ICT_LPF_H_PT_TBB ) ( \
    (((ICT_LPFS5_F_TBB) & 0x1f) << 10) | \
    (((ICT_LPFS5_PT_TBB) & 0x1f) << 5) | \
    (((ICT_LPF_H_PT_TBB) & 0x1f) << 0) | \
    (0x01060000 | 0x80000000))
#define GET_LMS7002_TBB_ICT_LPFS5_F_TBB(r) (((r) >> 10 ) & 0x1f)
#define GET_LMS7002_TBB_ICT_LPFS5_PT_TBB(r) (((r) >> 5 ) & 0x1f)
#define GET_LMS7002_TBB_ICT_LPF_H_PT_TBB(r) (((r) >> 0 ) & 0x1f)

enum lms7002m_reg_0x0107 {
    LMS7002_TBB_ICT_LPFH_F_TBB_OFF = 10,
    LMS7002_TBB_ICT_LPFH_F_TBB_MSK = 0x1f,
    LMS7002_TBB_ICT_LPFLAD_F_TBB_OFF = 5,
    LMS7002_TBB_ICT_LPFLAD_F_TBB_MSK = 0x1f,
    LMS7002_TBB_ICT_LPFLAD_PT_TBB_OFF = 0,
    LMS7002_TBB_ICT_LPFLAD_PT_TBB_MSK = 0x1f,
};
#define MAKE_LMS7002_0x0107( ICT_LPFH_F_TBB, ICT_LPFLAD_F_TBB, ICT_LPFLAD_PT_TBB ) ( \
    (((ICT_LPFH_F_TBB) & 0x1f) << 10) | \
    (((ICT_LPFLAD_F_TBB) & 0x1f) << 5) | \
    (((ICT_LPFLAD_PT_TBB) & 0x1f) << 0) | \
    (0x01070000 | 0x80000000))
#define GET_LMS7002_TBB_ICT_LPFH_F_TBB(r) (((r) >> 10 ) & 0x1f)
#define GET_LMS7002_TBB_ICT_LPFLAD_F_TBB(r) (((r) >> 5 ) & 0x1f)
#define GET_LMS7002_TBB_ICT_LPFLAD_PT_TBB(r) (((r) >> 0 ) & 0x1f)

enum lms7002m_reg_0x0108 {
    LMS7002_TBB_CG_IAMP_TBB_OFF = 10,
    LMS7002_TBB_CG_IAMP_TBB_MSK = 0x3f,
    LMS7002_TBB_ICT_IAMP_FRP_TBB_OFF = 5,
    LMS7002_TBB_ICT_IAMP_FRP_TBB_MSK = 0x1f,
    LMS7002_TBB_ICT_IAMP_GG_FRP_TBB_OFF = 0,
    LMS7002_TBB_ICT_IAMP_GG_FRP_TBB_MSK = 0x1f,
};
#define MAKE_LMS7002_0x0108( CG_IAMP_TBB, ICT_IAMP_FRP_TBB, ICT_IAMP_GG_FRP_TBB ) ( \
    (((CG_IAMP_TBB) & 0x3f) << 10) | \
    (((ICT_IAMP_FRP_TBB) & 0x1f) << 5) | \
    (((ICT_IAMP_GG_FRP_TBB) & 0x1f) << 0) | \
    (0x01080000 | 0x80000000))
#define GET_LMS7002_TBB_CG_IAMP_TBB(r) (((r) >> 10 ) & 0x3f)
#define GET_LMS7002_TBB_ICT_IAMP_FRP_TBB(r) (((r) >> 5 ) & 0x1f)
#define GET_LMS7002_TBB_ICT_IAMP_GG_FRP_TBB(r) (((r) >> 0 ) & 0x1f)

enum lms7002m_reg_0x0109 {
    LMS7002_TBB_RCAL_LPFH_TBB_OFF = 8,
    LMS7002_TBB_RCAL_LPFH_TBB_MSK = 0xff,
    LMS7002_TBB_RCAL_LPFLAD_TBB_OFF = 0,
    LMS7002_TBB_RCAL_LPFLAD_TBB_MSK = 0xff,
};
#define MAKE_LMS7002_0x0109( RCAL_LPFH_TBB, RCAL_LPFLAD_TBB ) ( \
    (((RCAL_LPFH_TBB) & 0xff) << 8) | \
    (((RCAL_LPFLAD_TBB) & 0xff) << 0) | \
    (0x01090000 | 0x80000000))
#define GET_LMS7002_TBB_RCAL_LPFH_TBB(r) (((r) >> 8 ) & 0xff)
#define GET_LMS7002_TBB_RCAL_LPFLAD_TBB(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x010A {
    LMS7002_TBB_TSTIN_TBB_OFF = 14,
    LMS7002_TBB_TSTIN_TBB_MSK = 0x3,
    LMS7002_TBB_BYPLADDER_TBB_OFF = 13,
    LMS7002_TBB_CCAL_LPFLAD_TBB_OFF = 8,
    LMS7002_TBB_CCAL_LPFLAD_TBB_MSK = 0x1f,
    LMS7002_TBB_RCAL_LPFS5_TBB_OFF = 0,
    LMS7002_TBB_RCAL_LPFS5_TBB_MSK = 0xff,
};
#define MAKE_LMS7002_0x010A( TSTIN_TBB, BYPLADDER_TBB, CCAL_LPFLAD_TBB, RCAL_LPFS5_TBB ) ( \
    (((TSTIN_TBB) & 0x3) << 14) | \
    (((BYPLADDER_TBB) & 0x1) << 13) | \
    (((CCAL_LPFLAD_TBB) & 0x1f) << 8) | \
    (((RCAL_LPFS5_TBB) & 0xff) << 0) | \
    (0x010A0000 | 0x80000000))
#define GET_LMS7002_TBB_TSTIN_TBB(r) (((r) >> 14 ) & 0x3)
#define GET_LMS7002_TBB_BYPLADDER_TBB(r) (((r) >> 13 ) & 0x1)
#define GET_LMS7002_TBB_CCAL_LPFLAD_TBB(r) (((r) >> 8 ) & 0x1f)
#define GET_LMS7002_TBB_RCAL_LPFS5_TBB(r) (((r) >> 0 ) & 0xff)



/*************************************
 * TRF configuration registers
 *************************************/
enum lms7002m_reg_0x0100 {
    LMS7002_TRF_EN_LOWBWLOMX_TMX_TRF_OFF = 15,
    LMS7002_TRF_EN_NEXTTX_TRF_OFF = 14,
    LMS7002_TRF_EN_AMPHF_PDET_TRF_OFF = 12,
    LMS7002_TRF_EN_AMPHF_PDET_TRF_MSK = 0x3,
    LMS7002_TRF_LOADR_PDET_TRF_OFF = 10,
    LMS7002_TRF_LOADR_PDET_TRF_MSK = 0x3,
    LMS7002_TRF_PD_PDET_TRF_OFF = 3,
    LMS7002_TRF_PD_TLOBUF_TRF_OFF = 2,
    LMS7002_TRF_PD_TXPAD_TRF_OFF = 1,
    LMS7002_TRF_EN_G_TRF_OFF = 0,
};
#define MAKE_LMS7002_0x0100( EN_LOWBWLOMX_TMX_TRF, EN_NEXTTX_TRF, EN_AMPHF_PDET_TRF, LOADR_PDET_TRF, PD_PDET_TRF, PD_TLOBUF_TRF, PD_TXPAD_TRF, EN_G_TRF ) ( \
    (((EN_LOWBWLOMX_TMX_TRF) & 0x1) << 15) | \
    (((EN_NEXTTX_TRF) & 0x1) << 14) | \
    (((EN_AMPHF_PDET_TRF) & 0x3) << 12) | \
    (((LOADR_PDET_TRF) & 0x3) << 10) | \
    (((PD_PDET_TRF) & 0x1) << 3) | \
    (((PD_TLOBUF_TRF) & 0x1) << 2) | \
    (((PD_TXPAD_TRF) & 0x1) << 1) | \
    (((EN_G_TRF) & 0x1) << 0) | \
    (0x01000000 | 0x80000000))
#define GET_LMS7002_TRF_EN_LOWBWLOMX_TMX_TRF(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_TRF_EN_NEXTTX_TRF(r) (((r) >> 14 ) & 0x1)
#define GET_LMS7002_TRF_EN_AMPHF_PDET_TRF(r) (((r) >> 12 ) & 0x3)
#define GET_LMS7002_TRF_LOADR_PDET_TRF(r) (((r) >> 10 ) & 0x3)
#define GET_LMS7002_TRF_PD_PDET_TRF(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_TRF_PD_TLOBUF_TRF(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_TRF_PD_TXPAD_TRF(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_TRF_EN_G_TRF(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x0101 {
    LMS7002_TRF_F_TXPAD_TRF_OFF = 13,
    LMS7002_TRF_F_TXPAD_TRF_MSK = 0x7,
    LMS7002_TRF_L_LOOPB_TXPAD_TRF_OFF = 11,
    LMS7002_TRF_L_LOOPB_TXPAD_TRF_MSK = 0x3,
    LMS7002_TRF_LOSS_LIN_TXPAD_TRF_OFF = 6,
    LMS7002_TRF_LOSS_LIN_TXPAD_TRF_MSK = 0x1f,
    LMS7002_TRF_LOSS_MAIN_TXPAD_TRF_OFF = 1,
    LMS7002_TRF_LOSS_MAIN_TXPAD_TRF_MSK = 0x1f,
    LMS7002_TRF_EN_LOOPB_TXPAD_TRF_OFF = 0,
};
#define MAKE_LMS7002_0x0101( F_TXPAD_TRF, L_LOOPB_TXPAD_TRF, LOSS_LIN_TXPAD_TRF, LOSS_MAIN_TXPAD_TRF, EN_LOOPB_TXPAD_TRF ) ( \
    (((F_TXPAD_TRF) & 0x7) << 13) | \
    (((L_LOOPB_TXPAD_TRF) & 0x3) << 11) | \
    (((LOSS_LIN_TXPAD_TRF) & 0x1f) << 6) | \
    (((LOSS_MAIN_TXPAD_TRF) & 0x1f) << 1) | \
    (((EN_LOOPB_TXPAD_TRF) & 0x1) << 0) | \
    (0x01010000 | 0x80000000))
#define GET_LMS7002_TRF_F_TXPAD_TRF(r) (((r) >> 13 ) & 0x7)
#define GET_LMS7002_TRF_L_LOOPB_TXPAD_TRF(r) (((r) >> 11 ) & 0x3)
#define GET_LMS7002_TRF_LOSS_LIN_TXPAD_TRF(r) (((r) >> 6 ) & 0x1f)
#define GET_LMS7002_TRF_LOSS_MAIN_TXPAD_TRF(r) (((r) >> 1 ) & 0x1f)
#define GET_LMS7002_TRF_EN_LOOPB_TXPAD_TRF(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x0102 {
    LMS7002_TRF_GCAS_GNDREF_TXPAD_TRF_OFF = 15,
    LMS7002_TRF_ICT_LIN_TXPAD_TRF_OFF = 10,
    LMS7002_TRF_ICT_LIN_TXPAD_TRF_MSK = 0x1f,
    LMS7002_TRF_ICT_MAIN_TXPAD_TRF_OFF = 5,
    LMS7002_TRF_ICT_MAIN_TXPAD_TRF_MSK = 0x1f,
    LMS7002_TRF_VGCAS_TXPAD_TRF_OFF = 0,
    LMS7002_TRF_VGCAS_TXPAD_TRF_MSK = 0x1f,
};
#define MAKE_LMS7002_0x0102( GCAS_GNDREF_TXPAD_TRF, ICT_LIN_TXPAD_TRF, ICT_MAIN_TXPAD_TRF, VGCAS_TXPAD_TRF ) ( \
    (((GCAS_GNDREF_TXPAD_TRF) & 0x1) << 15) | \
    (((ICT_LIN_TXPAD_TRF) & 0x1f) << 10) | \
    (((ICT_MAIN_TXPAD_TRF) & 0x1f) << 5) | \
    (((VGCAS_TXPAD_TRF) & 0x1f) << 0) | \
    (0x01020000 | 0x80000000))
#define GET_LMS7002_TRF_GCAS_GNDREF_TXPAD_TRF(r) (((r) >> 15 ) & 0x1)
#define GET_LMS7002_TRF_ICT_LIN_TXPAD_TRF(r) (((r) >> 10 ) & 0x1f)
#define GET_LMS7002_TRF_ICT_MAIN_TXPAD_TRF(r) (((r) >> 5 ) & 0x1f)
#define GET_LMS7002_TRF_VGCAS_TXPAD_TRF(r) (((r) >> 0 ) & 0x1f)

enum lms7002m_reg_0x0103 {
    LMS7002_TRF_SEL_BAND1_TRF_OFF = 11,
    LMS7002_TRF_SEL_BAND2_TRF_OFF = 10,
    LMS7002_TRF_LOBIASN_TXM_TRF_OFF = 5,
    LMS7002_TRF_LOBIASN_TXM_TRF_MSK = 0x1f,
    LMS7002_TRF_LOBIASP_TXX_TRF_OFF = 0,
    LMS7002_TRF_LOBIASP_TXX_TRF_MSK = 0x1f,
};
#define MAKE_LMS7002_0x0103( SEL_BAND1_TRF, SEL_BAND2_TRF, LOBIASN_TXM_TRF, LOBIASP_TXX_TRF ) ( \
    (((SEL_BAND1_TRF) & 0x1) << 11) | \
    (((SEL_BAND2_TRF) & 0x1) << 10) | \
    (((LOBIASN_TXM_TRF) & 0x1f) << 5) | \
    (((LOBIASP_TXX_TRF) & 0x1f) << 0) | \
    (0x01030000 | 0x80000000))
#define GET_LMS7002_TRF_SEL_BAND1_TRF(r) (((r) >> 11 ) & 0x1)
#define GET_LMS7002_TRF_SEL_BAND2_TRF(r) (((r) >> 10 ) & 0x1)
#define GET_LMS7002_TRF_LOBIASN_TXM_TRF(r) (((r) >> 5 ) & 0x1f)
#define GET_LMS7002_TRF_LOBIASP_TXX_TRF(r) (((r) >> 0 ) & 0x1f)

enum lms7002m_reg_0x0104 {
    LMS7002_TRF_CDC_I_TRF_OFF = 4,
    LMS7002_TRF_CDC_I_TRF_MSK = 0xf,
    LMS7002_TRF_CDC_Q_TRF_OFF = 0,
    LMS7002_TRF_CDC_Q_TRF_MSK = 0xf,
};
#define MAKE_LMS7002_0x0104( CDC_I_TRF, CDC_Q_TRF ) ( \
    (((CDC_I_TRF) & 0xf) << 4) | \
    (((CDC_Q_TRF) & 0xf) << 0) | \
    (0x01040000 | 0x80000000))
#define GET_LMS7002_TRF_CDC_I_TRF(r) (((r) >> 4 ) & 0xf)
#define GET_LMS7002_TRF_CDC_Q_TRF(r) (((r) >> 0 ) & 0xf)



/*************************************
 * TXNCO configuration registers
 *************************************/
enum lms7002m_reg_0x0240 {
    LMS7002_TXNCO_DTHBIT_OFF = 5,
    LMS7002_TXNCO_DTHBIT_MSK = 0xf,
    LMS7002_TXNCO_SEL_OFF = 1,
    LMS7002_TXNCO_SEL_MSK = 0xf,
    LMS7002_TXNCO_MODE_OFF = 0,
};
#define MAKE_LMS7002_0x0240( DTHBIT, SEL, MODE ) ( \
    (((DTHBIT) & 0xf) << 5) | \
    (((SEL) & 0xf) << 1) | \
    (((MODE) & 0x1) << 0) | \
    (0x02400000 | 0x80000000))
#define GET_LMS7002_TXNCO_DTHBIT(r) (((r) >> 5 ) & 0xf)
#define GET_LMS7002_TXNCO_SEL(r) (((r) >> 1 ) & 0xf)
#define GET_LMS7002_TXNCO_MODE(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x0241 {
    LMS7002_TXNCO_PHO_OFF = 0,
    LMS7002_TXNCO_PHO_MSK = 0xffff,
};
#define MAKE_LMS7002_0x0241( PHO ) ( \
    (((PHO) & 0xffff) << 0) | \
    (0x02410000 | 0x80000000))
#define GET_LMS7002_TXNCO_PHO(r) (((r) >> 0 ) & 0xffff)

enum lms7002m_reg_0x0242 {
    LMS7002_TXNCO_FCW0_HI_OFF = 0,
    LMS7002_TXNCO_FCW0_HI_MSK = 0xffff,
};
#define MAKE_LMS7002_0x0242( FCW0_HI ) ( \
    (((FCW0_HI) & 0xffff) << 0) | \
    (0x02420000 | 0x80000000))
#define GET_LMS7002_TXNCO_FCW0_HI(r) (((r) >> 0 ) & 0xffff)

enum lms7002m_reg_0x0243 {
    LMS7002_TXNCO_FCW0_LO_OFF = 0,
    LMS7002_TXNCO_FCW0_LO_MSK = 0xffff,
};
#define MAKE_LMS7002_0x0243( FCW0_LO ) ( \
    (((FCW0_LO) & 0xffff) << 0) | \
    (0x02430000 | 0x80000000))
#define GET_LMS7002_TXNCO_FCW0_LO(r) (((r) >> 0 ) & 0xffff)



/*************************************
 * TXTSP configuration registers
 *************************************/
enum lms7002m_reg_0x0200 {
    LMS7002_TXTSP_TSGFC_OFF = 9,
    LMS7002_TXTSP_TSGFCW_OFF = 7,
    LMS7002_TXTSP_TSGFCW_MSK = 0x3,
    LMS7002_TXTSP_TSGDCLDQ_OFF = 6,
    LMS7002_TXTSP_TSGDCLDI_OFF = 5,
    LMS7002_TXTSP_TSGSWAPIQ_OFF = 4,
    LMS7002_TXTSP_TSGMODE_OFF = 3,
    LMS7002_TXTSP_INSEL_OFF = 2,
    LMS7002_TXTSP_BSTART_OFF = 1,
    LMS7002_TXTSP_EN_OFF = 0,
};
#define MAKE_LMS7002_0x0200( TSGFC, TSGFCW, TSGDCLDQ, TSGDCLDI, TSGSWAPIQ, TSGMODE, INSEL, BSTART, EN ) ( \
    (((TSGFC) & 0x1) << 9) | \
    (((TSGFCW) & 0x3) << 7) | \
    (((TSGDCLDQ) & 0x1) << 6) | \
    (((TSGDCLDI) & 0x1) << 5) | \
    (((TSGSWAPIQ) & 0x1) << 4) | \
    (((TSGMODE) & 0x1) << 3) | \
    (((INSEL) & 0x1) << 2) | \
    (((BSTART) & 0x1) << 1) | \
    (((EN) & 0x1) << 0) | \
    (0x02000000 | 0x80000000))
#define GET_LMS7002_TXTSP_TSGFC(r) (((r) >> 9 ) & 0x1)
#define GET_LMS7002_TXTSP_TSGFCW(r) (((r) >> 7 ) & 0x3)
#define GET_LMS7002_TXTSP_TSGDCLDQ(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_TXTSP_TSGDCLDI(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_TXTSP_TSGSWAPIQ(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_TXTSP_TSGMODE(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_TXTSP_INSEL(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_TXTSP_BSTART(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_TXTSP_EN(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x0201 {
    LMS7002_TXTSP_GCORRQ_OFF = 0,
    LMS7002_TXTSP_GCORRQ_MSK = 0x7ff,
};
#define MAKE_LMS7002_0x0201( GCORRQ ) ( \
    (((GCORRQ) & 0x7ff) << 0) | \
    (0x02010000 | 0x80000000))
#define GET_LMS7002_TXTSP_GCORRQ(r) (((r) >> 0 ) & 0x7ff)

enum lms7002m_reg_0x0202 {
    LMS7002_TXTSP_GCORRI_OFF = 0,
    LMS7002_TXTSP_GCORRI_MSK = 0x7ff,
};
#define MAKE_LMS7002_0x0202( GCORRI ) ( \
    (((GCORRI) & 0x7ff) << 0) | \
    (0x02020000 | 0x80000000))
#define GET_LMS7002_TXTSP_GCORRI(r) (((r) >> 0 ) & 0x7ff)

enum lms7002m_reg_0x0203 {
    LMS7002_TXTSP_HBI_OVR_OFF = 12,
    LMS7002_TXTSP_HBI_OVR_MSK = 0x7,
    LMS7002_TXTSP_IQCORR_OFF = 0,
    LMS7002_TXTSP_IQCORR_MSK = 0xfff,
};
#define MAKE_LMS7002_0x0203( HBI_OVR, IQCORR ) ( \
    (((HBI_OVR) & 0x7) << 12) | \
    (((IQCORR) & 0xfff) << 0) | \
    (0x02030000 | 0x80000000))
#define GET_LMS7002_TXTSP_HBI_OVR(r) (((r) >> 12 ) & 0x7)
#define GET_LMS7002_TXTSP_IQCORR(r) (((r) >> 0 ) & 0xfff)

enum lms7002m_reg_0x0204 {
    LMS7002_TXTSP_DCCORRI_OFF = 8,
    LMS7002_TXTSP_DCCORRI_MSK = 0xff,
    LMS7002_TXTSP_DCCORRQ_OFF = 0,
    LMS7002_TXTSP_DCCORRQ_MSK = 0xff,
};
#define MAKE_LMS7002_0x0204( DCCORRI, DCCORRQ ) ( \
    (((DCCORRI) & 0xff) << 8) | \
    (((DCCORRQ) & 0xff) << 0) | \
    (0x02040000 | 0x80000000))
#define GET_LMS7002_TXTSP_DCCORRI(r) (((r) >> 8 ) & 0xff)
#define GET_LMS7002_TXTSP_DCCORRQ(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x0205 {
    LMS7002_TXTSP_GFIR1_L_OFF = 8,
    LMS7002_TXTSP_GFIR1_L_MSK = 0x7,
    LMS7002_TXTSP_GFIR1_N_OFF = 0,
    LMS7002_TXTSP_GFIR1_N_MSK = 0xff,
};
#define MAKE_LMS7002_0x0205( GFIR1_L, GFIR1_N ) ( \
    (((GFIR1_L) & 0x7) << 8) | \
    (((GFIR1_N) & 0xff) << 0) | \
    (0x02050000 | 0x80000000))
#define GET_LMS7002_TXTSP_GFIR1_L(r) (((r) >> 8 ) & 0x7)
#define GET_LMS7002_TXTSP_GFIR1_N(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x0206 {
    LMS7002_TXTSP_GFIR2_L_OFF = 8,
    LMS7002_TXTSP_GFIR2_L_MSK = 0x7,
    LMS7002_TXTSP_GFIR2_N_OFF = 0,
    LMS7002_TXTSP_GFIR2_N_MSK = 0xff,
};
#define MAKE_LMS7002_0x0206( GFIR2_L, GFIR2_N ) ( \
    (((GFIR2_L) & 0x7) << 8) | \
    (((GFIR2_N) & 0xff) << 0) | \
    (0x02060000 | 0x80000000))
#define GET_LMS7002_TXTSP_GFIR2_L(r) (((r) >> 8 ) & 0x7)
#define GET_LMS7002_TXTSP_GFIR2_N(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x0207 {
    LMS7002_TXTSP_GFIR3_L_OFF = 8,
    LMS7002_TXTSP_GFIR3_L_MSK = 0x7,
    LMS7002_TXTSP_GFIR3_N_OFF = 0,
    LMS7002_TXTSP_GFIR3_N_MSK = 0xff,
};
#define MAKE_LMS7002_0x0207( GFIR3_L, GFIR3_N ) ( \
    (((GFIR3_L) & 0x7) << 8) | \
    (((GFIR3_N) & 0xff) << 0) | \
    (0x02070000 | 0x80000000))
#define GET_LMS7002_TXTSP_GFIR3_L(r) (((r) >> 8 ) & 0x7)
#define GET_LMS7002_TXTSP_GFIR3_N(r) (((r) >> 0 ) & 0xff)

enum lms7002m_reg_0x0208 {
    LMS7002_TXTSP_CMIX_GAIN_OFF = 14,
    LMS7002_TXTSP_CMIX_GAIN_MSK = 0x3,
    LMS7002_TXTSP_CMIX_SC_OFF = 13,
    LMS7002_TXTSP_CMIX_BYP_OFF = 8,
    LMS7002_TXTSP_ISINC_BYP_OFF = 7,
    LMS7002_TXTSP_GFIR3_BYP_OFF = 6,
    LMS7002_TXTSP_GFIR2_BYP_OFF = 5,
    LMS7002_TXTSP_GFIR1_BYP_OFF = 4,
    LMS7002_TXTSP_DC_BYP_OFF = 3,
    LMS7002_TXTSP_GC_BYP_OFF = 1,
    LMS7002_TXTSP_PH_BYP_OFF = 0,
};
#define MAKE_LMS7002_0x0208( CMIX_GAIN, CMIX_SC, CMIX_BYP, ISINC_BYP, GFIR3_BYP, GFIR2_BYP, GFIR1_BYP, DC_BYP, GC_BYP, PH_BYP ) ( \
    (((CMIX_GAIN) & 0x3) << 14) | \
    (((CMIX_SC) & 0x1) << 13) | \
    (((CMIX_BYP) & 0x1) << 8) | \
    (((ISINC_BYP) & 0x1) << 7) | \
    (((GFIR3_BYP) & 0x1) << 6) | \
    (((GFIR2_BYP) & 0x1) << 5) | \
    (((GFIR1_BYP) & 0x1) << 4) | \
    (((DC_BYP) & 0x1) << 3) | \
    (((GC_BYP) & 0x1) << 1) | \
    (((PH_BYP) & 0x1) << 0) | \
    (0x02080000 | 0x80000000))
#define GET_LMS7002_TXTSP_CMIX_GAIN(r) (((r) >> 14 ) & 0x3)
#define GET_LMS7002_TXTSP_CMIX_SC(r) (((r) >> 13 ) & 0x1)
#define GET_LMS7002_TXTSP_CMIX_BYP(r) (((r) >> 8 ) & 0x1)
#define GET_LMS7002_TXTSP_ISINC_BYP(r) (((r) >> 7 ) & 0x1)
#define GET_LMS7002_TXTSP_GFIR3_BYP(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_TXTSP_GFIR2_BYP(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_TXTSP_GFIR1_BYP(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_TXTSP_DC_BYP(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_TXTSP_GC_BYP(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_TXTSP_PH_BYP(r) (((r) >> 0 ) & 0x1)

enum lms7002m_reg_0x020C {
    LMS7002_TXTSP_DC_REG_OFF = 0,
    LMS7002_TXTSP_DC_REG_MSK = 0xffff,
};
#define MAKE_LMS7002_0x020C( DC_REG ) ( \
    (((DC_REG) & 0xffff) << 0) | \
    (0x020C0000 | 0x80000000))
#define GET_LMS7002_TXTSP_DC_REG(r) (((r) >> 0 ) & 0xffff)



/*************************************
 * XBUF configuration registers
 *************************************/
enum lms7002m_reg_0x0085 {
    LMS7002_XBUF_SLFB_XBUF_RX_OFF = 8,
    LMS7002_XBUF_SLFB_XBUF_TX_OFF = 7,
    LMS7002_XBUF_BYP_XBUF_RX_OFF = 6,
    LMS7002_XBUF_BYP_XBUF_TX_OFF = 5,
    LMS7002_XBUF_EN_OUT2_XBUF_TX_OFF = 4,
    LMS7002_XBUF_EN_TBUFIN_XBUF_RX_OFF = 3,
    LMS7002_XBUF_PD_XBUF_RX_OFF = 2,
    LMS7002_XBUF_PD_XBUF_TX_OFF = 1,
    LMS7002_XBUF_EN_G_XBUF_OFF = 0,
};
#define MAKE_LMS7002_0x0085( SLFB_XBUF_RX, SLFB_XBUF_TX, BYP_XBUF_RX, BYP_XBUF_TX, EN_OUT2_XBUF_TX, EN_TBUFIN_XBUF_RX, PD_XBUF_RX, PD_XBUF_TX, EN_G_XBUF ) ( \
    (((SLFB_XBUF_RX) & 0x1) << 8) | \
    (((SLFB_XBUF_TX) & 0x1) << 7) | \
    (((BYP_XBUF_RX) & 0x1) << 6) | \
    (((BYP_XBUF_TX) & 0x1) << 5) | \
    (((EN_OUT2_XBUF_TX) & 0x1) << 4) | \
    (((EN_TBUFIN_XBUF_RX) & 0x1) << 3) | \
    (((PD_XBUF_RX) & 0x1) << 2) | \
    (((PD_XBUF_TX) & 0x1) << 1) | \
    (((EN_G_XBUF) & 0x1) << 0) | \
    (0x00850000 | 0x80000000))
#define GET_LMS7002_XBUF_SLFB_XBUF_RX(r) (((r) >> 8 ) & 0x1)
#define GET_LMS7002_XBUF_SLFB_XBUF_TX(r) (((r) >> 7 ) & 0x1)
#define GET_LMS7002_XBUF_BYP_XBUF_RX(r) (((r) >> 6 ) & 0x1)
#define GET_LMS7002_XBUF_BYP_XBUF_TX(r) (((r) >> 5 ) & 0x1)
#define GET_LMS7002_XBUF_EN_OUT2_XBUF_TX(r) (((r) >> 4 ) & 0x1)
#define GET_LMS7002_XBUF_EN_TBUFIN_XBUF_RX(r) (((r) >> 3 ) & 0x1)
#define GET_LMS7002_XBUF_PD_XBUF_RX(r) (((r) >> 2 ) & 0x1)
#define GET_LMS7002_XBUF_PD_XBUF_TX(r) (((r) >> 1 ) & 0x1)
#define GET_LMS7002_XBUF_EN_G_XBUF(r) (((r) >> 0 ) & 0x1)




#define LMS7002_OPT_MAC_NONE 0u
#define LMS7002_OPT_MAC_CHA 1u
#define LMS7002_OPT_MAC_CHB 2u
#define LMS7002_OPT_MAC_CHAB 3u
#define LMS7002_OPT_SPIMODE_3WIRE 0u
#define LMS7002_OPT_SPIMODE_4WIRE 1u
#define LMS7002_OPT_DIQDIR2_OUTPUT 0u
#define LMS7002_OPT_DIQDIR2_INPUT 1u
#define LMS7002_OPT_DIQDIR1_OUTPUT 0u
#define LMS7002_OPT_DIQDIR1_INPUT 1u
#define LMS7002_OPT_ENABLEDIR2_OUTPUT 0u
#define LMS7002_OPT_ENABLEDIR2_INPUT 1u
#define LMS7002_OPT_ENABLEDIR1_OUTPUT 0u
#define LMS7002_OPT_ENABLEDIR1_INPUT 1u
#define LMS7002_OPT_LML2_RXNTXIQ_RXIQ 0u
#define LMS7002_OPT_LML2_RXNTXIQ_TXIQ 1u
#define LMS7002_OPT_LML2_MODE_TRXIQ 0u
#define LMS7002_OPT_LML2_MODE_JESD207 1u
#define LMS7002_OPT_LML1_RXNTXIQ_RXIQ 0u
#define LMS7002_OPT_LML1_RXNTXIQ_TXIQ 1u
#define LMS7002_OPT_LML1_MODE_TRXIQ 0u
#define LMS7002_OPT_LML1_MODE_JESD207 1u
#define LMS7002_OPT_LML1_S3S_AI 0u
#define LMS7002_OPT_LML1_S3S_AQ 1u
#define LMS7002_OPT_LML1_S3S_BI 2u
#define LMS7002_OPT_LML1_S3S_BQ 3u
#define LMS7002_OPT_LML1_S2S_AI 0u
#define LMS7002_OPT_LML1_S2S_AQ 1u
#define LMS7002_OPT_LML1_S2S_BI 2u
#define LMS7002_OPT_LML1_S2S_BQ 3u
#define LMS7002_OPT_LML1_S1S_AI 0u
#define LMS7002_OPT_LML1_S1S_AQ 1u
#define LMS7002_OPT_LML1_S1S_BI 2u
#define LMS7002_OPT_LML1_S1S_BQ 3u
#define LMS7002_OPT_LML1_S0S_AI 0u
#define LMS7002_OPT_LML1_S0S_AQ 1u
#define LMS7002_OPT_LML1_S0S_BI 2u
#define LMS7002_OPT_LML1_S0S_BQ 3u
#define LMS7002_OPT_LML2_S3S_AI 0u
#define LMS7002_OPT_LML2_S3S_AQ 1u
#define LMS7002_OPT_LML2_S3S_BI 2u
#define LMS7002_OPT_LML2_S3S_BQ 3u
#define LMS7002_OPT_LML2_S2S_AI 0u
#define LMS7002_OPT_LML2_S2S_AQ 1u
#define LMS7002_OPT_LML2_S2S_BI 2u
#define LMS7002_OPT_LML2_S2S_BQ 3u
#define LMS7002_OPT_LML2_S1S_AI 0u
#define LMS7002_OPT_LML2_S1S_AQ 1u
#define LMS7002_OPT_LML2_S1S_BI 2u
#define LMS7002_OPT_LML2_S1S_BQ 3u
#define LMS7002_OPT_LML2_S0S_AI 0u
#define LMS7002_OPT_LML2_S0S_AQ 1u
#define LMS7002_OPT_LML2_S0S_BI 2u
#define LMS7002_OPT_LML2_S0S_BQ 3u
#define LMS7002_OPT_RX_MUX_RXTSP 0u
#define LMS7002_OPT_RX_MUX_TXFIFO 1u
#define LMS7002_OPT_RX_MUX_LFSR 2u
#define LMS7002_OPT_RX_MUX_LFSR_ 3u
#define LMS7002_OPT_TX_MUX_PORT1 0u
#define LMS7002_OPT_TX_MUX_PORT2 1u
#define LMS7002_OPT_TX_MUX_RXTSP 2u
#define LMS7002_OPT_TX_MUX_RXTSP_ 3u
#define LMS7002_OPT_TXRDCLK_MUX_FCLK1 0u
#define LMS7002_OPT_TXRDCLK_MUX_FCLK2 1u
#define LMS7002_OPT_TXRDCLK_MUX_TXTSPCLK 2u
#define LMS7002_OPT_TXRDCLK_MUX_TXTSPCLK_ 3u
#define LMS7002_OPT_TXWRCLK_MUX_FCLK1 0u
#define LMS7002_OPT_TXWRCLK_MUX_FCLK2 1u
#define LMS7002_OPT_TXWRCLK_MUX_RXTSPCLK 2u
#define LMS7002_OPT_TXWRCLK_MUX_RXTSPCLK_ 3u
#define LMS7002_OPT_RXRDCLK_MUX_MCLK1 0u
#define LMS7002_OPT_RXRDCLK_MUX_MCLK2 1u
#define LMS7002_OPT_RXRDCLK_MUX_FCLK1 2u
#define LMS7002_OPT_RXRDCLK_MUX_FCLK2 3u
#define LMS7002_OPT_RXWRCLK_MUX_FCLK1 0u
#define LMS7002_OPT_RXWRCLK_MUX_FCLK2 1u
#define LMS7002_OPT_RXWRCLK_MUX_RXTSPCLK 2u
#define LMS7002_OPT_RXWRCLK_MUX_RXTSPCLK_ 3u
#define LMS7002_OPT_MCLK2SRC_TXTSPCLKA_DIV 0u
#define LMS7002_OPT_MCLK2SRC_RXTSPCLKA_DIV 1u
#define LMS7002_OPT_MCLK2SRC_TXTSPCLKA 2u
#define LMS7002_OPT_MCLK2SRC_RXTSPCLKA 3u
#define LMS7002_OPT_MCLK1SRC_TXTSPCLKA_DIV 0u
#define LMS7002_OPT_MCLK1SRC_RXTSPCLKA_DIV 1u
#define LMS7002_OPT_MCLK1SRC_TXTSPCLKA 2u
#define LMS7002_OPT_MCLK1SRC_RXTSPCLKA 3u
#define LMS7002_OPT_MODE_INTERLEAVE_AFE_2ADCS 0u
#define LMS7002_OPT_MODE_INTERLEAVE_AFE_INTERLEAVED 1u
#define LMS7002_OPT_MUX_AFE_1_MUXOFF 0u
#define LMS7002_OPT_MUX_AFE_1_PDET_1 1u
#define LMS7002_OPT_MUX_AFE_1_BIAS_TOP 2u
#define LMS7002_OPT_MUX_AFE_1_RSSI1 3u
#define LMS7002_OPT_MUX_AFE_2_MUXOFF 0u
#define LMS7002_OPT_MUX_AFE_2_PDET_2 1u
#define LMS7002_OPT_MUX_AFE_2_RSSI1 2u
#define LMS7002_OPT_MUX_AFE_2_RSSI2 3u
#define LMS7002_OPT_SEL_SDMCLK_CGEN_CLK_DIV 0u
#define LMS7002_OPT_SEL_SDMCLK_CGEN_CLK_REF 1u
#define LMS7002_OPT_TST_CGEN_DISABLED 0u
#define LMS7002_OPT_TST_CGEN_TSTDO 1u
#define LMS7002_OPT_TST_CGEN_VCO_TUNE_50_KOHM 2u
#define LMS7002_OPT_TST_CGEN_VCO_TUNE 3u
#define LMS7002_OPT_TST_CGEN_PFD_UP 5u
#define LMS7002_OPT_EN_NEXTTX_TRF_SISO 0u
#define LMS7002_OPT_EN_NEXTTX_TRF_MIMO 1u
#define LMS7002_OPT_SEL_PATH_RFE_NONE 0u
#define LMS7002_OPT_SEL_PATH_RFE_LNAH 1u
#define LMS7002_OPT_SEL_PATH_RFE_LNAL 2u
#define LMS7002_OPT_SEL_PATH_RFE_LNAW 3u
#define LMS7002_OPT_EN_NEXTRX_RFE_SISO 0u
#define LMS7002_OPT_EN_NEXTRX_RFE_MIMO 1u
#define LMS7002_OPT_INPUT_CTL_PGA_RBB_LPFL 0u
#define LMS7002_OPT_INPUT_CTL_PGA_RBB_LPFH 1u
#define LMS7002_OPT_INPUT_CTL_PGA_RBB_BYPASS 2u
#define LMS7002_OPT_INPUT_CTL_PGA_RBB_TBB 3u
#define LMS7002_OPT_INPUT_CTL_PGA_RBB_PDET 4u
#define LMS7002_OPT_SEL_SDMCLK_CLK_DIV 0u
#define LMS7002_OPT_SEL_SDMCLK_CLK_REF 1u
#define LMS7002_OPT_SEL_VCO_VCOL 0u
#define LMS7002_OPT_SEL_VCO_VCOM 1u
#define LMS7002_OPT_SEL_VCO_VCOH 2u
#define LMS7002_OPT_TSGFC_NEG6DB 0u
#define LMS7002_OPT_TSGFC_FS 1u
#define LMS7002_OPT_TSGFCW_DIV8 1u
#define LMS7002_OPT_TSGFCW_DIV4 2u
#define LMS7002_OPT_TSGMODE_NCO 0u
#define LMS7002_OPT_TSGMODE_DC 1u
#define LMS7002_OPT_INSEL_LML 0u
#define LMS7002_OPT_INSEL_TEST 1u
#define LMS7002_OPT_HBI_OVR_BYPASS 7u
#define LMS7002_OPT_CMIX_GAIN_0DB 0u
#define LMS7002_OPT_CMIX_GAIN_POS6DB 1u
#define LMS7002_OPT_CMIX_GAIN_NEG6DB 2u
#define LMS7002_OPT_CMIX_SC_UPCONVERT 0u
#define LMS7002_OPT_CMIX_SC_DOWNCONVERT 1u
#define LMS7002_OPT_MODE_FCW 0u
#define LMS7002_OPT_MODE_PHO 1u
#define LMS7002_OPT_CAPSEL_RSSI 0u
#define LMS7002_OPT_CAPSEL_ADCI_ADCQ 1u
#define LMS7002_OPT_CAPSEL_BSIGI_BSTATE 2u
#define LMS7002_OPT_CAPSEL_BSIGQ_BSTATE 3u
#define LMS7002_OPT_CAPSEL_ADC_RXTSP_INPUT 0u
#define LMS7002_OPT_CAPSEL_ADC_RXTSP_OUTPUT 1u
#define LMS7002_OPT_TSGFC_NEG6DB 0u
#define LMS7002_OPT_TSGFC_FS 1u
#define LMS7002_OPT_TSGFCW_DIV8 1u
#define LMS7002_OPT_TSGFCW_DIV4 2u
#define LMS7002_OPT_TSGMODE_NCO 0u
#define LMS7002_OPT_TSGMODE_DC 1u
#define LMS7002_OPT_INSEL_LML 0u
#define LMS7002_OPT_INSEL_TEST 1u
#define LMS7002_OPT_HBD_OVR_BYPASS 7u
#define LMS7002_OPT_RSSI_MODE_RSSI_NORM 0u
#define LMS7002_OPT_RSSI_MODE_RSSI_I 1u
#define LMS7002_OPT_RSSI_MODE_RSSI_Q 2u
#define LMS7002_OPT_AGC_MODE_AGC 0u
#define LMS7002_OPT_AGC_MODE_RSSI 1u
#define LMS7002_OPT_AGC_MODE_BYPASS 2u
#define LMS7002_OPT_CMIX_GAIN_0DB 0u
#define LMS7002_OPT_CMIX_GAIN_POS6DB 1u
#define LMS7002_OPT_CMIX_GAIN_NEG6DB 2u
#define LMS7002_OPT_CMIX_SC_UPCONVERT 0u
#define LMS7002_OPT_CMIX_SC_DOWNCONVERT 1u
#define LMS7002_OPT_MODE_FCW 0u
#define LMS7002_OPT_MODE_PHO 1u

/* All known registers */
enum lms7002_regs {
    LMS7002M_0x0020 = 0x0020,
    LMS7002M_0x0021 = 0x0021,
    LMS7002M_0x0022 = 0x0022,
    LMS7002M_0x0023 = 0x0023,
    LMS7002M_0x0024 = 0x0024,
    LMS7002M_0x0025 = 0x0025,
    LMS7002M_0x0026 = 0x0026,
    LMS7002M_0x0027 = 0x0027,
    LMS7002M_0x0028 = 0x0028,
    LMS7002M_0x0029 = 0x0029,
    LMS7002M_0x002A = 0x002A,
    LMS7002M_0x002B = 0x002B,
    LMS7002M_0x002C = 0x002C,
    LMS7002M_0x002E = 0x002E,
    LMS7002M_0x002F = 0x002F,
    LMS7002M_0x0081 = 0x0081,
    LMS7002M_0x0082 = 0x0082,
    LMS7002M_0x0084 = 0x0084,
    LMS7002M_0x0085 = 0x0085,
    LMS7002M_0x0086 = 0x0086,
    LMS7002M_0x0087 = 0x0087,
    LMS7002M_0x0088 = 0x0088,
    LMS7002M_0x0089 = 0x0089,
    LMS7002M_0x008A = 0x008A,
    LMS7002M_0x008B = 0x008B,
    LMS7002M_0x008C = 0x008C,
    LMS7002M_0x008D = 0x008D,
    LMS7002M_0x0092 = 0x0092,
    LMS7002M_0x0093 = 0x0093,
    LMS7002M_0x0094 = 0x0094,
    LMS7002M_0x0095 = 0x0095,
    LMS7002M_0x0096 = 0x0096,
    LMS7002M_0x0097 = 0x0097,
    LMS7002M_0x0098 = 0x0098,
    LMS7002M_0x0099 = 0x0099,
    LMS7002M_0x009A = 0x009A,
    LMS7002M_0x009B = 0x009B,
    LMS7002M_0x009C = 0x009C,
    LMS7002M_0x009D = 0x009D,
    LMS7002M_0x009E = 0x009E,
    LMS7002M_0x009F = 0x009F,
    LMS7002M_0x00A0 = 0x00A0,
    LMS7002M_0x00A1 = 0x00A1,
    LMS7002M_0x00A2 = 0x00A2,
    LMS7002M_0x00A3 = 0x00A3,
    LMS7002M_0x00A4 = 0x00A4,
    LMS7002M_0x00A5 = 0x00A5,
    LMS7002M_0x00A6 = 0x00A6,
    LMS7002M_0x00A7 = 0x00A7,
    LMS7002M_0x0100 = 0x0100,
    LMS7002M_0x0101 = 0x0101,
    LMS7002M_0x0102 = 0x0102,
    LMS7002M_0x0103 = 0x0103,
    LMS7002M_0x0104 = 0x0104,
    LMS7002M_0x0105 = 0x0105,
    LMS7002M_0x0106 = 0x0106,
    LMS7002M_0x0107 = 0x0107,
    LMS7002M_0x0108 = 0x0108,
    LMS7002M_0x0109 = 0x0109,
    LMS7002M_0x010A = 0x010A,
    LMS7002M_0x010C = 0x010C,
    LMS7002M_0x010D = 0x010D,
    LMS7002M_0x010E = 0x010E,
    LMS7002M_0x010F = 0x010F,
    LMS7002M_0x0110 = 0x0110,
    LMS7002M_0x0111 = 0x0111,
    LMS7002M_0x0112 = 0x0112,
    LMS7002M_0x0113 = 0x0113,
    LMS7002M_0x0114 = 0x0114,
    LMS7002M_0x0115 = 0x0115,
    LMS7002M_0x0116 = 0x0116,
    LMS7002M_0x0117 = 0x0117,
    LMS7002M_0x0118 = 0x0118,
    LMS7002M_0x0119 = 0x0119,
    LMS7002M_0x011A = 0x011A,
    LMS7002M_0x011B = 0x011B,
    LMS7002M_0x011C = 0x011C,
    LMS7002M_0x011D = 0x011D,
    LMS7002M_0x011E = 0x011E,
    LMS7002M_0x011F = 0x011F,
    LMS7002M_0x0120 = 0x0120,
    LMS7002M_0x0121 = 0x0121,
    LMS7002M_0x0122 = 0x0122,
    LMS7002M_0x0123 = 0x0123,
    LMS7002M_0x0124 = 0x0124,
    LMS7002M_0x0200 = 0x0200,
    LMS7002M_0x0201 = 0x0201,
    LMS7002M_0x0202 = 0x0202,
    LMS7002M_0x0203 = 0x0203,
    LMS7002M_0x0204 = 0x0204,
    LMS7002M_0x0205 = 0x0205,
    LMS7002M_0x0206 = 0x0206,
    LMS7002M_0x0207 = 0x0207,
    LMS7002M_0x0208 = 0x0208,
    LMS7002M_0x020C = 0x020C,
    LMS7002M_0x0240 = 0x0240,
    LMS7002M_0x0241 = 0x0241,
    LMS7002M_0x0242 = 0x0242,
    LMS7002M_0x0243 = 0x0243,
    LMS7002M_0x0400 = 0x0400,
    LMS7002M_0x0401 = 0x0401,
    LMS7002M_0x0402 = 0x0402,
    LMS7002M_0x0403 = 0x0403,
    LMS7002M_0x0404 = 0x0404,
    LMS7002M_0x0405 = 0x0405,
    LMS7002M_0x0406 = 0x0406,
    LMS7002M_0x0407 = 0x0407,
    LMS7002M_0x0408 = 0x0408,
    LMS7002M_0x0409 = 0x0409,
    LMS7002M_0x040A = 0x040A,
    LMS7002M_0x040B = 0x040B,
    LMS7002M_0x040C = 0x040C,
    LMS7002M_0x0440 = 0x0440,
    LMS7002M_0x0441 = 0x0441,
    LMS7002M_0x0442 = 0x0442,
    LMS7002M_0x0443 = 0x0443,
    LMS7002M_0x05C0 = 0x05C0,
    LMS7002M_0x05C1 = 0x05C1,
    LMS7002M_0x05C2 = 0x05C2,
    LMS7002M_0x05C3 = 0x05C3,
    LMS7002M_0x05C4 = 0x05C4,
    LMS7002M_0x05C5 = 0x05C5,
    LMS7002M_0x05C6 = 0x05C6,
    LMS7002M_0x05C7 = 0x05C7,
    LMS7002M_0x05C8 = 0x05C8,
    LMS7002M_0x05C9 = 0x05C9,
    LMS7002M_0x05CA = 0x05CA,
    LMS7002M_0x05CB = 0x05CB,
    LMS7002M_0x05CC = 0x05CC,
};

/* All indexed registers (to store whole state) */
enum lms7002_reg_idxs {
    LMS7002M_IDX_0x0020 = 0,
    LMS7002M_IDX_0x0021 = 1,
    LMS7002M_IDX_0x0022 = 2,
    LMS7002M_IDX_0x0023 = 3,
    LMS7002M_IDX_0x0024 = 4,
    LMS7002M_IDX_0x0025 = 5,
    LMS7002M_IDX_0x0026 = 6,
    LMS7002M_IDX_0x0027 = 7,
    LMS7002M_IDX_0x0028 = 8,
    LMS7002M_IDX_0x0029 = 9,
    LMS7002M_IDX_0x002A = 10,
    LMS7002M_IDX_0x002B = 11,
    LMS7002M_IDX_0x002C = 12,
    LMS7002M_IDX_0x002E = 13,
    LMS7002M_IDX_0x002F = 14,
    LMS7002M_IDX_0x0081 = 15,
    LMS7002M_IDX_0x0082 = 16,
    LMS7002M_IDX_0x0084 = 17,
    LMS7002M_IDX_0x0085 = 18,
    LMS7002M_IDX_0x0086 = 19,
    LMS7002M_IDX_0x0087 = 20,
    LMS7002M_IDX_0x0088 = 21,
    LMS7002M_IDX_0x0089 = 22,
    LMS7002M_IDX_0x008A = 23,
    LMS7002M_IDX_0x008B = 24,
    LMS7002M_IDX_0x008C = 25,
    LMS7002M_IDX_0x008D = 26,
    LMS7002M_IDX_0x0092 = 27,
    LMS7002M_IDX_0x0093 = 28,
    LMS7002M_IDX_0x0094 = 29,
    LMS7002M_IDX_0x0095 = 30,
    LMS7002M_IDX_0x0096 = 31,
    LMS7002M_IDX_0x0097 = 32,
    LMS7002M_IDX_0x0098 = 33,
    LMS7002M_IDX_0x0099 = 34,
    LMS7002M_IDX_0x009A = 35,
    LMS7002M_IDX_0x009B = 36,
    LMS7002M_IDX_0x009C = 37,
    LMS7002M_IDX_0x009D = 38,
    LMS7002M_IDX_0x009E = 39,
    LMS7002M_IDX_0x009F = 40,
    LMS7002M_IDX_0x00A0 = 41,
    LMS7002M_IDX_0x00A1 = 42,
    LMS7002M_IDX_0x00A2 = 43,
    LMS7002M_IDX_0x00A3 = 44,
    LMS7002M_IDX_0x00A4 = 45,
    LMS7002M_IDX_0x00A5 = 46,
    LMS7002M_IDX_0x00A6 = 47,
    LMS7002M_IDX_0x00A7 = 48,
    LMS7002M_IDX_0x0100 = 49,
    LMS7002M_IDX_0x0101 = 50,
    LMS7002M_IDX_0x0102 = 51,
    LMS7002M_IDX_0x0103 = 52,
    LMS7002M_IDX_0x0104 = 53,
    LMS7002M_IDX_0x0105 = 54,
    LMS7002M_IDX_0x0106 = 55,
    LMS7002M_IDX_0x0107 = 56,
    LMS7002M_IDX_0x0108 = 57,
    LMS7002M_IDX_0x0109 = 58,
    LMS7002M_IDX_0x010A = 59,
    LMS7002M_IDX_0x010C = 60,
    LMS7002M_IDX_0x010D = 61,
    LMS7002M_IDX_0x010E = 62,
    LMS7002M_IDX_0x010F = 63,
    LMS7002M_IDX_0x0110 = 64,
    LMS7002M_IDX_0x0111 = 65,
    LMS7002M_IDX_0x0112 = 66,
    LMS7002M_IDX_0x0113 = 67,
    LMS7002M_IDX_0x0114 = 68,
    LMS7002M_IDX_0x0115 = 69,
    LMS7002M_IDX_0x0116 = 70,
    LMS7002M_IDX_0x0117 = 71,
    LMS7002M_IDX_0x0118 = 72,
    LMS7002M_IDX_0x0119 = 73,
    LMS7002M_IDX_0x011A = 74,
    LMS7002M_IDX_0x011B = 75,
    LMS7002M_IDX_0x011C = 76,
    LMS7002M_IDX_0x011D = 77,
    LMS7002M_IDX_0x011E = 78,
    LMS7002M_IDX_0x011F = 79,
    LMS7002M_IDX_0x0120 = 80,
    LMS7002M_IDX_0x0121 = 81,
    LMS7002M_IDX_0x0122 = 82,
    LMS7002M_IDX_0x0123 = 83,
    LMS7002M_IDX_0x0124 = 84,
    LMS7002M_IDX_0x0200 = 85,
    LMS7002M_IDX_0x0201 = 86,
    LMS7002M_IDX_0x0202 = 87,
    LMS7002M_IDX_0x0203 = 88,
    LMS7002M_IDX_0x0204 = 89,
    LMS7002M_IDX_0x0205 = 90,
    LMS7002M_IDX_0x0206 = 91,
    LMS7002M_IDX_0x0207 = 92,
    LMS7002M_IDX_0x0208 = 93,
    LMS7002M_IDX_0x020C = 94,
    LMS7002M_IDX_0x0240 = 95,
    LMS7002M_IDX_0x0241 = 96,
    LMS7002M_IDX_0x0242 = 97,
    LMS7002M_IDX_0x0243 = 98,
    LMS7002M_IDX_0x0400 = 99,
    LMS7002M_IDX_0x0401 = 100,
    LMS7002M_IDX_0x0402 = 101,
    LMS7002M_IDX_0x0403 = 102,
    LMS7002M_IDX_0x0404 = 103,
    LMS7002M_IDX_0x0405 = 104,
    LMS7002M_IDX_0x0406 = 105,
    LMS7002M_IDX_0x0407 = 106,
    LMS7002M_IDX_0x0408 = 107,
    LMS7002M_IDX_0x0409 = 108,
    LMS7002M_IDX_0x040A = 109,
    LMS7002M_IDX_0x040B = 110,
    LMS7002M_IDX_0x040C = 111,
    LMS7002M_IDX_0x0440 = 112,
    LMS7002M_IDX_0x0441 = 113,
    LMS7002M_IDX_0x0442 = 114,
    LMS7002M_IDX_0x0443 = 115,
    LMS7002M_IDX_0x05C0 = 116,
    LMS7002M_IDX_0x05C1 = 117,
    LMS7002M_IDX_0x05C2 = 118,
    LMS7002M_IDX_0x05C3 = 119,
    LMS7002M_IDX_0x05C4 = 120,
    LMS7002M_IDX_0x05C5 = 121,
    LMS7002M_IDX_0x05C6 = 122,
    LMS7002M_IDX_0x05C7 = 123,
    LMS7002M_IDX_0x05C8 = 124,
    LMS7002M_IDX_0x05C9 = 125,
    LMS7002M_IDX_0x05CA = 126,
    LMS7002M_IDX_0x05CB = 127,
    LMS7002M_IDX_0x05CC = 128,
    LMS7002M_IDX_COUNT = 129
};


#endif /* LMS7002M_DEFS_H */

