[![Downloads](https://img.shields.io/github/downloads/muquit/mailsend-go/total.svg)](https://github.com/muquit/mailsend-go/releases)

## Page Contents
- [Introduction](#introduction)
- [Features](#features)
- [Contributing](#contributing)
- [Synopsis](#synopsis)
- [Vulnerability Check](#vulnerability-check)
- [Version](#version)
- [Downloading and Installing](#downloading-and-installing)
  - [Installing using Homebrew on Mac](#installing-using-homebrew-on-mac)
    - [Install](#install)
    - [Uninstall](#uninstall)
  - [Installing the debian package on Ubuntu or Debian or Raspberry pi](#installing-the-debian-package-on-ubuntu-or-debian-or-raspberry-pi)
    - [Inspect the package content](#inspect-the-package-content)
    - [Install](#install-1)
    - [Uninstall](#uninstall-1)
  - [Install the RPM package](#install-the-rpm-package)
    - [Inspect the package content](#inspect-the-package-content-1)
    - [Install/Upgrade](#installupgrade)
    - [Uninstall](#uninstall-2)
  - [Install from archive](#install-from-archive)
    - [Inspect the content](#inspect-the-content)
    - [Install Linux](#install-linux)
    - [Install Windows](#install-windows)
      - [Installing using Scoop on Windows](#installing-using-scoop-on-windows)
        - [Install](#install-2)
        - [Uninstall](#uninstall-3)
      - [Installing Manually](#installing-manually)
- [Compiling](#compiling)
- [Docker](#docker)
- [Examples](#examples)
  - [Show SMTP server information](#show-smtp-server-information)
    - [StartTLS will be used if server supports it](#starttls-will-be-used-if-server-supports-it)
    - [Use SSL. Note the port is different](#use-ssl-note-the-port-is-different)
    - [Print SMTP server certificate chain](#print-smtp-server-certificate-chain)
    - [Use default settings for well known mail providers](#use-default-settings-for-well-known-mail-providers)
  - [Send mail with a text message](#send-mail-with-a-text-message)
  - [Send mail with a HTML message](#send-mail-with-a-html-message)
  - [Attach a PDF file](#attach-a-pdf-file)
  - [Attach a PDF file and an image](#attach-a-pdf-file-and-an-image)
  - [Attach a PDF file and embed an image](#attach-a-pdf-file-and-embed-an-image)
  - [Set Carbon Copy and Blind Carbon copy](#set-carbon-copy-and-blind-carbon-copy)
  - [Send mail to a list of users](#send-mail-to-a-list-of-users)
  - [Add Custom Headers](#add-custom-headers)
  - [Write logs to a file](#write-logs-to-a-file)
  - [Specify a different character set](#specify-a-different-character-set)
- [Frequently Asked Questions (FAQ)](#frequently-asked-questions-faq)
- [License (is MIT)](#license-is-mit)
- [See Also](#see-also)

# Introduction

`mailsend-go` is a command line tool to send mail via SMTP protocol. This is the
[golang](https://golang.org/) incarnation of my C version of
[mailsend](https://github.com/muquit/mailsend/). However, this version is much
simpler and all the heavy lifting is done by the package
[gomail.v2](https://gopkg.in/gomail.v2). However, this package is not maintained anymore. Therefore, I forked it to
[gomail](https://github.com/muquit/gomail) (starting from mailsend-go v1.0.11-b1 Aug-24-2025).
The main purpose of this fork is to add XOAUTH2 support (Bug #68)

If you use [mailsend](https://github.com/muquit/mailsend), please consider
using mailsend-go as no new features will be added to 
[mailsend](https://github.com/muquit/mailsend).

If you have any question, request or suggestion, please enter it in the 
[Issues](https://github.com/muquit/mailsend-go/issues) with appropriate label.

**NOTE:** XOAUTH2 support is available in v1.0.11-b1 (Released on Aug-24-2025)

Please look at [ChangeLog](ChangeLog.md) for what has changed in the current version.

# Features

* Add a mail body
* Support Multiple Attachments
* Supports ESMTP Authentication
* Supports StartTLS and SSL
* Send mail to a list of users
* Show SMTP server info
* Fixes [issues of mailsend](https://github.com/muquit/mailsend#known-issues)

# Contributing

Please send a pull request if you add features, fix bugs or update the documentation. 

If you want to update the documentation, **please do not update README.md directly**, 
rather update the Markdown files in _docs/_ directory. README.md 
is generated by [markdown_helper](https://github.com/BurdetteLamar/markdown_helper) ruby gem by
assembling the individual Markdown files in the _docs/_ directory. If you
would like to generate README.md, type `make gen` (you will need required tools of
course)

# Synopsis
```
 Version: @($) mailsend-go v1.0.11-b2
 https://github.com/muquit/mailsend-go
 Compiled with go version: go1.25.1

 mailsend-go [options]
  Where the options are:
  -debug                 - Print debug messages
  -sub subject           - Subject
  -t to,to..*            - email address/es of the recipient/s. Required
  -list file             - file with list of email addresses. 
                           Syntax is: Name, email_address
  -fname name            - name of sender
  -f address*            - email address of the sender. Required
  -cc cc,cc..            - carbon copy addresses
  -bcc bcc,bcc..         - blind carbon copy addresses
  -rt rt                 - reply to address
  -smtp host/IP          - hostname/IP address of the SMTP server. Required
                           unless '-use' is set.
  -use mailprovider      - Arranges -smtp, -port and -ssl for you when using
                           a well known mailprovider. Allowed values:
                           gmail, yahoo, outlook, gmx, zoho, aol
  -port port             - port of SMTP server. Default is 587
  -domain domain         - domain name for SMTP HELO. Default is localhost
  -info                  - Print info about SMTP server
  -printCerts            - Print Certificates in connection with -info. Default is No
  -ssl                   - SMTP over SSL. Default is StartTLS
  -verifyCert            - Verify Certificate in connection. Default is No
  -ex                    - show examples
  -help                  - show this help
  -q                     - quiet
  -log filePath          - write log messages to this file
  -cs charset            - Character set for text/HTML. Default is utf-8
  -V                     - show version and exit
  auth                   - Auth Command
   -user username*       - For basic auth: username for ESMTP authentication
                           For OAuth2: email address of the authenticated account
                           Required for both auth methods
   -pass password*       - password for ESMTP authentication. Required for basic auth
   -oauth2               - Use OAuth2 XOAUTH2 authentication instead of basic auth
   -token access_token*  - OAuth2 access token. Required when -oauth2 is used
  body                   - body command for attachment for mail body
   -msg msg              - message to show as body 
   -file path            - or path of a text/HTML file
   -mime-type type       - MIME type of the body content. Default is detected
  attach                 - attach command. Repeat for multiple attachments
   -file path*           - path of the attachment. Required
   -name name            - name of the attachment. Default is filename
   -mime-type type       - MIME-Type of the attachment. Default is detected
   -inline               - Set Content-Disposition to "inline". 
                           Default is "attachment"
  header                 - Header Command. Repeat for multiple headers
   -name header          - Header name
   -value value          - Header value

The options with * are required. 

Environment variables:
   SMTP_USER_PASS for auth password (-pass)
   SMTP_OAUTH_TOKEN for OAuth2 access token (-token)

```

# Vulnerability Check

```
➤ govulncheck --version
Go: go1.25.1
Scanner: govulncheck@v1.1.4
DB: https://vuln.go.dev
DB updated: 2025-09-24 19:21:41 +0000 UTC

No vulnerabilities found.
```

```
➤ govulncheck -show verbose ./...
Fetching vulnerabilities from the database...

Checking the code against the vulnerabilities...

The package pattern matched the following 2 root packages:
  github.com/muquit/mailsend-go/pkg/version
  github.com/muquit/mailsend-go
Govulncheck scanned the following 2 modules and the go1.25.1 standard library:
  github.com/muquit/mailsend-go
  github.com/muquit/gomail@v0.0.0-20250704205629-a34fa7a15a08

No vulnerabilities found.
```

# Version
The current stable ersion of mailsend-go is 1.0.10, released on Dec-06-2020 

The current beta version is v1.0.11-b2.  Note: v1.0.11-b1 was
the first cut with support for SMTP XOAUTH2

Please look at [ChangeLog](ChangeLog.md) for what has changed in the current version.

# Downloading and Installing

Pre-compiled `mailsend-go` binaries are available for the following platforms:

* Windows - 32 and 64 bit (zip, Scoop)
* Linux - 64 bit (tgz, debian and rpm)
* MacOS - 64 bit (tgz, Homebrew)
* Raspberry pi - 32 bit (debian, rpm)

Please download the binaries from the [releases](https://github.com/muquit/mailsend-go/releases)
page.  

Please add an [issue](https://github.com/muquit/mailsend-go/issues) if you would need binaries for any other         platforms.

Before installing, please make sure to verify the checksum.

When the tgz or zip archives are extracted they create a directory `mailsend-go-dir/` with the 
content.

**Example**

```
    $ tar -tvf mailsend-go_x.x.x_linux_64-bit.tar.gz
	-rw-r--r--  0 muquit staff    1081 Jan 26 15:21 mailsend-go-dir/LICENSE.txt
	-rw-r--r--  0 muquit staff   14242 Jan 27 13:47 mailsend-go-dir/README.md
	-rw-r--r--  0 muquit staff   16866 Jan 27 13:47 mailsend-go-dir/docs/mailsend-go.1
	-rwxr-xr-x  0 muquit staff 5052992 Feb  9 19:23 mailsend-go-dir/mailsend-go
```

```
	$ unzip -l mailsend-go_x.x.x_windows_64-bit.zip
	Archive:  mailsend-go_x.x.x_windows_64-bit.zip
	  Length      Date    Time    Name
	---------  ---------- -----   ----
		 1081  01-26-2019 15:21   mailsend-go-dir/LICENSE.txt
		14242  01-27-2019 13:47   mailsend-go-dir/README.md
		16866  01-27-2019 13:47   mailsend-go-dir/docs/mailsend-go.1
	  4933632  02-09-2019 19:23   mailsend-go-dir/mailsend-go.exe
	---------                     -------
	  4965821                     4 files
```

## Installing using Homebrew on Mac

You will need to install [Homebrew](https://brew.sh/) first.

### Install

First install the custom tap.

```
    $ brew tap
    $ brew untap muquit/mailsend-go
    $ brew tap muquit/mailsend-go
    $ brew install mailsend-go
```

### Uninstall
```
    $ brew uninstall mailsend-go
```


## Installing the debian package on Ubuntu or Debian or Raspberry pi

### Inspect the package content
```
    $ dpkg -c mailsend-go_linux_64-bit.deb
	drwxr-xr-x 0/0               0 2019-02-10 20:17 usr/
	drwxr-xr-x 0/0               0 2019-02-10 20:17 usr/local/
	drwxr-xr-x 0/0               0 2019-02-10 20:17 usr/local/share/
	drwxr-xr-x 0/0               0 2019-02-10 20:17 usr/local/share/docs/
	drwxr-xr-x 0/0               0 2019-02-10 20:17 usr/local/share/docs/mailsend-go/
	-rw-r--r-- 0/0            1081 2019-02-10 20:17 usr/local/share/docs/mailsend-go/LICENSE.txt
	drwxr-xr-x 0/0               0 2019-02-10 20:17 usr/local/bin/
	-rwxr-xr-x 0/0         5052992 2019-02-10 20:17 usr/local/bin/mailsend-go
	drwxr-xr-x 0/0               0 2019-02-10 20:17 usr/local/share/man/
	drwxr-xr-x 0/0               0 2019-02-10 20:17 usr/local/share/man/man1/
	-rw-r--r-- 0/0           20896 2019-02-10 20:17 usr/local/share/man/man1/mailsend-go.1
	-rw-r--r-- 0/0           19236 2019-02-10 20:17 usr/local/share/docs/mailsend-go/README.md
```

### Install

```
    $ sudo dpkg -i mailsend-go_linux_64-bit.deb 
	Selecting previously unselected package mailsend-go.
	(Reading database ... 4039 files and directories currently installed.)
	Preparing to unpack mailsend-go_linux_64-bit.deb ...
	Unpacking mailsend-go (x.x.x) ...
	Setting up mailsend-go (x.x.x) ...
    $ mailsend-go -V
    @(#) mailsend-go vx.x.x
```

### Uninstall

```
    $ sudo dpkg -r mailsend-go
```

## Install the RPM package

### Inspect the package content
```
    $ rpm -qlp mailsend-go_linux_64-bit.rpm
    /usr/local/bin/mailsend-go
    /usr/local/share/docs/mailsend-go/LICENSE.txt
    /usr/local/share/docs/mailsend-go/README.md
    /usr/local/share/man/man1/mailsend-go.1
```
### Install/Upgrade
```
    # rpm -Uvh mailsend-go_linux_64-bit.rpm
    # mailsend-go -V
    @(#) mailsend-go vx.x.x
```
### Uninstall
```
    # rpm -ev mailsend-go
```

## Install from archive

### Inspect the content
```
    $ tar -tvf mailsend-go_x.x.x_linux_64-bit.tar.gz
    -rw-r--r--  0 muquit staff    1081 Jan 26 15:21 mailsend-go-dir/LICENSE.txt
    -rw-r--r--  0 muquit staff   14242 Jan 27 13:47 mailsend-go-dir/README.md
    -rw-r--r--  0 muquit staff   16866 Jan 27 13:47 mailsend-go-dir/docs/mailsend-go.1
    -rwxr-xr-x  0 muquit staff 5052992 Feb  9 19:23 mailsend-go-dir/mailsend-go
```

```
    $ unzip -l mailsend-go_x.x.x_windows_64-bit.zip
    Archive:  mailsend-go_x.x.x_windows_64-bit.zip
      Length      Date    Time    Name
    ---------  ---------- -----   ----
     1081  01-26-2019 15:21   mailsend-go-dir/LICENSE.txt
    14242  01-27-2019 13:47   mailsend-go-dir/README.md
    16866  01-27-2019 13:47   mailsend-go-dir/docs/mailsend-go.1
      4933632  02-09-2019 19:23   mailsend-go-dir/mailsend-go.exe
    ---------                     -------
      4965821                     4 files
```

### Install Linux
```
    $ tar -xf mailsend-go_x.x.x_linux_64-bit.tar.gz
    $ sudo cp mailsend-go-dir/mailsend-go /usr/local/bin
    $ sudo cp mailsend-go-dir/doc/mailsend-go.1 /usr/local/share/man/man1
```

### Install Windows

#### Installing using Scoop on Windows

You will need to install [Scoop](https://scoop.sh/) first.

##### Install

```batch
c:\> scoop install mailsend-go
````

##### Uninstall

```batch
c:\> scoop uninstall mailsend-go
````

#### Installing Manually

After [downloading](#downloading-and-installing) the latest .zip file (e.g., mailsend-go_x.x.x_windows_64-bit.zip), unzip it, and copy `mailsend-go-dir\mailsend-go.exe` somewhere in your PATH or run it from the directory.

# Compiling

Compiling from scratch requires the [Go programming language toolchain](https://golang.org/dl/) and git. Note: *mailsend-go* uses [go modules](https://github.com/golang/go/wiki/Modules) for dependency management.

To install the binary:

```
    $ go install github.com/muquit/mailsend-go@latest
```
The binary will be installed at $GOPATH/bin/ directory.


If you see the error message `go: cannot find main module; see 'go help
modules'`, make sure GO111MODULE environment variable is not set to on. Unset it by
typing `unset GO111MODULE`


To compile yourself:

```
    $ git clone https://github.com/muquit/mailsend-go.git
    $ cd mailsend-go
    $ make
    $ ./mailsend-go -V
```

* List the packages used (if you are outside $GOPATH)
```
    $ go list -m "all"
    github.com/muquit/mailsend-go
    github.com/muquit/gomail v0.0.0-20250327010414-6846ede5e07d
    github.com/muquit/quotedprintable v0.0.0-20250204043250-71206103869d
```

# Docker

* Building for docker can be done with ```docker build -t mailsend-go .```. This will also fetch the golang image and create a intermediate image (about 820MB in total). If space is a concern for you, remove them with ```docker rmi golang:1.13.7``` and ```docker image prune```

* Running with docker can be done as any other docker image. Everything after the image name will be passed to the program. Example: ```docker run -it --rm mailsend-go -V``` will show the version

# Examples

Each example mailsend-go command is a single line. In Unix back slash \ 
can be used to continue in the next line. Also in Unix, use single quotes 
instead of double quotes, otherwise if input has any shell character like 
$ etc, it will get expanded by the shell.

## Show SMTP server information

### StartTLS will be used if server supports it

```
  mailsend-go -info -smtp smtp.gmail.com -port 587
```    

```
[S] 220 smtp.gmail.com ESMTP k185-v6sm17739711qkd.27 - gsmtp
[C] HELO localhost
[C] EHLO localhost
[S] 250-smtp.gmail.com at your service, [x.x.x.x]
[S] 250-SIZE 35882577
[S] 250-8BITMIME
[S] 250-STARTTLS
[S] 250-ENHANCEDSTATUSCODES
[S] 250-PIPELINING
[S] 250-CHUNKING
[S] 250-SMTPUTF8
[C] STARTTLS
[S] 220-2.0.0 Ready to start TLS
[C] EHLO localhost
[S] 250-smtp.gmail.com at your service, [x.x.x.x]
[S] 250-SIZE 35882577
[S] 250-8BITMIME
[S] 250-AUTH LOGIN PLAIN XOAUTH2 PLAIN-CLIENTTOKEN OAUTHBEARER XOAUTH
[S] 250-ENHANCEDSTATUSCODES
[S] 250-PIPELINING
[S] 250-CHUNKING
[S] 250-SMTPUTF8
Certificate of smtp.gmail.com:
 Version: 3 (0x3)
 Serial Number: 149685795415515161014990164765 (0x1e3a9301cfc7206383f9a531d)
 Signature Algorithm: SHA256-RSA
 Subject: CN=Google Internet Authority G3,O=Google Trust Services,C=US
 Issuer: GlobalSign
 Not before: 2017-06-15 00:00:42 +0000 UTC
 Not after: 2021-12-15 00:00:42 +0000 UTC
[C] QUIT
[S] 221-2.0.0 closing connection k185-v6sm17739711qkd.27 - gsmtp
```

### Use SSL. Note the port is different

```
  mailsend-go -info -smtp smtp.gmail.com -port 465 -ssl
```

### Print SMTP server certificate chain

```bash
  mailsend-go -info -smtp smtp.gmail.com -port 587 -printCerts
```

```bash
[S] 220 smtp.gmail.com ESMTP 6a1803df08f44-80166e2f32bsm34741116d6.41 - gsmtp
[C] HELO localhost
[C] EHLO localhost
[S] 250-smtp.gmail.com at your service, [x.x.x.x]
[S] 250-SIZE 35882577
[S] 250-8BITMIME
[S] 250-STARTTLS
[S] 250-ENHANCEDSTATUSCODES
[S] 250-PIPELINING
[S] 250-CHUNKING
[S] 250-SMTPUTF8
[C] STARTTLS
[S] 220-2.0.0 Ready to start TLS
[C] EHLO localhost
[S] 250-smtp.gmail.com at your service, [x.x.x.x]
[S] 250-SIZE 35882577
[S] 250-8BITMIME
[S] 250-AUTH LOGIN PLAIN XOAUTH2 PLAIN-CLIENTTOKEN OAUTHBEARER XOAUTH
[S] 250-ENHANCEDSTATUSCODES
[S] 250-PIPELINING
[S] 250-CHUNKING
[S] 250-SMTPUTF8
[C] QUIT
[S] 221-2.0.0 closing connection 6a1803df08f44-80166e2f32bsm34741116d6.41 - gsmtp

=== TLS Connection Information ===
TLS Version: TLS 1.3
Cipher Suite: 0x1301
Server Name: smtp.gmail.com
Negotiated Protocol:

Certificate Chain (3 certificates):

--- Certificate 1 ---
Subject: CN=smtp.gmail.com
Issuer: CN=WR2,O=Google Trust Services,C=US
Serial Number: 14461562026188826353951632455228095006
Not Before: 2025-09-08T08:36:45Z
Not After: 2025-12-01T08:36:44Z
Is CA: false
DNS Names: smtp.gmail.com
Key Usage: Digital Signature
Status: Valid

--- Certificate 2 ---
Subject: CN=WR2,O=Google Trust Services,C=US
Issuer: CN=GTS Root R1,O=Google Trust Services LLC,C=US
Serial Number: 170058220837755766831192027518741805976
Not Before: 2023-12-13T09:00:00Z
Not After: 2029-02-20T14:00:00Z
Is CA: true
Key Usage: Digital Signature, Certificate Sign, CRL Sign
Status: Valid

--- Certificate 3 ---
Subject: CN=GTS Root R1,O=Google Trust Services LLC,C=US
Issuer: CN=GlobalSign Root CA,OU=Root CA,O=GlobalSign nv-sa,C=BE
Serial Number: 159159747900478145820483398898491642637
Not Before: 2020-06-19T00:00:42Z
Not After: 2028-01-28T00:00:42Z
Is CA: true
Key Usage: Digital Signature, Certificate Sign, CRL Sign
Status: Valid

--- Certificate Fingerprints (Leaf) ---
SHA-1: 28:88:45:90:10:20:88:BA:87:2E:0E:7C:3A:12:D6:35:EC:26:AE:90
SHA-256: 6F:F8:E2:F5:D4:AE:5A:FF:92:4A:5F:AC:88:80:14:3A:30:33:7A:CF:EE:33:94:82:EF:2A:93:47:80:E4:18:EF
=====================================
```

```bash
   mailsend-go -info -smtp smtp.gmail.com -port 465 -ssl -printCerts
```

```bash
[S] 220 smtp.gmail.com ESMTP 6a1803df08f44-80166781d27sm35134546d6.45 - gsmtp
[C] HELO localhost
[C] EHLO localhost
[S] 250-smtp.gmail.com at your service, [x.x.x.x]
[S] 250-SIZE 35882577
[S] 250-8BITMIME
[S] 250-AUTH LOGIN PLAIN XOAUTH2 PLAIN-CLIENTTOKEN OAUTHBEARER XOAUTH
[S] 250-ENHANCEDSTATUSCODES
[S] 250-PIPELINING
[S] 250-CHUNKING
[S] 250-SMTPUTF8
[C] QUIT
[S] 221-2.0.0 closing connection 6a1803df08f44-80166781d27sm35134546d6.45 - gsmtp

=== TLS Connection Information ===
TLS Version: TLS 1.3
Cipher Suite: 0x1301
Server Name: smtp.gmail.com
Negotiated Protocol:

Certificate Chain (3 certificates):

--- Certificate 1 ---
Subject: CN=smtp.gmail.com
Issuer: CN=WR2,O=Google Trust Services,C=US
Serial Number: 14461562026188826353951632455228095006
Not Before: 2025-09-08T08:36:45Z
Not After: 2025-12-01T08:36:44Z
Is CA: false
DNS Names: smtp.gmail.com
Key Usage: Digital Signature
Status: Valid

--- Certificate 2 ---
Subject: CN=WR2,O=Google Trust Services,C=US
Issuer: CN=GTS Root R1,O=Google Trust Services LLC,C=US
Serial Number: 170058220837755766831192027518741805976
Not Before: 2023-12-13T09:00:00Z
Not After: 2029-02-20T14:00:00Z
Is CA: true
Key Usage: Digital Signature, Certificate Sign, CRL Sign
Status: Valid

--- Certificate 3 ---
Subject: CN=GTS Root R1,O=Google Trust Services LLC,C=US
Issuer: CN=GlobalSign Root CA,OU=Root CA,O=GlobalSign nv-sa,C=BE
Serial Number: 159159747900478145820483398898491642637
Not Before: 2020-06-19T00:00:42Z
Not After: 2028-01-28T00:00:42Z
Is CA: true
Key Usage: Digital Signature, Certificate Sign, CRL Sign
Status: Valid

--- Certificate Fingerprints (Leaf) ---
SHA-256: 6F:F8:E2:F5:D4:AE:5A:FF:92:4A:5F:AC:88:80:14:3A:30:33:7A:CF:EE:33:94:82:EF:2A:93:47:80:E4:18:EF
SHA-1: 28:88:45:90:10:20:88:BA:87:2E:0E:7C:3A:12:D6:35:EC:26:AE:90
=====================================
```

```bash
    mailsend-go -info -smtp smtp-mail.outlook.com -port 587 -printCerts
```

```bash
[S] 220 MN2PR01CA0065.outlook.office365.com Microsoft ESMTP MAIL Service ready at Sat, 27 Sep 2025 00:29:10 +0000 [08DDFAA3FED0C1E0]
[C] HELO localhost
[C] EHLO localhost
[S] 250-MN2PR01CA0065.outlook.office365.com Hello [x.x.x.x]
[S] 250-SIZE 157286400
[S] 250-PIPELINING
[S] 250-DSN
[S] 250-ENHANCEDSTATUSCODES
[S] 250-STARTTLS
[S] 250-8BITMIME
[S] 250-BINARYMIME
[S] 250-CHUNKING
[S] 250-SMTPUTF8
[C] STARTTLS
[S] 220-2.0.0 SMTP server ready
[C] EHLO localhost
[S] 250-MN2PR01CA0065.outlook.office365.com Hello [x.x.x.x]
[S] 250-SIZE 157286400
[S] 250-PIPELINING
[S] 250-DSN
[S] 250-ENHANCEDSTATUSCODES
[S] 250-AUTH LOGIN XOAUTH2
[S] 250-8BITMIME
[S] 250-BINARYMIME
[S] 250-CHUNKING
[S] 250-SMTPUTF8
[C] QUIT
[S] 221-2.0.0 Service closing transmission channel

=== TLS Connection Information ===
TLS Version: TLS 1.3
Cipher Suite: 0x1302
Server Name: smtp-mail.outlook.com
Negotiated Protocol:

Certificate Chain (2 certificates):

--- Certificate 1 ---
Subject: CN=outlook.com,O=Microsoft Corporation,L=Redmond,ST=Washington,C=US
Issuer: CN=DigiCert Cloud Services CA-1,O=DigiCert Inc,C=US
Serial Number: 10535063011692331098818316272276424549
Not Before: 2025-03-29T00:00:00Z
Not After: 2026-03-28T23:59:59Z
Is CA: false
DNS Names: *.clo.footprintdns.com, *.hotmail.com, *.internal.outlook.com, *.live.com, *.nrb.footprintdns.com, *.office.com, *.office365.com, *.outlook.com, *.outlook.office365.com, attachment.outlook.live.net, attachment.outlook.office.net, attachment.outlook.officeppe.net, attachments.office.net, attachments-sdf.office.net, ccs.login.microsoftonline.com, ccs-sdf.login.microsoftonline.com, hotmail.com, mail.services.live.com, office365.com, outlook.com, outlook.office.com, substrate.office.com, substrate-sdf.office.com
Key Usage: Digital Signature, Key Encipherment
Status: Valid

--- Certificate 2 ---
Subject: CN=DigiCert Cloud Services CA-1,O=DigiCert Inc,C=US
Issuer: CN=DigiCert Global Root CA,OU=www.digicert.com,O=DigiCert Inc,C=US
Serial Number: 20058375873168194746987232153701302504
Not Before: 2020-09-25T00:00:00Z
Not After: 2030-09-24T23:59:59Z
Is CA: true
Key Usage: Digital Signature, Certificate Sign, CRL Sign
Status: Valid

--- Certificate Fingerprints (Leaf) ---
SHA-1: A6:F7:EC:FB:2B:F6:31:B3:A8:4F:EB:B0:9F:FD:BB:4E:3B:0F:42:11
SHA-256: 4F:94:1A:8E:50:52:5E:09:24:4F:8F:FE:75:65:E1:6A:51:DD:10:47:04:74:94:6A:0F:BA:84:6A:86:E4:DE:8C
=====================================
```

### Use default settings for well known mail providers

Don't worry about the settings of -smtp, -port and -ssl for well known mail
providers. This works for gmail, yahoo, outlook, gmx, zoho and aol.

      mailsend-go -info -use gmail

## Send mail with a text message

Notice "auth" is a command and it takes -user and -pass arguments. "body" is
also a command and here it took -msg as an argument. The command "body" can
not repeat, if specified more than once, the last one will be used.

```
    mailsend-go -sub "Test"  -smtp smtp.gmail.com -port 587 \
     auth \
      -user jsnow@gmail.com -pass "secret" \
     -from "jsnow@gmail.com" -to  "mjane@example.com" \
     body \
       -msg "hello, world!\nThis is a message"
```                    
The embedded new line \\n will be converted to a real newline and the final
message will show up as two lines.

The environment variable "SMTP_USER_PASS" can be used instead of the flag
`-pass`.

## Send mail with a HTML message
```
    mailsend-go -sub "Test"  \
    -smtp smtp.gmail.com -port 587 \
    auth \
     -user jsnow@gmail.com -pass "secret" \
    -from "jsnow@gmail.com"  \
    -to  "mjane@example.com" -from "jsnow@gmail.com" \
    body \
     -msg "<b>hello, world!</b>"
```

## Attach a PDF file
MIME type will be detected. Content-Disposition will be set to "attachment",
Content-Transfer-Encoding will be "Base64". Notice, "attach" is a command it
took -file as an arg. The command "attach" can repeat.
```
    mailsend-go -sub "Test"  \
    -smtp smtp.gmail.com -port 587 \
    auth \
     -user jsnow@gmail.com -pass "secret" \
    -from "jsnow@gmail.com"  \
    -to  "mjane@example.com" -from "jsnow@gmail.com" \
    body \
     -msg "A PDF file is attached" \
    attach \
     -file "/path/file.pdf"
```
The name of the attachment will be file.pdf. To change the attachmetn name,
use the `-name` flag. e.g.

```
    attach -file "/path/file.pdf" -name "report.pdf"
```

## Attach a PDF file and an image
Notice, the "attach" command is repeated here.
```
    mailsend-go -sub "Test"  \
    -smtp smtp.gmail.com -port 587 \
    auth \
     -user jsnow@gmail.com -pass "secret" \
    -from "jsnow@gmail.com"  \
    -to  "mjane@example.com" -from "jsnow@gmail.com" \
    body \
     -msg "A PDF file and a PNG file is attached" \
    attach \
     -file "/path/file.pdf" \
    attach \
     -file "/path/file.png"
```
## Attach a PDF file and embed an image
Content-Disposition for the image will be set to "inline". It's an hint to the
mail reader to display the image on the page. Note: it is just a hint, it is
up to the mail reader to respect it or ignore it.
```
    mailsend-go -sub "Test"  \
    -smtp smtp.gmail.com -port 587 \
    auth \
     -user jsnow@gmail.com -pass "secret" \
    -from "jsnow@gmail.com"  \
    -to  "mjane@example.com" -from "jsnow@gmail.com" \
    body \
     -msg "A PDF file is attached, image should be displayed inline" \
    attach \
     -file "/path/file.pdf" \
    attach \
     -file "/path/file.png" \
     -inline
```
## Set Carbon Copy and Blind Carbon copy
```
    mailsend-go -sub "Testing -cc and -bcc" \
    -smtp smtp.gmail.com -port 587 \
    auth \
     -user example@gmail.com -pass "secret" \
     -to jsoe@example.com \
     -f "example@gmail.com" \
     -cc "user1@example.com,user2@example.com" \
     -bcc "foo@example.com" \
     body -msg "Testing Carbon Copy and Blind Carbon copy"
```
Cc addresses will be visible to the recipients but Bcc address will not be.

## Send mail to a list of users

Create a file with list of users. The syntax is ```Name,email_address``` in a line. Name can be empty but comma must be specified. Example of a list file:

```
    # This is a comment.
    # The syntax is Name,email address in a line. Name can be empty but comma 
    # must be specified
    John Snow,jsnow@example.com
    Mary Jane,mjane@example.com
    ,foobar@example.com
```

Specify the list file with ```-list``` flag. 

```
    mailsend-go -sub "Test sending mail to a list of users" \
    -smtp smtp.gmail.com -port 587 \
    auth \
     -user example@gmail.com -pass "secret" \
        -f "me@example.com" \
        -to "xyz@example.com" \
        body \
        -msg "This is a test of sendmail mail to a list of users" \
        attach \
            -file "cat.jpg" \
         attach \
            -file "flower.jpg" \
            -inline \
         -list "list.txt"
```

## Add Custom Headers

Use the command "header" to add custom headers. The command "header" can be
repeated.

```
    mailsend-go -sub "Testing custom headers" \
    -smtp smtp.gmail.com -port 587 \
    auth \
     -user example@gmail.com -pass "secret" \
     -to jdoe@example.com \
     -f "example@gmail.com" \
     body -msg "Testing adding Custom headers"
     header \
         -name "X-MyHeader-1" -value "Value of X-MyHeader-1" \
     header \
         -name "X-MyHeader-2" -value "Value of X-MyHeader-2"

```

## Write logs to a file

Use the flag `-log path_of_log_file.txt`

```
    mailsend-go -sub "test log" \
     -smtp smtp.example.com -port 587 \
     auth \
      -user example@gmail.com -pass "secret" \
      -to jdoe@example.com \
      -f "example@gmail.com" \
      body -msg "Testing log file" \
      -log "/tmp/mailsend-go.log"
```

## Specify a different character set

The default character set is utf-8

```
    mailsend-go -sub "test character set" \
     -smtp smtp.example.com -port 587 \
     auth \
      -user example@gmail.com -pass "secret" \
      -to jdoe@example.com \
      -from "example@gmail.com" \
      -subject "Testing Big5 Charset" \
      -cs "Big5" \
      body -msg "中文測試"

```

---

(Generated from docs/examples.md)

---

# Frequently Asked Questions (FAQ)

**1. How to send mail via smtp.gmail.com?**

From May 30, 2022, Google no longer supports the use of third-party apps to sign in to Google Account using username and password. However, an app-specific password can be set for mailsend-go to send mail via smtp.gmail.com. Here are the steps:

- Login to your gmail account
- Click on the Profile icon at the right side and then click on **Manage your Google Account**
- Click on **Security** link from the list on the left sidebar.
- Now you have to enable 2FA (Two Factor Authentication). Think carefully if you are going to do that for your main account. I used a test account and it does not seem to ask for 2FA code while sending email using smtp.gmail.com. However, it will require to enter 2FA code when you login to gmail.com. By default it sends 2FA code to your phone#, which is not secure. Configure to use Google Authenticator App instead for 2FA.
- After 2FA is enabled, Click on **Security** link again. Select 2-Step Verification. Generate the app specific password by clicking on the **App Passwords** link. Specify mailsend-go as the app (I don't think it matters).
- Use the username and this app specific password to send mail via smtp.gmail.com. It does not seem to ask for 2FA code.

If there are any gotchas or need more clarification, please send a pull request or update Issue #49 with your experience and I will update the FAQ.

```
-- updated: Jul-01-2022
```

# License (is MIT)

License is MIT

Copyright © 2018-2025 muquit@muquit.com

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

# See Also

Original [mailsend](https://github.com/muquit/mailsend) (in C)

---
* This file is assembled from docs/*.md with [markdown_helper](https://github.com/BurdetteLamar/markdown_helper)
* The software is released with [go-xbuild-go](https://github.com/muquit/go-xbuild-go)
