/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.controls;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.PropertyBag;
import com.paterva.maltego.imgfactoryapi.ImageFactory;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.editing.AttachmentUtils;
import com.paterva.maltego.typing.editing.GenericPropertyBag;
import com.paterva.maltego.typing.editing.attachments.AttachmentNode;
import com.paterva.maltego.typing.editing.attachments.AttachmentsAddAction;
import com.paterva.maltego.typing.editing.attachments.AttachmentsNode;
import com.paterva.maltego.typing.editing.attachments.AttachmentsPropertiesNode;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.util.FileSize;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.ImageUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.swing.outline.RenderDataProvider;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.OutlineView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class AttachmentsEditorPanel
extends TopComponent
implements ExplorerManager.Provider,
Lookup.Provider {
    private static final int THUMB_HEIGHT = 64;
    private static final String BASE64_PROP_IMAGE_TEXT = "Set Base64 Property as Entity Image";
    private static final String BASE64_PROP_TEXT = "Set Base64 Property";
    private final ExplorerManager _explorer;
    private final Lookup _lookup;
    private final PropertyChangeListener _listener;
    private final MaltegoPart _part;
    private final boolean _cancellable;
    private final Color _descriptionFg = UIManager.getLookAndFeelDefaults().getColor("7-description-foreground");
    private final ActionListener _setBase64Click;
    private Attachment _newEntityImage;
    private JButton _attachButton;
    private JButton _deleteButton;
    private JButton _entityBase64ImageButton;
    private JButton _entityImageButton;
    private OutlineView _outlineView;
    private JLabel _selectedLabel;
    private JLabel _selectedTitleLabel;
    private JLabel _sizeLabel;
    private JLabel _sizeTitleLabel;
    private JLabel _thumbnail;
    private JLabel _typeLabel;
    private JLabel _typeTitleLabel;
    private JPanel jPanel2;
    private JPanel jPanel5;

    public AttachmentsEditorPanel(MaltegoPart part, boolean cancellable, ActionListener evt) {
        this._part = part;
        this._cancellable = cancellable;
        this._newEntityImage = null;
        this._listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AttachmentsEditorPanel.this.updateSelectionChanged();
            }
        };
        this._explorer = new ExplorerManager();
        this._explorer.addPropertyChangeListener(this._listener);
        this._setBase64Click = evt;
        this.initComponents();
        this._outlineView.getOutline().setRootVisible(false);
        this._outlineView.getOutline().setDragEnabled(true);
        this._outlineView.setPropertyColumns(new String[]{"Source", "Source", "Size", "Size", "Type", "Type"});
        TableColumnModel columns = this._outlineView.getOutline().getColumnModel();
        TableColumn column = columns.getColumn(1);
        column.setMinWidth(10);
        column.setPreferredWidth(100);
        column = columns.getColumn(2);
        column.setMinWidth(10);
        column.setMaxWidth(80);
        column.setPreferredWidth(60);
        column = columns.getColumn(3);
        column.setMinWidth(10);
        column.setMaxWidth(80);
        column.setPreferredWidth(50);
        this._outlineView.getOutline().setAutoCreateColumnsFromModel(false);
        RenderDataProvider defaultRenderDataProvider = this._outlineView.getOutline().getRenderDataProvider();
        RowHighlightRenderProvider newRenderDataProvider = new RowHighlightRenderProvider(defaultRenderDataProvider);
        this._outlineView.getOutline().setRenderDataProvider((RenderDataProvider)newRenderDataProvider);
        this.setAttachments(new Attachments());
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this._explorer));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this._explorer));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this._explorer));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this._explorer, (boolean)true));
        InputMap keys = this.getInputMap(1);
        keys.put(Utilities.stringToKey((String)"D-C"), "copy-to-clipboard");
        keys.put(Utilities.stringToKey((String)"D-X"), "cut-to-clipboard");
        keys.put(Utilities.stringToKey((String)"D-V"), "paste-from-clipboard");
        keys.put(KeyStroke.getKeyStroke("DELETE"), "delete");
        this._lookup = ExplorerUtils.createLookup((ExplorerManager)this._explorer, (ActionMap)map);
        this.associateLookup(this._lookup);
        map = this._outlineView.getOutline().getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this._explorer));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this._explorer));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this._explorer));
        keys = this._outlineView.getOutline().getInputMap(1);
        keys.put(Utilities.stringToKey((String)"D-C"), "copy-to-clipboard");
        keys.put(Utilities.stringToKey((String)"D-X"), "cut-to-clipboard");
        keys.put(Utilities.stringToKey((String)"D-V"), "paste-from-clipboard");
        this._entityImageButton.setVisible(this._part instanceof MaltegoEntity);
    }

    public ExplorerManager getExplorerManager() {
        return this._explorer;
    }

    public Lookup getLookup() {
        return this._lookup;
    }

    protected void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this._explorer, (boolean)true);
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this._explorer, (boolean)false);
    }

    public final void setPropertyBag(PropertyBag propertyBag) {
        List<PropertyDescriptor> pds;
        if (!AttachmentUtils.hasAttachmentsProperty(propertyBag)) {
            AttachmentUtils.addAttachmentsProperty(propertyBag);
        }
        AbstractNode rootNode = (pds = AttachmentUtils.getPropertyDescriptors(propertyBag)).size() == 1 ? new AttachmentsNode(propertyBag, pds.get(0), this.getActionMap()) : new AttachmentsPropertiesNode(propertyBag);
        this._explorer.setRootContext((Node)rootNode);
        propertyBag.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this._listener, (Object)propertyBag));
        this.initialUpdate();
    }

    public final void setAttachments(Attachments atts) {
        this._newEntityImage = null;
        GenericPropertyBag propertyBag = new GenericPropertyBag();
        this.addAttachmentsProperty(propertyBag, atts);
        this.setPropertyBag(propertyBag);
    }

    private void addAttachmentsProperty(GenericPropertyBag propertyBag, Attachments atts) {
        PropertyDescriptor pd = new PropertyDescriptor(Attachments.class, "Attachments");
        propertyBag.addProperty(pd);
        propertyBag.setValue(pd, new Attachments(atts));
    }

    public Attachments getAttachments() {
        Node root = this._explorer.getRootContext();
        PropertyBag propertyBag = (PropertyBag)root.getLookup().lookup(PropertyBag.class);
        PropertyDescriptorCollection properties = propertyBag.getProperties();
        if (properties.size() != 1) {
            throw new IllegalStateException();
        }
        Iterator iterator = properties.iterator();
        if (iterator.hasNext()) {
            PropertyDescriptor pd = (PropertyDescriptor)iterator.next();
            return new Attachments((Attachments)propertyBag.getValue(pd));
        }
        return null;
    }

    public void applyNewEntityImageAttachment() {
        if (this._newEntityImage != null) {
            AttachmentUtils.setAttachmentAsEntityImage((MaltegoEntity)this._part, this._newEntityImage);
        }
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        this._thumbnail = new JLabel();
        JPanel jPanel3 = new JPanel();
        this._selectedLabel = new JLabel();
        this._sizeLabel = new JLabel();
        this._typeLabel = new JLabel();
        this._selectedTitleLabel = new JLabel();
        this._sizeTitleLabel = new JLabel();
        this._typeTitleLabel = new JLabel();
        this.jPanel5 = new JPanel();
        JPanel jPanel4 = new JPanel();
        this._outlineView = new OutlineView("File");
        this.jPanel2 = new JPanel();
        this._attachButton = new JButton();
        this._deleteButton = new JButton();
        this._entityImageButton = new JButton();
        this._entityBase64ImageButton = new JButton();
        this.setLayout(new BorderLayout());
        jPanel1.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel1.setLayout(new BorderLayout());
        this._thumbnail.setText(NbBundle.getMessage(AttachmentsEditorPanel.class, (String)"AttachmentsEditorPanel._thumbnail.text"));
        this._thumbnail.setVerticalAlignment(1);
        jPanel1.add((Component)this._thumbnail, "West");
        jPanel3.setLayout(new GridBagLayout());
        this._selectedLabel.setForeground(this._descriptionFg);
        this._selectedLabel.setText(NbBundle.getMessage(AttachmentsEditorPanel.class, (String)"AttachmentsEditorPanel._selectedLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        jPanel3.add((Component)this._selectedLabel, gridBagConstraints);
        this._sizeLabel.setForeground(this._descriptionFg);
        this._sizeLabel.setText(NbBundle.getMessage(AttachmentsEditorPanel.class, (String)"AttachmentsEditorPanel._sizeLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        jPanel3.add((Component)this._sizeLabel, gridBagConstraints);
        this._typeLabel.setForeground(this._descriptionFg);
        this._typeLabel.setText(NbBundle.getMessage(AttachmentsEditorPanel.class, (String)"AttachmentsEditorPanel._typeLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        jPanel3.add((Component)this._typeLabel, gridBagConstraints);
        this._selectedTitleLabel.setHorizontalAlignment(4);
        this._selectedTitleLabel.setText(NbBundle.getMessage(AttachmentsEditorPanel.class, (String)"AttachmentsEditorPanel._selectedTitleLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        jPanel3.add((Component)this._selectedTitleLabel, gridBagConstraints);
        this._sizeTitleLabel.setHorizontalAlignment(4);
        this._sizeTitleLabel.setText(NbBundle.getMessage(AttachmentsEditorPanel.class, (String)"AttachmentsEditorPanel._sizeTitleLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        jPanel3.add((Component)this._sizeTitleLabel, gridBagConstraints);
        this._typeTitleLabel.setHorizontalAlignment(4);
        this._typeTitleLabel.setText(NbBundle.getMessage(AttachmentsEditorPanel.class, (String)"AttachmentsEditorPanel._typeTitleLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        jPanel3.add((Component)this._typeTitleLabel, gridBagConstraints);
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add((Component)this.jPanel5, gridBagConstraints);
        jPanel1.add((Component)jPanel3, "Center");
        this.add(jPanel1, "South");
        jPanel4.setPreferredSize(new Dimension(450, 300));
        jPanel4.setLayout(new BorderLayout());
        this._outlineView.setBorder((Border)BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getLookAndFeelDefaults().getColor("darculaMod.borderColor")));
        jPanel4.add((Component)this._outlineView, "Center");
        this.add(jPanel4, "Center");
        this.jPanel2.setLayout(new FlowLayout(0, 10, 10));
        this._attachButton.setText(NbBundle.getMessage(AttachmentsEditorPanel.class, (String)"AttachmentsEditorPanel._attachButton.text"));
        this._attachButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttachmentsEditorPanel.this._attachButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this._attachButton);
        this._deleteButton.setText(NbBundle.getMessage(AttachmentsEditorPanel.class, (String)"AttachmentsEditorPanel._deleteButton.text"));
        this._deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttachmentsEditorPanel.this._deleteButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this._deleteButton);
        this._entityImageButton.setText(NbBundle.getMessage(AttachmentsEditorPanel.class, (String)"AttachmentsEditorPanel._entityImageButton.text"));
        this._entityImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttachmentsEditorPanel.this._entityImageButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this._entityImageButton);
        this._entityBase64ImageButton.setText(BASE64_PROP_IMAGE_TEXT);
        this._entityBase64ImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttachmentsEditorPanel.this._entityBase64ImageButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this._entityBase64ImageButton);
        this.add(this.jPanel2, "North");
    }

    private void _attachButtonActionPerformed(ActionEvent evt) {
        AttachmentsAddAction action = (AttachmentsAddAction)SystemAction.get(AttachmentsAddAction.class);
        action.performAction(new Node[]{this.getFirstAttachmentsNode()});
    }

    private void _deleteButtonActionPerformed(ActionEvent evt) {
        ExplorerUtils.actionDelete((ExplorerManager)this._explorer, (boolean)true).actionPerformed(null);
    }

    private void _entityImageButtonActionPerformed(ActionEvent evt) {
        Attachment att = this.getSelectedAttachments().get(0);
        if (this._cancellable) {
            this._newEntityImage = att;
        } else {
            AttachmentUtils.setAttachmentAsEntityImage((MaltegoEntity)this._part, att);
        }
    }

    private void _entityBase64ImageButtonActionPerformed(ActionEvent evt) {
        Boolean success;
        Attachment att = this.getSelectedAttachments().get(0);
        if (!this._cancellable && (success = Boolean.valueOf(AttachmentUtils.setAttachmentAsBase64Prop((MaltegoEntity)this._part, true, att))).booleanValue() && this._setBase64Click != null) {
            this._setBase64Click.actionPerformed(evt);
        }
    }

    private void initialUpdate() {
        this.updateInfoBox();
        this.updateDeleteButton();
        this.updateEntityImageButton();
        this.updateEntityBase64ImageButton();
        this._attachButton.setEnabled(this.getFirstAttachmentsNode() != null);
    }

    private void updateSelectionChanged() {
        this.updateInfoBox();
        this.updateDeleteButton();
        this.updateEntityImageButton();
        this.updateEntityBase64ImageButton();
    }

    private void updateDeleteButton() {
        this._deleteButton.setEnabled(this.getSelectedAttachments().size() > 0);
    }

    private void updateEntityImageButton() {
        List<Attachment> selectedAtts;
        boolean enabled = false;
        if (this._part instanceof MaltegoEntity && (selectedAtts = this.getSelectedAttachments()).size() == 1) {
            enabled = this.isImageType(selectedAtts.get(0));
        }
        this._entityImageButton.setEnabled(enabled);
    }

    private void updateEntityBase64ImageButton() {
        List<Attachment> selectedAtts;
        boolean enabled = false;
        if (!this._cancellable && this._part instanceof MaltegoEntity && (selectedAtts = this.getSelectedAttachments()).size() == 1) {
            enabled = true;
            this._entityBase64ImageButton.setText(this.isImageType(selectedAtts.get(0)) ? BASE64_PROP_IMAGE_TEXT : BASE64_PROP_TEXT);
        }
        this._entityBase64ImageButton.setEnabled(enabled);
    }

    private void updateInfoBox() {
        this.updateInfoThumbnail();
        this.updateInfoName();
        this.updateInfoSize();
        this.updateInfoType();
    }

    private void updateInfoThumbnail() {
        Image image = null;
        List<Attachment> atts = this.getSelectedAttachments();
        if (!atts.isEmpty()) {
            if (atts.size() > 1) {
                image = this.createCascadingThumbnail(atts);
            } else {
                Attachment att = atts.get(0);
                image = ImageFactory.getDefault().getImage((Object)att, null);
                if (image != null && image.getHeight(null) > 64) {
                    image = ImageFactory.getDefault().getImage((Object)att, -1, 64, null);
                }
            }
        }
        this._thumbnail.setIcon(ImageUtils.toIcon(image));
    }

    private void updateInfoName() {
        List<Attachment> atts = this.getSelectedAttachments();
        String selectedText = !atts.isEmpty() ? (atts.size() == 1 ? atts.get(0).getFileName() : Integer.toString(atts.size()) + " items selected") : Integer.toString(this.getAttachmentCount()) + " items";
        this._selectedLabel.setText(selectedText);
    }

    private void updateInfoSize() {
        List<Attachment> atts = this.getSelectedAttachments();
        long size = !atts.isEmpty() ? AttachmentUtils.getSize(atts) : (long)this.getAttachmentsSize();
        this._sizeLabel.setText(new FileSize(size).toString());
    }

    private void updateInfoType() {
        HashSet<String> types = new HashSet<String>();
        List<Attachment> atts = this.getSelectedAttachments();
        String typeStr = " ";
        if (atts.size() == 1) {
            Attachment att = atts.get(0);
            typeStr = this.getFileType(att);
        } else {
            if (!atts.isEmpty()) {
                for (Attachment att : atts) {
                    types.add(this.getFileType(att));
                }
            }
            if (!types.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (String type : types) {
                    sb.append(type);
                    sb.append("/");
                }
                typeStr = sb.substring(0, sb.length() - 1);
            }
        }
        this._typeLabel.setText(typeStr);
    }

    private String getFileType(Attachment att) {
        return FileUtilities.getFileType((String)att.getFileName());
    }

    private Image createCascadingThumbnail(List<Attachment> atts) {
        int MAX_IMAGES = 3;
        int X_INCREMENT = 10;
        int Y_INCREMENT = 5;
        int imgCount = Math.min(3, atts.size());
        int heightPerImg = 64 - (imgCount - 1) * 5;
        ArrayList<Image> images = new ArrayList<Image>();
        int width = 0;
        for (int i = 0; images.size() < imgCount && i < atts.size(); ++i) {
            Attachment att = atts.get(i);
            Image image = ImageFactory.getDefault().getImage((Object)att, null);
            if (image == null) continue;
            if (image.getHeight(null) > heightPerImg) {
                image = ImageFactory.getDefault().getImage((Object)att, -1, heightPerImg, null);
            }
            if (((BufferedImage)image).getRaster().getNumBands() != 4) continue;
            width = Math.max(width, image.getWidth(null) + images.size() * 10);
            images.add(image);
        }
        if (width == 0) {
            return null;
        }
        BufferedImage img = new BufferedImage(width, 64, 2);
        Graphics2D g = img.createGraphics();
        int xOffset = 0;
        int yOffset = 0;
        RescaleOp rescaleOp = new RescaleOp(new float[]{1.0f, 1.0f, 1.0f, 0.8f}, new float[4], null);
        for (Image image : images) {
            g.drawImage((BufferedImage)image, rescaleOp, xOffset, yOffset);
            xOffset += 10;
            yOffset += 5;
        }
        g.dispose();
        return img;
    }

    private List<Attachment> getSelectedAttachments() {
        Node[] selectedNodes = this._explorer.getSelectedNodes();
        ArrayList<Attachment> atts = new ArrayList<Attachment>();
        for (Node node : selectedNodes) {
            if (!(node instanceof AttachmentNode)) continue;
            atts.add((Attachment)node.getLookup().lookup(Attachment.class));
        }
        return atts;
    }

    private int getAttachmentCount() {
        Node root = this._explorer.getRootContext();
        PropertyBag propertyBag = (PropertyBag)root.getLookup().lookup(PropertyBag.class);
        return AttachmentUtils.getAttachmentCount(propertyBag);
    }

    private int getAttachmentsSize() {
        Node root = this._explorer.getRootContext();
        PropertyBag propertyBag = (PropertyBag)root.getLookup().lookup(PropertyBag.class);
        return AttachmentUtils.getAttachmentsSize(propertyBag);
    }

    private Node getFirstAttachmentsNode() {
        Node node = this._explorer.getRootContext();
        if (node instanceof AttachmentsPropertiesNode) {
            Node[] nodes = node.getChildren().getNodes(true);
            node = null;
            if (nodes.length > 0 && nodes[0] instanceof AttachmentsNode) {
                node = nodes[0];
            }
        }
        return node;
    }

    private boolean isImageType(Attachment att) {
        return "Image".equals(FileUtilities.getFileType((String)att.getFileName()));
    }

    private class RowHighlightRenderProvider
    implements RenderDataProvider {
        private final Color _highlightColor = UIManager.getLookAndFeelDefaults().getColor("darcula.selectionBackground");
        private final RenderDataProvider _delegate;

        public RowHighlightRenderProvider(RenderDataProvider delegate) {
            this._delegate = delegate;
        }

        public boolean isHtmlDisplayName(Object o) {
            return this._delegate.isHtmlDisplayName(o);
        }

        public String getTooltipText(Object o) {
            return this._delegate.getTooltipText(o);
        }

        public Icon getIcon(Object o) {
            return this._delegate.getIcon(o);
        }

        public Color getForeground(Object o) {
            return this._delegate.getForeground(o);
        }

        public String getDisplayName(Object o) {
            return this._delegate.getDisplayName(o);
        }

        public Color getBackground(Object o) {
            if (AttachmentsEditorPanel.this._part instanceof MaltegoEntity) {
                MaltegoEntity entity = (MaltegoEntity)AttachmentsEditorPanel.this._part;
                Node node = Visualizer.findNode((Object)o);
                if (node instanceof AttachmentNode) {
                    Attachment att = (Attachment)node.getLookup().lookup(Attachment.class);
                    boolean isEntityImage = AttachmentsEditorPanel.this._newEntityImage != null ? att.equals((Object)AttachmentsEditorPanel.this._newEntityImage) : att.equals((Object)AttachmentUtils.getEntityImageAttachment(entity));
                    if (isEntityImage) {
                        return this._highlightColor;
                    }
                }
            }
            return this._delegate.getBackground(o);
        }
    }
}

