/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.customicons.add;

import com.paterva.maltego.customicons.add.IconCategoryController;
import com.paterva.maltego.imgfactory.icons.IconLayerRegistry;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.IconUtils;
import com.paterva.maltego.importexport.ImportAction;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import com.paterva.maltego.util.ui.dialog.EditDialogDisplayer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class AddIconsHelper {
    private static final String[] IMG_EXT = new String[]{".png", ".bmp", ".gif", ".jpg", ".jpeg", ".svg", ".tif", ".tiff", ".webp"};
    private static final String ICON_SIZES = IconSize.TINY.getSize() + "|" + IconSize.SMALL.getSize() + "|" + IconSize.MEDIUM.getSize() + "|" + IconSize.LARGE.getSize() + "|" + IconSize.MASSIVE.getSize();

    public static void showDialog() {
        String category;
        List<File> imageFiles;
        File[] files = AddIconsHelper.showFileDialog();
        if (files != null && files.length > 0 && (imageFiles = AddIconsHelper.getImageFiles(files)) != null && !imageFiles.isEmpty() && (category = AddIconsHelper.showCategoryDialog()) != null) {
            AddIconsHelper.addImageFiles(category, imageFiles);
        }
    }

    static void addImageFiles(String category, List<File> imageFiles) {
        String actualCategory = (String)IconRegistry.getDefault().getCorrectCaseCategory(category).get();
        Map<String, EnumMap<IconSize, File>> sortedFiles = AddIconsHelper.sortBySize(imageFiles);
        AddIconsHelper.lookForOtherSizes(sortedFiles);
        sortedFiles = AddIconsHelper.replacePathWithIconName(sortedFiles, actualCategory);
        AddIconsHelper.addIcons(actualCategory, sortedFiles);
    }

    private static File[] showFileDialog() {
        FileChooserBuilder builder = new FileChooserBuilder(ImportAction.class);
        builder.setApproveText("Add Icons");
        builder.setFilesOnly(true);
        builder.setTitle("Select icons to add");
        File[] files = builder.showMultiOpenDialog();
        return files;
    }

    private static String showCategoryDialog() {
        String category = null;
        IconCategoryController controller = new IconCategoryController();
        EditDialogDescriptor descriptor = new EditDialogDescriptor(controller.getName(), (WizardDescriptor.Panel)controller);
        descriptor.putProperty("iconCategory", (Object)"Custom");
        if (EditDialogDescriptor.OK_OPTION.equals(EditDialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor)) && (category = (String)descriptor.getProperty("iconCategory")) != null) {
            category = category.trim();
        }
        return category;
    }

    private static List<File> getImageFiles(File[] files) {
        ArrayList<File> valid = new ArrayList<File>();
        ArrayList<File> invalid = new ArrayList<File>();
        for (File file : files) {
            if (AddIconsHelper.isValidImage(file)) {
                valid.add(file);
                continue;
            }
            invalid.add(file);
        }
        if (!invalid.isEmpty() && !AddIconsHelper.showInvalidPrompt(invalid)) {
            return null;
        }
        return valid;
    }

    private static boolean showInvalidPrompt(List<File> invalid) {
        StringBuilder msg = new StringBuilder("The following files are not valid images. Skip them and continue?\n");
        for (File file : invalid) {
            msg.append("    ").append(file.getName()).append("\n");
        }
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg.toString());
        nd.setTitle("Invalid files");
        nd.setMessageType(2);
        nd.setOptionType(2);
        return NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd));
    }

    private static Map<String, EnumMap<IconSize, File>> sortBySize(List<File> files) {
        HashMap<String, EnumMap<IconSize, File>> sortedFiles = new HashMap<String, EnumMap<IconSize, File>>();
        for (File file : files) {
            String[] parsedName = AddIconsHelper.parseName(file.getAbsolutePath());
            if (parsedName == null) continue;
            String iconName = parsedName[0];
            IconSize size = IconSize.getSize((String)parsedName[1]);
            EnumMap<IconSize, File> filesBySize = (EnumMap<IconSize, File>)sortedFiles.get(iconName);
            if (filesBySize == null) {
                filesBySize = new EnumMap<IconSize, File>(IconSize.class);
                sortedFiles.put(iconName, filesBySize);
            }
            filesBySize.put(size, file);
        }
        return sortedFiles;
    }

    static String[] parseName(String filename) {
        Matcher matcher = Pattern.compile("^(.*?)(" + ICON_SIZES + ")?\\.[^\\.]+$").matcher(filename);
        if (matcher.find()) {
            String iconName = matcher.group(1);
            String size = matcher.group(2);
            return new String[]{iconName, size};
        }
        return null;
    }

    private static void lookForOtherSizes(Map<String, EnumMap<IconSize, File>> sortedFiles) {
        for (Map.Entry<String, EnumMap<IconSize, File>> entry : sortedFiles.entrySet()) {
            String pathPrefix = entry.getKey();
            EnumMap<IconSize, File> sizes = entry.getValue();
            for (IconSize size : IconSize.values()) {
                if (sizes.containsKey(size)) continue;
                File file = null;
                if (size == IconSize.TINY) {
                    file = AddIconsHelper.searchForFile(pathPrefix);
                }
                if (file == null) {
                    file = AddIconsHelper.searchForFile(pathPrefix + size.getSize());
                }
                if (file == null) continue;
                sizes.put(size, file);
            }
        }
    }

    private static Map<String, EnumMap<IconSize, File>> replacePathWithIconName(Map<String, EnumMap<IconSize, File>> sortedFiles, String iconCategory) {
        IconRegistry iconRegistry = IconRegistry.getDefault();
        HashMap<String, EnumMap<IconSize, File>> validNames = new HashMap<String, EnumMap<IconSize, File>>();
        for (Map.Entry<String, EnumMap<IconSize, File>> entry : sortedFiles.entrySet()) {
            String name = entry.getKey().replaceFirst("^.*[\\\\/]([^\\\\/]+)$", "$1");
            name = IconUtils.createUniqueIconName((IconRegistry)iconRegistry, (String)iconCategory, (String)name);
            while (validNames.containsKey(name) || iconRegistry.existsCaseInsensitive(iconCategory, name)) {
                name = name + "_";
            }
            validNames.put(name, entry.getValue());
        }
        return validNames;
    }

    private static File searchForFile(String pathPrefix) {
        for (String ext : IMG_EXT) {
            File file = new File(pathPrefix + ext);
            if (file.exists() && AddIconsHelper.isValidImage(file)) {
                return file;
            }
            file = new File(pathPrefix + ext.toUpperCase());
            if (!file.exists() || !AddIconsHelper.isValidImage(file)) continue;
            return file;
        }
        return null;
    }

    private static boolean isValidImage(File file) {
        String name = file.getName();
        if (!name.equals("thumbs.db") && name.contains(".") && !name.endsWith(".") && !name.startsWith(".")) {
            try {
                BufferedImage img = ImageIO.read(file);
                return img != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static void addIcons(String category, Map<String, EnumMap<IconSize, File>> sortedFiles) {
        IconLayerRegistry iconRegistry = IconLayerRegistry.getDefault();
        for (Map.Entry<String, EnumMap<IconSize, File>> entry : sortedFiles.entrySet()) {
            String iconName = entry.getKey();
            EnumMap<IconSize, File> sizes = entry.getValue();
            HashMap<IconSize, FileObject> iconFiles = new HashMap<IconSize, FileObject>();
            for (IconSize size : IconSize.values()) {
                File file = AddIconsHelper.fixSize(AddIconsHelper.getFile(sizes, size), size);
                if (file == null) continue;
                iconFiles.put(size, FileUtil.toFileObject((File)file));
            }
            if (iconFiles.isEmpty()) continue;
            try {
                iconRegistry.addFromFiles(category, iconName, iconFiles);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static File getFile(EnumMap<IconSize, File> sizes, IconSize size) {
        File file = sizes.get(size);
        if (file == null) {
            file = IconSize.getBiggestForIconType(sizes, (IconSize)size);
        }
        return file;
    }

    static File fixSize(File file, IconSize size) {
        return AddIconsHelper.fixSize(file, size.getSize());
    }

    static File fixSize(File file, int size) {
        try {
            BufferedImage img = ImageIO.read(file);
            if (img.getWidth() == size && img.getHeight() == size) {
                return file;
            }
            BufferedImage resized = ImageUtils.smartSize((BufferedImage)img, (double)size);
            File tempFile = FileUtil.normalizeFile((File)File.createTempFile("maltegoTmp", ".png"));
            ImageIO.write((RenderedImage)resized, "png", tempFile);
            tempFile.deleteOnExit();
            return tempFile;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }
}

