/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.serializers.map;

import com.paterva.maltego.serializers.compact.LinkNameMappings;
import java.util.HashMap;
import java.util.Map;

public class PartMapTranslator {
    private final LinkNameMappings _linkMappings = new LinkNameMappings();
    protected static final String DEGREE_CHAR = "\u00b0";

    public LinkNameMappings getLinkMappings() {
        return this._linkMappings;
    }

    public Map<String, Object> escapeDots(Map<String, Object> map) {
        return this.replaceInKeys(map, "[.]", DEGREE_CHAR);
    }

    public String escapeDots(String key) {
        return key.replaceAll("[.]", DEGREE_CHAR);
    }

    public Map<String, Object> unescapeDots(Map<String, Object> map) {
        return this.replaceInKeys(map, DEGREE_CHAR, ".");
    }

    public String unescapeDots(String key) {
        return key.replaceAll(DEGREE_CHAR, ".");
    }

    public Map<String, Object> replaceInKeys(Map<String, Object> map, String regex, String replacement) {
        HashMap<String, Object> escapedMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey().replaceAll(regex, replacement);
            Map<String, Object> value = entry.getValue();
            if (value instanceof Map) {
                Map innerMap = value;
                value = this.replaceInKeys(innerMap, regex, replacement);
            }
            escapedMap.put(key, value);
        }
        return escapedMap;
    }
}

