/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.imex;

import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.imex.MachineConfig;
import com.paterva.maltego.automation.imex.MachineExistInfo;
import com.paterva.maltego.automation.imex.MachineImporter;
import com.paterva.maltego.automation.imex.SelectableMachine;
import com.paterva.maltego.automation.imex.Util;
import com.paterva.maltego.automation.impl.FileSystemMachineRepository;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigImporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.openide.filesystems.FileObject;

public class MachineConfigImporter
extends ConfigImporter {
    public Config loadConfig(MaltegoArchiveReader reader) throws IOException {
        MachineImporter importer = new MachineImporter();
        List<MachineDescriptor> machines = importer.read(reader);
        return this.createConfig(machines);
    }

    private Config createConfig(List<MachineDescriptor> machines) {
        if (machines.isEmpty()) {
            return null;
        }
        List<SelectableMachine> selectables = Util.createSelectables(machines);
        MachineExistInfo existInfo = new MachineExistInfo();
        for (SelectableMachine selectable : selectables) {
            selectable.setSelected(!existInfo.exist(selectable.getMachine()));
        }
        return new MachineConfig(selectables);
    }

    public Config loadPreviousConfig(FileObject configRoot) throws IOException {
        FileSystemMachineRepository repo = new FileSystemMachineRepository(configRoot);
        ArrayList<MachineDescriptor> machines = new ArrayList<MachineDescriptor>(repo.getAll());
        return this.createConfig(machines);
    }

    public int applyConfig(Config config) {
        MachineImporter importer = new MachineImporter();
        MachineConfig machineConfig = (MachineConfig)config;
        HashSet<MachineDescriptor> machines = new HashSet<MachineDescriptor>();
        for (SelectableMachine selectable : machineConfig.getSelectedMachines()) {
            machines.add(selectable.getMachine());
        }
        return importer.apply(machines, null);
    }
}

