/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.runtime;

import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.automation.runtime.MachineRuntime;
import com.paterva.maltego.automation.runtime.MachineRuntimeException;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public abstract class MachineRunner {
    public static MachineRunner getDefault() {
        MachineRunner manager = (MachineRunner)Lookup.getDefault().lookup(MachineRunner.class);
        if (manager == null) {
            manager = new TrivialMachineRunner();
        }
        return manager;
    }

    public abstract boolean handleEvent(MachineRuntime var1, Object var2, Object var3);

    public abstract void start(MachineRuntime var1, DataObject var2, Payload var3) throws MachineRuntimeException;

    public abstract void stop(MachineRuntime var1);

    public abstract void suspend(MachineRuntime var1);

    public abstract void resume(MachineRuntime var1);

    private static class TrivialMachineRunner
    extends MachineRunner {
        private TrivialMachineRunner() {
        }

        @Override
        public boolean handleEvent(MachineRuntime machine, Object eventName, Object eventParam) {
            throw new UnsupportedOperationException("No Machine Runner registered.");
        }

        @Override
        public void start(MachineRuntime runtime, DataObject target, Payload payload) {
            throw new UnsupportedOperationException("No Machine Runner registered.");
        }

        @Override
        public void stop(MachineRuntime runtime) {
            throw new UnsupportedOperationException("No Machine Runner registered.");
        }

        @Override
        public void suspend(MachineRuntime m) {
            throw new UnsupportedOperationException("No Machine Runner registered.");
        }

        @Override
        public void resume(MachineRuntime m) {
            throw new UnsupportedOperationException("No Machine Runner registered.");
        }
    }
}

