/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;

public class CredentialTypeMetadata
implements Comparable<CredentialTypeMetadata> {
    private static final Logger logger = Logger.getLogger(CredentialTypeMetadata.class);
    public static final String DEFAULT_ICON_CSS_CLASS = "kcAuthenticatorDefaultClass";
    private String type;
    private String displayName;
    private String helpText;
    private String iconCssClass = "kcAuthenticatorDefaultClass";
    private String createAction;
    private String updateAction;
    private Boolean removeable;
    private Category category;

    private CredentialTypeMetadata() {
    }

    public String getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public String getIconCssClass() {
        return this.iconCssClass;
    }

    public String getCreateAction() {
        return this.createAction;
    }

    public String getUpdateAction() {
        return this.updateAction;
    }

    public boolean isRemoveable() {
        return this.removeable;
    }

    public Category getCategory() {
        return this.category;
    }

    public static CredentialTypeMetadataBuilder builder() {
        return new CredentialTypeMetadataBuilder();
    }

    @Override
    public int compareTo(CredentialTypeMetadata other) {
        int categoryCompare;
        int n = this.category == null ? (other.category == null ? 0 : 1) : (categoryCompare = other.category == null ? -1 : this.category.compareWith(other.category));
        if (categoryCompare != 0) {
            return categoryCompare;
        }
        int typeCompare = this.type == null ? (other.type == null ? 0 : 1) : (other.type == null ? -1 : this.type.compareTo(other.type));
        return typeCompare;
    }

    public static class CredentialTypeMetadataBuilder {
        private CredentialTypeMetadata instance = new CredentialTypeMetadata();

        public CredentialTypeMetadataBuilder type(String type) {
            this.instance.type = type;
            return this;
        }

        public CredentialTypeMetadataBuilder displayName(String displayName) {
            this.instance.displayName = displayName;
            return this;
        }

        public CredentialTypeMetadataBuilder helpText(String helpText) {
            this.instance.helpText = helpText;
            return this;
        }

        public CredentialTypeMetadataBuilder iconCssClass(String iconCssClass) {
            this.instance.iconCssClass = iconCssClass;
            return this;
        }

        public CredentialTypeMetadataBuilder createAction(String createAction) {
            this.instance.createAction = createAction;
            return this;
        }

        public CredentialTypeMetadataBuilder updateAction(String updateAction) {
            this.instance.updateAction = updateAction;
            return this;
        }

        public CredentialTypeMetadataBuilder removeable(boolean removeable) {
            this.instance.removeable = removeable;
            return this;
        }

        public CredentialTypeMetadataBuilder category(Category category) {
            this.instance.category = category;
            return this;
        }

        public CredentialTypeMetadata build(KeycloakSession session) {
            this.assertNotNull(this.instance.type, "type");
            this.assertNotNull(this.instance.displayName, "displayName");
            this.assertNotNull(this.instance.helpText, "helpText");
            this.assertNotNull(this.instance.iconCssClass, "iconCssClass");
            this.assertNotNull(this.instance.removeable, "removeable");
            this.assertNotNull((Object)this.instance.category, "category");
            if (!this.verifyRequiredAction(session, this.instance.createAction)) {
                this.instance.createAction = null;
            }
            if (!this.verifyRequiredAction(session, this.instance.updateAction)) {
                this.instance.updateAction = null;
            }
            if (this.instance.createAction != null && this.instance.updateAction != null) {
                throw new IllegalStateException("Both createAction and updateAction are not null when building CredentialTypeMetadata for the credential type '" + this.instance.type);
            }
            return this.instance;
        }

        private void assertNotNull(Object input, String fieldName) {
            if (input == null) {
                throw new IllegalStateException("Field '" + fieldName + "' is null when building CredentialTypeMetadata for the credential type '" + this.instance.type);
            }
        }

        private boolean verifyRequiredAction(KeycloakSession session, String requiredActionProviderId) {
            if (requiredActionProviderId == null) {
                return false;
            }
            RealmModel realm = session.getContext().getRealm();
            if (realm == null) {
                logger.warnf("Realm was not set in context when trying to get credential metadata of provider '%s'", (Object)this.instance.type);
                return false;
            }
            return realm.getRequiredActionProvidersStream().filter(RequiredActionProviderModel::isEnabled).map(RequiredActionProviderModel::getProviderId).anyMatch(requiredActionProviderId::equals);
        }
    }

    public static enum Category {
        BASIC_AUTHENTICATION("basic-authentication", 1),
        TWO_FACTOR("two-factor", 2),
        PASSWORDLESS("passwordless", 3);

        private String categoryName;
        private int order;

        private Category(String categoryName, int order) {
            this.categoryName = categoryName;
            this.order = order;
        }

        public String toString() {
            return this.categoryName;
        }

        public int compareWith(Category that) {
            return this.order - that.order;
        }
    }
}

