/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository;

import com.paterva.maltego.transform.descriptor.Popup;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformFilter;
import com.paterva.maltego.transform.descriptor.TransformRepositoriesLock;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformSettings;
import com.paterva.maltego.transform.repository.ListMapTransformSettings;
import com.paterva.maltego.transform.repository.TransformDefinitionCookie;
import com.paterva.maltego.transform.repository.serializer.TransformDescriptorSerializer;
import com.paterva.maltego.transform.repository.serializer.TransformSettingsSerializer;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import java.io.File;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.ExposedFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class FSTransformRepository
extends TransformRepository {
    private static final Logger LOG = Logger.getLogger(FSTransformRepository.class.getName());
    private final String _name;
    private final FileObject _folder;
    private Map<String, TransformDefinition> _transforms;
    private static final String TRANSFORM_EXT = "transform";
    private static final String SETTINGS_EXT = "transformsettings";

    public FSTransformRepository(String name, FileObject folder) {
        this._folder = folder;
        this._name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, TransformDefinition> transforms() {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            if (this._transforms == null) {
                this._transforms = new HashMap<String, TransformDefinition>();
                for (FileObject fo : this._folder.getChildren()) {
                    TransformDefinition td;
                    if (fo.isFolder() || (td = this.get(fo)) == null) continue;
                    this._transforms.put(td.getName(), td);
                }
            }
            return this._transforms;
        }
    }

    public Set<TransformDefinition> getAll() {
        return Collections.unmodifiableSet(new HashSet<TransformDefinition>(this.transforms().values()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformDefinition get(String uniqueName) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            return this.transforms().get(uniqueName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransformDefinition get(FileObject fo) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            if (fo != null) {
                try {
                    TransformDefinitionCookie cookie;
                    DataObject obj = DataObject.find((FileObject)fo);
                    if (obj != null && (cookie = (TransformDefinitionCookie)obj.getLookup().lookup(TransformDefinitionCookie.class)) != null) {
                        TransformDefinition td = cookie.getTransformDefinition();
                        td.setRepositoryName(this._name);
                        td.markClean();
                        return td;
                    }
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TransformDefinition> find(TransformFilter filter) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            HashSet<TransformDefinition> set = new HashSet<TransformDefinition>();
            this.find(filter, set);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void find(TransformFilter filter, Set<TransformDefinition> set) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            for (Map.Entry<String, TransformDefinition> entry : this.transforms().entrySet()) {
                TransformDefinition def = entry.getValue();
                if (!filter.matches(def)) continue;
                set.add(def);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(TransformDescriptor descriptor) {
        try {
            TransformDefinition definition;
            TransformDefinition oldDef = null;
            Object object = TransformRepositoriesLock.LOCK;
            synchronized (object) {
                boolean transferPopup;
                oldDef = this.get(descriptor.getName());
                if (descriptor.isCopy((TransformDescriptor)oldDef)) {
                    oldDef.markClean();
                    return;
                }
                FileObject transformFile = this._folder.getFileObject(descriptor.getName(), TRANSFORM_EXT);
                boolean mayLog = LOG.isLoggable(Level.FINE);
                if (mayLog && transformFile == null) {
                    LOG.log(Level.FINE, "FileObject transformFile is null: {0}", descriptor.getName());
                }
                File folder = FileUtil.toFile((FileObject)this._folder);
                if (mayLog) {
                    if (folder == null) {
                        LOG.log(Level.FINE, "FileUtil.toFile(_folder) is null: {0}", descriptor.getName());
                    } else if (!folder.exists()) {
                        LOG.log(Level.FINE, "FileUtil.toFile(_folder) does not exist: {0}", descriptor.getName());
                    }
                }
                File file = new File(folder, descriptor.getName() + "." + TRANSFORM_EXT);
                if (mayLog && !file.exists()) {
                    LOG.log(Level.FINE, "new File(folder, descriptor.getName() + \".\" + TRANSFORM_EXT) does not exist: {0}", file.getAbsolutePath());
                }
                ExposedFileSystem fileSystem = ExposedFileSystem.getInstance();
                try (OutputStream os = fileSystem.getOutputStream(file);){
                    TransformDescriptorSerializer serializer = new TransformDescriptorSerializer();
                    serializer.write(descriptor, os);
                }
                Object settings = oldDef == null && descriptor instanceof TransformDefinition ? (TransformDefinition)descriptor : this.get(transformFile);
                if (settings == null) {
                    settings = new ListMapTransformSettings();
                }
                boolean bl = transferPopup = oldDef == null;
                if (transferPopup) {
                    Iterator iterator = descriptor.getProperties().iterator();
                    while (iterator.hasNext()) {
                        DisplayDescriptor property;
                        settings.setPopup((PropertyDescriptor)property, (property = (DisplayDescriptor)iterator.next()).isPopup() ? Popup.Yes : Popup.No);
                    }
                }
                definition = new TransformDefinition(descriptor, (TransformSettings)settings);
                if (oldDef != null) {
                    this.transforms().remove(oldDef.getName());
                }
                definition.setRepositoryName(this._name);
                definition.markClean();
                this.transforms().put(definition.getName(), definition);
                if (transferPopup) {
                    this.saveSettings(definition);
                }
            }
            if (oldDef != null) {
                this.fireItemRemoved(oldDef);
            }
            this.fireItemAdded(definition);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSettings(TransformDefinition definition) {
        boolean fireChanged = false;
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            if (definition.isDirty() && this.get(definition.getName()) != null) {
                fireChanged = this.saveSettings(definition);
            }
        }
        if (fireChanged) {
            definition.markClean();
            this.fireItemChanged(definition);
        }
    }

    private boolean saveSettings(TransformDefinition definition) {
        boolean fireChanged = false;
        try {
            File folder = FileUtil.toFile((FileObject)this._folder);
            File file = new File(folder, definition.getName() + "." + SETTINGS_EXT);
            ExposedFileSystem fileSystem = ExposedFileSystem.getInstance();
            try (OutputStream os = fileSystem.getOutputStream(file);){
                TransformSettingsSerializer serializer = new TransformSettingsSerializer();
                serializer.write(definition, os, false);
            }
            fireChanged = true;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return fireChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String uniqueName) {
        TransformDefinition definition;
        boolean found = false;
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            File folder = FileUtil.toFile((FileObject)this._folder);
            File transformFile = new File(folder, uniqueName + "." + TRANSFORM_EXT);
            File settingsFile = new File(folder, uniqueName + "." + SETTINGS_EXT);
            try {
                found = transformFile.delete();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            try {
                settingsFile.delete();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            definition = this.get(uniqueName);
            if (definition != null) {
                this.transforms().remove(uniqueName);
            }
        }
        if (definition != null) {
            this.fireItemRemoved(definition);
        }
        return found;
    }
}

