/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.imex;

import com.maltego.tx3.java.api.execution.Property;
import com.paterva.maltego.entity.api.EntityPropTypeMapping;
import com.paterva.maltego.util.StringUtilities;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultEntityPropTypeMapping
extends EntityPropTypeMapping {
    private static final Map<Property.PropertyType, String> typeMap = new HashMap<Property.PropertyType, String>();

    public String getV2PropTypeName(String v3PropTypeName, boolean isArray, boolean javaArrayForJsonArray, Object ... values) {
        Property.PropertyType v3PropType = Property.PropertyType.valueOf((String)v3PropTypeName);
        String typeName = typeMap.get(v3PropType);
        if (Property.PropertyType.INT == v3PropType && values != null) {
            for (Object value : values) {
                if (value == null) continue;
                if (javaArrayForJsonArray) {
                    typeName = this.getV3IntToV2TypeName(isArray, false, value);
                    break;
                }
                typeName = this.getV3IntToV2TypeName(isArray, value);
                break;
            }
        }
        return typeName;
    }

    private String getV3IntToV2TypeName(boolean isArray, boolean returnArrayName, Object value) {
        if (!isArray) {
            if (value instanceof Long) {
                return "long";
            }
            if (value instanceof BigInteger) {
                return "bigint";
            }
        } else if (value != null && isArray && ((Object[])value).length > 0) {
            if (((Object[])value)[0] instanceof Long) {
                return returnArrayName ? "long[]" : "long";
            }
            if (((Object[])value)[0] instanceof BigInteger) {
                return returnArrayName ? "bigint[]" : "bigint";
            }
        }
        return isArray ? (returnArrayName ? "int[]" : "int") : "int";
    }

    private String getV3IntToV2TypeName(boolean isArray, Object value) {
        if (!isArray) {
            if (value instanceof String) {
                return this.parsedStringTypeName((String)value);
            }
            if (value instanceof Long) {
                return "long";
            }
            if (value instanceof BigInteger) {
                return "bigint";
            }
        } else if (value != null && isArray && !((List)value).isEmpty()) {
            if (((List)value).get(0) instanceof String) {
                return this.parsedStringTypeName((String)((List)value).get(0));
            }
            if (((List)value).get(0) instanceof Long) {
                return "long";
            }
            if (((List)value).get(0) instanceof BigInteger) {
                return "bigint";
            }
        }
        return "int";
    }

    private String parsedStringTypeName(String value) {
        if (StringUtilities.isNullOrEmpty((String)value)) {
            return "int";
        }
        try {
            Integer.valueOf(value);
            return "int";
        }
        catch (NumberFormatException ex1) {
            try {
                Long.valueOf(value);
                return "long";
            }
            catch (NumberFormatException ex2) {
                try {
                    new BigInteger(value);
                    return "bigint";
                }
                catch (NumberFormatException numberFormatException) {
                    return "int";
                }
            }
        }
    }

    static {
        typeMap.put(Property.PropertyType.STRING, "string");
        typeMap.put(Property.PropertyType.DATE, "date");
        typeMap.put(Property.PropertyType.DATE_TIME, "datetime");
        typeMap.put(Property.PropertyType.DATE_RANGE, "daterange");
        typeMap.put(Property.PropertyType.INT, "int");
        typeMap.put(Property.PropertyType.BOOLEAN, "boolean");
        typeMap.put(Property.PropertyType.DOUBLE, "double");
        typeMap.put(Property.PropertyType.URL, "url");
        typeMap.put(Property.PropertyType.COLOR, "color");
    }
}

