/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.net.MalformedURLException;
import org.lobobrowser.html.BrowserFrame;
import org.lobobrowser.html.domimpl.FrameNode;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.js.Window;
import org.lobobrowser.html.style.IFrameRenderState;
import org.lobobrowser.html.style.RenderState;
import org.w3c.dom.Document;
import org.w3c.dom.html2.HTMLIFrameElement;

public class HTMLIFrameElementImpl
extends HTMLAbstractUIElement
implements HTMLIFrameElement,
FrameNode {
    private volatile BrowserFrame browserFrame;

    public HTMLIFrameElementImpl(String name) {
        super(name);
    }

    @Override
    public void setBrowserFrame(BrowserFrame frame) {
        String src;
        this.browserFrame = frame;
        if (frame != null && (src = this.getAttribute("src")) != null) {
            try {
                frame.loadURL(this.getFullURL(src));
            }
            catch (MalformedURLException mfu) {
                this.warn("setBrowserFrame(): Unable to navigate to src.", mfu);
            }
        }
    }

    @Override
    public BrowserFrame getBrowserFrame() {
        return this.browserFrame;
    }

    @Override
    public String getAlign() {
        return this.getAttribute("align");
    }

    @Override
    public Document getContentDocument() {
        BrowserFrame frame = this.browserFrame;
        if (frame == null) {
            return null;
        }
        return frame.getContentDocument();
    }

    public Window getContentWindow() {
        BrowserFrame frame = this.browserFrame;
        if (frame == null) {
            return null;
        }
        return Window.getWindow(frame.getHtmlRendererContext());
    }

    @Override
    public String getFrameBorder() {
        return this.getAttribute("frameborder");
    }

    @Override
    public String getHeight() {
        return this.getAttribute("height");
    }

    @Override
    public String getLongDesc() {
        return this.getAttribute("longdesc");
    }

    @Override
    public String getMarginHeight() {
        return this.getAttribute("marginheight");
    }

    @Override
    public String getMarginWidth() {
        return this.getAttribute("marginwidth");
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    @Override
    public String getScrolling() {
        return this.getAttribute("scrolling");
    }

    @Override
    public String getSrc() {
        return this.getAttribute("src");
    }

    @Override
    public String getWidth() {
        return this.getAttribute("width");
    }

    @Override
    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    @Override
    public void setFrameBorder(String frameBorder) {
        this.setAttribute("frameborder", frameBorder);
    }

    @Override
    public void setHeight(String height) {
        this.setAttribute("height", height);
    }

    @Override
    public void setLongDesc(String longDesc) {
        this.setAttribute("longdesc", longDesc);
    }

    @Override
    public void setMarginHeight(String marginHeight) {
        this.setAttribute("marginHeight", marginHeight);
    }

    @Override
    public void setMarginWidth(String marginWidth) {
        this.setAttribute("marginWidth", marginWidth);
    }

    @Override
    public void setName(String name) {
        this.setAttribute("name", name);
    }

    @Override
    public void setScrolling(String scrolling) {
        this.setAttribute("scrolling", scrolling);
    }

    @Override
    public void setSrc(String src) {
        this.setAttribute("src", src);
    }

    @Override
    public void setWidth(String width) {
        this.setAttribute("width", width);
    }

    @Override
    protected void assignAttributeField(String normalName, String value) {
        if ("src".equals(normalName)) {
            BrowserFrame frame = this.browserFrame;
            if (frame != null) {
                try {
                    frame.loadURL(this.getFullURL(value));
                }
                catch (MalformedURLException mfu) {
                    this.warn("assignAttributeField(): Unable to navigate to src.", mfu);
                }
            }
        } else {
            super.assignAttributeField(normalName, value);
        }
    }

    @Override
    protected RenderState createRenderState(RenderState prevRenderState) {
        return new IFrameRenderState(prevRenderState, this);
    }
}

