/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.wizard.offline;

import com.paterva.maltego.licensing.ui.wizard.offline.FileBrowsePanel;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.MaltegoUrl;
import com.paterva.maltego.util.ui.LinkLabel;
import com.paterva.maltego.util.ui.components.MatteBorderLeft;
import com.paterva.maltego.util.ui.dialog.ChangeEventPropagator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class OfflineActivationControl
extends JPanel {
    private static final String OFFLINE_ACTIVATION_URL = MaltegoUrl.getCurrent().getGotoOfflineActivation();
    private static final String MALTEGO_ID_OFFLINE_ACTIVATION_URL = MaltegoUrl.getCurrent().getGotoMaltegoIDOfflineActivation();
    private final ChangeEventPropagator _changeSupport = new ChangeEventPropagator((Object)this);
    private ActionListener _linkListener;
    private FileBrowsePanel _fileBrowsePanel;
    private LinkLabel _linkLabel;
    private JTextArea _requestTextArea;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;

    public OfflineActivationControl() {
        this.initComponents();
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        this._fileBrowsePanel.addChangeListener((ChangeListener)this._changeSupport);
        this._linkLabel.setForeground(laf.getColor("Link.foreground"));
        this._linkLabel.setHighlightColor(laf.getColor("link-highlight-fg"));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._linkListener = e -> {
            try {
                URL url = new URL(this._linkLabel.getText());
                if (!FileUtilities.isRemoteFileURL((URL)url)) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                }
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        };
        this._linkLabel.addActionListener(this._linkListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this._linkLabel.removeActionListener(this._linkListener);
        this._linkListener = null;
    }

    public void setActivationForMaltegoID(boolean isMaltegoId) {
        if (isMaltegoId) {
            Mnemonics.setLocalizedText((JLabel)this._linkLabel, (String)MALTEGO_ID_OFFLINE_ACTIVATION_URL);
        } else {
            Mnemonics.setLocalizedText((JLabel)this._linkLabel, (String)OFFLINE_ACTIVATION_URL);
        }
    }

    public void setLicenseRequest(String request) {
        this._requestTextArea.setText(request);
    }

    public String getLicenseFile() {
        return this._fileBrowsePanel.getFile();
    }

    public void setLicenseFile(String licenseFile) {
        this._fileBrowsePanel.setFile(licenseFile);
    }

    public void addChangeListener(ChangeListener cl) {
        this._changeSupport.addChangeListener(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this._changeSupport.removeChangeListener(cl);
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        this._fileBrowsePanel = new FileBrowsePanel();
        JPanel jPanel2 = new JPanel();
        JScrollPane jScrollPane2 = new JScrollPane();
        this._requestTextArea = new JTextArea();
        this.jLabel1 = new JLabel();
        this._linkLabel = new LinkLabel();
        this.jLabel2 = new JLabel();
        this.jButton1 = new JButton();
        this.setPreferredSize(new Dimension(500, 400));
        this.setLayout(new GridBagLayout());
        jPanel1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), NbBundle.getMessage(OfflineActivationControl.class, (String)"OfflineActivationControl.jPanel1.border.outsideBorder.title")), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        jPanel1.setLayout(new BorderLayout());
        jPanel1.add((Component)this._fileBrowsePanel, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)jPanel1, gridBagConstraints);
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), NbBundle.getMessage(OfflineActivationControl.class, (String)"OfflineActivationControl.jPanel2.border.outsideBorder.title")), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        jPanel2.setLayout(new BorderLayout());
        this._requestTextArea.setEditable(false);
        this._requestTextArea.setBackground(new JTextField().getBackground());
        this._requestTextArea.setColumns(20);
        this._requestTextArea.setLineWrap(true);
        this._requestTextArea.setRows(5);
        jScrollPane2.setViewportView(this._requestTextArea);
        jPanel2.add((Component)jScrollPane2, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)jPanel2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(OfflineActivationControl.class, (String)"OfflineActivationControl.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(3, 10, 0, 6);
        this.add((Component)this.jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._linkLabel, (String)OFFLINE_ACTIVATION_URL);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 25;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this._linkLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(OfflineActivationControl.class, (String)"OfflineActivationControl.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 10, 3, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(OfflineActivationControl.class, (String)"OfflineActivationControl.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OfflineActivationControl.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 26;
        gridBagConstraints.insets = new Insets(0, 6, 0, 12);
        this.add((Component)this.jButton1, gridBagConstraints);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.showOptions();
    }

    private void showOptions() {
        OptionsDisplayer.getDefault().open("General");
    }
}

