/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.collect;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.views.impl.CollectionNodes;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class CollectionNodeStructureReader
implements GraphStructureReader {
    private final CollectionNodes _collectionNodes;

    public CollectionNodeStructureReader(CollectionNodes collectionNodes) {
        this._collectionNodes = collectionNodes;
    }

    public boolean exists(EntityID entityID) throws GraphStoreException {
        return this._collectionNodes.exists(entityID);
    }

    public boolean exists(LinkID linkID) throws GraphStoreException {
        return this._collectionNodes.exists(linkID);
    }

    public int getEntityCount() throws GraphStoreException {
        return this._collectionNodes.getEntityCount();
    }

    public int getLinkCount() throws GraphStoreException {
        return this._collectionNodes.getLinkCount();
    }

    public Set<EntityID> getExistingEntities(Collection<EntityID> entityIDs) throws GraphStoreException {
        return this._collectionNodes.getExistingEntities(entityIDs);
    }

    public Set<LinkID> getExistingLinks(Collection<LinkID> linkIDs) throws GraphStoreException {
        return this._collectionNodes.getExistingLinks(linkIDs);
    }

    public Set<EntityID> getEntities() throws GraphStoreException {
        return this._collectionNodes.getEntities();
    }

    public Set<LinkID> getLinks() throws GraphStoreException {
        return this._collectionNodes.getLinks();
    }

    public Map<LinkID, LinkEntityIDs> getEntities(Collection<LinkID> linkIDs) throws GraphStoreException {
        return this._collectionNodes.getEntities(linkIDs);
    }

    public LinkEntityIDs getEntities(LinkID linkID) throws GraphStoreException {
        return this._collectionNodes.getEntities(linkID);
    }

    public Map<LinkID, EntityID> getSources(Collection<LinkID> linkIDs) throws GraphStoreException {
        return this._collectionNodes.getSources(linkIDs);
    }

    public EntityID getSource(LinkID linkID) throws GraphStoreException {
        return this._collectionNodes.getSource(linkID);
    }

    public Map<LinkID, EntityID> getTargets(Collection<LinkID> linkIDs) throws GraphStoreException {
        return this._collectionNodes.getTargets(linkIDs);
    }

    public EntityID getTarget(LinkID linkID) throws GraphStoreException {
        return this._collectionNodes.getTarget(linkID);
    }

    public Set<LinkID> getLinksBetween(Collection<EntityID> entityIDs) throws GraphStoreException {
        return this._collectionNodes.getLinksBetween(entityIDs);
    }

    public Set<LinkID> getLinks(Collection<EntityID> entityIDs) throws GraphStoreException {
        return this._collectionNodes.getLinks(entityIDs);
    }

    public Map<EntityID, Set<LinkID>> getLinksMap(Collection<EntityID> entityIDs) throws GraphStoreException {
        return this._collectionNodes.getLinksMap(entityIDs);
    }

    public Set<LinkID> getLinks(EntityID entityID) throws GraphStoreException {
        return this._collectionNodes.getLinks(entityID);
    }

    public Map<EntityID, Set<LinkID>> getOutgoing(Collection<EntityID> entityIDs) throws GraphStoreException {
        return this._collectionNodes.getOutgoing(entityIDs);
    }

    public Set<LinkID> getOutgoing(EntityID entityID) throws GraphStoreException {
        return this._collectionNodes.getOutgoing(entityID);
    }

    public Map<EntityID, Set<LinkID>> getIncoming(Collection<EntityID> entityIDs) throws GraphStoreException {
        return this._collectionNodes.getIncoming(entityIDs);
    }

    public Set<LinkID> getIncoming(EntityID entityID) throws GraphStoreException {
        return this._collectionNodes.getIncoming(entityID);
    }

    public Map<EntityID, Set<EntityID>> getParents(Collection<EntityID> entityIDs) throws GraphStoreException {
        return this._collectionNodes.getParents(entityIDs);
    }

    public Set<EntityID> getParents(EntityID entityID) throws GraphStoreException {
        return this._collectionNodes.getParents(entityID);
    }

    public Map<EntityID, Set<EntityID>> getChildren(Collection<EntityID> entityIDs) throws GraphStoreException {
        return this._collectionNodes.getChildren(entityIDs);
    }

    public Set<EntityID> getChildren(EntityID entityID) throws GraphStoreException {
        return this._collectionNodes.getChildren(entityID);
    }

    public String toString() {
        return "CollectionNodeStructureReader{_collectionNodes=" + this._collectionNodes + '}';
    }

    public Map<EntityID, Boolean> getPinned(Collection<EntityID> entityIDs) throws GraphStoreException {
        return this._collectionNodes.getPinned(entityIDs);
    }

    public boolean getPinned(EntityID entityID) throws GraphStoreException {
        return this._collectionNodes.getPinned(entityID);
    }

    public Set<EntityID> getAllEntitiesWithoutLinks() throws GraphStoreException {
        return this._collectionNodes.getAllEntitiesWithoutLinks();
    }

    public Set<EntityID> getAllSingleLinkChildren(EntityID entityID) throws GraphStoreException {
        return this._collectionNodes.getAllSingleLinkChildren(entityID);
    }

    public int getLinkCount(EntityID entity) throws GraphStoreException {
        return this._collectionNodes.getLinkCount(entity);
    }

    public int getIncomingLinkCount(EntityID entity) throws GraphStoreException {
        return this._collectionNodes.getIncomingLinkCount(entity);
    }

    public int getOutgoingLinkCount(EntityID entity) throws GraphStoreException {
        return this._collectionNodes.getOutgoingLinkCount(entity);
    }

    public boolean hasLinks(EntityID entity) throws GraphStoreException {
        return this._collectionNodes.hasLinks(entity);
    }
}

