/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.outline;

import com.bulenkov.darcula.ui.DarculaTextFieldUICallback;
import com.paterva.maltego.util.ui.outline.TextQuickFilter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.swing.etable.ETable;
import org.openide.util.NbBundle;

public class TableSearchPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(TableSearchPanel.class.getName());
    private ETable _table;
    private TextQuickFilter _filter;
    private int _column = 0;
    private final DarculaTextFieldUICallback _fieldCallBack = new DarculaTextFieldUICallbackImpl();
    private JTextField _searchText;
    private JButton jButton1;

    public TableSearchPanel() {
        this.initComponents();
        this._searchText.putClientProperty("JTextField.variant", "search");
        this._searchText.putClientProperty("JTextField.Search.SearchType", "progressiveTimer");
        this._fieldCallBack.setFilterDelay(500);
        this._searchText.putClientProperty("JTextField.Search.ProgressiveTimer.Callback", this._fieldCallBack);
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this._searchText = new JTextField();
        this.jButton1.setText(NbBundle.getMessage(TableSearchPanel.class, (String)"TableSearchPanel.jButton1.text"));
        this.setLayout(new GridBagLayout());
        this._searchText.setText(NbBundle.getMessage(TableSearchPanel.class, (String)"TableSearchPanel._searchText.text_1"));
        this._searchText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TableSearchPanel.this.searchKeyTyped(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this._searchText, gridBagConstraints);
    }

    private void searchKeyTyped(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            this._searchText.setText("");
            this.doSearch();
        }
    }

    private void doSearch() {
        try {
            String text = this._searchText.getText();
            if (this._table != null && this._filter != null) {
                this._filter.setText(text);
                this._table.setQuickFilter(this._column, (Object)this._filter);
            }
        }
        catch (NullPointerException ex) {
            LOG.log(Level.WARNING, ex.toString());
        }
    }

    public ETable getTable() {
        return this._table;
    }

    public void setTable(ETable table) {
        this._table = table;
        this.doSearch();
    }

    public TextQuickFilter getFilter() {
        return this._filter;
    }

    public void setFilter(TextQuickFilter filter) {
        this.setFilter(filter, 0);
    }

    public void setFilter(TextQuickFilter filter, int column) {
        this._filter = filter;
        this._column = column;
        this.doSearch();
    }

    private class DarculaTextFieldUICallbackImpl
    extends DarculaTextFieldUICallback {
        private DarculaTextFieldUICallbackImpl() {
        }

        public void perform() {
            TableSearchPanel.this.doSearch();
        }
    }
}

