/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.recovery.ui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.maltego.recovery.ui.RecoveryUtility;
import com.paterva.maltego.archive.mtz.GraphFileType;
import com.paterva.maltego.core.GraphID;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BackupMetadata {
    public static final String RECOVERY_SUCCESSFUL = "recovery_succesful";
    private final String graphID;
    private final GraphFileType fileType;
    private String name = "New Graph";
    private String filepath;
    private Date lastBackupTime;
    private transient boolean backupReady;
    private transient boolean selectedForRecovery;
    private transient boolean recoveredSuccessfully;
    private transient PropertyChangeSupport pcs;

    public BackupMetadata(GraphID graphID, GraphFileType fileType) {
        this.graphID = graphID.toString();
        this.fileType = fileType;
    }

    public String getGraphID() {
        return this.graphID;
    }

    public GraphFileType getFileType() {
        return this.fileType;
    }

    public String getName() {
        return this.name;
    }

    public String getFilepath() {
        return this.filepath;
    }

    public Date getLastBackupTime() {
        return this.lastBackupTime;
    }

    public boolean isSelectedForRecovery() {
        return this.selectedForRecovery;
    }

    public void setSelectedForRecovery(boolean selectedForRecovery) {
        this.selectedForRecovery = selectedForRecovery;
    }

    public boolean isRecoveredSuccessfully() {
        return this.recoveredSuccessfully;
    }

    public void setRecoveredSuccessfully(boolean recoveredSuccessfully) {
        boolean oldValue = this.recoveredSuccessfully;
        this.recoveredSuccessfully = recoveredSuccessfully;
        if (this.pcs != null) {
            this.pcs.firePropertyChange(RECOVERY_SUCCESSFUL, oldValue, recoveredSuccessfully);
        }
    }

    public void changeName(String name) {
        String string = this.name = name == null ? "New Graph" : name;
        if (this.backupReady) {
            this.writeToFile();
        }
    }

    public void changeFilepath(File file) {
        String string = this.filepath = file == null ? null : file.getAbsolutePath();
        if (this.backupReady) {
            this.writeToFile();
        }
    }

    public void updateBackup() {
        this.lastBackupTime = new Date();
        this.backupReady = true;
        this.writeToFile();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    private synchronized void writeToFile() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(this);
        try {
            Files.write(RecoveryUtility.getBackupFile(this.graphID).toPath(), json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException ex) {
            Logger.getLogger(BackupMetadata.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

