/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.notifications;

import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.rest.C;
import com.paterva.maltego.notifications.ServerNotificationSerializer;
import com.paterva.maltego.notifications.data.ServerNotification;
import com.paterva.maltego.rest.MaltegoRestExchange;
import com.paterva.maltego.rest.MaltegoRestResponse;
import com.paterva.maltego.rest.PatervaUrlConstants;
import com.paterva.maltego.rest.RestException;
import com.paterva.maltego.util.NormalException;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class ServerNotificationsDownloader {
    private static final Logger LOG = Logger.getLogger(ServerNotificationsDownloader.class.getName());
    private static final String NOTIFICATION_XML_ROOT = "MaltegoNoticeRequest";

    public List<ServerNotification> download() {
        try {
            Map entries = C.A();
            MaltegoRestResponse response = this.download(entries);
            String responseXml = response.getText();
            ServerNotificationSerializer serializer = new ServerNotificationSerializer();
            return serializer.read(responseXml);
        }
        catch (IOException ex) {
            NormalException.logStackTrace((Throwable)ex);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return Collections.emptyList();
    }

    private MaltegoRestResponse download(Map<String, String> entries) throws RestException, GeneralSecurityException, IOException {
        URL url = new URL(PatervaUrlConstants.NOTIFICATIONS);
        String accessToken = LicenseManager.A().F();
        MaltegoRestExchange exchange = new MaltegoRestExchange(url, NOTIFICATION_XML_ROOT, entries, accessToken);
        exchange.sendRequest();
        return exchange.getResponse();
    }

    private MaltegoRestResponse testResponseError(Map<String, String> entries) throws Exception {
        String nonce = entries.get("Nonce");
        return new MaltegoRestResponse("<MaltegoNoticeResponse>\n    <Nonce>" + nonce + "</Nonce>\n    <Status>ERROR</Status>\n    <Message>Something went wrong</Message>\n</MaltegoNoticeResponse>", nonce, true);
    }

    private MaltegoRestResponse testResponseHtml(Map<String, String> entries) throws Exception {
        String nonce = entries.get("Nonce");
        return new MaltegoRestResponse("<MaltegoNoticeResponse>\n    <Nonce>" + nonce + "</Nonce>\n    <Status>OK</Status>\n    <Notices>\n        <!--Each notice will be displayed in their own dialog-->\n        <!--So multiple notices can be combined by the server and shown together if it makes sense-->\n        <Notice title=\"Hello World!\" width=\"400\" height=\"600\">\n            <Content>&lt;html&gt;\n  &lt;body&gt;\n    &lt;h2&gt;A H2 Header&lt;/h2&gt;\n    Some HTML with a &lt;a href=&quot;http://example.com&quot;&gt;hyperlink&lt;/a&gt;!&lt;br&gt;\n    Woohoo a new line!\n  &lt;/body&gt;\n&lt;/html&gt;</Content>\n        </Notice>\n    </Notices>\n</MaltegoNoticeResponse>", nonce, true);
    }

    private MaltegoRestResponse testResponseButtons(Map<String, String> entries) throws Exception {
        String nonce = entries.get("Nonce");
        return new MaltegoRestResponse("<MaltegoNoticeResponse>\n    <Nonce>" + nonce + "</Nonce>\n    <Status>OK</Status>\n    <Notices>\n        <Notice title=\"Hello World!\">\n            <Content>Plain text content.</Content>\n            <!--Optional buttons, default is a single \"Close\" button-->\n            <!--Note that all buttons will close the dialog-->\n            <Buttons>\n                <!--Optional url to POST to on click-->\n                <Button id=\"understand\" text=\"I Understand\" url=\"https://asdfqwerzxcvtyuivbnm.com/blah\"/>\n                <!--Optional button with id \"exit\" will quit Maltego when clicked-->\n                <Button id=\"exit\" text=\"Exit\"/>\n            </Buttons>\n        </Notice>\n    </Notices>\n</MaltegoNoticeResponse>", nonce, true);
    }
}

