/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.ui;

import com.paterva.maltego.chat.ChatRoomTopComponentRegistry;
import com.paterva.maltego.chatapi.ChatRoom;
import com.paterva.maltego.chatapi.ChatRoomCookie;
import com.paterva.maltego.chatapi.session.ChatSessionRegistry;
import com.paterva.maltego.collab.graph.GraphChatRoom;
import com.paterva.maltego.collab.ui.GraphNameSuffixCookie;
import com.paterva.maltego.ui.graph.GraphType;
import com.paterva.maltego.ui.graph.GraphTypeChangePropagator;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class DataObjectUtils {
    public static void attachGraphChatRoom(final GraphDataObject gdo, GraphChatRoom graphChatRoom) {
        final GraphChatRoom chatRoom = graphChatRoom;
        final ChatRoomCookie chatRoomCookie = new ChatRoomCookie((ChatRoom)chatRoom);
        final GraphNameSuffixCookie graphNameSuffixCookie = new GraphNameSuffixCookie((ChatRoom)chatRoom);
        gdo.addCookie((Node.Cookie)chatRoomCookie);
        gdo.addCookie((Node.Cookie)graphNameSuffixCookie);
        gdo.setCanFreeze(false);
        gdo.updateDisplayName();
        GraphType.clearCache();
        PropertyChangeListener closeHandler = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("chatRoomRemoved".equals(evt.getPropertyName())) {
                    TopComponent tc = (TopComponent)evt.getNewValue();
                    ChatRoom removedRoom = ChatRoomTopComponentRegistry.getDefault().getChatRoom(tc);
                    if (Utilities.compareObjects((Object)((Object)chatRoom), (Object)removedRoom)) {
                        ChatRoomTopComponentRegistry.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                        ChatSessionRegistry.getDefault().removeChatRoom((ChatRoom)chatRoom);
                        gdo.setDisplayNameColor(null);
                        gdo.removeCookie((Node.Cookie)chatRoomCookie);
                        gdo.removeCookie((Node.Cookie)graphNameSuffixCookie);
                        GraphType.clearCache();
                    }
                }
            }
        };
        ChatRoomTopComponentRegistry.getDefault().addPropertyChangeListener(closeHandler);
        GraphTypeChangePropagator.get().fireChange();
    }
}

