/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.serialize;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.paterva.maltego.licensing.json.rest.MaltegoIDKeyPair;
import com.paterva.maltego.licensing.json.rest.SignatureService;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.MaltegoUrl;
import com.paterva.maltego.util.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class M {
    private static final Logger B = Logger.getLogger(M.class.getName());
    private static final ObjectMapper E = new ObjectMapper();
    private static final String C = "MaltegoID.keypair";
    private static final String A = MaltegoUrl.MALTEGO_ID_LICENSE_DEV_ENV_TESTING && Version.getCurrent().isDevBuild() ? "ServerKeyDev.pem" : (MaltegoUrl.MALTEGO_ID_LICENSE_QA_ENV_TESTING && Version.getCurrent().isDevBuild() ? "ServerKeyQA.pem" : (MaltegoUrl.MALTEGO_ID_LICENSE_Staging_ENV_TESTING && Version.getCurrent().isDevBuild() ? "ServerKeyStaging.pem" : "ServerKey.pem"));
    public static final String D = "MaltegoID.activation";

    public static boolean D() {
        return M.A(C).exists();
    }

    public static boolean E() {
        return M.B(C);
    }

    public static boolean B() {
        return M.A(D).exists();
    }

    public static String C() throws IOException {
        File activationFile = M.A(D);
        byte[] activationBytes = Files.readAllBytes(activationFile.toPath());
        return new String(activationBytes);
    }

    public static MaltegoIDKeyPair A() throws IOException {
        File keypairFile = M.A(C);
        byte[] keypairBytes = Files.readAllBytes(keypairFile.toPath());
        String keypairJson = new String(keypairBytes);
        return (MaltegoIDKeyPair)E.readValue(keypairJson, MaltegoIDKeyPair.class);
    }

    public static PublicKey A(KeyFactory keyFactory) throws IOException, GeneralSecurityException {
        InputStream resourceAsStream = SignatureService.class.getResourceAsStream("/com/paterva/maltego/licensing/serialize/" + A);
        InputStreamReader inputStreamReader = new InputStreamReader(resourceAsStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String serverKeyPem = bufferedReader.lines().collect(Collectors.joining("\n"));
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(M.C(serverKeyPem));
        return keyFactory.generatePublic(keySpec);
    }

    static byte[] C(String pem) {
        String replace = pem.replaceAll("-.*-", "");
        replace = replace.replace("\r", "");
        replace = replace.replace("\n", "");
        return Base64.getDecoder().decode(replace);
    }

    public static void D(String activationJson) throws IOException {
        M.A(M.A(D), activationJson.getBytes());
    }

    public static void A(MaltegoIDKeyPair keypair) throws IOException {
        String keypairJson = E.writeValueAsString((Object)keypair);
        M.A(M.A(C), keypairJson.getBytes());
    }

    private static void A(File file, byte[] content) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(content);
        }
    }

    public static File A(String filename) {
        boolean machineLicense = false;
        File userDir = FileUtilities.getUserDir((boolean)machineLicense);
        File lf = null;
        if (userDir == null) {
            B.severe("Unable to determine license directory location");
        } else {
            File parentDir = userDir.getParentFile();
            lf = parentDir != null && parentDir.isDirectory() ? new File(parentDir, filename) : new File(userDir, filename);
        }
        return lf;
    }

    public static boolean B(String filename) {
        File file = M.A(filename);
        if (file != null && file.exists()) {
            return file.delete();
        }
        return true;
    }

    public static String A(SignatureService signatureService, String signedContent) throws IOException, GeneralSecurityException {
        String signature;
        int endOfJsonContent = signedContent.lastIndexOf("}.");
        if (endOfJsonContent < 0) {
            B.log(Level.WARNING, "Signature not found for the received content: {0}", signedContent);
            return signedContent;
        }
        String jsonContent = signedContent.substring(0, endOfJsonContent + 1);
        boolean verified = signatureService.verifyServerMessage(jsonContent, signature = signedContent.substring(endOfJsonContent + 2).trim());
        if (!verified) {
            throw new GeneralSecurityException("Server signature cannot be verified for the activation response!");
        }
        return jsonContent;
    }
}

