/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.IHttpHeader;
import org.xlightweb.SimpleMessageWriter;
import org.xsocket.DataConverter;
import org.xsocket.MaxWriteSizeExceededException;
import org.xsocket.connection.IWriteCompletionHandler;

final class FullMessageWriter
extends SimpleMessageWriter {
    private static final Logger LOG = Logger.getLogger(FullMessageWriter.class.getName());
    private final int contentLength;
    private int written = 0;

    public FullMessageWriter(AbstractHttpConnection httpConnection, boolean destroyOnClose, IHttpHeader header, int contentLength) throws IOException {
        super(httpConnection, destroyOnClose, header);
        this.contentLength = contentLength;
        header.setContentLength(contentLength);
    }

    protected int writeBody(AbstractHttpConnection con, ByteBuffer[] bodyData, IWriteCompletionHandler completionHandler) throws IOException {
        this.written += super.writeBody(con, bodyData, completionHandler);
        if (this.written > this.contentLength) {
            throw new MaxWriteSizeExceededException();
        }
        return this.written;
    }

    void onClose(boolean destroyOnClose) throws IOException {
        try {
            if (this.written != this.contentLength) {
                IOException ioe = new IOException("content size is " + this.written + " byte, but content-length field declares " + this.contentLength + " bytes");
                if (this.getConnection() != null) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] error occured by closing data sink " + ioe.getMessage());
                    }
                    this.getConnection().destroy();
                }
                throw ioe;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(DataConverter.toFormatedBytesSize((long)this.written) + " body data written");
            }
            if (destroyOnClose) {
                this.getConnection().destroy();
            }
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] error occured by closing full message writer. Destroying connection. reason " + DataConverter.toString((Throwable)ioe));
            }
            this.getConnection().destroy();
            throw ioe;
        }
    }
}

