/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.BadMessageException;
import org.xlightweb.ComposedByteBuffer;
import org.xlightweb.HeaderlineParser;
import org.xlightweb.HttpRequestHeader;
import org.xlightweb.IHttpHeader;
import org.xlightweb.IMessageHeaderParser;
import org.xsocket.connection.INonBlockingConnection;

final class HttpRequestHeaderParser
implements IMessageHeaderParser {
    private static final Logger LOG = Logger.getLogger(HttpRequestHeaderParser.class.getName());
    private static ThreadLocal<HttpRequestHeaderParser> instanceThreadLocal = new ThreadLocal();
    private static final int MAX_HEADER_SIZE = 8192;
    private static final int STATE_INIT = 0;
    private static final int STATE_READING_REQUEST_LINE = 5;
    private static final int STATE_READING_HEADER_LINES = 9;
    private int state = 0;
    private HttpRequestHeader requestHeader = null;
    private RequestLineParser requestLineParser;
    private HeaderlineParser headerlineParser;

    HttpRequestHeaderParser() {
    }

    static HttpRequestHeaderParser newInstance() {
        HttpRequestHeaderParser instance = instanceThreadLocal.get();
        if (instance == null) {
            instance = new HttpRequestHeaderParser();
        }
        instanceThreadLocal.set(null);
        return instance;
    }

    static void recycleInstance(HttpRequestHeaderParser parser) {
        instanceThreadLocal.set(parser);
    }

    public void recycle() {
        HttpRequestHeaderParser.recycleInstance(this);
    }

    public IHttpHeader parse(INonBlockingConnection connection, ComposedByteBuffer composedByteBuffer) throws BadMessageException, IOException {
        int size = 0;
        switch (this.state) {
            case 0: {
                this.requestHeader = new HttpRequestHeader(connection);
                this.requestLineParser = RequestLineParser.newInstance();
                this.state = 5;
                return this.parse(connection, composedByteBuffer);
            }
            case 5: {
                size = this.computeSizeToRead(composedByteBuffer);
                for (int i = 0; i < size; ++i) {
                    boolean isRead = this.requestLineParser.parse(connection, composedByteBuffer, this.requestHeader);
                    if (!isRead) continue;
                    this.requestLineParser.recycle();
                    this.requestLineParser = null;
                    this.headerlineParser = HeaderlineParser.newInstance();
                    this.state = 9;
                    return this.parse(connection, composedByteBuffer);
                }
                break;
            }
            case 9: {
                size = this.computeSizeToRead(composedByteBuffer);
                for (int i = 0; i < size; ++i) {
                    boolean isRead = this.headerlineParser.parse(composedByteBuffer, this.requestHeader);
                    if (!isRead) continue;
                    this.headerlineParser.recycle();
                    this.headerlineParser = null;
                    HttpRequestHeader result = this.requestHeader;
                    this.requestHeader = null;
                    this.state = 0;
                    this.completeHeader(result);
                    return result;
                }
                break;
            }
        }
        if (this.requestHeader.incCountParsedChars(size) >= 8192) {
            throw new BadMessageException("max header size exceeded");
        }
        return null;
    }

    private void completeHeader(HttpRequestHeader header) {
        String host = header.getHeader("Host");
        int port = -1;
        if (host != null) {
            int idx = host.lastIndexOf(":");
            if (idx != -1) {
                port = Integer.parseInt(host.substring(idx + 1, host.length()).trim());
                host = host.substring(0, idx);
            }
            header.setServernameSilence(host);
            if (port != -1) {
                header.setServerportPortSilence(port);
            }
        }
    }

    private int computeSizeToRead(ComposedByteBuffer composedByteBuffer) {
        int remaining;
        int size = remaining = composedByteBuffer.remaining();
        if (remaining > 8192 - this.requestHeader.getCountParsedChars()) {
            size = 8192 - this.requestHeader.getCountParsedChars();
        }
        return size;
    }

    public void onException(IOException ioe, ComposedByteBuffer rawData) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.info("error occured by receiving header. Reason: " + ioe.toString());
            StringBuilder sb = new StringBuilder();
            if (this.requestHeader != null) {
                sb.append(this.requestHeader.toString());
            }
            LOG.info("received header lines: " + sb.toString());
        }
    }

    private static final class RequestLineParser {
        private static ThreadLocal<RequestLineParser> instanceThreadLocal = new ThreadLocal();
        private int state = 0;
        private final StringBuilder methodBuilder = new StringBuilder(8);
        private final StringBuilder pathBuilder = new StringBuilder();
        private final StringBuilder queryBuilder = new StringBuilder();
        private final StringBuilder rawQueryBuilder = new StringBuilder();
        private final StringBuilder protocolBuilder = new StringBuilder(4);
        private final StringBuilder protocolVersionBuilder = new StringBuilder(3);
        private String paramName = null;

        private RequestLineParser() {
        }

        static RequestLineParser newInstance() {
            RequestLineParser instance = instanceThreadLocal.get();
            if (instance == null) {
                instance = new RequestLineParser();
            }
            instanceThreadLocal.set(null);
            return instance;
        }

        static void recycleInstance(RequestLineParser parser) {
            instanceThreadLocal.set(parser);
        }

        public boolean parse(INonBlockingConnection connection, ComposedByteBuffer composedByteBuffer, HttpRequestHeader messageHeader) throws BadMessageException, IOException {
            byte b = composedByteBuffer.getByte();
            block0 : switch (this.state) {
                case 0: {
                    switch (b) {
                        case 13: {
                            break block0;
                        }
                        case 10: {
                            break block0;
                        }
                        case 32: {
                            this.reset();
                            throw new BadMessageException("bad request. request starts with SPACE");
                        }
                        case 9: {
                            this.reset();
                            throw new BadMessageException("bad request. request starts with HTAB");
                        }
                    }
                    this.methodBuilder.append((char)b);
                    this.state = 5;
                    break;
                }
                case 5: {
                    switch (b) {
                        case 32: {
                            messageHeader.setMethodSilence(this.methodBuilder.toString());
                            this.state = 10;
                            break block0;
                        }
                        case 9: {
                            this.state = 10;
                            messageHeader.setMethodSilence(this.methodBuilder.toString());
                            break block0;
                        }
                    }
                    this.methodBuilder.append((char)b);
                    break;
                }
                case 10: {
                    switch (b) {
                        case 32: {
                            break block0;
                        }
                        case 9: {
                            break block0;
                        }
                    }
                    this.pathBuilder.append((char)b);
                    this.state = 11;
                    break;
                }
                case 11: {
                    switch (b) {
                        case 32: {
                            messageHeader.setPathSilence(this.pathBuilder.toString());
                            this.state = 30;
                            break block0;
                        }
                        case 9: {
                            messageHeader.setPathSilence(this.pathBuilder.toString());
                            this.state = 30;
                            break block0;
                        }
                        case 63: {
                            messageHeader.setPathSilence(this.pathBuilder.toString());
                            this.state = 20;
                            break block0;
                        }
                        case 13: {
                            break block0;
                        }
                        case 10: {
                            this.reset();
                            throw new BadMessageException("simple request messages are not supported");
                        }
                    }
                    this.pathBuilder.append((char)b);
                    break;
                }
                case 20: {
                    switch (b) {
                        case 32: {
                            this.state = 30;
                            break block0;
                        }
                        case 9: {
                            this.state = 30;
                            break block0;
                        }
                    }
                    this.rawQueryBuilder.append((char)b);
                    this.queryBuilder.append((char)b);
                    this.state = 21;
                    break;
                }
                case 21: {
                    switch (b) {
                        case 32: {
                            messageHeader.setRawQueryStringSilence(this.rawQueryBuilder.toString());
                            this.state = 30;
                            break block0;
                        }
                        case 9: {
                            messageHeader.setRawQueryStringSilence(this.rawQueryBuilder.toString());
                            this.state = 30;
                            break block0;
                        }
                        case 61: {
                            this.rawQueryBuilder.append((char)b);
                            this.paramName = this.queryBuilder.toString();
                            this.queryBuilder.setLength(0);
                            this.state = 22;
                            break block0;
                        }
                        case 13: {
                            break block0;
                        }
                        case 10: {
                            messageHeader.setRawQueryStringSilence(this.rawQueryBuilder.toString());
                            this.reset();
                            return true;
                        }
                    }
                    this.rawQueryBuilder.append((char)b);
                    this.queryBuilder.append((char)b);
                    break;
                }
                case 22: {
                    switch (b) {
                        case 32: {
                            messageHeader.setRawQueryStringSilence(this.rawQueryBuilder.toString());
                            messageHeader.addRawQueryParameterSilence(this.paramName, this.queryBuilder.toString());
                            this.paramName = null;
                            this.queryBuilder.setLength(0);
                            this.state = 30;
                            break block0;
                        }
                        case 9: {
                            messageHeader.setRawQueryStringSilence(this.rawQueryBuilder.toString());
                            messageHeader.addRawQueryParameterSilence(this.paramName, this.queryBuilder.toString());
                            this.paramName = null;
                            this.queryBuilder.setLength(0);
                            this.state = 30;
                            break block0;
                        }
                        case 38: {
                            this.rawQueryBuilder.append((char)b);
                            messageHeader.addRawQueryParameterSilence(this.paramName, this.queryBuilder.toString());
                            this.paramName = null;
                            this.queryBuilder.setLength(0);
                            this.state = 21;
                            break block0;
                        }
                        case 13: {
                            break block0;
                        }
                        case 10: {
                            messageHeader.setRawQueryStringSilence(this.rawQueryBuilder.toString());
                            this.reset();
                            return true;
                        }
                    }
                    this.queryBuilder.append((char)b);
                    this.rawQueryBuilder.append((char)b);
                    break;
                }
                case 30: {
                    switch (b) {
                        case 32: {
                            break block0;
                        }
                        case 9: {
                            break block0;
                        }
                        case 13: {
                            break block0;
                        }
                        case 10: {
                            this.reset();
                            return true;
                        }
                    }
                    this.protocolBuilder.append((char)b);
                    this.state = 31;
                    break;
                }
                case 31: {
                    switch (b) {
                        case 47: {
                            String protocol = this.protocolBuilder.toString();
                            messageHeader.setProtocolSchemeSilence(protocol);
                            this.state = 32;
                            break block0;
                        }
                        case 13: {
                            break block0;
                        }
                        case 10: {
                            String protocol = this.protocolBuilder.toString();
                            messageHeader.setProtocolVersionSilence(protocol);
                            this.reset();
                            return true;
                        }
                    }
                    this.protocolBuilder.append((char)b);
                    break;
                }
                case 32: {
                    this.protocolVersionBuilder.append((char)b);
                    this.state = 33;
                    break;
                }
                case 33: {
                    switch (b) {
                        case 32: {
                            messageHeader.setProtocolVersionSilence(this.protocolVersionBuilder.toString());
                            this.state = 999;
                            break block0;
                        }
                        case 9: {
                            messageHeader.setProtocolVersionSilence(this.protocolVersionBuilder.toString());
                            this.state = 999;
                            break block0;
                        }
                        case 13: {
                            break block0;
                        }
                        case 10: {
                            messageHeader.setProtocolVersionSilence(this.protocolVersionBuilder.toString());
                            this.reset();
                            return true;
                        }
                    }
                    this.protocolVersionBuilder.append((char)b);
                    break;
                }
            }
            return false;
        }

        public void reset() {
            this.state = 0;
            this.methodBuilder.setLength(0);
            this.pathBuilder.setLength(0);
            this.queryBuilder.setLength(0);
            this.rawQueryBuilder.setLength(0);
            this.protocolBuilder.setLength(0);
            this.protocolVersionBuilder.setLength(0);
            this.paramName = null;
        }

        public void recycle() {
            RequestLineParser.recycleInstance(this);
        }
    }
}

