/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.impl;

import com.paterva.maltego.imgfactory.impl.ImageFromFileCallback;
import com.paterva.maltego.util.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

class ImageFromFileThread
extends Thread {
    private Object _source;
    private ImageFromFileCallback _cb;

    public ImageFromFileThread(File file, ImageFromFileCallback cb) {
        this._source = file;
        this._cb = cb;
    }

    public ImageFromFileThread(InputStream is, ImageFromFileCallback cb) {
        this._source = is;
        this._cb = cb;
    }

    @Override
    public void run() {
        this.newWay();
    }

    private void oldWay() {
        try {
            BufferedImage img = this._source instanceof File ? ImageFromFileThread.getImage((File)this._source) : ImageFromFileThread.getImage((InputStream)this._source);
            if (img != null && (img.getWidth(null) > 240 || img.getHeight(null) > 240)) {
                img = ImageUtils.smartSize((BufferedImage)img, (double)240.0);
            }
            this._cb.imageFromFileReady(this, img);
        }
        catch (Exception ex) {
            this._cb.imageFromFileFailed(this, ex);
        }
    }

    private void newWay() {
        try {
            BufferedImage img = ImageUtils.loadThumb((Object)this._source, (int)240);
            this._cb.imageFromFileReady(this, img);
        }
        catch (Exception ex) {
            this._cb.imageFromFileFailed(this, ex);
        }
    }

    public static BufferedImage getImage(File file) throws IOException {
        BufferedImage img = null;
        try {
            img = ImageUtils.loadThumb((Object)file, (int)240);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return img;
    }

    private static BufferedImage getImage(InputStream is) throws IOException {
        BufferedImage img = null;
        try {
            img = ImageIO.read(is);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return img;
    }
}

