/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.customicons.imex;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.customicons.imex.IconMetadata;
import com.paterva.maltego.customicons.imex.Util;
import com.paterva.maltego.imgfactory.icons.LayerIconSerializer;
import com.paterva.maltego.imgfactory.icons.LayerIconStub;
import com.paterva.maltego.util.FileUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IconMetadataEntry
extends Entry<IconMetadata> {
    public static final String DEFAULT_FOLDER = "Icons";
    public static final String EXTENSION = "xml";

    public IconMetadataEntry(IconMetadata iconMetadata) {
        super((Object)iconMetadata, "Icons/" + iconMetadata.getCategory(), iconMetadata.getIconName() + "." + EXTENSION);
    }

    public IconMetadataEntry(String path) {
        super(path);
    }

    protected IconMetadata read(InputStream is) throws IOException {
        String folders = this.getFolder();
        String category = Util.getCategory(DEFAULT_FOLDER, folders);
        String iconName = this.getTypeName();
        iconName = FileUtilities.removePathChangeCharacters((String)iconName);
        category = FileUtilities.removePathChangeCharacters((String)category);
        LayerIconSerializer serializer = new LayerIconSerializer();
        LayerIconStub stub = serializer.read(is);
        IconMetadata metadata = new IconMetadata(category, iconName, stub.getAliases());
        return metadata;
    }

    protected void write(IconMetadata iconMetadata, OutputStream os) throws IOException {
        LayerIconStub stub = new LayerIconStub();
        stub.setAliases(iconMetadata.getAliases());
        LayerIconSerializer serializer = new LayerIconSerializer();
        serializer.write(stub, os);
    }
}

