/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.maltego.cloud.data.CaseMember;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Case {
    private final UUID id;
    private final String name;
    private final UUID organizationId;
    private final boolean encrypted;
    private final boolean inbox;
    private final Date createdAt;
    private final Date updatedAt;
    private final CaseMember[] members;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public Case(@JsonProperty(value="id", required=true) UUID id, @JsonProperty(value="name", required=true) String name, @JsonProperty(value="organizationId", required=true) UUID organizationId, @JsonProperty(value="encrypted") boolean encrypted, @JsonProperty(value="inbox") boolean inbox, @JsonProperty(value="createdAt", required=true) Date createdAt, @JsonProperty(value="updatedAt", required=true) Date updatedAt, @JsonProperty(value="members", required=true) CaseMember[] members) {
        this.id = id;
        this.name = name;
        this.organizationId = organizationId;
        this.encrypted = encrypted;
        this.inbox = inbox;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.members = members;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public UUID getOrganizationId() {
        return this.organizationId;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public boolean isInbox() {
        return this.inbox;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public CaseMember[] getMembers() {
        return this.members;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Case)) {
            return false;
        }
        Case aCase = (Case)o;
        return this.encrypted == aCase.encrypted && this.inbox == aCase.inbox && Objects.equals(this.id, aCase.id) && Objects.equals(this.name, aCase.name) && Objects.equals(this.organizationId, aCase.organizationId) && Objects.equals(this.createdAt, aCase.createdAt) && Objects.equals(this.updatedAt, aCase.updatedAt) && Objects.deepEquals(this.members, aCase.members);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.organizationId, this.encrypted, this.inbox, this.createdAt, this.updatedAt, Arrays.hashCode(this.members));
    }

    public String toString() {
        return "Case{id=" + this.id + ", name='" + this.name + '\'' + ", organizationId=" + this.organizationId + ", encrypted=" + this.encrypted + ", inbox=" + this.inbox + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", members=" + Arrays.toString(this.members) + '}';
    }
}

