/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository;

import com.paterva.maltego.transform.descriptor.PolymorphicTransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformSettings;
import com.paterva.maltego.transform.repository.ListMapTransformSettings;
import com.paterva.maltego.transform.repository.PreviousConfigFileSystem;
import com.paterva.maltego.transform.repository.TransformDefinitionCookie;
import com.paterva.maltego.transform.repository.TransformDescriptorCookie;
import com.paterva.maltego.transform.repository.TransformSettingsCookie;
import com.paterva.maltego.transform.repository.serializer.TransformDescriptorSerializer;
import com.paterva.maltego.transform.repository.serializer.TransformSettingsSerializer;
import com.paterva.maltego.util.XmlSerializationException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.openide.filesystems.ExposedFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class TransformDataObject
extends MultiDataObject
implements TransformDefinitionCookie,
TransformDescriptorCookie,
TransformSettingsCookie {
    private final TransformDefinition _definition;
    private FileEntry _settingsEntry;

    public TransformDataObject(FileObject descriptorFile, FileObject settingsFile, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(descriptorFile, loader);
        if (!descriptorFile.equals(settingsFile)) {
            this._settingsEntry = (FileEntry)this.registerEntry(settingsFile);
        }
        this._definition = new PolymorphicTransformDefinition(this.loadTransformDescriptor(), this.loadTransformSettings());
    }

    FileEntry getSettingsEntry() {
        return this._settingsEntry;
    }

    void setSettingsFileEntry(FileEntry entry) {
        this._settingsEntry = entry;
    }

    protected Node createNodeDelegate() {
        return new DataNode((DataObject)this, Children.LEAF, this.getLookup());
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    @Override
    public TransformDescriptor getTransformDescriptor() {
        return this.getTransformDefinition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransformDescriptor loadTransformDescriptor() {
        FileObject file = this.getPrimaryFile();
        InputStream input = null;
        try {
            input = file.getInputStream();
            TransformDescriptorSerializer serializer = new TransformDescriptorSerializer();
            TransformDescriptor transformDescriptor = serializer.read(input);
            return transformDescriptor;
        }
        catch (XmlSerializationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return null;
    }

    @Override
    public TransformDefinition getTransformDefinition() {
        return this._definition;
    }

    @Override
    public TransformSettings getTransformSettings() {
        return this.getTransformDefinition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransformSettings loadTransformSettings() {
        FileObject settingsFile = this._settingsEntry.getFile();
        if (settingsFile != null && "transformsettings".equals(settingsFile.getExt())) {
            InputStream stream = null;
            try {
                File file = FileUtil.toFile((FileObject)settingsFile);
                Path path = file.toPath();
                if (path != null && Files.isRegularFile(path, new LinkOption[0])) {
                    File rootFile;
                    FileObject root;
                    File prevConfDir = null;
                    Path settingsPath = Paths.get(settingsFile.getPath(), new String[0]);
                    if (path.endsWith(settingsPath) && (root = FileUtil.getConfigRoot()) != null && (rootFile = FileUtil.toFile((FileObject)root)) != null && rootFile.isDirectory()) {
                        Path nonOverlappingPart = path.subpath(0, path.getNameCount() - settingsPath.getNameCount());
                        Path nonOverlappingPartWithRoot = path.getRoot().resolve(nonOverlappingPart);
                        if (nonOverlappingPartWithRoot.endsWith("config") && !nonOverlappingPartWithRoot.equals(rootFile.toPath())) {
                            prevConfDir = nonOverlappingPartWithRoot.toFile();
                        }
                    }
                    if (prevConfDir != null) {
                        PreviousConfigFileSystem fs = new PreviousConfigFileSystem();
                        fs.setRootDirectory(prevConfDir);
                        fs.setReadOnly(true);
                        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                        stream = fs.wrap(is);
                    } else {
                        ExposedFileSystem fileSystem = ExposedFileSystem.getInstance();
                        stream = fileSystem.getInputStream(file);
                    }
                    TransformSettingsSerializer serializer = new TransformSettingsSerializer();
                    TransformSettings transformSettings = serializer.read(stream);
                    return transformSettings;
                }
            }
            catch (Exception ex) {
                Exceptions.attachMessage((Throwable)ex, (String)("Error while loading file " + settingsFile.getPath()));
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        return new ListMapTransformSettings();
    }
}

