/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates.ui.manager;

import com.paterva.maltego.certificates.CertificateDefinition;
import com.paterva.maltego.certificates.CertificateRepository;
import com.paterva.maltego.certificates.ui.manager.CertificateNodeAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;

public final class CertificateDeleteAction
extends CertificateNodeAction {
    private static final String DIALOG_NAME = "Delete Certificate";

    public CertificateDeleteAction() {
        super(DIALOG_NAME);
    }

    protected void performAction(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return;
        }
        String toDelete = nodes.length == 1 ? this.getCertificateDefinition(nodes[0]).getDisplayName() : String.format("these %s certificates", nodes.length);
        String msg = String.format("Are you sure you want to delete %s?", toDelete);
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, "Delete");
        if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
            for (Node node : nodes) {
                CertificateDefinition certDef = (CertificateDefinition)node.getLookup().lookup(CertificateDefinition.class);
                if (!this.canDelete(certDef)) continue;
                CertificateRepository.getDefault().remove(certDef.getCertificate());
            }
        }
    }

    @Override
    protected boolean enable(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return false;
        }
        for (Node node : nodes) {
            if (this.canDelete(this.getCertificateDefinition(node))) continue;
            return false;
        }
        return true;
    }

    protected String iconResource() {
        return "com/paterva/maltego/automation/resources/Delete.png";
    }

    private boolean canDelete(CertificateDefinition certDef) {
        return certDef != null;
    }

    private CertificateDefinition getCertificateDefinition(Node node) {
        return (CertificateDefinition)node.getLookup().lookup(CertificateDefinition.class);
    }
}

