/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Objects;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.sdjwt.SdJwtUtils;

public class SdJws {
    private final JWSInput jwsInput;
    private final JsonNode payload;

    public String toJws() {
        if (this.jwsInput == null) {
            throw new IllegalStateException("JWS not yet signed");
        }
        return this.jwsInput.getWireString();
    }

    public JsonNode getPayload() {
        return this.payload;
    }

    public String getJwsString() {
        return this.jwsInput.getWireString();
    }

    protected SdJws(JsonNode payload) {
        this.payload = payload;
        this.jwsInput = null;
    }

    protected SdJws(String jwsString) {
        this.jwsInput = SdJws.parse(jwsString);
        this.payload = SdJws.readPayload(this.jwsInput);
    }

    protected SdJws(JsonNode payload, JWSInput jwsInput) {
        this.payload = payload;
        this.jwsInput = jwsInput;
    }

    protected SdJws(JsonNode payload, SignatureSignerContext signer, String jwsType) {
        this.payload = payload;
        this.jwsInput = SdJws.sign(payload, signer, jwsType);
    }

    protected static JWSInput sign(JsonNode payload, SignatureSignerContext signer, String jwsType) {
        String jwsString = new JWSBuilder().type(jwsType).jsonContent(payload).sign(signer);
        return SdJws.parse(jwsString);
    }

    public void verifySignature(SignatureVerifierContext verifier) throws VerificationException {
        Objects.requireNonNull(verifier, "verifier must not be null");
        try {
            if (!verifier.verify(this.jwsInput.getEncodedSignatureInput().getBytes("UTF-8"), this.jwsInput.getSignature())) {
                throw new VerificationException("Invalid jws signature");
            }
        }
        catch (Exception e) {
            throw new VerificationException((Throwable)e);
        }
    }

    private static final JWSInput parse(String jwsString) {
        try {
            return new JWSInput(Objects.requireNonNull(jwsString, "jwsString must not be null"));
        }
        catch (JWSInputException e) {
            throw new RuntimeException(e);
        }
    }

    private static final JsonNode readPayload(JWSInput jwsInput) {
        try {
            return SdJwtUtils.mapper.readTree(jwsInput.getContent());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

