/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.imprt.wizard;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.csv.io.CSVTableReader;
import com.paterva.maltego.graph.excel.io.ExcelTableReader;
import com.paterva.maltego.graph.store.GraphFactory;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.table.TableIO;
import com.paterva.maltego.graph.table.format.GroupEntityTypeFormat;
import com.paterva.maltego.graph.table.format.LinkTableFormatter;
import com.paterva.maltego.graph.table.format.PropertyFlatMapFormat;
import com.paterva.maltego.graph.table.ui.actions.TabularGraphOpenAction;
import com.paterva.maltego.graph.table.ui.actions.TabularGraphRecycleImportAction;
import com.paterva.maltego.graph.table.ui.imprt.wizard.TabularGraphImportResult;
import com.paterva.maltego.graph.table.ui.imprt.wizard.TabularImportFailurePanel;
import com.paterva.maltego.graph.table.ui.imprt.wizard.TabularImportSuccessPanel;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.ui.graph.GraphCopyHelper;
import com.paterva.maltego.util.ui.dialog.PassFailProgressController;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.Exceptions;
import org.openide.util.actions.SystemAction;

class TabularImportProgressController
extends PassFailProgressController<TabularGraphImportResult, TabularImportSuccessPanel, TabularImportFailurePanel> {
    public TabularImportProgressController() {
        this.setName("Import");
        this.setDescription("The summary of the progress to import a graph from grouped/flat entity property table(s) is shown below.");
    }

    protected TabularImportSuccessPanel createPassComponent() {
        return new TabularImportSuccessPanel();
    }

    protected TabularImportFailurePanel createFailComponent() {
        return new TabularImportFailurePanel("Data read error!");
    }

    protected void pass(WizardDescriptor descriptor, TabularImportSuccessPanel component, TabularGraphImportResult result) {
        component.setResult(result);
    }

    protected void fail(TabularImportFailurePanel failurePanel, Exception e) {
        if (e == null) {
            failurePanel.setError(null);
        } else {
            failurePanel.setError(e.getMessage());
        }
    }

    protected TabularGraphImportResult doProcessing(WizardDescriptor descriptor, ProgressHandle handle) throws Exception {
        List entityLinkPairs = (List)descriptor.getProperty("importTableFiles");
        TabularGraphImportResult result = new TabularGraphImportResult();
        for (List pair : entityLinkPairs) {
            this.importGraph(true, pair, result);
        }
        return result;
    }

    public boolean canBack() {
        return false;
    }

    List<MaltegoEntity> importGraph(boolean addToGraph, List<File> fileList, TabularGraphImportResult result) throws GraphStoreException, Exception {
        ArrayList<TableIO> tables = new ArrayList<TableIO>();
        for (File file : fileList) {
            TableIO table = TabularImportProgressController.decorateFile(file);
            if (table != null) {
                tables.add(table);
                continue;
            }
            String error = "File " + file.getName() + "cannot be converted.";
            throw new WizardValidationException((JComponent)this.getDisplayComponent(), error, error);
        }
        if (tables.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List<MaltegoEntity> entities = TabularImportProgressController.extractEntities(tables);
        if (entities.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Map<MaltegoLink, LinkEntityIDs> links = TabularImportProgressController.extractLinks(tables);
        int entitiesImported = entities.size();
        result.setEntitiesImported(entitiesImported);
        result.setLinksImported(links.size());
        this.addImportsToGraph(addToGraph, entities, links, result, entitiesImported, fileList);
        return entities;
    }

    private void addImportsToGraph(boolean addToGraph, List<MaltegoEntity> entities, Map<MaltegoLink, LinkEntityIDs> links, TabularGraphImportResult result, int entitiesImported, List<File> fileList) throws GraphStoreException {
        if (addToGraph) {
            GraphID graphID = GraphFactory.getDefault().createInvisibleInMemoryGraph();
            GraphStoreWriter.addEntities((GraphID)graphID, entities);
            GraphStoreWriter.addLinks((GraphID)graphID, links);
            Set graphEntities = GraphStoreHelper.getMaltegoEntities((GraphID)graphID);
            int graphEntityCount = graphEntities.size();
            result.setDuplicatesRemoved(entitiesImported - graphEntityCount);
            TabularImportProgressController.openNewGraph(graphID, fileList.get(0).getName());
        }
    }

    private static TableIO decorateFile(File file) throws IOException, Exception {
        if (TabularGraphRecycleImportAction.CSV_EXT_FILTER.accept(file)) {
            return new CSVTableReader(file);
        }
        if (TabularGraphRecycleImportAction.EXCEL_EXT_FILTER.accept(file)) {
            return new ExcelTableReader(file);
        }
        return null;
    }

    private static List<MaltegoEntity> extractEntities(List<TableIO> tables) {
        ArrayList<MaltegoEntity> entities = new ArrayList<MaltegoEntity>();
        if (tables == null || tables.isEmpty()) {
            return entities;
        }
        for (TableIO table : tables) {
            MaltegoEntity entity;
            GroupEntityTypeFormat etf = new GroupEntityTypeFormat(table);
            Iterator iterator = etf.entityIterator();
            while (iterator.hasNext()) {
                entity = (MaltegoEntity)iterator.next();
                if (entity == null) continue;
                entities.add(entity);
            }
            if (!entities.isEmpty()) continue;
            etf = new PropertyFlatMapFormat(table);
            iterator = etf.entityIterator();
            while (iterator.hasNext()) {
                entity = (MaltegoEntity)iterator.next();
                if (entity == null) continue;
                entities.add(entity);
            }
        }
        return entities;
    }

    private static Map<MaltegoLink, LinkEntityIDs> extractLinks(List<TableIO> tables) {
        HashMap<MaltegoLink, LinkEntityIDs> links = new HashMap<MaltegoLink, LinkEntityIDs>();
        if (tables == null || tables.isEmpty()) {
            return links;
        }
        for (TableIO table : tables) {
            LinkTableFormatter ltf = new LinkTableFormatter(table);
            Iterator iterator = ltf.linkIterator();
            while (iterator.hasNext()) {
                LinkTableFormatter.Data linkData = (LinkTableFormatter.Data)iterator.next();
                if (linkData == null) continue;
                LinkEntityIDs entityIDs = new LinkEntityIDs(linkData.getSourceID(), linkData.getTargetID());
                links.put(linkData.getLink(), entityIDs);
            }
        }
        return links;
    }

    private static void openNewGraph(GraphID memGraphID, String name) throws GraphStoreException {
        GraphID graphID = GraphCopyHelper.copy((GraphID)memGraphID, (boolean)false);
        SwingUtilities.invokeLater(() -> TabularImportProgressController.newGraphOpened(memGraphID, graphID, name));
    }

    private static void newGraphOpened(GraphID memGraphID, GraphID graphID, String name) {
        try {
            int extensionStart = name.lastIndexOf(46);
            if (extensionStart > 0) {
                name = name.substring(0, extensionStart);
            }
            TabularGraphOpenAction openAction = (TabularGraphOpenAction)SystemAction.get(TabularGraphOpenAction.class);
            openAction.setGraph(graphID, name);
            openAction.performAction();
            TabularImportProgressController.close(memGraphID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void close(GraphID memGraphID) throws GraphStoreException {
        GraphLifeCycleManager.getDefault().fireGraphClosing(memGraphID);
        GraphStore memGraphStore = GraphStoreRegistry.getDefault().forGraphID(memGraphID);
        memGraphStore.close(true);
        GraphLifeCycleManager.getDefault().fireGraphClosed(memGraphID);
    }
}

