/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.StringUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.openide.util.Lookup;

public abstract class FileStore {
    private static FileStore _instance;

    public static FileStore getDefault() {
        if (_instance == null && (_instance = (FileStore)Lookup.getDefault().lookup(FileStore.class)) == null) {
            _instance = new DefaultFileStore();
            _instance.clear();
        }
        return _instance;
    }

    public abstract int add(File var1) throws IOException;

    public abstract int add(InputStream var1, String var2) throws IOException;

    public abstract File get(int var1) throws FileNotFoundException;

    public abstract long getSize(int var1);

    public abstract void remove(int var1);

    public abstract void clear();

    public abstract String getRelativePath(int var1) throws FileNotFoundException;

    public static class DefaultFileStore
    extends FileStore {
        private final Map<Integer, File> _files;
        private final File _tempDir = FileUtilities.getTempDir("Files");
        private int _counter = 0;

        public DefaultFileStore() {
            this._files = new HashMap<Integer, File>();
        }

        @Override
        public int add(File sourceFile) throws IOException {
            File destFile = this.getUniqueTempPath(sourceFile.getName());
            FileUtilities.copyFile(sourceFile, destFile);
            this._files.put(++this._counter, destFile);
            return this._counter;
        }

        @Override
        public int add(InputStream is, String filename) throws IOException {
            File destFile = this.getUniqueTempPath(filename);
            FileUtilities.writeTo(is, destFile);
            this._files.put(++this._counter, destFile);
            return this._counter;
        }

        private File getUniqueTempPath(String filename) {
            String ext = FileUtilities.getFileExtensionCommonsIO(filename);
            String newFilename = FileUtilities.replaceIllegalCharsForPandora(FileUtilities.getFileNameWithoutExtension(filename)) + (StringUtilities.isNullOrEmpty(ext) ? "" : "." + ext);
            File destFile = null;
            int subFolderNum = 0;
            do {
                File dir = subFolderNum <= 0 ? this._tempDir : new File(this._tempDir, Integer.toString(subFolderNum));
                dir.mkdirs();
                destFile = new File(dir, newFilename);
                ++subFolderNum;
            } while (destFile.exists());
            return destFile;
        }

        @Override
        public File get(int id) throws FileNotFoundException {
            return this._files.get(id);
        }

        @Override
        public long getSize(int id) {
            return this._files.get(id).length();
        }

        @Override
        public void remove(int id) {
            Integer key = id;
            this._files.get(key).delete();
            this._files.remove(key);
        }

        @Override
        public final void clear() {
            FileUtilities.delete(this._tempDir);
        }

        @Override
        public String getRelativePath(int id) throws FileNotFoundException {
            return this.get(id).getAbsolutePath().substring(this._tempDir.getAbsolutePath().length());
        }
    }
}

