/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.find.files.impl;

import com.paterva.maltego.archive.mtz.GraphFileType;
import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.find.files.FindInFileSearcher;
import com.paterva.maltego.find.files.FindInFilesCallback;
import com.paterva.maltego.find.files.FindInFilesInput;
import com.paterva.maltego.find.files.FindInFilesResult;
import com.paterva.maltego.find.files.impl.EmptyEdgeRealizerSerializer;
import com.paterva.maltego.find.files.impl.EmptyNodeRealizerSerializer;
import com.paterva.maltego.find.files.impl.FindEntityInputHandlerProvider;
import com.paterva.maltego.find.files.impl.FindLinkInputHandlerProvider;
import com.paterva.maltego.find.files.impl.SnippetBuilder;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.metadata.GraphMetadata;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.data.GraphDataStore;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphDataStoreWriter;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.data.SearchOptions;
import com.paterva.maltego.graph.store.query.part.EntitiesDataQuery;
import com.paterva.maltego.graph.store.query.part.LinksDataQuery;
import com.paterva.maltego.mtgx.imex.FileStoreReader;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.serializer.AttachmentsPathRegistry;
import com.paterva.maltego.ui.graph.imex.GraphStoreSerializer;
import com.paterva.maltego.ui.graph.imex.MaltegoEntityIO;
import com.paterva.maltego.ui.graph.imex.MaltegoLinkIO;
import com.paterva.maltego.ui.graph.metadata.GraphMetadataEntry;
import com.paterva.maltego.ui.graph.metadata.GraphMetadataImpl;
import com.paterva.maltego.ui.graph.view2d.DefaultGraph2DViewAdapter;
import com.paterva.maltego.util.ListMap;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.PasswordUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import yguard.A.H.B.B.S;
import yguard.A.H.B.D.J;
import yguard.A.H.B.D.K;
import yguard.A.H.B.D.g;
import yguard.A.H.Q;
import yguard.A.J.SA;

public class DefaultFindInFileSearcher
extends FindInFileSearcher {
    private static final String GRAPH_NAME = "Graph1";
    private static final int BATCH_SIZE = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FindInFilesResult find(FileObject fileObject, FindInFilesInput input, FindInFilesCallback callback, AtomicBoolean cancelled) throws IOException {
        String fileDisplayName = FileUtil.getFileDisplayName((FileObject)fileObject);
        if (cancelled.get()) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            throw new IOException("File not found: " + FileUtil.getFileDisplayName((FileObject)fileObject));
        }
        ZipFile zipFile = this.getGraphZipFile(file, fileObject, callback);
        if (zipFile == null) {
            return null;
        }
        GraphFileType fileType = GraphFileType.forFile((File)file);
        FindInFilesResult result = new FindInFilesResult();
        if (GraphFileType.GRAPHML.equals((Object)fileType)) {
            FileHeader fileHeader = this.getGraphFileHeader(zipFile);
            if (fileHeader == null) {
                throw new IOException("Invalid Maltego graph file. Unable to find internal GraphML: " + fileDisplayName);
            }
            if (!this.contains(zipFile, fileHeader, input, fileDisplayName)) {
                return null;
            }
            if (cancelled.get()) {
                return null;
            }
            Q handler = new Q();
            g core = handler.T();
            if (input.isSearchEntities()) {
                MaltegoEntityIO entityReader = new MaltegoEntityIO();
                EntityFactory factory = EntityFactory.getDefault();
                core.B((S)new FindEntityInputHandlerProvider(factory, entityReader, input, result, cancelled));
            }
            if (input.isSearchLinks()) {
                MaltegoLinkIO linkReader = new MaltegoLinkIO();
                core.B((S)new FindLinkInputHandlerProvider(linkReader, input, result, cancelled));
            }
            handler.A((J)new EmptyNodeRealizerSerializer());
            handler.A((K)new EmptyEdgeRealizerSerializer());
            if (cancelled.get()) {
                return null;
            }
            ZipInputStream inputStream = this.getGraphInputStream(zipFile, fileHeader);
            if (inputStream != null) {
                try {
                    handler.A(new SA(), (InputStream)inputStream);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException factory) {}
                }
            }
            if (!result.getMatchedParts().isEmpty()) {
                result.setFolderPath(FileUtil.toFile((FileObject)fileObject.getParent()).getAbsolutePath());
                result.setGraphName(fileObject.getNameExt());
                result.setGraphMetaData(this.loadMetadata(zipFile));
                return result;
            }
        } else {
            AttachmentsPathRegistry.lock();
            Map oldPaths = AttachmentsPathRegistry.getPaths();
            try {
                GraphID graphID = GraphID.create();
                EntityRegistry entityRegistry = EntityRegistry.getDefault();
                EntityRegistry.associate((GraphID)graphID, (EntityRegistry)entityRegistry);
                LinkRegistry linkRegistry = LinkRegistry.getDefault();
                LinkRegistry.associate((GraphID)graphID, (LinkRegistry)linkRegistry);
                MaltegoArchiveReader reader = new MaltegoArchiveReader(zipFile);
                HashMap paths = FileStoreReader.readPaths((MaltegoArchiveReader)reader, (String)GRAPH_NAME);
                AttachmentsPathRegistry.setPaths((Map)paths);
                GraphStore graphStore = GraphStoreSerializer.getDefault().readData(reader, graphID);
                GraphDataStore dataStore = graphStore.getGraphDataStore();
                GraphDataStoreReader dataStoreReader = dataStore.getDataStoreReader();
                GraphDataStoreWriter dataWriter = dataStore.getDataStoreWriter();
                dataWriter.convertAttachmentPathsToIDs(AttachmentsPathRegistry.getPaths());
                SearchOptions options = DefaultGraph2DViewAdapter.toSearchOptions((String)input.getText(), this.getInputMap(input));
                List matchedEntities = Collections.synchronizedList(new ArrayList());
                if (input.isSearchEntities()) {
                    ArrayList searchEntities = new ArrayList(dataStoreReader.searchEntities(options));
                    ((Stream)DefaultFindInFileSearcher.batches(searchEntities, 10000).parallel()).forEach(entityIDs -> {
                        try {
                            EntitiesDataQuery query = new EntitiesDataQuery();
                            query.setIDs(new HashSet(entityIDs));
                            dataStoreReader.getEntities(query).forEach((id, maltegoEntity) -> {
                                SnippetBuilder snippetBuilder = new SnippetBuilder((SpecRegistry)entityRegistry, input);
                                String snippet = snippetBuilder.buildSnippet((MaltegoPart)maltegoEntity);
                                if (!StringUtilities.isNullOrEmpty((String)snippet)) {
                                    FindInFilesResult.Part part = new FindInFilesResult.Part();
                                    part.setPart((MaltegoPart)maltegoEntity);
                                    part.setMatchSnippet(snippet);
                                    matchedEntities.add(part);
                                }
                            });
                        }
                        catch (GraphStoreException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    });
                }
                result.getMatchedParts().addAll(matchedEntities);
                List matchedLinks = Collections.synchronizedList(new ArrayList());
                if (input.isSearchLinks()) {
                    ArrayList searchLinks = new ArrayList(dataStoreReader.searchLinks(options));
                    ((Stream)DefaultFindInFileSearcher.batches(searchLinks, 10000).parallel()).forEach(linkIDs -> {
                        try {
                            LinksDataQuery query = new LinksDataQuery();
                            query.setIDs(new HashSet(linkIDs));
                            dataStoreReader.getLinks(query).forEach((id, maltegoLink) -> {
                                SnippetBuilder snippetBuilder = new SnippetBuilder((SpecRegistry)linkRegistry, input);
                                String snippet = snippetBuilder.buildSnippet((MaltegoPart)maltegoLink);
                                if (!StringUtilities.isNullOrEmpty((String)snippet)) {
                                    FindInFilesResult.Part part = new FindInFilesResult.Part();
                                    part.setPart((MaltegoPart)maltegoLink);
                                    part.setMatchSnippet(snippet);
                                    matchedLinks.add(part);
                                }
                            });
                        }
                        catch (GraphStoreException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    });
                }
                result.getMatchedParts().addAll(matchedLinks);
                graphStore.close(true);
                GraphLifeCycleManager.getDefault().fireGraphClosed(graphID);
            }
            finally {
                AttachmentsPathRegistry.setPaths((Map)oldPaths);
                AttachmentsPathRegistry.unlock();
            }
        }
        if (!result.getMatchedParts().isEmpty()) {
            result.setFolderPath(FileUtil.toFile((FileObject)fileObject.getParent()).getAbsolutePath());
            result.setGraphName(fileObject.getNameExt());
            result.setGraphMetaData(this.loadMetadata(zipFile));
            return result;
        }
        return null;
    }

    public static <T> Stream<List<T>> batches(List<T> source, int length) {
        int size = source.size();
        if (size <= 0) {
            return Stream.empty();
        }
        int fullChunks = (size - 1) / length;
        return IntStream.range(0, fullChunks + 1).mapToObj(n -> source.subList(n * length, n == fullChunks ? size : (n + 1) * length));
    }

    private ListMap<String, Object> getInputMap(FindInFilesInput input) {
        ListMap map = new ListMap();
        MaltegoEntitySpec spec = new MaltegoEntitySpec();
        spec.setTypeName(input.getEntityType());
        map.put((Object)"type", (Object)spec);
        map.put((Object)"displayInfo", (Object)input.isSearchDisplayInfo());
        map.put((Object)"notes", (Object)input.isSearchNotes());
        map.put((Object)"allProperties", (Object)input.isSearchProperties());
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean contains(ZipFile zipFile, FileHeader fileHeader, FindInFilesInput input, String name) throws IOException {
        ZipInputStream inputStream;
        if (StringUtilities.isNullOrEmpty((String)input.getText())) {
            return true;
        }
        String text = input.getText();
        if (!input.isRegex() && !input.isCaseSensitive()) {
            text = text.toLowerCase();
        }
        if ((inputStream = this.getGraphInputStream(zipFile, fileHeader)) == null) {
            throw new IOException("Invalid Maltego graph file. Unable to get GraphML input stream: " + name);
        }
        BufferedReader reader = null;
        try {
            String line;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            reader = new BufferedReader(inputStreamReader);
            while ((line = reader.readLine()) != null) {
                if (input.isRegex()) {
                    if (!input.matches(line)) continue;
                    System.out.println("Match line: " + line);
                    boolean bl = true;
                    return bl;
                }
                if (!input.isCaseSensitive()) {
                    line = line.toLowerCase();
                }
                if (!line.contains(text)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                } else {
                    inputStream.close(true);
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZipFile getGraphZipFile(File file, FileObject fileObject, FindInFilesCallback callback) throws IOException {
        ZipFile zipFile;
        block10: {
            zipFile = null;
            try {
                Object monitor;
                zipFile = new ZipFile(file);
                if (!zipFile.isValidZipFile()) {
                    throw new IOException("Invalid Maltego graph file. Not a zip file: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                }
                if (!zipFile.isEncrypted()) break block10;
                Object object = monitor = new Object();
                synchronized (object) {
                    zipFile.setPassword(callback.getPassword());
                    boolean firstTry = true;
                    while (!(callback.isSkipAll() || callback.isSkip() || PasswordUtil.isPasswordValid((ZipFile)zipFile))) {
                        callback.requestPassword(fileObject, monitor, firstTry);
                        try {
                            monitor.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        zipFile.setPassword(callback.getPassword());
                        firstTry = false;
                    }
                    if (callback.isSkip() || callback.isSkipAll()) {
                        return null;
                    }
                }
            }
            catch (ZipException ex) {
                throw new IOException(ex);
            }
        }
        return zipFile;
    }

    private FileHeader getGraphFileHeader(ZipFile zipFile) throws IOException {
        FileHeader fileHeader = null;
        try {
            String path = "Graphs/Graph1.graphml";
            fileHeader = zipFile.getFileHeader(path);
        }
        catch (ZipException ex) {
            throw new IOException(ex);
        }
        return fileHeader;
    }

    private ZipInputStream getGraphInputStream(ZipFile zipFile, FileHeader fileHeader) throws IOException {
        ZipInputStream inputStream = null;
        try {
            inputStream = zipFile.getInputStream(fileHeader);
        }
        catch (ZipException ex) {
            throw new IOException(ex);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraphMetadata loadMetadata(ZipFile zipFile) throws IOException {
        GraphMetadataImpl metadata;
        block10: {
            metadata = null;
            try {
                ZipInputStream inputStream;
                GraphMetadataEntry entry = new GraphMetadataEntry(GRAPH_NAME);
                FileHeader fileHeader = zipFile.getFileHeader(entry.getName());
                if (fileHeader == null || (inputStream = zipFile.getInputStream(fileHeader)) == null) break block10;
                try {
                    metadata = entry.read((InputStream)inputStream);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (ZipException ex) {
                throw new IOException(ex);
            }
        }
        if (metadata == null) {
            metadata = new GraphMetadataImpl();
        }
        return metadata;
    }
}

