/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.table;

public abstract class ModelDecorator {
    private ActionDecorator[] _markers;

    public ModelDecorator(String ... actions) {
        this._markers = new ActionDecorator[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            this._markers[i] = new ActionDecorator(actions[i]);
        }
    }

    protected abstract int getDelegateColumnCount();

    protected abstract String getDelegateColumnName(int var1);

    protected abstract Class<?> getDelegateColumnClass(int var1);

    private int getButtonCount() {
        return this._markers.length;
    }

    public int getColumnCount() {
        return this.getDelegateColumnCount() + this.getButtonCount();
    }

    public String getColumnName(int column) {
        if (column >= this.getDelegateColumnCount()) {
            return this._markers[column - this.getDelegateColumnCount()].getCommand();
        }
        return this.getDelegateColumnName(column);
    }

    public Class<?> getColumnClass(int column) {
        if (column < this.getDelegateColumnCount()) {
            return this.getDelegateColumnClass(column);
        }
        return ActionDecorator.class;
    }

    public ActionDecorator getDecorator(int column) {
        return this._markers[column];
    }

    public static class ActionDecorator {
        private String _command;

        public ActionDecorator(String command) {
            this._command = command;
        }

        public String getCommand() {
            return this._command;
        }
    }
}

