/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.tx3.java.api.constraints.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.maltego.tx3.java.api.constraints.ConstraintTypeEnum;
import com.maltego.tx3.java.api.constraints.LogicalOperation;
import com.maltego.tx3.java.api.constraints.execution.InputConstraint;
import com.maltego.tx3.java.api.execution.Entity;
import com.maltego.tx3.java.api.execution.Graph;
import com.maltego.tx3.java.api.execution.Link;
import com.maltego.tx3.java.api.execution.Property;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class CompositeInputConstraint
extends InputConstraint {
    private final List<InputConstraint> constraints;
    private final LogicalOperation operation;

    @JsonCreator
    public CompositeInputConstraint(@JsonProperty(value="constraints") List<InputConstraint> constraints, @JsonProperty(value="operation") String operation) {
        this.constraints = constraints;
        this.operation = LogicalOperation.valueOf(operation.toUpperCase());
        this.constraintType = ConstraintTypeEnum.GROUP_CONSTRAINT;
    }

    @Override
    public boolean evaluate(Entity inputValue) {
        return this.evaluate((Object)inputValue);
    }

    @Override
    public boolean evaluate(Graph inputValue) {
        return this.evaluate((Object)inputValue);
    }

    @Override
    public boolean evaluate(Link inputValue) {
        return this.evaluate((Object)inputValue);
    }

    @Override
    public boolean evaluate(Property inputValue) {
        return this.evaluate((Object)inputValue);
    }

    @Override
    public boolean evaluate(Object inputValue) {
        ArrayList<Boolean> evaluationResults = new ArrayList<Boolean>();
        for (InputConstraint constraint : this.constraints) {
            if (constraint.getConstraintType() == ConstraintTypeEnum.GROUP_CONSTRAINT) {
                evaluationResults.add(constraint.evaluate(inputValue));
                continue;
            }
            if (inputValue instanceof Entity && constraint.getConstraintType() == ConstraintTypeEnum.ENTITY) {
                evaluationResults.add(constraint.evaluate((Entity)inputValue));
                continue;
            }
            if (inputValue instanceof Link && constraint.getConstraintType() == ConstraintTypeEnum.LINK) {
                evaluationResults.add(constraint.evaluate((Link)inputValue));
                continue;
            }
            if (inputValue instanceof Graph && constraint.getConstraintType() == ConstraintTypeEnum.GRAPH) {
                evaluationResults.add(constraint.evaluate((Graph)inputValue));
                continue;
            }
            if (inputValue instanceof Property && constraint.getConstraintType() == ConstraintTypeEnum.PROPERTY) {
                evaluationResults.add(constraint.evaluate((Property)inputValue));
                continue;
            }
            throw new IllegalArgumentException("Invalid evaluate method for inputValue type " + inputValue.getClass() + " and constraint type " + (Object)((Object)constraint.getConstraintType()));
        }
        Stream evaluations = evaluationResults.parallelStream();
        switch (this.operation) {
            case ANY: {
                return evaluations.anyMatch(Boolean::booleanValue);
            }
            case ALL: {
                return evaluations.allMatch(Boolean::booleanValue);
            }
            case NONE: {
                return evaluations.noneMatch(Boolean::booleanValue);
            }
        }
        throw new IllegalArgumentException("Invalid operation: " + (Object)((Object)this.operation));
    }

    @Override
    public LogicalOperation getConstraintOperation() {
        return this.operation;
    }

    @Override
    public List<InputConstraint> getInnerConstraints() {
        return this.constraints;
    }
}

