/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.tx3.java.api.constraints.execution.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.maltego.tx3.java.api.constraints.ConstraintTargetTypeEnum;
import com.maltego.tx3.java.api.constraints.ConstraintTypeEnum;
import com.maltego.tx3.java.api.constraints.LogicalOperation;
import com.maltego.tx3.java.api.constraints.execution.InputConstraint;
import com.maltego.tx3.java.api.execution.Entity;
import java.util.List;

public class BaseEntitySatisfies
extends InputConstraint {
    private final String matchValue;
    private final MatchOperation operation;

    @JsonCreator
    public BaseEntitySatisfies(@JsonProperty(value="matchValue") String matchValue, @JsonProperty(value="operation") MatchOperation operation) {
        this.matchValue = matchValue;
        this.operation = operation;
        this.constraintType = ConstraintTypeEnum.ENTITY;
        this.constraintTargetType = ConstraintTargetTypeEnum.BASE_ENTITY_TYPE;
    }

    @Override
    public boolean evaluate(Entity inputValue) {
        List<String> baseEntityTypes = inputValue.getBaseEntities();
        return this.checkBaseEntityType(baseEntityTypes);
    }

    private boolean checkBaseEntityType(List<String> baseEntityTypes) {
        if (baseEntityTypes == null || baseEntityTypes.isEmpty()) {
            return false;
        }
        return baseEntityTypes.stream().anyMatch(this::matches);
    }

    private boolean matches(String baseEntityType) {
        if (baseEntityType == null) {
            return false;
        }
        switch (this.operation) {
            case IS: {
                return baseEntityType.equals(this.matchValue);
            }
            case CONTAINS: {
                return baseEntityType.contains(this.matchValue);
            }
        }
        throw new IllegalArgumentException("Invalid operation: " + (Object)((Object)this.operation));
    }

    public MatchOperation getOperation() {
        return this.operation;
    }

    public String getMatchValue() {
        return this.matchValue;
    }

    @Override
    public LogicalOperation getConstraintOperation() {
        return LogicalOperation.ALL;
    }

    public static enum MatchOperation {
        IS,
        CONTAINS;

    }
}

