/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.js.nodes.FrameDescriptorProvider;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.control.ResumableNode;
import com.oracle.truffle.js.nodes.control.YieldException;
import com.oracle.truffle.js.nodes.instrumentation.DeclareTagProvider;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

public abstract class BlockScopeNode
extends JavaScriptNode
implements ResumableNode,
RepeatingNode {
    @Node.Child
    protected JavaScriptNode block;

    protected BlockScopeNode(JavaScriptNode block) {
        this.block = block;
    }

    public static BlockScopeNode create(JavaScriptNode block, FrameSlot blockScopeSlot, FrameDescriptor frameDescriptor, FrameSlot parentSlot, boolean functionBlock, boolean captureFunctionFrame) {
        return new FrameBlockScopeNode(block, blockScopeSlot, frameDescriptor, parentSlot, functionBlock, captureFunctionFrame);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        try {
            Object object = this.block.execute(this.appendScopeFrame(frame));
            return object;
        }
        finally {
            this.exitScope(frame);
        }
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        try {
            this.block.executeVoid(this.appendScopeFrame(frame));
        }
        finally {
            this.exitScope(frame);
        }
    }

    public abstract VirtualFrame appendScopeFrame(VirtualFrame var1);

    public abstract void exitScope(VirtualFrame var1);

    public abstract Object getBlockScope(VirtualFrame var1);

    public abstract void setBlockScope(VirtualFrame var1, Object var2);

    public boolean executeRepeating(VirtualFrame frame) {
        try {
            boolean bl = ((RepeatingNode)this.block).executeRepeating(this.appendScopeFrame(frame));
            return bl;
        }
        finally {
            this.exitScope(frame);
        }
    }

    public JavaScriptNode getBlock() {
        return this.block;
    }

    public abstract boolean isFunctionBlock();

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return this.block.isResultAlwaysOfType(clazz);
    }

    public static class FrameBlockScopeNode
    extends BlockScopeNode
    implements FrameDescriptorProvider {
        protected final FrameSlot blockScopeSlot;
        protected final FrameDescriptor frameDescriptor;
        protected final FrameSlot parentSlot;
        protected final boolean functionBlock;
        protected final boolean captureFunctionFrame;

        protected FrameBlockScopeNode(JavaScriptNode block, FrameSlot blockScopeSlot, FrameDescriptor frameDescriptor, FrameSlot parentSlot, boolean functionBlock, boolean captureFunctionFrame) {
            super(block);
            this.blockScopeSlot = blockScopeSlot;
            this.frameDescriptor = frameDescriptor;
            this.parentSlot = parentSlot;
            this.functionBlock = functionBlock;
            this.captureFunctionFrame = captureFunctionFrame;
        }

        public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
            if (materializedTags.contains(JSTags.DeclareTag.class) && !DeclareTagProvider.isMaterializedFrameProvider(this)) {
                JavaScriptNode materialized = DeclareTagProvider.createMaterializedBlockNode(FrameBlockScopeNode.cloneUninitialized(this.block, materializedTags), this.blockScopeSlot, this.frameDescriptor, this.parentSlot, this.getSourceSection(), this.functionBlock, this.captureFunctionFrame);
                FrameBlockScopeNode.transferSourceSectionAndTags(this, materialized);
                return materialized;
            }
            return this;
        }

        @Override
        public VirtualFrame appendScopeFrame(VirtualFrame frame) {
            Object parentScopeFrame = FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.blockScopeSlot);
            if (this.captureFunctionFrame) {
                assert (parentScopeFrame == Undefined.instance);
                parentScopeFrame = frame.materialize();
            }
            MaterializedFrame scopeFrame = Truffle.getRuntime().createVirtualFrame(frame.getArguments(), this.frameDescriptor).materialize();
            scopeFrame.setObject(this.parentSlot, parentScopeFrame);
            frame.setObject(this.blockScopeSlot, (Object)scopeFrame);
            return frame;
        }

        @Override
        public void exitScope(VirtualFrame frame) {
            MaterializedFrame blockScopeFrame = JSFrameUtil.castMaterializedFrame(FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.blockScopeSlot));
            Object parentScopeFrame = FrameUtil.getObjectSafe((Frame)blockScopeFrame, (FrameSlot)this.parentSlot);
            if (this.captureFunctionFrame) {
                assert (((Frame)parentScopeFrame).getFrameDescriptor() == frame.getFrameDescriptor());
                parentScopeFrame = Undefined.instance;
            }
            frame.setObject(this.blockScopeSlot, parentScopeFrame);
            assert (CompilerDirectives.inCompiledCode() || ScopeFrameNode.isBlockScopeFrame((Frame)blockScopeFrame));
        }

        @Override
        public FrameDescriptor getFrameDescriptor() {
            return this.frameDescriptor;
        }

        @Override
        public Object resume(VirtualFrame frame) {
            Object state = this.getStateAndReset(frame);
            if (state == Undefined.instance) {
                this.appendScopeFrame(frame);
            } else {
                this.setBlockScope(frame, state);
            }
            try {
                Object object = this.block.execute(frame);
                return object;
            }
            catch (YieldException e) {
                this.setState(frame, this.getBlockScope(frame));
                throw e;
            }
            finally {
                this.exitScope(frame);
            }
        }

        @Override
        public Object getBlockScope(VirtualFrame frame) {
            return FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.blockScopeSlot);
        }

        @Override
        public void setBlockScope(VirtualFrame frame, Object state) {
            assert (state instanceof MaterializedFrame);
            frame.setObject(this.blockScopeSlot, state);
        }

        @Override
        public boolean isFunctionBlock() {
            return this.functionBlock;
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new FrameBlockScopeNode(FrameBlockScopeNode.cloneUninitialized(this.block, materializedTags), this.blockScopeSlot, this.frameDescriptor, this.parentSlot, this.functionBlock, this.captureFunctionFrame);
        }
    }
}

