/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.SparseArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class AbstractConstantArray
extends DynamicArray {
    protected static final CreateWritableProfileAccess CREATE_WRITABLE_PROFILE = new CreateWritableProfileAccess(){};

    protected AbstractConstantArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    @Override
    public final ScriptArray setElementImpl(DynamicObject object, long index, Object value, boolean strict) {
        if (index <= Integer.MAX_VALUE) {
            if (value instanceof Integer) {
                return this.createWriteableInt(object, index, (Integer)value, ScriptArray.ProfileHolder.empty()).setElementImpl(object, index, value, strict);
            }
            if (value instanceof Double) {
                return this.createWriteableDouble(object, index, (Double)value, ScriptArray.ProfileHolder.empty()).setElementImpl(object, index, value, strict);
            }
            return this.createWriteableObject(object, index, value, ScriptArray.ProfileHolder.empty()).setElementImpl(object, index, value, strict);
        }
        return SparseArray.makeSparseArray(object, this).setElementImpl(object, index, value, strict);
    }

    @Override
    public final Object getElement(DynamicObject object, long index) {
        if (this.isInBoundsFast(object, index)) {
            return this.getElementInBounds(object, (int)index);
        }
        return Undefined.instance;
    }

    @Override
    public final Object getElementInBounds(DynamicObject object, long index) {
        assert (this.isInBoundsFast(object, index));
        return this.getElementInBounds(object, (int)index);
    }

    public abstract Object getElementInBounds(DynamicObject var1, int var2);

    @Override
    public final long length(DynamicObject object) {
        return this.lengthInt(object);
    }

    @Override
    public long firstElementIndex(DynamicObject object) {
        return 0L;
    }

    @Override
    public long lastElementIndex(DynamicObject object) {
        return this.length(object) - 1L;
    }

    @Override
    public long nextElementIndex(DynamicObject object, long index) {
        if (index >= this.lastElementIndex(object)) {
            return JSRuntime.MAX_SAFE_INTEGER_LONG;
        }
        return index + 1L;
    }

    @Override
    public long previousElementIndex(DynamicObject object, long index) {
        return index - 1L;
    }

    @Override
    public final boolean isInBoundsFast(DynamicObject object, long index) {
        return this.firstElementIndex(object) <= index && index <= this.lastElementIndex(object);
    }

    public abstract AbstractWritableArray createWriteableDouble(DynamicObject var1, long var2, double var4, ScriptArray.ProfileHolder var6);

    public abstract AbstractWritableArray createWriteableInt(DynamicObject var1, long var2, int var4, ScriptArray.ProfileHolder var5);

    public abstract AbstractWritableArray createWriteableObject(DynamicObject var1, long var2, Object var4, ScriptArray.ProfileHolder var5);

    public abstract AbstractWritableArray createWriteableJSObject(DynamicObject var1, long var2, JSDynamicObject var4, ScriptArray.ProfileHolder var5);

    public static ScriptArray.ProfileHolder createCreateWritableProfile() {
        return ScriptArray.ProfileHolder.create(4, CreateWritableProfileAccess.class);
    }

    @Override
    public boolean hasHoles(DynamicObject object) {
        return false;
    }

    protected static interface CreateWritableProfileAccess
    extends ScriptArray.ProfileAccess {
        default public boolean lengthZero(ScriptArray.ProfileHolder profile, boolean condition) {
            return profile.profile(this, 0, condition);
        }

        default public boolean lengthBelowLimit(ScriptArray.ProfileHolder profile, boolean condition) {
            return profile.profile(this, 1, condition);
        }

        default public boolean indexZero(ScriptArray.ProfileHolder profile, boolean condition) {
            return profile.profile(this, 2, condition);
        }

        default public boolean indexLessThanLength(ScriptArray.ProfileHolder profile, boolean condition) {
            return profile.profile(this, 3, condition);
        }
    }
}

