/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSModuleNamespaceObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.objects.Dead;
import com.oracle.truffle.js.runtime.objects.ExportResolution;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.DefinePropertyUtil;
import java.util.List;
import java.util.Map;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;

public final class JSModuleNamespace
extends JSNonProxy {
    public static final JSModuleNamespace INSTANCE = new JSModuleNamespace();
    public static final String CLASS_NAME = "Module";

    private JSModuleNamespace() {
    }

    public static JSModuleRecord getModule(DynamicObject obj) {
        assert (JSModuleNamespace.isJSModuleNamespace(obj));
        return ((JSModuleNamespaceObject)obj).getModule();
    }

    public static UnmodifiableEconomicMap<String, ExportResolution> getExports(DynamicObject obj) {
        assert (JSModuleNamespace.isJSModuleNamespace(obj));
        return ((JSModuleNamespaceObject)obj).getExports();
    }

    public static JSModuleNamespaceObject create(JSContext context, JSRealm realm, JSModuleRecord module, List<Map.Entry<String, ExportResolution>> sortedExports) {
        CompilerAsserts.neverPartOfCompilation();
        EconomicMap exportResolutionMap = EconomicMap.create((int)sortedExports.size());
        JSObjectFactory.BoundProto factory = context.getModuleNamespaceFactory();
        JSModuleNamespaceObject obj = JSModuleNamespaceObject.create(realm, factory, module, (UnmodifiableEconomicMap<String, ExportResolution>)exportResolutionMap);
        for (Map.Entry<String, ExportResolution> entry : sortedExports) {
            DynamicObjectLibrary.getUncached().putWithFlags((DynamicObject)obj, (Object)entry.getKey(), (Object)entry.getValue(), 0x40 | JSAttributes.notConfigurableEnumerableWritable());
            exportResolutionMap.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        assert (!JSObject.isExtensible(obj));
        return context.trackAllocation(obj);
    }

    public static Shape makeInitialShape(JSContext context) {
        Shape initialShape = JSShape.newBuilder(context, INSTANCE, Null.instance).shapeFlags(1).build();
        initialShape = Shape.newBuilder((Shape)initialShape).addConstantProperty((Object)JSObject.HIDDEN_PROTO, (Object)Null.instance, 0).addConstantProperty((Object)Symbol.SYMBOL_TO_STRING_TAG, (Object)CLASS_NAME, JSAttributes.notConfigurableNotEnumerableNotWritable()).build();
        assert (!JSShape.isExtensible(initialShape));
        return initialShape;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return CLASS_NAME;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String toDisplayStringImpl(DynamicObject obj, int depth, boolean allowSideEffects) {
        return "[Module]";
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(DynamicObject store, Object thisObj, Object key, Node encapsulatingNode) {
        if (!(key instanceof String)) {
            return super.getOwnHelper(store, thisObj, key, encapsulatingNode);
        }
        ExportResolution binding = (ExportResolution)JSModuleNamespace.getExports(store).get((Object)((String)key));
        if (binding != null) {
            return JSModuleNamespace.getBindingValue(binding);
        }
        return Undefined.instance;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object getBindingValue(ExportResolution binding) {
        JSModuleRecord targetModule = binding.getModule();
        MaterializedFrame targetEnv = targetModule.getEnvironment();
        if (targetEnv == null) {
            throw Errors.createReferenceErrorNotDefined(binding.getBindingName(), null);
        }
        if (binding.isNamespace()) {
            return targetModule.getContext().getEvaluator().getModuleNamespace(targetModule);
        }
        FrameSlot frameSlot = targetEnv.getFrameDescriptor().findFrameSlot((Object)binding.getBindingName());
        if (JSFrameUtil.hasTemporalDeadZone(frameSlot) && targetEnv.isObject(frameSlot) && FrameUtil.getObjectSafe((Frame)targetEnv, (FrameSlot)frameSlot) == Dead.instance()) {
            throw Errors.createReferenceErrorNotDefined(binding.getBindingName(), null);
        }
        return targetEnv.getValue(frameSlot);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasProperty(DynamicObject thisObj, Object key) {
        if (!(key instanceof String)) {
            return super.hasProperty(thisObj, key);
        }
        return JSModuleNamespace.getExports(thisObj).containsKey((Object)((String)key));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasOwnProperty(DynamicObject thisObj, Object key) {
        if (!(key instanceof String)) {
            return super.hasOwnProperty(thisObj, key);
        }
        ExportResolution binding = (ExportResolution)JSModuleNamespace.getExports(thisObj).get((Object)((String)key));
        if (binding != null) {
            JSModuleNamespace.getBindingValue(binding);
            return true;
        }
        return false;
    }

    @Override
    public boolean delete(DynamicObject thisObj, long index, boolean isStrict) {
        return true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(DynamicObject thisObj, Object key, boolean isStrict) {
        if (!(key instanceof String)) {
            return super.delete(thisObj, key, isStrict);
        }
        if (JSModuleNamespace.getExports(thisObj).containsKey((Object)((String)key))) {
            if (isStrict) {
                throw Errors.createTypeErrorNotConfigurableProperty(key);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean setPrototypeOf(DynamicObject thisObj, DynamicObject newPrototype) {
        return newPrototype == Null.instance;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean defineOwnProperty(DynamicObject thisObj, Object key, PropertyDescriptor desc, boolean doThrow) {
        if (!(key instanceof String)) {
            return super.defineOwnProperty(thisObj, key, desc, doThrow);
        }
        PropertyDescriptor current = this.getOwnProperty(thisObj, key);
        if (current != null && !desc.isAccessorDescriptor() && desc.getIfHasWritable(true) && desc.getIfHasEnumerable(true) && !desc.getIfHasConfigurable(false) && (!desc.hasValue() || JSRuntime.isSameValue(desc.getValue(), current.getValue()))) {
            return true;
        }
        return DefinePropertyUtil.reject(doThrow, "not allowed to defineProperty on a namespace object");
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public PropertyDescriptor getOwnProperty(DynamicObject thisObj, Object key) {
        if (!(key instanceof String)) {
            return super.getOwnProperty(thisObj, key);
        }
        ExportResolution binding = (ExportResolution)JSModuleNamespace.getExports(thisObj).get((Object)((String)key));
        if (binding != null) {
            Object value = JSModuleNamespace.getBindingValue(binding);
            return PropertyDescriptor.createData(value, true, true, false);
        }
        return null;
    }

    public static boolean isJSModuleNamespace(Object obj) {
        return obj instanceof JSModuleNamespaceObject;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean setIntegrityLevel(DynamicObject obj, boolean freeze, boolean doThrow) {
        for (ExportResolution binding : JSModuleNamespace.getExports(obj).getValues()) {
            JSModuleNamespace.getBindingValue(binding);
            if (!freeze) continue;
            throw Errors.createTypeError("not allowed to freeze a namespace object");
        }
        return true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean testIntegrityLevel(DynamicObject obj, boolean frozen) {
        for (ExportResolution binding : JSModuleNamespace.getExports(obj).getValues()) {
            JSModuleNamespace.getBindingValue(binding);
            if (!frozen) continue;
            return false;
        }
        return true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        if (isStrict) {
            throw Errors.createTypeErrorNotExtensible(thisObj, key);
        }
        return false;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(DynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        if (isStrict) {
            throw Errors.createTypeErrorNotExtensible(thisObj, Boundaries.stringValueOf(index));
        }
        return false;
    }

    @Override
    public boolean usesOrdinaryGetOwnProperty() {
        return false;
    }
}

