/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.builtins.wasm.WebAssemblyBuiltins;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public final class JSWebAssembly {
    public static final String CLASS_NAME = "WebAssembly";
    public static final HiddenKey FUNCTION_ADDRESS = new HiddenKey("FunctionAddress");

    private JSWebAssembly() {
    }

    public static DynamicObject create(JSRealm realm) {
        DynamicObject webAssembly = JSOrdinary.createInit(realm);
        JSObjectUtil.putToStringTag(webAssembly, CLASS_NAME);
        JSObjectUtil.putFunctionsFromContainer(realm, webAssembly, WebAssemblyBuiltins.BUILTINS);
        return webAssembly;
    }

    public static boolean isExportedFunction(Object function) {
        return JSDynamicObject.isJSDynamicObject(function) && JSObjectUtil.hasHiddenProperty((JSDynamicObject)((Object)function), FUNCTION_ADDRESS);
    }

    public static Object getExportedFunction(DynamicObject function) {
        assert (JSWebAssembly.isExportedFunction(function));
        return JSObjectUtil.getHiddenProperty(function, FUNCTION_ADDRESS);
    }

    public static Object getEmbedderData(JSRealm realm, Object wasmEntity) {
        Object embedderDataGetter = realm.getWASMEmbedderDataGet();
        try {
            return InteropLibrary.getUncached((Object)embedderDataGetter).execute(embedderDataGetter, new Object[]{wasmEntity});
        }
        catch (InteropException iex) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)iex);
        }
    }

    public static void setEmbedderData(JSRealm realm, Object wasmEntity, Object data) {
        Object embedderDataSetter = realm.getWASMEmbedderDataSet();
        try {
            InteropLibrary.getUncached((Object)embedderDataSetter).execute(embedderDataSetter, new Object[]{wasmEntity, data});
        }
        catch (InteropException iex) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)iex);
        }
    }
}

