/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.api.impl;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.transform.api.TransformMessage;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.runner.api.TransformErrorHelper;
import com.paterva.maltego.transform.runner.api.TransformMessageHandler;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.transform.runner.api.TransformSpecialMessageHelper;
import com.paterva.maltego.transform.runner.api.TransformsRunContext;
import com.paterva.maltego.util.Args;
import java.util.ArrayList;
import java.util.List;

public class DefaultTransformMessageHandler
extends TransformMessageHandler {
    @Override
    public void handle(TransformRunContext ctx, List<TransformMessage> messages, MaltegoEntity inputEntity) {
        Args.notNull((Object)ctx, (String)"ctx");
        Args.notNull(messages, (String)"messages");
        messages = this.handleSpecialMessagesAndErrors(ctx, messages);
        boolean hasErrors = false;
        for (TransformMessage message : messages) {
            this.display(ctx, message, inputEntity);
            if (message.getSeverity() != TransformMessage.Severity.Error) continue;
            hasErrors = true;
        }
        TransformsRunContext transformsContext = ctx.getTransformsContext();
        if (hasErrors) {
            if (transformsContext.isPopupErrors()) {
                this.popupErrors(ctx.getTransform(), messages);
            }
            transformsContext.onTransformError(ctx, messages);
        }
    }

    protected void display(TransformRunContext ctx, TransformMessage message, MaltegoEntity inputEntity) {
        System.out.println("Transform message: " + message.getSeverity().toString().toUpperCase() + " " + message.getText());
    }

    private List<TransformMessage> handleSpecialMessagesAndErrors(TransformRunContext ctx, List<TransformMessage> messages) {
        ArrayList<TransformMessage> result = new ArrayList<TransformMessage>(messages);
        for (TransformMessage message : messages) {
            TransformMessage.Severity severity = message.getSeverity();
            int code = message.getCode();
            if (severity == TransformMessage.Severity.Error && code != 0 && (code < 200 || code >= 300) && code != Integer.MAX_VALUE) {
                if (!TransformErrorHelper.handle(ctx, message)) continue;
                result.remove(message);
                continue;
            }
            if (severity != TransformMessage.Severity.Error || code < 201 || code >= 300 || !TransformSpecialMessageHelper.handle(ctx, message)) continue;
            result.remove(message);
        }
        return result;
    }

    protected void popupErrors(TransformDefinition transform, List<TransformMessage> messages) {
    }
}

