/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.sound;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

class ThreadedSound
implements Runnable {
    private static final Logger LOG = Logger.getLogger(ThreadedSound.class.getName());
    private static List<String> _notFound;
    private String _soundFile = "";

    ThreadedSound() {
    }

    @Override
    public void run() {
        this.play();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void play() {
        if (_notFound != null && _notFound.contains(this._soundFile)) {
            return;
        }
        try {
            FileObject fo = FileUtil.getConfigFile((String)this.getSoundFile());
            try (BufferedInputStream bis = new BufferedInputStream(fo.getInputStream());
                 AudioInputStream inputStream = AudioSystem.getAudioInputStream(bis);){
                AudioListener listener = new AudioListener();
                Clip clip = AudioSystem.getClip();
                clip.addLineListener(listener);
                clip.open(inputStream);
                try {
                    clip.start();
                    listener.waitUntilDone();
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    clip.removeLineListener(listener);
                    clip.close();
                }
            }
        }
        catch (IllegalArgumentException fo) {
        }
        catch (LineUnavailableException fo) {
        }
        catch (IllegalStateException fo) {
        }
        catch (FileNotFoundException ex) {
            if (_notFound == null) {
                _notFound = new ArrayList<String>();
            }
            if (!_notFound.contains(this._soundFile)) {
                LOG.log(Level.WARNING, ex.getMessage());
                _notFound.add(this._soundFile);
            }
        }
        catch (UnsupportedAudioFileException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public String getSoundFile() {
        return this._soundFile;
    }

    public void setSoundFile(String soundFile) {
        this._soundFile = soundFile;
    }

    private static class AudioListener
    implements LineListener {
        private boolean _done = false;

        private AudioListener() {
        }

        @Override
        public synchronized void update(LineEvent event) {
            LineEvent.Type eventType = event.getType();
            if (eventType == LineEvent.Type.STOP || eventType == LineEvent.Type.CLOSE) {
                this._done = true;
                this.notifyAll();
            }
        }

        public synchronized void waitUntilDone() throws InterruptedException {
            while (!this._done) {
                this.wait();
            }
        }
    }
}

