/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.datagram;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.datagram.AbstractChannelBasedEndpoint;
import org.xsocket.datagram.IConnectedEndpoint;
import org.xsocket.datagram.IDatagramHandler;
import org.xsocket.datagram.UserDatagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectedEndpoint
extends AbstractChannelBasedEndpoint
implements IConnectedEndpoint {
    private static final Logger LOG = Logger.getLogger(ConnectedEndpoint.class.getName());
    private final SocketAddress remoteAddress;

    public ConnectedEndpoint(String host, int port) throws IOException {
        this(new InetSocketAddress(host, port));
    }

    public ConnectedEndpoint(SocketAddress remoteAddress) throws IOException {
        this(remoteAddress, -1);
    }

    public ConnectedEndpoint(SocketAddress remoteAddress, int receivePacketSize) throws IOException {
        this(remoteAddress, receivePacketSize, null);
    }

    public ConnectedEndpoint(String host, int port, int receivePacketSize) throws IOException {
        this((SocketAddress)new InetSocketAddress(host, port), new HashMap<String, Object>(), receivePacketSize, null, ConnectedEndpoint.getGlobalWorkerPool());
    }

    public ConnectedEndpoint(SocketAddress remoteAddress, int receivePacketSize, IDatagramHandler datagramHandler) throws IOException {
        this(remoteAddress, new HashMap<String, Object>(), receivePacketSize, datagramHandler, ConnectedEndpoint.getGlobalWorkerPool());
    }

    public ConnectedEndpoint(SocketAddress remoteAddress, Map<String, Object> options, int receivePacketSize, IDatagramHandler datagramHandler) throws IOException {
        this(remoteAddress, options, receivePacketSize, datagramHandler, ConnectedEndpoint.getGlobalWorkerPool());
    }

    public ConnectedEndpoint(SocketAddress remoteAddress, Map<String, Object> options, int receivePacketSize, IDatagramHandler datagramHandler, Executor workerPool) throws IOException {
        super(new InetSocketAddress(0), options, datagramHandler, receivePacketSize, workerPool);
        this.remoteAddress = remoteAddress;
        this.getChannel().connect(remoteAddress);
    }

    @Override
    public void send(UserDatagram packet) throws IOException {
        if (LOG.isLoggable(Level.FINER) && packet.getRemoteSocketAddress() != null) {
            LOG.fine("remote address of given packet is already set with " + packet.getRemoteSocketAddress() + ". this value will be overriden by " + this.remoteAddress);
        }
        packet.setRemoteAddress(this.remoteAddress);
        super.send(packet);
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.remoteAddress;
    }

    @Override
    protected ConnectedEndpoint setOption(String name, Object value) throws IOException {
        return (ConnectedEndpoint)super.setOption(name, value);
    }
}

