/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui;

import com.maltego.cloud.CloudAuth;
import com.paterva.maltego.licensing.C;
import com.paterva.maltego.licensing.EulaDisplayer;
import com.paterva.maltego.licensing.LicenseErrorDisplayer;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.serialize.I;
import com.paterva.maltego.licensing.serialize.J;
import com.paterva.maltego.licensing.ui.CaseFileEntitiesManager;
import com.paterva.maltego.licensing.ui.eula.EulaDownloader;
import com.paterva.maltego.licensing.ui.laf.LicenseLookAndFeelUpdater;
import com.paterva.maltego.licensing.ui.monitor.A;
import com.paterva.maltego.licensing.ui.monitor.B;
import com.paterva.maltego.licensing.ui.monitor.E;
import com.paterva.maltego.licensing.ui.product.ProductSelectionAction;
import com.paterva.maltego.licensing.ui.wizard.FirstRunWizard;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.Version;
import com.paterva.maltego.util.ui.dialog.UIRunQueue;
import com.paterva.maltego.util.ui.problemreport.settings.ProblemReportOptions;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.openide.modules.ModuleInstall;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public class Installer
extends ModuleInstall {
    private static final Logger LOG = Logger.getLogger(Installer.class.getName());
    public static final String CHECK_EULA_ACCEPTED_TASK = "CheckEulaAccepted";

    public void restored() {
        LicenseManager licenseManager = LicenseManager.A();
        com.paterva.maltego.licensing.mode.A licenseMode = licenseManager.A(false);
        LicenseLookAndFeelUpdater.init();
        A.H();
        B.I();
        E.D();
        CaseFileEntitiesManager.init();
        LOG.log(Level.INFO, "License mode: {0}", licenseMode.V());
        LOG.log(Level.INFO, "Machine hash: {0}", ProblemReportOptions.getDefault().getMachineIdHash());
        Version version = Version.getCurrent();
        System.setProperty("netbeans.buildnumber", version.toString(false, false, true));
        Logger.getLogger(com.paterva.maltego.util.Installer.class.getName()).log(Level.INFO, "Version: {0}", version.toString(true, true, true));
        PropertyChangeListener frameListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ignored1) {
                final JFrame frame = (JFrame)WindowManager.getDefault().getMainWindow();
                if (frame != null) {
                    WindowManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                    PropertyChangeListener titleListener = new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent ignored2) {
                            frame.removePropertyChangeListener("title", this);
                            SwingUtilities.invokeLater(() -> {
                                com.paterva.maltego.licensing.mode.A licenseMode = LicenseManager.A().A(false);
                                LicenseLookAndFeelUpdater.updateTitleBar(licenseMode);
                            });
                        }
                    };
                    frame.addPropertyChangeListener("title", titleListener);
                }
            }
        };
        WindowManager.getDefault().addPropertyChangeListener(frameListener);
        if (licenseMode.D()) {
            UIRunQueue.instance().queue(5, "Startup - Product Selection", () -> {
                ProductSelectionAction action = (ProductSelectionAction)SystemAction.get(ProductSelectionAction.class);
                action.actionPerformed(new ActionEvent((Object)this, 0, "startup"));
            });
        } else if (licenseMode.L()) {
            UIRunQueue.instance().queue(5, "Startup - CE -> Unified MaltegoID", () -> {
                try {
                    CloudAuth.getDefault().logout(true);
                }
                catch (Exception ex) {
                    NormalException.logStackTrace((Throwable)ex);
                }
                licenseManager.C(false);
                licenseManager.B(false);
                licenseManager.H(false);
                licenseManager.G(false);
                licenseManager.I(false);
                licenseManager.A(licenseMode);
            });
        }
        UIRunQueue.instance().queue(150, "First Run Wizard", () -> FirstRunWizard.checkShow());
        UIRunQueue.instance().queue(25000, "Eula Accepted Check", this::checkEulaAccepted);
    }

    private void checkEulaAccepted() {
        com.paterva.maltego.licensing.mode.A licMode = LicenseManager.A().A(false);
        C capabilityValidity = licMode.J();
        if (licMode.W()) {
            capabilityValidity = licMode.R();
        }
        if (licMode.Q() || capabilityValidity != null && capabilityValidity.J().B()) {
            UIRunQueue.instance().registerAsyncTask(CHECK_EULA_ACCEPTED_TASK);
            Thread thread = new Thread(() -> {
                EulaDownloader downloader = new EulaDownloader();
                downloader.downloadLatest().ifPresent(eula -> {
                    Optional savedEulaOpt = J.A();
                    if (!(savedEulaOpt.isPresent() && eula.B().equals(((I)savedEulaOpt.get()).B()) && ((I)savedEulaOpt.get()).C())) {
                        eula.A(false);
                        UIRunQueue.instance().queue(35000, "Eula Accepted Save", () -> {
                            J.A((I)eula);
                            this.checkSavedEulaAccepted();
                            UIRunQueue.instance().setAsyncTaskCompleted(CHECK_EULA_ACCEPTED_TASK);
                        });
                    } else {
                        UIRunQueue.instance().setAsyncTaskCompleted(CHECK_EULA_ACCEPTED_TASK);
                    }
                });
            });
            thread.setName("EULA Download");
            thread.setDaemon(true);
            thread.start();
        } else if (!licMode.D() && !LicenseErrorDisplayer.getDefault().isShowing()) {
            this.checkSavedEulaAccepted();
        }
    }

    private void checkSavedEulaAccepted() {
        Optional eulaOpt = J.A();
        eulaOpt.ifPresent(eula -> {
            if (!eula.C()) {
                EulaDisplayer.getDefault().show(eula);
            }
        });
    }
}

