/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.wizard;

import com.paterva.maltego.licensing.ui.wizard.DiscoveryControllerProvider;
import com.paterva.maltego.licensing.ui.wizard.LicenseAgreementController;
import com.paterva.maltego.licensing.ui.wizard.LicenseModeController;
import com.paterva.maltego.licensing.ui.wizard.browser.BrowserLoginController;
import com.paterva.maltego.licensing.ui.wizard.browser.BrowserLoginOptionsController;
import com.paterva.maltego.licensing.ui.wizard.licensed.LicenseActivationController;
import com.paterva.maltego.licensing.ui.wizard.licensed.LicenseKeyController;
import com.paterva.maltego.licensing.ui.wizard.licensed.MaltegoIdActivationController;
import com.paterva.maltego.licensing.ui.wizard.licensed.RequestLicenseController;
import com.paterva.maltego.licensing.ui.wizard.offline.OfflineActivationController;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;

public class LicenseWizardIterator<Data>
implements WizardDescriptor.Iterator<Data> {
    private WizardDescriptor wd;
    private LicenseModeController panelLicenseMode;
    private LicenseAgreementController panelLicenseAgreement;
    private LicenseKeyController panelLicenseKey;
    private RequestLicenseController panelRequestLicense;
    private LicenseActivationController panelLicenseActivation;
    private MaltegoIdActivationController panelMaltegoIdActivation;
    private OfflineActivationController panelOfflineActivation;
    private BrowserLoginController panelLoginRequest;
    private BrowserLoginOptionsController panelLoginOptions;
    private WizardDescriptor.Panel panelChooseSeeds;
    private WizardDescriptor.Panel panelInitialUpdate;
    private WizardDescriptor.Panel panelUpdateDisclaimers;
    private WizardDescriptor.Panel panelInitialInstallTransforms;
    private List<WizardDescriptor.Panel> panelsVisible;
    private int index = 0;

    public void initialize(WizardDescriptor wd) {
        this.wd = wd;
        this.createPanels();
    }

    public WizardDescriptor.Panel[] getPanels() {
        if (this.panelLicenseMode == null) {
            this.panelLicenseMode = new LicenseModeController();
            this.panelLicenseKey = new LicenseKeyController();
            this.panelRequestLicense = new RequestLicenseController();
            this.panelLicenseActivation = new LicenseActivationController();
            this.panelMaltegoIdActivation = new MaltegoIdActivationController();
            this.panelOfflineActivation = new OfflineActivationController();
            this.panelLoginOptions = new BrowserLoginOptionsController();
            this.panelLoginRequest = new BrowserLoginController();
            this.panelLicenseAgreement = new LicenseAgreementController();
            DiscoveryControllerProvider provider = DiscoveryControllerProvider.getDefault();
            this.panelChooseSeeds = provider.getChooseSeedsController();
            this.panelInitialUpdate = provider.getInitialUpdateController();
            this.panelUpdateDisclaimers = provider.getUpdateDisclaimerController();
            this.panelInitialInstallTransforms = provider.getInstallInitialTransformsController();
        }
        return new WizardDescriptor.Panel[]{this.panelLicenseMode, this.panelLicenseKey, this.panelRequestLicense, this.panelOfflineActivation, this.panelLoginOptions, this.panelLoginRequest, this.panelLicenseAgreement, this.panelLicenseActivation, this.panelMaltegoIdActivation, this.panelChooseSeeds, this.panelInitialUpdate, this.panelUpdateDisclaimers, this.panelInitialInstallTransforms};
    }

    private void createPanels() {
        WizardUtilities.updatePanels((WizardDescriptor.Panel[])this.getPanels());
        this.updateVisiblePanels();
    }

    public WizardDescriptor.Panel<Data> current() {
        return this.panelsVisible.isEmpty() ? null : this.panelsVisible.get(this.index);
    }

    public String name() {
        return "Licensing";
    }

    public boolean hasNext() {
        return this.current() == this.panelLicenseMode || this.index < this.panelsVisible.size() - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
        this.updateVisiblePanels();
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
        this.updateVisiblePanels();
    }

    private void updateVisiblePanels() {
        this.panelsVisible = new ArrayList<WizardDescriptor.Panel>();
        boolean noSelection = Boolean.TRUE.equals(this.wd.getProperty("licensing.no-selection"));
        boolean loginOnly = Boolean.TRUE.equals(this.wd.getProperty("licensing.login.only"));
        boolean offlineActivation = Boolean.TRUE.equals(this.wd.getProperty("licensing.activation.offline"));
        boolean licensed = Boolean.TRUE.equals(this.wd.getProperty("licensing.licensed"));
        boolean freeOnline = Boolean.TRUE.equals(this.wd.getProperty("licensing.online"));
        boolean installHubItem = Boolean.TRUE.equals(this.wd.getProperty("licensing.install-hub-item"));
        boolean gatewayMaltegoId = Boolean.TRUE.equals(this.wd.getProperty("licensing.gateway-maltego-id"));
        boolean switchOrg = Boolean.TRUE.equals(this.wd.getProperty("licensing.switch-org.maltegoId"));
        if (switchOrg) {
            this.panelsVisible.add((WizardDescriptor.Panel)this.panelLoginOptions);
            this.panelLoginOptions.setName("Switch Organization");
            this.panelsVisible.add((WizardDescriptor.Panel)this.panelLoginRequest);
            this.panelsVisible.add((WizardDescriptor.Panel)this.panelMaltegoIdActivation);
        } else if (loginOnly) {
            this.panelsVisible.add((WizardDescriptor.Panel)this.panelLicenseAgreement);
            this.panelsVisible.add((WizardDescriptor.Panel)this.panelLoginOptions);
            this.panelsVisible.add((WizardDescriptor.Panel)this.panelLoginRequest);
        } else {
            if (offlineActivation) {
                if (!gatewayMaltegoId) {
                    this.panelsVisible.add((WizardDescriptor.Panel)this.panelLicenseKey);
                }
                this.panelsVisible.add((WizardDescriptor.Panel)this.panelOfflineActivation);
                this.panelsVisible.add((WizardDescriptor.Panel)this.panelLicenseAgreement);
                if (gatewayMaltegoId) {
                    this.panelsVisible.add((WizardDescriptor.Panel)this.panelMaltegoIdActivation);
                } else {
                    this.panelsVisible.add((WizardDescriptor.Panel)this.panelLicenseActivation);
                }
            } else if (licensed) {
                if (!noSelection) {
                    this.panelsVisible.add((WizardDescriptor.Panel)this.panelLicenseKey);
                    this.panelsVisible.add((WizardDescriptor.Panel)this.panelRequestLicense);
                    this.panelsVisible.add((WizardDescriptor.Panel)this.panelLicenseAgreement);
                    this.panelsVisible.add((WizardDescriptor.Panel)this.panelLicenseActivation);
                }
            } else if (gatewayMaltegoId) {
                if (!noSelection) {
                    this.panelsVisible.add((WizardDescriptor.Panel)this.panelLicenseAgreement);
                    this.panelsVisible.add((WizardDescriptor.Panel)this.panelLoginOptions);
                    this.panelsVisible.add((WizardDescriptor.Panel)this.panelLoginRequest);
                    this.panelsVisible.add((WizardDescriptor.Panel)this.panelMaltegoIdActivation);
                }
            } else if (freeOnline) {
                this.panelsVisible.add((WizardDescriptor.Panel)this.panelLicenseAgreement);
                this.panelsVisible.add((WizardDescriptor.Panel)this.panelLoginOptions);
                this.panelsVisible.add((WizardDescriptor.Panel)this.panelLoginRequest);
            } else {
                this.panelsVisible.add((WizardDescriptor.Panel)this.panelLicenseAgreement);
            }
            if ((offlineActivation || licensed || freeOnline || gatewayMaltegoId) && installHubItem) {
                this.panelsVisible.add(this.panelChooseSeeds);
                this.panelsVisible.add(this.panelInitialUpdate);
                this.panelsVisible.add(this.panelUpdateDisclaimers);
                this.panelsVisible.add(this.panelInitialInstallTransforms);
            }
        }
        this.updateContentPane();
    }

    private void updateContentPane() {
        String[] steps = this.getContentData();
        for (int i = 0; i < this.panelsVisible.size(); ++i) {
            WizardDescriptor.Panel panel = this.panelsVisible.get(i);
            Component c = panel.getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public String[] getContentData() {
        ArrayList<String> steps = new ArrayList<String>();
        for (int i = 0; i < this.panelsVisible.size(); ++i) {
            WizardDescriptor.Panel panel = this.panelsVisible.get(i);
            steps.add(panel.getComponent().getName());
            if (i < this.index || panel != this.panelLicenseMode) continue;
            steps.add("...");
            break;
        }
        return steps.toArray(new String[steps.size()]);
    }

    public void addChangeListener(ChangeListener cl) {
    }

    public void removeChangeListener(ChangeListener cl) {
    }
}

