/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Registration;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.NodeInformationProvider;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.muc.Affiliate;
import org.jivesoftware.smackx.muc.ConnectionDetachedPacketCollector;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.InvitationListener;
import org.jivesoftware.smackx.muc.InvitationRejectionListener;
import org.jivesoftware.smackx.muc.Occupant;
import org.jivesoftware.smackx.muc.PacketMultiplexListener;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jivesoftware.smackx.muc.RoomInfo;
import org.jivesoftware.smackx.muc.RoomListenerMultiplexor;
import org.jivesoftware.smackx.muc.SubjectUpdatedListener;
import org.jivesoftware.smackx.muc.UserStatusListener;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.jivesoftware.smackx.packet.MUCAdmin;
import org.jivesoftware.smackx.packet.MUCInitialPresence;
import org.jivesoftware.smackx.packet.MUCOwner;
import org.jivesoftware.smackx.packet.MUCUser;

public class MultiUserChat {
    private static final String discoNamespace = "http://jabber.org/protocol/muc";
    private static final String discoNode = "http://jabber.org/protocol/muc#rooms";
    private static Map<Connection, List<String>> joinedRooms = new WeakHashMap<Connection, List<String>>();
    private Connection connection;
    private String room;
    private String subject;
    private String nickname = null;
    private boolean joined = false;
    private Map<String, Presence> occupantsMap = new ConcurrentHashMap<String, Presence>();
    private final List<InvitationRejectionListener> invitationRejectionListeners = new ArrayList<InvitationRejectionListener>();
    private final List<SubjectUpdatedListener> subjectUpdatedListeners = new ArrayList<SubjectUpdatedListener>();
    private final List<UserStatusListener> userStatusListeners = new ArrayList<UserStatusListener>();
    private final List<ParticipantStatusListener> participantStatusListeners = new ArrayList<ParticipantStatusListener>();
    private PacketFilter presenceFilter;
    private List<PacketInterceptor> presenceInterceptors = new ArrayList<PacketInterceptor>();
    private PacketFilter messageFilter;
    private RoomListenerMultiplexor roomListenerMultiplexor;
    private ConnectionDetachedPacketCollector messageCollector;
    private List<PacketListener> connectionListeners = new ArrayList<PacketListener>();

    public MultiUserChat(Connection connection, String room) {
        this.connection = connection;
        this.room = room.toLowerCase();
        this.init();
    }

    public static boolean isServiceEnabled(Connection connection, String user) {
        try {
            DiscoverInfo result = ServiceDiscoveryManager.getInstanceFor(connection).discoverInfo(user);
            return result.containsFeature(discoNamespace);
        }
        catch (XMPPException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static Iterator<String> getJoinedRooms(Connection connection) {
        List<String> rooms = joinedRooms.get(connection);
        if (rooms != null) {
            return rooms.iterator();
        }
        return new ArrayList().iterator();
    }

    public static Iterator<String> getJoinedRooms(Connection connection, String user) {
        try {
            ArrayList<String> answer = new ArrayList<String>();
            DiscoverItems result = ServiceDiscoveryManager.getInstanceFor(connection).discoverItems(user, discoNode);
            Iterator<DiscoverItems.Item> items = result.getItems();
            while (items.hasNext()) {
                answer.add(items.next().getEntityID());
            }
            return answer.iterator();
        }
        catch (XMPPException e) {
            e.printStackTrace();
            return new ArrayList().iterator();
        }
    }

    public static RoomInfo getRoomInfo(Connection connection, String room) throws XMPPException {
        DiscoverInfo info = ServiceDiscoveryManager.getInstanceFor(connection).discoverInfo(room);
        return new RoomInfo(info);
    }

    public static Collection<String> getServiceNames(Connection connection) throws XMPPException {
        ArrayList<String> answer = new ArrayList<String>();
        ServiceDiscoveryManager discoManager = ServiceDiscoveryManager.getInstanceFor(connection);
        DiscoverItems items = discoManager.discoverItems(connection.getServiceName());
        Iterator<DiscoverItems.Item> it = items.getItems();
        while (it.hasNext()) {
            DiscoverItems.Item item = it.next();
            try {
                DiscoverInfo info = discoManager.discoverInfo(item.getEntityID());
                if (!info.containsFeature(discoNamespace)) continue;
                answer.add(item.getEntityID());
            }
            catch (XMPPException e) {}
        }
        return answer;
    }

    public static Collection<HostedRoom> getHostedRooms(Connection connection, String serviceName) throws XMPPException {
        ArrayList<HostedRoom> answer = new ArrayList<HostedRoom>();
        ServiceDiscoveryManager discoManager = ServiceDiscoveryManager.getInstanceFor(connection);
        DiscoverItems items = discoManager.discoverItems(serviceName);
        Iterator<DiscoverItems.Item> it = items.getItems();
        while (it.hasNext()) {
            answer.add(new HostedRoom(it.next()));
        }
        return answer;
    }

    public String getRoom() {
        return this.room;
    }

    public synchronized void create(String nickname) throws XMPPException {
        if (nickname == null || nickname.equals("")) {
            throw new IllegalArgumentException("Nickname must not be null or blank.");
        }
        if (this.joined) {
            throw new IllegalStateException("Creation failed - User already joined the room.");
        }
        Presence joinPresence = new Presence(Presence.Type.available);
        joinPresence.setTo(this.room + "/" + nickname);
        joinPresence.addExtension(new MUCInitialPresence());
        for (PacketInterceptor packetInterceptor : this.presenceInterceptors) {
            packetInterceptor.interceptPacket(joinPresence);
        }
        AndFilter responseFilter = new AndFilter(new FromMatchesFilter(this.room + "/" + nickname), new PacketTypeFilter(Presence.class));
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(joinPresence);
        Presence presence = (Presence)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (presence == null) {
            throw new XMPPException("No response from server.");
        }
        if (presence.getError() != null) {
            throw new XMPPException(presence.getError());
        }
        this.nickname = nickname;
        this.joined = true;
        this.userHasJoined();
        MUCUser mucUser = this.getMUCUserExtension(presence);
        if (mucUser != null && mucUser.getStatus() != null && "201".equals(mucUser.getStatus().getCode())) {
            return;
        }
        this.leave();
        throw new XMPPException("Creation failed - Missing acknowledge of room creation.");
    }

    public void join(String nickname) throws XMPPException {
        this.join(nickname, null, null, SmackConfiguration.getPacketReplyTimeout());
    }

    public void join(String nickname, String password) throws XMPPException {
        this.join(nickname, password, null, SmackConfiguration.getPacketReplyTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void join(String nickname, String password, DiscussionHistory history, long timeout) throws XMPPException {
        Presence presence;
        if (nickname == null || nickname.equals("")) {
            throw new IllegalArgumentException("Nickname must not be null or blank.");
        }
        if (this.joined) {
            this.leave();
        }
        Presence joinPresence = new Presence(Presence.Type.available);
        joinPresence.setTo(this.room + "/" + nickname);
        MUCInitialPresence mucInitialPresence = new MUCInitialPresence();
        if (password != null) {
            mucInitialPresence.setPassword(password);
        }
        if (history != null) {
            mucInitialPresence.setHistory(history.getMUCHistory());
        }
        joinPresence.addExtension(mucInitialPresence);
        for (PacketInterceptor packetInterceptor : this.presenceInterceptors) {
            packetInterceptor.interceptPacket(joinPresence);
        }
        AndFilter responseFilter = new AndFilter(new FromMatchesFilter(this.room + "/" + nickname), new PacketTypeFilter(Presence.class));
        PacketCollector response = null;
        try {
            response = this.connection.createPacketCollector(responseFilter);
            this.connection.sendPacket(joinPresence);
            presence = (Presence)response.nextResult(timeout);
        }
        finally {
            if (response != null) {
                response.cancel();
            }
        }
        if (presence == null) {
            throw new XMPPException("No response from server.");
        }
        if (presence.getError() != null) {
            throw new XMPPException(presence.getError());
        }
        this.nickname = nickname;
        this.joined = true;
        this.userHasJoined();
    }

    public boolean isJoined() {
        return this.joined;
    }

    public synchronized void leave() {
        if (!this.joined) {
            return;
        }
        Presence leavePresence = new Presence(Presence.Type.unavailable);
        leavePresence.setTo(this.room + "/" + this.nickname);
        for (PacketInterceptor packetInterceptor : this.presenceInterceptors) {
            packetInterceptor.interceptPacket(leavePresence);
        }
        this.connection.sendPacket(leavePresence);
        this.occupantsMap.clear();
        this.nickname = null;
        this.joined = false;
        this.userHasLeft();
    }

    public Form getConfigurationForm() throws XMPPException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.GET);
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        IQ answer = (IQ)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
        return Form.getFormFrom(answer);
    }

    public void sendConfigurationForm(Form form) throws XMPPException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        iq.addExtension(form.getDataFormToSend());
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        IQ answer = (IQ)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
    }

    public Form getRegistrationForm() throws XMPPException {
        Registration reg = new Registration();
        reg.setType(IQ.Type.GET);
        reg.setTo(this.room);
        AndFilter filter = new AndFilter(new PacketIDFilter(reg.getPacketID()), new PacketTypeFilter(IQ.class));
        PacketCollector collector = this.connection.createPacketCollector(filter);
        this.connection.sendPacket(reg);
        IQ result = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (result == null) {
            throw new XMPPException("No response from server.");
        }
        if (result.getType() == IQ.Type.ERROR) {
            throw new XMPPException(result.getError());
        }
        return Form.getFormFrom(result);
    }

    public void sendRegistrationForm(Form form) throws XMPPException {
        Registration reg = new Registration();
        reg.setType(IQ.Type.SET);
        reg.setTo(this.room);
        reg.addExtension(form.getDataFormToSend());
        AndFilter filter = new AndFilter(new PacketIDFilter(reg.getPacketID()), new PacketTypeFilter(IQ.class));
        PacketCollector collector = this.connection.createPacketCollector(filter);
        this.connection.sendPacket(reg);
        IQ result = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (result == null) {
            throw new XMPPException("No response from server.");
        }
        if (result.getType() == IQ.Type.ERROR) {
            throw new XMPPException(result.getError());
        }
    }

    public void destroy(String reason, String alternateJID) throws XMPPException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        MUCOwner.Destroy destroy = new MUCOwner.Destroy();
        destroy.setReason(reason);
        destroy.setJid(alternateJID);
        iq.setDestroy(destroy);
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        IQ answer = (IQ)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
        this.occupantsMap.clear();
        this.nickname = null;
        this.joined = false;
        this.userHasLeft();
    }

    public void invite(String user, String reason) {
        this.invite(new Message(), user, reason);
    }

    public void invite(Message message, String user, String reason) {
        message.setTo(this.room);
        MUCUser mucUser = new MUCUser();
        MUCUser.Invite invite = new MUCUser.Invite();
        invite.setTo(user);
        invite.setReason(reason);
        mucUser.setInvite(invite);
        message.addExtension(mucUser);
        this.connection.sendPacket(message);
    }

    public static void decline(Connection conn, String room, String inviter, String reason) {
        Message message = new Message(room);
        MUCUser mucUser = new MUCUser();
        MUCUser.Decline decline = new MUCUser.Decline();
        decline.setTo(inviter);
        decline.setReason(reason);
        mucUser.setDecline(decline);
        message.addExtension(mucUser);
        conn.sendPacket(message);
    }

    public static void addInvitationListener(Connection conn, InvitationListener listener) {
        InvitationsMonitor.getInvitationsMonitor(conn).addInvitationListener(listener);
    }

    public static void removeInvitationListener(Connection conn, InvitationListener listener) {
        InvitationsMonitor.getInvitationsMonitor(conn).removeInvitationListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvitationRejectionListener(InvitationRejectionListener listener) {
        List<InvitationRejectionListener> list = this.invitationRejectionListeners;
        synchronized (list) {
            if (!this.invitationRejectionListeners.contains(listener)) {
                this.invitationRejectionListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvitationRejectionListener(InvitationRejectionListener listener) {
        List<InvitationRejectionListener> list = this.invitationRejectionListeners;
        synchronized (list) {
            this.invitationRejectionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInvitationRejectionListeners(String invitee, String reason) {
        InvitationRejectionListener[] listeners;
        List<InvitationRejectionListener> list = this.invitationRejectionListeners;
        synchronized (list) {
            listeners = new InvitationRejectionListener[this.invitationRejectionListeners.size()];
            this.invitationRejectionListeners.toArray(listeners);
        }
        for (InvitationRejectionListener listener : listeners) {
            listener.invitationDeclined(invitee, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubjectUpdatedListener(SubjectUpdatedListener listener) {
        List<SubjectUpdatedListener> list = this.subjectUpdatedListeners;
        synchronized (list) {
            if (!this.subjectUpdatedListeners.contains(listener)) {
                this.subjectUpdatedListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubjectUpdatedListener(SubjectUpdatedListener listener) {
        List<SubjectUpdatedListener> list = this.subjectUpdatedListeners;
        synchronized (list) {
            this.subjectUpdatedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSubjectUpdatedListeners(String subject, String from) {
        SubjectUpdatedListener[] listeners;
        List<SubjectUpdatedListener> list = this.subjectUpdatedListeners;
        synchronized (list) {
            listeners = new SubjectUpdatedListener[this.subjectUpdatedListeners.size()];
            this.subjectUpdatedListeners.toArray(listeners);
        }
        for (SubjectUpdatedListener listener : listeners) {
            listener.subjectUpdated(subject, from);
        }
    }

    public void addPresenceInterceptor(PacketInterceptor presenceInterceptor) {
        this.presenceInterceptors.add(presenceInterceptor);
    }

    public void removePresenceInterceptor(PacketInterceptor presenceInterceptor) {
        this.presenceInterceptors.remove(presenceInterceptor);
    }

    public String getSubject() {
        return this.subject;
    }

    public String getReservedNickname() {
        try {
            DiscoverInfo result = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo(this.room, "x-roomuser-item");
            Iterator<DiscoverInfo.Identity> identities = result.getIdentities();
            if (identities.hasNext()) {
                DiscoverInfo.Identity identity = identities.next();
                return identity.getName();
            }
            return null;
        }
        catch (XMPPException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getNickname() {
        return this.nickname;
    }

    public void changeNickname(String nickname) throws XMPPException {
        if (nickname == null || nickname.equals("")) {
            throw new IllegalArgumentException("Nickname must not be null or blank.");
        }
        if (!this.joined) {
            throw new IllegalStateException("Must be logged into the room to change nickname.");
        }
        Presence joinPresence = new Presence(Presence.Type.available);
        joinPresence.setTo(this.room + "/" + nickname);
        for (PacketInterceptor packetInterceptor : this.presenceInterceptors) {
            packetInterceptor.interceptPacket(joinPresence);
        }
        AndFilter responseFilter = new AndFilter(new FromMatchesFilter(this.room + "/" + nickname), new PacketTypeFilter(Presence.class));
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(joinPresence);
        Presence presence = (Presence)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (presence == null) {
            throw new XMPPException("No response from server.");
        }
        if (presence.getError() != null) {
            throw new XMPPException(presence.getError());
        }
        this.nickname = nickname;
    }

    public void changeAvailabilityStatus(String status, Presence.Mode mode) {
        if (this.nickname == null || this.nickname.equals("")) {
            throw new IllegalArgumentException("Nickname must not be null or blank.");
        }
        if (!this.joined) {
            throw new IllegalStateException("Must be logged into the room to change the availability status.");
        }
        Presence joinPresence = new Presence(Presence.Type.available);
        joinPresence.setStatus(status);
        joinPresence.setMode(mode);
        joinPresence.setTo(this.room + "/" + this.nickname);
        for (PacketInterceptor packetInterceptor : this.presenceInterceptors) {
            packetInterceptor.interceptPacket(joinPresence);
        }
        this.connection.sendPacket(joinPresence);
    }

    public void kickParticipant(String nickname, String reason) throws XMPPException {
        this.changeRole(nickname, "none", reason);
    }

    public void grantVoice(Collection<String> nicknames) throws XMPPException {
        this.changeRole(nicknames, "participant");
    }

    public void grantVoice(String nickname) throws XMPPException {
        this.changeRole(nickname, "participant", null);
    }

    public void revokeVoice(Collection<String> nicknames) throws XMPPException {
        this.changeRole(nicknames, "visitor");
    }

    public void revokeVoice(String nickname) throws XMPPException {
        this.changeRole(nickname, "visitor", null);
    }

    public void banUsers(Collection<String> jids) throws XMPPException {
        this.changeAffiliationByAdmin(jids, "outcast");
    }

    public void banUser(String jid, String reason) throws XMPPException {
        this.changeAffiliationByAdmin(jid, "outcast", reason);
    }

    public void grantMembership(Collection<String> jids) throws XMPPException {
        this.changeAffiliationByAdmin(jids, "member");
    }

    public void grantMembership(String jid) throws XMPPException {
        this.changeAffiliationByAdmin(jid, "member", null);
    }

    public void revokeMembership(Collection<String> jids) throws XMPPException {
        this.changeAffiliationByAdmin(jids, "none");
    }

    public void revokeMembership(String jid) throws XMPPException {
        this.changeAffiliationByAdmin(jid, "none", null);
    }

    public void grantModerator(Collection<String> nicknames) throws XMPPException {
        this.changeRole(nicknames, "moderator");
    }

    public void grantModerator(String nickname) throws XMPPException {
        this.changeRole(nickname, "moderator", null);
    }

    public void revokeModerator(Collection<String> nicknames) throws XMPPException {
        this.changeRole(nicknames, "participant");
    }

    public void revokeModerator(String nickname) throws XMPPException {
        this.changeRole(nickname, "participant", null);
    }

    public void grantOwnership(Collection<String> jids) throws XMPPException {
        this.changeAffiliationByOwner(jids, "owner");
    }

    public void grantOwnership(String jid) throws XMPPException {
        this.changeAffiliationByOwner(jid, "owner");
    }

    public void revokeOwnership(Collection<String> jids) throws XMPPException {
        this.changeAffiliationByOwner(jids, "admin");
    }

    public void revokeOwnership(String jid) throws XMPPException {
        this.changeAffiliationByOwner(jid, "admin");
    }

    public void grantAdmin(Collection<String> jids) throws XMPPException {
        this.changeAffiliationByOwner(jids, "admin");
    }

    public void grantAdmin(String jid) throws XMPPException {
        this.changeAffiliationByOwner(jid, "admin");
    }

    public void revokeAdmin(Collection<String> jids) throws XMPPException {
        this.changeAffiliationByOwner(jids, "member");
    }

    public void revokeAdmin(String jid) throws XMPPException {
        this.changeAffiliationByOwner(jid, "member");
    }

    private void changeAffiliationByOwner(String jid, String affiliation) throws XMPPException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        MUCOwner.Item item = new MUCOwner.Item(affiliation);
        item.setJid(jid);
        iq.addItem(item);
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        IQ answer = (IQ)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
    }

    private void changeAffiliationByOwner(Collection<String> jids, String affiliation) throws XMPPException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        for (String jid : jids) {
            MUCOwner.Item item = new MUCOwner.Item(affiliation);
            item.setJid(jid);
            iq.addItem(item);
        }
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        IQ answer = (IQ)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
    }

    private void changeAffiliationByAdmin(String jid, String affiliation, String reason) throws XMPPException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        MUCAdmin.Item item = new MUCAdmin.Item(affiliation, null);
        item.setJid(jid);
        item.setReason(reason);
        iq.addItem(item);
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        IQ answer = (IQ)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
    }

    private void changeAffiliationByAdmin(Collection<String> jids, String affiliation) throws XMPPException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        for (String jid : jids) {
            MUCAdmin.Item item = new MUCAdmin.Item(affiliation, null);
            item.setJid(jid);
            iq.addItem(item);
        }
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        IQ answer = (IQ)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
    }

    private void changeRole(String nickname, String role, String reason) throws XMPPException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        MUCAdmin.Item item = new MUCAdmin.Item(null, role);
        item.setNick(nickname);
        item.setReason(reason);
        iq.addItem(item);
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        IQ answer = (IQ)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
    }

    private void changeRole(Collection<String> nicknames, String role) throws XMPPException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        for (String nickname : nicknames) {
            MUCAdmin.Item item = new MUCAdmin.Item(null, role);
            item.setNick(nickname);
            iq.addItem(item);
        }
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        IQ answer = (IQ)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
    }

    public int getOccupantsCount() {
        return this.occupantsMap.size();
    }

    public Iterator<String> getOccupants() {
        return Collections.unmodifiableList(new ArrayList<String>(this.occupantsMap.keySet())).iterator();
    }

    public Presence getOccupantPresence(String user) {
        return this.occupantsMap.get(user);
    }

    public Occupant getOccupant(String user) {
        Presence presence = this.occupantsMap.get(user);
        if (presence != null) {
            return new Occupant(presence);
        }
        return null;
    }

    public void addParticipantListener(PacketListener listener) {
        this.connection.addPacketListener(listener, this.presenceFilter);
        this.connectionListeners.add(listener);
    }

    public void removeParticipantListener(PacketListener listener) {
        this.connection.removePacketListener(listener);
        this.connectionListeners.remove(listener);
    }

    public Collection<Affiliate> getOwners() throws XMPPException {
        return this.getAffiliatesByOwner("owner");
    }

    public Collection<Affiliate> getAdmins() throws XMPPException {
        return this.getAffiliatesByOwner("admin");
    }

    public Collection<Affiliate> getMembers() throws XMPPException {
        return this.getAffiliatesByAdmin("member");
    }

    public Collection<Affiliate> getOutcasts() throws XMPPException {
        return this.getAffiliatesByAdmin("outcast");
    }

    private Collection<Affiliate> getAffiliatesByOwner(String affiliation) throws XMPPException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.GET);
        MUCOwner.Item item = new MUCOwner.Item(affiliation);
        iq.addItem(item);
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        MUCOwner answer = (MUCOwner)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
        ArrayList<Affiliate> affiliates = new ArrayList<Affiliate>();
        Iterator it = answer.getItems();
        while (it.hasNext()) {
            affiliates.add(new Affiliate((MUCOwner.Item)it.next()));
        }
        return affiliates;
    }

    private Collection<Affiliate> getAffiliatesByAdmin(String affiliation) throws XMPPException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.GET);
        MUCAdmin.Item item = new MUCAdmin.Item(affiliation, null);
        iq.addItem(item);
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        MUCAdmin answer = (MUCAdmin)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
        ArrayList<Affiliate> affiliates = new ArrayList<Affiliate>();
        Iterator it = answer.getItems();
        while (it.hasNext()) {
            affiliates.add(new Affiliate((MUCAdmin.Item)it.next()));
        }
        return affiliates;
    }

    public Collection<Occupant> getModerators() throws XMPPException {
        return this.getOccupants("moderator");
    }

    public Collection<Occupant> getParticipants() throws XMPPException {
        return this.getOccupants("participant");
    }

    private Collection<Occupant> getOccupants(String role) throws XMPPException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.GET);
        MUCAdmin.Item item = new MUCAdmin.Item(null, role);
        iq.addItem(item);
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        MUCAdmin answer = (MUCAdmin)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
        ArrayList<Occupant> participants = new ArrayList<Occupant>();
        Iterator it = answer.getItems();
        while (it.hasNext()) {
            participants.add(new Occupant((MUCAdmin.Item)it.next()));
        }
        return participants;
    }

    public void sendMessage(String text) throws XMPPException {
        Message message = new Message(this.room, Message.Type.groupchat);
        message.setBody(text);
        this.connection.sendPacket(message);
    }

    public Chat createPrivateChat(String occupant, MessageListener listener) {
        return this.connection.getChatManager().createChat(occupant, listener);
    }

    public Message createMessage() {
        return new Message(this.room, Message.Type.groupchat);
    }

    public void sendMessage(Message message) throws XMPPException {
        this.connection.sendPacket(message);
    }

    public Message pollMessage() {
        return (Message)this.messageCollector.pollResult();
    }

    public Message nextMessage() {
        return (Message)this.messageCollector.nextResult();
    }

    public Message nextMessage(long timeout) {
        return (Message)this.messageCollector.nextResult(timeout);
    }

    public void addMessageListener(PacketListener listener) {
        this.connection.addPacketListener(listener, this.messageFilter);
        this.connectionListeners.add(listener);
    }

    public void removeMessageListener(PacketListener listener) {
        this.connection.removePacketListener(listener);
        this.connectionListeners.remove(listener);
    }

    public void changeSubject(final String subject) throws XMPPException {
        Message message = new Message(this.room, Message.Type.groupchat);
        message.setSubject(subject);
        AndFilter responseFilter = new AndFilter(new FromMatchesFilter(this.room), new PacketTypeFilter(Message.class));
        responseFilter = new AndFilter(responseFilter, new PacketFilter(){

            @Override
            public boolean accept(Packet packet) {
                Message msg = (Message)packet;
                return subject.equals(msg.getSubject());
            }
        });
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(message);
        Message answer = (Message)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
    }

    private synchronized void userHasJoined() {
        List<String> rooms = joinedRooms.get(this.connection);
        if (rooms == null) {
            rooms = new ArrayList<String>();
            joinedRooms.put(this.connection, rooms);
        }
        rooms.add(this.room);
    }

    private synchronized void userHasLeft() {
        List<String> rooms = joinedRooms.get(this.connection);
        if (rooms == null) {
            return;
        }
        rooms.remove(this.room);
    }

    private MUCUser getMUCUserExtension(Packet packet) {
        if (packet != null) {
            return (MUCUser)packet.getExtension("x", "http://jabber.org/protocol/muc#user");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserStatusListener(UserStatusListener listener) {
        List<UserStatusListener> list = this.userStatusListeners;
        synchronized (list) {
            if (!this.userStatusListeners.contains(listener)) {
                this.userStatusListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserStatusListener(UserStatusListener listener) {
        List<UserStatusListener> list = this.userStatusListeners;
        synchronized (list) {
            this.userStatusListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireUserStatusListeners(String methodName, Object[] params) {
        UserStatusListener[] listeners;
        List<UserStatusListener> list = this.userStatusListeners;
        synchronized (list) {
            listeners = new UserStatusListener[this.userStatusListeners.size()];
            this.userStatusListeners.toArray(listeners);
        }
        Class[] paramClasses = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramClasses[i] = params[i].getClass();
        }
        try {
            Method method = UserStatusListener.class.getDeclaredMethod(methodName, paramClasses);
            for (UserStatusListener listener : listeners) {
                method.invoke((Object)listener, params);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParticipantStatusListener(ParticipantStatusListener listener) {
        List<ParticipantStatusListener> list = this.participantStatusListeners;
        synchronized (list) {
            if (!this.participantStatusListeners.contains(listener)) {
                this.participantStatusListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParticipantStatusListener(ParticipantStatusListener listener) {
        List<ParticipantStatusListener> list = this.participantStatusListeners;
        synchronized (list) {
            this.participantStatusListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireParticipantStatusListeners(String methodName, List<String> params) {
        ParticipantStatusListener[] listeners;
        List<ParticipantStatusListener> list = this.participantStatusListeners;
        synchronized (list) {
            listeners = new ParticipantStatusListener[this.participantStatusListeners.size()];
            this.participantStatusListeners.toArray(listeners);
        }
        try {
            Class[] classes = new Class[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                classes[i] = String.class;
            }
            Method method = ParticipantStatusListener.class.getDeclaredMethod(methodName, classes);
            for (ParticipantStatusListener listener : listeners) {
                method.invoke((Object)listener, params.toArray());
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void init() {
        this.messageFilter = new AndFilter(new FromMatchesFilter(this.room), new MessageTypeFilter(Message.Type.groupchat));
        this.messageFilter = new AndFilter(this.messageFilter, new PacketFilter(){

            @Override
            public boolean accept(Packet packet) {
                Message msg = (Message)packet;
                return msg.getBody() != null;
            }
        });
        this.presenceFilter = new AndFilter(new FromMatchesFilter(this.room), new PacketTypeFilter(Presence.class));
        this.messageCollector = new ConnectionDetachedPacketCollector();
        PacketListener subjectListener = new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                Message msg = (Message)packet;
                MultiUserChat.this.subject = msg.getSubject();
                MultiUserChat.this.fireSubjectUpdatedListeners(msg.getSubject(), msg.getFrom());
            }
        };
        PacketListener presenceListener = new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                Presence presence = (Presence)packet;
                String from = presence.getFrom();
                String myRoomJID = MultiUserChat.this.room + "/" + MultiUserChat.this.nickname;
                boolean isUserStatusModification = presence.getFrom().equals(myRoomJID);
                if (presence.getType() == Presence.Type.available) {
                    Presence oldPresence = MultiUserChat.this.occupantsMap.put(from, presence);
                    if (oldPresence != null) {
                        MUCUser mucExtension = MultiUserChat.this.getMUCUserExtension(oldPresence);
                        String oldAffiliation = mucExtension.getItem().getAffiliation();
                        String oldRole = mucExtension.getItem().getRole();
                        mucExtension = MultiUserChat.this.getMUCUserExtension(presence);
                        String newAffiliation = mucExtension.getItem().getAffiliation();
                        String newRole = mucExtension.getItem().getRole();
                        MultiUserChat.this.checkRoleModifications(oldRole, newRole, isUserStatusModification, from);
                        MultiUserChat.this.checkAffiliationModifications(oldAffiliation, newAffiliation, isUserStatusModification, from);
                    } else if (!isUserStatusModification) {
                        ArrayList<String> params = new ArrayList<String>();
                        params.add(from);
                        MultiUserChat.this.fireParticipantStatusListeners("joined", params);
                    }
                } else if (presence.getType() == Presence.Type.unavailable) {
                    MultiUserChat.this.occupantsMap.remove(from);
                    MUCUser mucUser = MultiUserChat.this.getMUCUserExtension(presence);
                    if (mucUser != null && mucUser.getStatus() != null) {
                        MultiUserChat.this.checkPresenceCode(mucUser.getStatus().getCode(), presence.getFrom().equals(myRoomJID), mucUser, from);
                    } else if (!isUserStatusModification) {
                        ArrayList<String> params = new ArrayList<String>();
                        params.add(from);
                        MultiUserChat.this.fireParticipantStatusListeners("left", params);
                    }
                }
            }
        };
        PacketListener declinesListener = new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                MUCUser mucUser = MultiUserChat.this.getMUCUserExtension(packet);
                if (mucUser.getDecline() != null && ((Message)packet).getType() != Message.Type.error) {
                    MultiUserChat.this.fireInvitationRejectionListeners(mucUser.getDecline().getFrom(), mucUser.getDecline().getReason());
                }
            }
        };
        PacketMultiplexListener packetMultiplexor = new PacketMultiplexListener(this.messageCollector, presenceListener, subjectListener, declinesListener);
        this.roomListenerMultiplexor = RoomListenerMultiplexor.getRoomMultiplexor(this.connection);
        this.roomListenerMultiplexor.addRoom(this.room, packetMultiplexor);
    }

    private void checkRoleModifications(String oldRole, String newRole, boolean isUserModification, String from) {
        ArrayList<String> params;
        if (("visitor".equals(oldRole) || "none".equals(oldRole)) && "participant".equals(newRole)) {
            if (isUserModification) {
                this.fireUserStatusListeners("voiceGranted", new Object[0]);
            } else {
                params = new ArrayList<String>();
                params.add(from);
                this.fireParticipantStatusListeners("voiceGranted", params);
            }
        } else if ("participant".equals(oldRole) && ("visitor".equals(newRole) || "none".equals(newRole))) {
            if (isUserModification) {
                this.fireUserStatusListeners("voiceRevoked", new Object[0]);
            } else {
                params = new ArrayList();
                params.add(from);
                this.fireParticipantStatusListeners("voiceRevoked", params);
            }
        }
        if (!"moderator".equals(oldRole) && "moderator".equals(newRole)) {
            if ("visitor".equals(oldRole) || "none".equals(oldRole)) {
                if (isUserModification) {
                    this.fireUserStatusListeners("voiceGranted", new Object[0]);
                } else {
                    params = new ArrayList();
                    params.add(from);
                    this.fireParticipantStatusListeners("voiceGranted", params);
                }
            }
            if (isUserModification) {
                this.fireUserStatusListeners("moderatorGranted", new Object[0]);
            } else {
                params = new ArrayList();
                params.add(from);
                this.fireParticipantStatusListeners("moderatorGranted", params);
            }
        } else if ("moderator".equals(oldRole) && !"moderator".equals(newRole)) {
            if ("visitor".equals(newRole) || "none".equals(newRole)) {
                if (isUserModification) {
                    this.fireUserStatusListeners("voiceRevoked", new Object[0]);
                } else {
                    params = new ArrayList();
                    params.add(from);
                    this.fireParticipantStatusListeners("voiceRevoked", params);
                }
            }
            if (isUserModification) {
                this.fireUserStatusListeners("moderatorRevoked", new Object[0]);
            } else {
                params = new ArrayList();
                params.add(from);
                this.fireParticipantStatusListeners("moderatorRevoked", params);
            }
        }
    }

    private void checkAffiliationModifications(String oldAffiliation, String newAffiliation, boolean isUserModification, String from) {
        ArrayList<String> params;
        if ("owner".equals(oldAffiliation) && !"owner".equals(newAffiliation)) {
            if (isUserModification) {
                this.fireUserStatusListeners("ownershipRevoked", new Object[0]);
            } else {
                params = new ArrayList<String>();
                params.add(from);
                this.fireParticipantStatusListeners("ownershipRevoked", params);
            }
        } else if ("admin".equals(oldAffiliation) && !"admin".equals(newAffiliation)) {
            if (isUserModification) {
                this.fireUserStatusListeners("adminRevoked", new Object[0]);
            } else {
                params = new ArrayList();
                params.add(from);
                this.fireParticipantStatusListeners("adminRevoked", params);
            }
        } else if ("member".equals(oldAffiliation) && !"member".equals(newAffiliation)) {
            if (isUserModification) {
                this.fireUserStatusListeners("membershipRevoked", new Object[0]);
            } else {
                params = new ArrayList();
                params.add(from);
                this.fireParticipantStatusListeners("membershipRevoked", params);
            }
        }
        if (!"owner".equals(oldAffiliation) && "owner".equals(newAffiliation)) {
            if (isUserModification) {
                this.fireUserStatusListeners("ownershipGranted", new Object[0]);
            } else {
                params = new ArrayList();
                params.add(from);
                this.fireParticipantStatusListeners("ownershipGranted", params);
            }
        } else if (!"admin".equals(oldAffiliation) && "admin".equals(newAffiliation)) {
            if (isUserModification) {
                this.fireUserStatusListeners("adminGranted", new Object[0]);
            } else {
                params = new ArrayList();
                params.add(from);
                this.fireParticipantStatusListeners("adminGranted", params);
            }
        } else if (!"member".equals(oldAffiliation) && "member".equals(newAffiliation)) {
            if (isUserModification) {
                this.fireUserStatusListeners("membershipGranted", new Object[0]);
            } else {
                params = new ArrayList();
                params.add(from);
                this.fireParticipantStatusListeners("membershipGranted", params);
            }
        }
    }

    private void checkPresenceCode(String code, boolean isUserModification, MUCUser mucUser, String from) {
        if ("307".equals(code)) {
            if (isUserModification) {
                this.joined = false;
                this.fireUserStatusListeners("kicked", new Object[]{mucUser.getItem().getActor(), mucUser.getItem().getReason()});
                this.occupantsMap.clear();
                this.nickname = null;
                this.userHasLeft();
            } else {
                ArrayList<String> params = new ArrayList<String>();
                params.add(from);
                params.add(mucUser.getItem().getActor());
                params.add(mucUser.getItem().getReason());
                this.fireParticipantStatusListeners("kicked", params);
            }
        } else if ("301".equals(code)) {
            if (isUserModification) {
                this.joined = false;
                this.fireUserStatusListeners("banned", new Object[]{mucUser.getItem().getActor(), mucUser.getItem().getReason()});
                this.occupantsMap.clear();
                this.nickname = null;
                this.userHasLeft();
            } else {
                ArrayList<String> params = new ArrayList<String>();
                params.add(from);
                params.add(mucUser.getItem().getActor());
                params.add(mucUser.getItem().getReason());
                this.fireParticipantStatusListeners("banned", params);
            }
        } else if ("321".equals(code)) {
            if (isUserModification) {
                this.joined = false;
                this.fireUserStatusListeners("membershipRevoked", new Object[0]);
                this.occupantsMap.clear();
                this.nickname = null;
                this.userHasLeft();
            }
        } else if ("303".equals(code)) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(from);
            params.add(mucUser.getItem().getNick());
            this.fireParticipantStatusListeners("nicknameChanged", params);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.connection != null) {
                this.roomListenerMultiplexor.removeRoom(this.room);
                for (PacketListener connectionListener : this.connectionListeners) {
                    this.connection.removePacketListener(connectionListener);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(final Connection connection) {
                ServiceDiscoveryManager.getInstanceFor(connection).addFeature(MultiUserChat.discoNamespace);
                ServiceDiscoveryManager.getInstanceFor(connection).setNodeInformationProvider(MultiUserChat.discoNode, new NodeInformationProvider(){

                    @Override
                    public List<DiscoverItems.Item> getNodeItems() {
                        ArrayList<DiscoverItems.Item> answer = new ArrayList<DiscoverItems.Item>();
                        Iterator rooms = MultiUserChat.getJoinedRooms(connection);
                        while (rooms.hasNext()) {
                            answer.add(new DiscoverItems.Item((String)rooms.next()));
                        }
                        return answer;
                    }

                    @Override
                    public List<String> getNodeFeatures() {
                        return null;
                    }

                    @Override
                    public List<DiscoverInfo.Identity> getNodeIdentities() {
                        return null;
                    }
                });
            }
        });
    }

    private static class InvitationsMonitor
    implements ConnectionListener {
        private static final Map<Connection, WeakReference<InvitationsMonitor>> monitors = new WeakHashMap<Connection, WeakReference<InvitationsMonitor>>();
        private final List<InvitationListener> invitationsListeners = new ArrayList<InvitationListener>();
        private Connection connection;
        private PacketFilter invitationFilter;
        private PacketListener invitationPacketListener;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static InvitationsMonitor getInvitationsMonitor(Connection conn) {
            Map<Connection, WeakReference<InvitationsMonitor>> map = monitors;
            synchronized (map) {
                if (!monitors.containsKey(conn)) {
                    monitors.put(conn, new WeakReference<InvitationsMonitor>(new InvitationsMonitor(conn)));
                }
                return (InvitationsMonitor)monitors.get(conn).get();
            }
        }

        private InvitationsMonitor(Connection connection) {
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addInvitationListener(InvitationListener listener) {
            List<InvitationListener> list = this.invitationsListeners;
            synchronized (list) {
                if (this.invitationsListeners.size() == 0) {
                    this.init();
                }
                if (!this.invitationsListeners.contains(listener)) {
                    this.invitationsListeners.add(listener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeInvitationListener(InvitationListener listener) {
            List<InvitationListener> list = this.invitationsListeners;
            synchronized (list) {
                if (this.invitationsListeners.contains(listener)) {
                    this.invitationsListeners.remove(listener);
                }
                if (this.invitationsListeners.size() == 0) {
                    this.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireInvitationListeners(String room, String inviter, String reason, String password, Message message) {
            InvitationListener[] listeners;
            List<InvitationListener> list = this.invitationsListeners;
            synchronized (list) {
                listeners = new InvitationListener[this.invitationsListeners.size()];
                this.invitationsListeners.toArray(listeners);
            }
            for (InvitationListener listener : listeners) {
                listener.invitationReceived(this.connection, room, inviter, reason, password, message);
            }
        }

        @Override
        public void connectionClosed() {
            this.cancel();
        }

        @Override
        public void connectionClosedOnError(Exception e) {
        }

        @Override
        public void reconnectingIn(int seconds) {
        }

        @Override
        public void reconnectionSuccessful() {
        }

        @Override
        public void reconnectionFailed(Exception e) {
        }

        private void init() {
            this.invitationFilter = new PacketExtensionFilter("x", "http://jabber.org/protocol/muc#user");
            this.invitationPacketListener = new PacketListener(){

                @Override
                public void processPacket(Packet packet) {
                    MUCUser mucUser = (MUCUser)packet.getExtension("x", "http://jabber.org/protocol/muc#user");
                    if (mucUser.getInvite() != null && ((Message)packet).getType() != Message.Type.error) {
                        InvitationsMonitor.this.fireInvitationListeners(packet.getFrom(), mucUser.getInvite().getFrom(), mucUser.getInvite().getReason(), mucUser.getPassword(), (Message)packet);
                    }
                }
            };
            this.connection.addPacketListener(this.invitationPacketListener, this.invitationFilter);
            this.connection.addConnectionListener(this);
        }

        private void cancel() {
            this.connection.removePacketListener(this.invitationPacketListener);
            this.connection.removeConnectionListener(this);
        }
    }
}

