/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.inputform;

import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorEnumeration;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.editing.inputform.PropertyStub;
import com.paterva.maltego.typing.serializer.UnresolvedReferenceException;
import java.util.LinkedList;
import java.util.List;

class FormDataTranslator {
    FormDataTranslator() {
    }

    public List<PropertyStub> translate(DisplayDescriptorEnumeration properties, DataSource data) {
        LinkedList<PropertyStub> stubs = new LinkedList<PropertyStub>();
        for (DisplayDescriptor desc : properties) {
            Object value = data.getValue((PropertyDescriptor)desc);
            if (value == null) {
                value = desc.getDefaultValue();
            }
            if (value == null) continue;
            TypeDescriptor td = TypeRegistry.getDefault().getType(desc.getType());
            PropertyStub stub = this.translate((PropertyDescriptor)desc, td);
            stub.setValue(td.convert(value));
            stubs.add(stub);
        }
        return stubs;
    }

    private PropertyStub translate(PropertyDescriptor descriptor, TypeDescriptor td) {
        PropertyStub stub = new PropertyStub();
        stub.setName(descriptor.getName());
        stub.setType(td.getTypeName());
        return stub;
    }

    public void translate(List<PropertyStub> stubs, DisplayDescriptorEnumeration properties, DataSource data) throws UnresolvedReferenceException {
        if (stubs != null) {
            for (PropertyStub stub : stubs) {
                String type = stub.getType();
                DisplayDescriptor desc = properties.get(stub.getName());
                if (desc == null || !desc.getTypeDescriptor().getTypeName().equals(type)) continue;
                Object value = desc.getTypeDescriptor().convert(stub.getValue());
                data.setValue((PropertyDescriptor)desc, value);
            }
        }
    }
}

